<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

global $empCod, $usuNom, $bitMod, $bitForm, $selBan, $dtFec, $numNum, $Banctab, $Banctac, $txtCodp, $txtNomp;

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

$dtDel=$_GET["dtDel"];
$dtAl=$_GET["dtAl"];

$lineWidth=19;
$lineHeight=0.42;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtDel, $dtAl;
        $this->SetMargins(1.5, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("REPORTE PARA SEGURO SOCIAL"),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, "PERIODO DEL: ".strftime("%d/%m/%Y", strtotime($dtDel))."  AL  ".strftime("%d/%m/%Y", strtotime($dtAl)),0,1,"L");

        $this->Ln();
        $this->SetFont("","",9);
        $header = array("No. AFILIACION","NOMBRE EMPLEADO","DEVENGADO","FECHA INGRESO","FECHA BAJA");
        $this->SetFont("","B");
        $this->SetWidths(array(3,7,3,2.5,2.5));
        $this->SetAligns(array("C","C","C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("L","L","R","C","C"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sNomper = "SELECT np.*, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
            TRIM(mae.mae_apec) AS mae_apec, TRIM(mae.mae_ctab) AS mae_ctab, TRIM(mae.mae_nigss) AS mae_nigss, 
            mae.mae_fing, mae.mae_fsal, TRIM(mae.mae_nit)  AS mae_nit, mae.mae_stat,
            SUM(np.np_sord+np.np_sexts+np.np_sextd+np.np_comi+np.np_otrp) AS np_devengado,
            SUM(np.np_igss) AS np_totigss
            FROM nomper np
            LEFT JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
            WHERE np_emp='$empCod' AND np_ffin>='$dtDel' AND np_ffin<='$dtAl' AND mae_igsssn='S' GROUP BY np_emp,mae_gru,mae_dep,np_cod,np_ano,np_mes";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["nomper"] = $db->query($sNomper);
$totpag=0;
# GENERAR PDF
//$pdf = new generatePDF("L","cm", "Letter");
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();
$func = new functions();

while ($rec = $db->fetchAssoc($select["nomper"])) {
    $fing="";
    if ($rec["mae_fing"]>=$dtDel && $rec["mae_fing"]<=$dtAl) {
        $fing=strftime("%d/%m/%Y", strtotime($rec["mae_fing"]));
    }   
    $fsal="";
    if ($rec["mae_stat"]=='B') {
      if ($rec["mae_fsal"]>=$dtDel && $rec["mae_fsal"]<=$dtAl) {
        $fsal=strftime("%d/%m/%Y", strtotime($rec["mae_fsal"]));
      }
    }
    $body = array(
        $rec["mae_nigss"],
        $rec["mae_nom"]." ".$rec["mae_ape"],
        number_format($rec["np_devengado"], 2, '.', ','),
        $fing,
        $fsal,
    );
    $pdf->RowBorderHidden($body, $lineHeight);
    $totpag+=$rec["np_devengado"];
}
$pdf->line($pdf->GetX()+9, $pdf->GetY(), 19.5, $pdf->GetY());
$body = array(
    "",
    "                                                TOTAL",        
    number_format($totpag, 2, '.', ','),        
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->Output(utf8_decode("ReporteSegurosocial").".pdf","I");
$db->close();
?>