<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNit=utf8_decode($_SESSION["empNit"]);

$numCoddm=(empty($_GET['numCoddm'])) ? 0 : $_GET['numCoddm'];
$dtDel=$_GET["dtDel"];
$dtAl=$_GET["dtAl"];

$nAnio=date("Y");
$nMes=date("m");

$lineWidth=34;
$lineHeight=0.42;
$lineHeight1=0.29;
$lineHeight2=0.32;
$lineHeight3=0.82;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $empNit;
        $lineWidth=34;
        $lineHeight=0.42;
//        $img = '../img/LogoOsher.png';
//        $this->Image($img,2,.5,3.9,3);
        $this->SetFont("ARIAL","",10);
        $this->MultiAlignCell($lineWidth, $lineHeight, "Folio No. __________                ",0,1,"R");
        $this->SetFont("ARIAL","B",14);
        $this->MultiAlignCell($lineWidth, $lineHeight, $empNom,0,1,"C");
        $this->MultiAlignCell($lineWidth, $lineHeight, $empNit,0,1,"C");
        $this->SetFont("ARIAL","B",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, "LIBRO COMPUTARIZADO PARA LA OPERACION DE SALARIOS DE TRABAJADORES PERMANENTES, AUTORIZADO POR EL MINISTERIO DE TRABAJO Y ",0,1,"C");
        $this->MultiAlignCell($lineWidth, $lineHeight, "PREVISION SOCIAL, FUNDAMENTO LEGAL: ARTICULOS 102 DEL DECRETO No. 1441 Y 2 DEL ACUERDO MINISTERIAL No. 124-2019",0,1,"C");
        //$this->Ln(1);
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
if ($numCoddm==0) {
    $sNomper = "SELECT *, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
                TRIM(tpu.tpu_nom) AS tpu_nom
                FROM nomper np
                LEFT JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
                LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
                WHERE np_emp='$empCod' AND np_ffin>='$dtDel' AND np_ffin<='$dtAl' ORDER BY np_emp,np_cod,np_fini";
} else {
    $sNomper = "SELECT *, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
                TRIM(tpu.tpu_nom) AS tpu_nom
                FROM nomper np
                LEFT JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
                LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
                WHERE np_emp='$empCod' AND np_ffin>='$dtDel' AND np_ffin<='$dtAl' AND np_cod='$numCoddm' ORDER BY np_emp,np_cod,np_fini";
}

# EJECUCION DE QUERYS
$db = new dbExec();
$select["nomper"] = $db->query($sNomper);
$db->close();

# GENERAR PDF
//$pdf = new generatePDF("L","cm", "Letter");
$pdf = new generatePDF("L","cm", "Legal");
$pdf->AddPage();
$pdf->SetMargins(2.2, 1, 1);
$func = new functions();
$ti_cod=9999999999;
$t_lini=1;
$t_corr=1;
$totdtra=0;
$tothord=0;
$tothext=0;
$totsord=0;
$totsext=0;
$tototrp=0;
$totvaca=0;
$totdev=0;
$totigss=0;
$totisr=0;
$tototrd=0;
$totdesc=0;
$totbono14=0;
$totagui=0;
$totboni=0;
$totliqrec=0;
while ($rec = $db->fetchAssoc($select["nomper"])) {
    if ($ti_cod!=$rec["np_cod"]) {
        if ($t_lini>1) {
            // Aqui deben ir los totales
            $htotales = array(
                "TOTALES",
                number_format($totdtra, 0, '.', ','),
                number_format($tothord, 0, '.', ','),
                number_format($tothext, 2, '.', ','),
                number_format($totsord, 2, '.', ','),
                number_format($totsext, 2, '.', ','),
                number_format($tototrp, 2, '.', ','),
                "",
                number_format($totvaca, 2, '.', ','),
                number_format($totdev, 2, '.', ','),
                number_format($totigss, 2, '.', ','),
                number_format($totisr, 2, '.', ','),
                number_format($tototrd, 2, '.', ','),
                number_format($totdesc, 2, '.', ','),
                number_format($totbono14, 2, '.', ','),
                number_format($totagui, 2, '.', ','),
                number_format($totboni, 2, '.', ','),
                "",
                number_format($totliqrec, 2, '.', ','),
            ); 
            $pdf->SetWidths(array(3.9,1.3,1.3,1.8,1.3,1.8,1.3,1.3,1.3,1.3,1.3,1.5,1.5,1.3,1.4,1.3,1.4,1.5,1.3));
            $pdf->SetAligns(array("C","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R"));
            $pdf->Row($htotales, $lineHeight1);
            $totdtra=0;
            $tothord=0;
            $tothext=0;
            $totsord=0;
            $totsext=0;
            $tototrp=0;
            $totvaca=0;
            $totdev=0;
            $totigss=0;
            $totisr=0;
            $tototrd=0;
            $totdesc=0;
            $totbono14=0;
            $totagui=0;
            $totboni=0;
            $totliqrec=0;
            $pdf->AddPage();
        }
        /*$pdf->SetFont("ARIAL","",10);
        $pdf->MultiAlignCell($lineWidth, $lineHeight, "Folio No. __________                ",0,1,"R");
        $pdf->SetFont("ARIAL","B",14);
        $pdf->MultiAlignCell($lineWidth, $lineHeight, $empNom,0,1,"C");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, $empNit,0,1,"C");
        $pdf->SetFont("ARIAL","B",9);
        $pdf->MultiAlignCell($lineWidth, $lineHeight, "LIBRO COMPUTARIZADO PARA LA OPERACION DE SALARIOS DE TRABAJADORES PERMANENTES, AUTORIZADO POR EL MINISTERIO DE TRABAJO Y ",0,1,"C");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, "PREVISION SOCIAL, FUNDAMENTO LEGAL: ARTICULOS 102 DEL DECRETO No. 1441 Y 2 DEL ACUERDO MINISTERIAL No. 124-2019",0,1,"C"); */
        $pdf->Ln(1); 
        $pdf->SetFont("ARIAL","U",8);
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, $rec["mae_nom"]." ".$rec["mae_ape"],0,0,"C");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, ($nAnio-date("Y", strtotime($rec["mae_fecnac"]))).utf8_decode(" Años"),0,0,"C");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, ($rec["mae_sexo"]=='M') ? "MASCULINO" : "FEMENINO",0,0,"C");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, $rec["mae_nacio"],0,0,"C");
        $pdf->MultiAlignCell($lineWidth/6, $lineHeight, $rec["tpu_nom"],0,1,"C");

        $pdf->SetFont("ARIAL","",8);
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, "Nombre del Trabajador",0,0,"C");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, "Edad",0,0,"C");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Género"),0,0,"C");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, "Nacionalidad",0,0,"C");
        $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("Ocupación o Puesto que Desempeña"),0,1,"C");

        $pdf->Ln(1);
        $pdf->SetFont("ARIAL","U",8);
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, $rec["mae_nigss"],0,0,"C");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, $rec["mae_dpi"],0,0,"C");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, strftime("%d/%m/%Y", strtotime($rec["mae_fing"])),0,0,"C");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, "",0,0,"C");
        $pdf->MultiAlignCell($lineWidth/6, $lineHeight, ($rec["mae_stat"]=='B') ? strftime("%d/%m/%Y", strtotime($rec["mae_fsal"])) : "",0,1,"C");
        $pdf->SetFont("ARIAL","",8);
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("No. de Afiliación al Igss"),0,0,"C");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, "No. DPI o Permiso de Trabajo",0,0,"C");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Inicio de relación laboral"),0,0,"C");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, "",0,0,"C");
        $pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("Fecha de Finalización de relación laboral"),0,1,"C");
        $pdf->Ln();

        $pdf->SetFont("","",6);
        $header = array("","HORAS TRABAJADAS","SALARIO DEVENGADO","","DEDUCCIONES LEGALES","");
        $pdf->SetWidths(array(5.1,3.1,7,1.3,5.6,9.2));
        $pdf->SetAligns(array("C","C","C","C","C","C"));
        $pdf->SetX(3);
        $pdf->Row($header, $lineHeight1);


        $header = array("No. de Pago","                   Periodo de Trabajo","                    Salario en Quetzales","                  Dias Trabajados","                  Ordinarias","                  Extraordinarias","                  Ordinario","                  Extraordinario","                  Otros Salarios","                  Septimos y asuetos","                  Vacaciones","                  SALARIO TOTAL","Cuota Laboral Igss","                   Descuentos ISR","                   Otras Deducciones","                  TOTAL","                    Bonificacion anual 42-92", "Aguinaldo decreto 76-78","Bonificacion Incentivo Decreto 37-2001","        Devoluciones ISR y Otras","                  Salario Liquido",utf8_decode("Firma o número de Boleta de Pago / Vaucher"),"                 Observaciones");
        $pdf->SetWidths(array(.7,1.8,1.3,1.3,1.3,1.8,1.3,1.8,1.3,1.3,1.3,1.3,1.3,1.5,1.5,1.3,1.4,1.3,1.4,1.1,1.3,1.4,1.3));
        $pdf->SetAligns(array("C","C","C","C","C","C","C","C","C","C","C","C","C","C","C","C","C","C","C","C","C","C","C"));
        $pdf->SetX(3);
        $pdf->Row($header, $lineHeight1);

        $pdf->SetAligns(array("L","C","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R"));

        $ti_cod=$rec["np_cod"];
        $t_lini=2;
        $t_corr=1;
    }
    $anod=date("Y", strtotime($rec["np_fini"]));
    $nMes=date("m", strtotime($rec["np_fini"]));
    $ndia=date("d", strtotime($rec["np_fini"]));
    if ($rec["np_dtra"]>30) {
        $rec["np_dtra"]=30;
    }
    $body = array(
        number_format($t_corr, 0, '.', ','),
        $ndia."-".strftime("%d/%m/%Y", strtotime($rec["np_ffin"])),
        number_format($rec["np_snom"], 2, '.', ','),
        number_format($rec["np_dtra"], 0, '.', ','),
        number_format($rec["np_dtra"]*8, 0, '.', ','),
        number_format($rec["np_hsim"]+$rec["np_hdob"], 2, '.', ','),
        number_format($rec["np_sord"], 2, '.', ','),
        number_format($rec["np_sexts"]+$rec["np_sextd"], 2, '.', ','),
        number_format($rec["np_comi"]+$rec["np_otrp"], 2, '.', ','),
        "",
        number_format($rec["np_vaca"], 2, '.', ','),
        number_format($rec["np_totdev"]-($rec["np_boni"]+$rec["np_bonii"]+$rec["np_bonoe"]), 2, '.', ','),
        number_format($rec["np_igss"], 2, '.', ','),
        number_format($rec["np_isr"], 2, '.', ','),
        number_format($rec["np_unif"]+$rec["np_lent"]+$rec["np_preb"]+$rec["np_pree"]+$rec["np_desj"]+$rec["np_otrd"], 2, '.', ','),
        number_format($rec["np_igss"]+$rec["np_isr"]+$rec["np_unif"]+$rec["np_lent"]+$rec["np_preb"]+$rec["np_pree"]+$rec["np_desj"]+$rec["np_otrd"], 2, '.', ','),
        number_format($rec["np_bono14"], 2, '.', ','),
        number_format($rec["np_agui"], 2, '.', ','),
        number_format(($rec["np_boni"]+$rec["np_bonii"]+$rec["np_bonoe"]), 2, '.', ','),
        "",
        number_format($rec["np_liqrec"]+$rec["np_anti"], 2, '.', ','),
        "",
        "",
    ); 
    $pdf->SetX(3);
    $pdf->RowBorderHidden($body, $lineHeight3);
    $t_corr+=1;
    $totdtra+=$rec["np_dtra"];
    $tothord+=($rec["np_dtra"]*8);
    $tothext+=($rec["np_hsim"]+$rec["np_hdob"]);
    $totsord+=$rec["np_sord"];
    $totsext+=$rec["np_sexts"]+$rec["np_sextd"];
    $tototrp+=$rec["np_comi"]+$rec["np_otrp"];
    $totvaca+=$rec["np_vaca"];
    $totdev+=($rec["np_totdev"]-($rec["np_boni"]+$rec["np_bonii"]+$rec["np_bonoe"]));
    $totigss+=$rec["np_igss"];
    $totisr+=$rec["np_isr"];
    $tototrd+=($rec["np_unif"]+$rec["np_lent"]+$rec["np_preb"]+$rec["np_pree"]+$rec["np_desj"]+$rec["np_otrd"]);
    $totdesc+=($rec["np_igss"]+$rec["np_isr"]+$rec["np_unif"]+$rec["np_lent"]+$rec["np_preb"]+$rec["np_pree"]+$rec["np_desj"]+$rec["np_otrd"]);
    $totbono14+=$rec["np_bono14"];
    $totagui+=$rec["np_agui"];
    $totboni+=$rec["np_boni"]+$rec["np_bonii"]+$rec["np_bonoe"];
    $totliqrec+=$rec["np_liqrec"]+$rec["np_anti"];
}
$htotales = array(
    "TOTALES",
    number_format($totdtra, 0, '.', ','),
    number_format($tothord, 0, '.', ','),
    number_format($tothext, 2, '.', ','),
    number_format($totsord, 2, '.', ','),
    number_format($totsext, 2, '.', ','),
    number_format($tototrp, 2, '.', ','),
    "",
    number_format($totvaca, 2, '.', ','),
    number_format($totdev, 2, '.', ','),
    number_format($totigss, 2, '.', ','),
    number_format($totisr, 2, '.', ','),
    number_format($tototrd, 2, '.', ','),
    number_format($totdesc, 2, '.', ','),
    number_format($totbono14, 2, '.', ','),
    number_format($totagui, 2, '.', ','),
    number_format($totboni, 2, '.', ','),
    "",
    number_format($totliqrec, 2, '.', ','),
); 
$pdf->SetWidths(array(3.8,1.3,1.3,1.8,1.3,1.8,1.3,1.3,1.3,1.3,1.3,1.5,1.5,1.3,1.4,1.3,1.4,1.1,1.3));
$pdf->SetAligns(array("C","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R"));
$pdf->SetX(3);
$pdf->Row($htotales, $lineHeight1);

$pdf->Output(utf8_decode("LibroSalarios").".pdf","I");
?>