<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$numAno=$_GET["numAno"];
$anoant=$numAno-1;

# QUERYS
$sBono14 = "SELECT *, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape, TRIM(gru_nom) AS gru_nom, TRIM(dep_nom) AS dep_nom,
                mae.mae_fpago, TRIM(tpu.tpu_nom) AS tpu_nom
                FROM bono14 b14
                LEFT JOIN maestro mae ON b14.b14_emp=mae.mae_emp AND b14.b14_cod = mae.mae_cod 
                LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
                LEFT JOIN grupo gru ON mae.mae_emp=gru.gru_emp AND mae.mae_gru = gru.gru_cod 
                LEFT JOIN dep dep ON mae.mae_emp=dep.dep_emp AND mae.mae_dep = dep.dep_cod 
                WHERE b14_emp='$empCod' AND b14_ano='$numAno' ORDER BY b14_emp,mae_gru,mae_dep,b14_cod";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["bono14"] = $db->query($sBono14);

$func = new functions();

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
    die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$iIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($i=0; $i < 1; $i++) { 
    $objPHPExcel->createSheet();
}

# HOJAS
$sheet['bono14']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()->setCreator("Asesoría en Sistemas, S.A.")
                        ->setLastModifiedBy("Asesoría en Sistemas, S.A.")
                        ->setTitle("Office 2007 XLSX Test Document")
                        ->setSubject("Office 2007 XLSX Test Document")
                        ->setDescription("")
                        ->setKeywords("office 2007 openxml php")
                        ->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$i=$iIni;
$j=5;
$objPHPExcel->setActiveSheetIndex($sheet['bono14'])
            ->setCellValueByColumnAndRow($i, 1, $empNom)
            ->setCellValueByColumnAndRow($i, 2, "Bono 14")

            ->setCellValueByColumnAndRow($i, 3, "Correspondiente al ".$numAno)
            ->setCellValueByColumnAndRow($i++, $j, 'CODIGO')
            ->setCellValueByColumnAndRow($i++, $j, 'NOMBRE')
            ->setCellValueByColumnAndRow($i++, $j, 'PUESTO')
            ->setCellValueByColumnAndRow($i++, $j, 'FECHA INGRESO')
            ->setCellValueByColumnAndRow($i++, $j, 'JULIO '.$anoant)
            ->setCellValueByColumnAndRow($i++, $j, 'AGOSTO '.$anoant)
            ->setCellValueByColumnAndRow($i++, $j, 'SEPTIEMBRE '.$anoant)
            ->setCellValueByColumnAndRow($i++, $j, 'OCTUBRE '.$anoant)
            ->setCellValueByColumnAndRow($i++, $j, 'NOVIEMBRE '.$anoant)
            ->setCellValueByColumnAndRow($i++, $j, 'DICIEMBRE '.$anoant)
            ->setCellValueByColumnAndRow($i++, $j, 'ENERO '.$numAno)
            ->setCellValueByColumnAndRow($i++, $j, 'FEBRERO '.$numAno)
            ->setCellValueByColumnAndRow($i++, $j, 'MARZO '.$numAno)
            ->setCellValueByColumnAndRow($i++, $j, 'ABRIL '.$numAno)
            ->setCellValueByColumnAndRow($i++, $j, 'MAYO '.$numAno)
            ->setCellValueByColumnAndRow($i++, $j, 'JUNIO '.$numAno)
            ->setCellValueByColumnAndRow($i++, $j, 'SUMATORIA')
            ->setCellValueByColumnAndRow($i++, $j, 'DIAS')
            ->setCellValueByColumnAndRow($i++, $j, 'BONO 14')
            ->setCellValueByColumnAndRow($i++, $j, 'ANTICIPO')
            ->setCellValueByColumnAndRow($i++, $j, 'LIQUIDO RECIBIR');

# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'bold' => true,
        'size' => 12,
    )
 /*,   'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    ) */
);

$styFec = array(
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styEncabezado = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        'color' => array('rgb' => 'FFFFFF')
        //'color' => array('rgb' => '001a57')

    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => '354D73') ),
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        'wrap' => true,
        )    
);

$styTotales = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        'color' => array('rgb' => 'FFFFFF')
        //'color' => array('rgb' => '001a57')

    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => '354D73') )
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
);

$styLineas = array(
    'font' => array(
        'bold' => false,
        'size' => 9,
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);
//foreach(range('A','I') as $colID) { 
//    $objPHPExcel->getActiveSheet()->getColumnDimension($colID)->setAutoSize(true); 
//}

$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A3')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A4')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A5:U5')->applyFromArray($styEncabezado);
$totdepo=0;
$totch=0;
$grupop=99999;
$depp=99999;
$t_lini=1;
$j=6;
$inidep=6;
while ($rec = $db->fetchAssoc($select["bono14"])) {
    if (($rec["mae_gru"].$rec["mae_dep"]) != ($grupop.$depp)) {
        if ($t_lini>1) {
           $i=$iIni;
           $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, "           TOTAL ESTE DEPARTAMENTO")
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, "") 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(E'.$inidep.':E'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$inidep.':F'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(G'.$inidep.':G'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(H'.$inidep.':H'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(I'.$inidep.':I'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(J'.$inidep.':J'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(K'.$inidep.':K'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(L'.$inidep.':L'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(M'.$inidep.':M'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(N'.$inidep.':N'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(O'.$inidep.':O'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(P'.$inidep.':P'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(Q'.$inidep.':Q'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, "") 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(S'.$inidep.':S'.($j-1).')') 
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(T'.$inidep.':T'.($j-1).')')
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(U'.$inidep.':U'.($j-1).')');
            $objPHPExcel->getActiveSheet()->getStyle('B'.$j.':U'.$j)->applyFromArray($styTotales);
            $j+=1;
            $inidep=$j;
        }

        $i=$iIni;
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($i++, $j, "GRUPO Y DEPARTAMENTO: ".$rec["gru_nom"].", ".$rec["dep_nom"]);
        $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':E'.$j)->applyFromArray($styEmp);

        $grupop=$rec["mae_gru"];
        $depp=$rec["mae_dep"];
        $j+=1;
        $t_lini=2;
    }
    $i=$iIni;
    $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_cod"])
                ->setCellValueByColumnAndRow($i++, $j, utf8_encode($rec["mae_nom"].$rec["mae_ape"]))
                ->setCellValueByColumnAndRow($i++, $j, $rec["tpu_nom"])
                ->setCellValueByColumnAndRow($i++, $j, strftime("%d/%m/%Y", strtotime($rec["mae_fing"])))
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_jul"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_ago"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_sep"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_oct"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_nov"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_dic"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_ene"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_feb"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_mar"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_abr"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_may"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_jun"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_tot"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_dias"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_bono"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_anti"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["b14_liqrec"]); 
    $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':U'.$j)->applyFromArray($styLineas);
    $j+=1;
    if ($rec["mae_fpago"]<=2) {
        $totdepo+=$rec["b14_liqrec"];
    } else {
        $totch+=$rec["b14_liqrec"];
    }
}
$i=$iIni;
$objPHPExcel->getActiveSheet()
        ->setCellValueByColumnAndRow($i++, $j, "")
        ->setCellValueByColumnAndRow($i++, $j, "           TOTAL ESTE DEPARTAMENTO")
        ->setCellValueByColumnAndRow($i++, $j, "")
        ->setCellValueByColumnAndRow($i++, $j, "") 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(E'.$inidep.':E'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$inidep.':F'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(G'.$inidep.':G'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(H'.$inidep.':H'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(I'.$inidep.':I'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(J'.$inidep.':J'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(K'.$inidep.':K'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(L'.$inidep.':L'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(M'.$inidep.':M'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(N'.$inidep.':N'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(O'.$inidep.':O'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(P'.$inidep.':P'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(Q'.$inidep.':Q'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, "") 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(S'.$inidep.':S'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(T'.$inidep.':T'.($j-1).')')
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(U'.$inidep.':U'.($j-1).')');
    $objPHPExcel->getActiveSheet()->getStyle('B'.$j.':U'.$j)->applyFromArray($styTotales);
$j+=1;
$inidep=$j;

$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "                          TOTAL GENERAL")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",E6:E'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",F6:F'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",G6:G'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",H6:H'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",I6:I'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",J6:J'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",K6:K'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",L6:L'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",M6:M'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",N6:N'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",O6:O'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",P6:P'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",Q6:Q'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",S6:S'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",T6:T'.($j-1).')')
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",U6:U'.($j-1).')');
$objPHPExcel->getActiveSheet()->getStyle('B'.$j.':U'.$j)->applyFromArray($styTotales);

$j+=3;
$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "DEPOSITO A CUENTA")
    ->setCellValueByColumnAndRow($i++, $j, $totdepo);
$j+=1;
$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "PAGO CON CHEQUE")
    ->setCellValueByColumnAndRow($i++, $j, $totch);


$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(10);
$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(12);
$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(12);

$objPHPExcel->getActiveSheet()->getStyle('E6'.':Q'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('R6'.':R'.$j)->getNumberFormat()->setFormatCode('#,##0');
$objPHPExcel->getActiveSheet()->getStyle('S6'.':U'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('A6'.':C'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['bono14'])->setTitle('Bono 14');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="Bono 14.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>