<?php 
include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);
$pTcam=$_SESSION["pTcam"];

$lineWidth=18;
$lineHeight=0.35;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $empNomc, $txtTitulo, $txtFecl, $textoMoneda, $cbNoFol, $numHoja, $lineWidth, $lineHeight;
        $this->SetMargins(2, 2, 2);

        $func = new functions();
        $this->SetFont("Arial","B",15);
        $this->SetY(1.5);
        $this->Ln();
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("LISTADO DE USUARIOS"),0,1,"C");
        $this->Ln();

        $this->SetFont("","B",8);
        $header = array(utf8_decode("Código"),"Nombre","Puesto");
        $this->SetWidths(array(2,8,8));
        $this->SetAligns(array("C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("C","C","C"));
    }
    
    function Footer() {
        global $cbFecsn;
        // Posición: a 1,5 cm del final
        $func = new functions();
        $this->SetY(-2);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"C");
    }
}

# QUERYS
$sUsuarios = "SELECT * FROM usuarios";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["usuarios"] = $db->query($sUsuarios);

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();

$func = new functions();
while ($rec = $db->fetchAssoc($select["usuarios"])) {
    $body = array($rec["usu_cod"], $rec["usu_nom"], $rec["usu_pue"]);
    $pdf->RowBorderLR($body, $lineHeight);
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 20, $pdf->GetY());

$db->close();
$pdf->Output(utf8_decode("Listado de Usuarios").".pdf","I");
?>