<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');
include_once("../../../php/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$usuNom=utf8_decode($_SESSION["usuNom"]);


$numNum=$_GET["numNum"];
$selBanCod=$_GET["selBanCod"];

$lineWidth=17;
$lineHeight=0.35;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $numPoli, $numPolf;
    }
    
    function Footer() {
    }
}

# QUERYS
$sCheques = "SELECT *, TRIM(m.mes_nom) AS mes_nom 
        FROM cheques ch LEFT JOIN bancos ban ON ban.ban_emp=ch.ch_emp AND ban.ban_num=ch.ch_ban 
        LEFT JOIN meses m ON month(ch.ch_fec)=m.mes_cod 
        WHERE ch_emp='$empCod' AND ch_ban='$selBanCod' AND ch_num='$numNum'";

function sPoli_det($selBanCod, $numNum) {
    global $empCod;
    return "SELECT *,
                TRIM(pold_cta) AS pold_cta,
                TRIM(pold_ctan) AS pold_ctan
            FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='004' AND pold_num='$numNum'";
}

# EJECUCION DE QUERYS
$db = new dbExec();
$select["cheques"] = $db->query($sCheques);

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 27.94));
$pdf->AddPage();
$totDebe = 0;
$totHaber = 0;
while ($rec = $db->fetchAssoc($select['cheques'])) {
    $anoch=date("Y", strtotime($rec["ch_fec"]));
    $diach=date("d", strtotime($rec["ch_fec"]));

    $func = new functions();

    $valor=$rec["ch_tot"];
    $tcam=$rec["ch_tcam"];
    $valLetras=$func->numLetras($valor,$tcam);

    $pdf->SetMargins(1.2, 1, 2.5);
    $pdf->SetAutoPageBreak(true,.5);
    $pdf->SetFont("Arial","B",20);

    $lineWidth=17;
    $lineHeight=0.6;

    $pdf->SetFont("","",11);
    $pdf->SetFont("","");
    $pdf->SetX(8.5);
    $pdf->SetY(1.55);
    if ($rec["ch_nego"] == "N") {
        $pdf->SetFont("","B");
        $pdf->SetX(8.1);
        $pdf->MultiAlignCell($lineWidth/4, $lineHeight, "NO NEGOCIABLE",0,1,"L");
    } else {
        $pdf->SetFont("","B");
        $pdf->MultiAlignCell($lineWidth/4, $lineHeight, " ",0,1,"L");
    }
    $pdf->SetFont("","");
    $pdf->SetY(2.30);
    $pdf->SetX(3.3);
    $pdf->MultiAlignCell($lineWidth/7.5, $lineHeight, utf8_decode("Guatemala, "));
    $pdf->MultiAlignCell($lineWidth/2.35, $lineHeight, $diach." de ".$rec["mes_nom"]." del ".$anoch);
    $pdf->MultiAlignCell($lineWidth/4.8, $lineHeight, "***".number_format($rec["ch_tot"],2),0,1,"R");
    $pdf->SetFont("","",10);
    $pdf->SetX(3.6);
    $pdf->MultiAlignCell($lineWidth/1.1, $lineHeight,utf8_decode("** ".$rec["ch_bene"]." **"),0,1,"L");
    $pdf->SetX(2.2);
    $pdf->SetFont("","",10);
    $pdf->MultiAlignCell($lineWidth/1.1, $lineHeight,utf8_decode("** ".$valLetras." **"),0,1,"L");
    $pdf->SetX(4.0);

    $pdf->SetFont("","",8);

//    if ($rec["ch_num"] < $numChf) { $pdf->AddPage(); }        
}

$db->close();

$pdf->Output(utf8_decode("Cheques").".pdf","I");

?>