<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');
include_once("../../../php/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$usuNom=utf8_decode($_SESSION["usuNom"]);


$numNum=$_GET["numNum"];
$selBanCod=$_GET["selBanCod"];

$lineWidth=17;
$lineHeight=0.35;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $numPoli, $numPolf;
    }
    
    function Footer() {
    }
}

# QUERYS
$sCheques = "SELECT *, TRIM(m.mes_nom) AS mes_nom, TRIM(ban.ban_nom) AS ban_nom, 
        TRIM(ban.ban_ctab) AS ban_ctab 
        FROM cheques ch LEFT JOIN bancos ban ON ban.ban_emp=ch.ch_emp AND ban.ban_num=ch.ch_ban 
        LEFT JOIN meses m ON month(ch.ch_fec)=m.mes_cod 
        WHERE ch_emp='$empCod' AND ch_ban='$selBanCod' AND ch_num='$numNum'";

function sPoli_det($selBanCod, $numNum) {
    global $empCod;
    return "SELECT *,
                TRIM(pold_cta) AS pold_cta,
                TRIM(pold_ctan) AS pold_ctan
            FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='004' AND pold_num='$numNum'";
}

# EJECUCION DE QUERYS
$db = new dbExec();
$select["cheques"] = $db->query($sCheques);

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 27.94));
$pdf->AddPage();
$totDebe = 0;
$totHaber = 0;
while ($rec = $db->fetchAssoc($select['cheques'])) {
    $anoch=date("Y", strtotime($rec["ch_fec"]));
    $diach=date("d", strtotime($rec["ch_fec"]));

    $func = new functions();

    $valor=$rec["ch_tot"];
    $tcam=$rec["ch_tcam"];
    $valLetras=$func->numLetras($valor,$tcam);

    $pdf->SetMargins(1.2, 1, 2.5);
    $pdf->SetAutoPageBreak(true,.5);
    $pdf->SetFont("Arial","B",20);

    $lineWidth=17;
    $lineHeight=0.7;

    $pdf->SetFont("","",9);
    $pdf->SetFont("","");
    $pdf->SetY(.9);
    $pdf->SetX(15.5);
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, $numNum,0,1,"L");

    $pdf->SetFont("","",11);
    $pdf->SetFont("","");
    $pdf->SetX(8.5);
    $pdf->SetY(1.75);
    if ($rec["ch_nego"] == "N") {
        $pdf->SetFont("","B");
        $pdf->SetX(8.5);
        $pdf->MultiAlignCell($lineWidth/4, $lineHeight, "NO NEGOCIABLE",0,1,"L");
    } else {
        $pdf->SetFont("","B");
        $pdf->MultiAlignCell($lineWidth/4, $lineHeight, " ",0,1,"L");
    }
    $pdf->SetY(2.5);
    $pdf->SetX(5.5);
    $pdf->MultiAlignCell($lineWidth/7, $lineHeight, utf8_decode("Guatemala, "));
    $pdf->MultiAlignCell($lineWidth/2.35, $lineHeight, $diach." de ".$rec["mes_nom"]." del ".$anoch);
    $pdf->MultiAlignCell($lineWidth/4.5, $lineHeight, "***".number_format($rec["ch_tot"],2),0,1,"R");
    $pdf->SetX(5.5);
    $pdf->MultiAlignCell($lineWidth/1.1, $lineHeight,utf8_decode("** ".$rec["ch_bene"]." **"),0,1,"L");
    $pdf->SetX(4.8);
    $pdf->MultiAlignCell($lineWidth/1.1, $lineHeight,utf8_decode("** ".$valLetras." **"),0,1,"L");
    $pdf->SetX(4.0);

    $pdf->SetY(5.5);
    $pdf->SetX(5.0);
    $pdf->SetFont("","B",9);
    $pdf->MultiAlignCell($lineWidth/2, $lineHeight,utf8_decode("BANCO: ".$rec["ban_nom"]),0,0,"L");
    $pdf->MultiAlignCell($lineWidth/2, $lineHeight,utf8_decode("CUENTA: ".$rec["ban_ctab"]),0,1,"L");

    $pdf->SetFont("","B",9);
    $pdf->SetY(7.5);
    $pdf->SetX(2.0);

    $lineHeight=0.4;

    $pdf->Ln($lineHeight*6);

//    $header = array("","Nombre de Cuenta","Debe","Haber");
    $pdf->SetFont("","B");
    $pdf->SetWidths(array(3,8,3,3));
    $pdf->SetAligns(array("C","C","C","C"));
//    $pdf->Row($header, $lineHeight);

//    $pdf->SetFont("");
    $pdf->SetAligns(array("L","L","R","R"));
    $debe = 0;
    $haber = 0;

    $pdf->SetY(7.0);
    $select["poli_det"] = $db->query(sPoli_det($rec["ch_ban"], $rec["ch_num"]));
    while ($recTbl = $db->fetchAssoc($select['poli_det'])) {
        $debe += $recTbl["pold_debe"];
        $haber += $recTbl["pold_haber"];
        $body = array(
            $recTbl["pold_cta"],
            $recTbl["pold_ctan"],
            ($recTbl["pold_debe"] != 0) ? $recTbl["pold_debe"] : "",
            ($recTbl["pold_haber"] != 0) ? $recTbl["pold_haber"] : "",
        );
        $pdf->RowBorderHidden($body, $lineHeight);
    }

    $pdf->SetAligns(array("","R","R","R"));
    $body = array(
        "",
        "",
        "===============",
        "===============",
    );
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array(
        "",
        "",
        number_format($debe,2),
        number_format($haber,2),
    );
    $pdf->RowBorderHidden($body, $lineHeight);

    $pdf->Ln();
    $pdf->SetX(4.0);
    $pdf->MultiAlignCell($lineWidth/1, $lineHeight, $rec["ch_con"]);
    $pdf->Ln();
//    $pdf->SetX(4.0);
    $pdf->MultiAlignCell($lineWidth, $lineHeight, strftime("%d/%m/%Y", strtotime($rec["ch_fec"])),0,1,"L");

//    $pdf->SetFont("","",8);
    $pdf->SetY(14.5);
    $pdf->SetX(1.0);
    $pdf->MultiAlignCell($lineWidth/4, $lineHeight, $usuNom,0,1,"L");

//    if ($rec["ch_num"] < $numChf) { $pdf->AddPage(); }        
}

$db->close();

$pdf->Output(utf8_decode("Voucher").".pdf","I");

?>