<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);


$jsonCaja=json_decode($_GET["tblCaja"]);


class generatePDF extends PDF_MC_Table {
    function Header() {
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        $this->SetY(-2.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();
$pdf->SetMargins(1.5, 1, 1.5);
$pdf->SetFont("Arial","B",17);

$pdf->Cell(20,.7,$empNom,0,1,"C");

$lineWidth=17;
$lineHeight=0.4;

$pdf->SetFont("","",8);
$pdf->Ln($lineHeight);
$pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de Documentos para emision de Cheque Caja Chica"));
    //.strftime("%d/%m/%Y", strtotime($dtFec))),0,0,"C");
$pdf->Ln($lineHeight);

$header = array("Serie","Numero","Fecha","Nit","Proveedor","Valor");
$pdf->SetFont("","B");
$pdf->SetWidths(array(2.8,2.8,1.8,2.5,7,2));
$pdf->SetAligns(array("L","L","C","C","L","C"));
$pdf->Row($header, $lineHeight);
$pdf->SetFont("");
$pdf->SetAligns(array("L","L","C","L","L","R"));
$valtot=0;
foreach ($jsonCaja as $obj) {
    $body = array(
        $obj->serie,
        $obj->numero,
        $obj->fecha,    
        $obj->nit,
        utf8_decode($obj->prov),
        $obj->valor,
    );
    $pdf->RowBorderHidden($body, $lineHeight); 
    $valtot += $obj->valor;
} 


$pdf->line($pdf->GetX(), $pdf->GetY(), 20.5, $pdf->GetY());

$pdf->SetAligns(array("","","","","R","R"));
$body = array(
    "",
    "",
    "",
    "",
    "Totales:",
    number_format($valtot,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX(), $pdf->GetY(), 20.5, $pdf->GetY());

$pdf->Output(utf8_decode("Listado Caja Chica").".pdf","I");
?>