<?php 
include_once('../../../php/sessionStart.php'); 
include_once('../../../php/db/dbExec.php');
include_once('../../../php/maxExecTime.php');

# QUERYS
$sMeses = "SELECT * FROM meses";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["meses"] = $db->query($sMeses);
$db->close();

$AnoTrab=date("Y", strtotime($_SESSION['empFtrab']));
$MesTrab=date("m", strtotime($_SESSION['empFtrab']));
?>
<?php include_once('../includes/htmlOpen.php'); ?>
    <main class="main" style="">
      <?php 
        $li[0] = '<i class="fas fa-file-excel"></i>';
        $li[1] = $_GET["opcNom"];
        include_once('../../../php/includes/ol.php');

        $modalImp = "modalImp";
        include_once('../../../php/includes/modalImp.php');
      ?>
      <div class="container-as">
        <div class="row">
          <div class="col">
            <ul class="nav nav-pills mb-1" id="pills-tab" role="tablist">
              <li class="nav-item">
                <a class="nav-link active" id="pills-0-tab" data-toggle="pill" href="#pills-0" role="tab" aria-controls="pills-0" aria-selected="true">Generar Reporte</a>
              </li>
            </ul>
            <div class="tab-content bg-transparent border-0" id="pills-tabContent">
              <div class="tab-pane fade show active" id="pills-0" role="tabpanel" aria-labelledby="pills-0-tab">
                
                <form action="" name="thisform" autocomplete="off" enctype="multipart/form-data">
                  <div class="form-group">
                    <div class="form-row align-items-end">
                      <div class="col-md-6">
                        <div class="form-row">
                          <div class="col-7">
                            <label for="selMes">Mes</label>
                            <select class="form-control form-control-sm form-control-as" name="selMes" id="selMes">
                              <?php
                                while ($rec = $db->fetchAssoc($select['meses'])) {
                                  echo  '<option value="'.$rec['mes_cod'].'">'.utf8_encode($rec['mes_nom']).'</option>';
                                }
                              ?>
                            </select>
                          </div>

                          <div class="col-5">
                            <label for="numAno">Año</label>
                            <input type="number" class="form-control form-control-sm form-control-as" id="numAno" placeholder="">
                          </div>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <label for="txtFecl">Fecha en letras</label>
                        <input type="text" class="form-control form-control-sm form-control-as" id="txtFecl" placeholder="">
                      </div>
                    </div>

                    <div class="form-row align-items-end">
                      <div class="col-md-6">
                        <label for="txtTitulo">Título del Reporte</label>
                        <input type="text" class="form-control form-control-sm form-control-as" id="txtTitulo" placeholder="">
                      </div>

                      <div class="col-md-6">
                        <div class="form-row align-items-end">
                          <div class="col-4">
                            <label for="selNiv">Nivel</label>
                            <select class="form-control form-control-sm form-control-as" name="selNiv" id="selNiv">
                              <option value="0">Seleccionar...</option>
                              <option value="1">1</option>
                              <option value="2">2</option>
                              <option value="3">3</option>
                              <option value="4">4</option>
                              <option value="5">5</option>
                              <option value="6">6</option>
                              <option value="7">7</option>
                              <option value="8">8</option>
                              <option value="9">9</option>
                            </select>
                          </div>
                          <div class="col-8">
                            <label for="numHoja">No. Última Hoja</label>
                            <input type="number" class="form-control form-control-sm form-control-as" id="numHoja" placeholder="">
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="form-row">
                      <div class="col-md-4">
                        <label class="pr-1">Moneda</label>
                        <div class="custom-control custom-radio custom-control-inline">
                          <input type="radio" id="crMoneda1" name="crMoneda" class="custom-control-input" value="L">
                          <label class="custom-control-label" for="crMoneda1">Local</label>
                        </div>
                        <div class="custom-control custom-radio custom-control-inline">
                          <input type="radio" id="crMoneda2" name="crMoneda" class="custom-control-input" value="D">
                          <label class="custom-control-label" for="crMoneda2">Dólares</label>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="custom-control custom-switch">
                          <input type="checkbox" class="custom-control-input" name="cbSinPol" id="cbSinPol">
                          <label class="custom-control-label" for="cbSinPol">Sin póliza de cierre</label>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="custom-control custom-switch">
                          <input type="checkbox" class="custom-control-input" name="cbFecsn" id="cbFecsn">
                          <label class="custom-control-label" for="cbFecsn">Incluye fecha y hora</label>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="custom-control custom-switch">
                          <input type="checkbox" class="custom-control-input" name="cbNoFol" id="cbNoFol">
                          <label class="custom-control-label" for="cbNoFol">Incluye No. Folio</label>
                        </div>
                      </div>
                    </div>

                    <div class="form-row">
                      <div class="col-12">
                        <label for="txtLeyenda">Leyenda</label>
                        <textarea class="form-control form-control-sm form-control-as" id="txtLeyenda" rows="7"></textarea>
                      </div>
                    </div>
                  </div>

                  <h3 class="text-light"></h3>

                  <div class="form-group">
                    <div class="form-row">
                      <div class="form-group col">
                        <button class="btn btn-primary btn-lg btn-block" id="btnImprimir" type="button">Imprimir</button>
                      </div>
                      <div class="form-group col">
                        <button class="btn btn-success btn-lg btn-block" id="btnExcel" type="button">Excel</button>
                      </div>
                    </div>
                  </div>
                </form>

              </div>
            </div>
          </div>
        </div>
      </div>
    </main>
<?php include_once('../../../php/includes/htmlClose.php'); ?>

<script>
  const selMes = document.thisform.selMes;
  const numAno = document.thisform.numAno;
  const txtFecl = document.thisform.txtFecl;
  const txtTitulo = document.thisform.txtTitulo;
  const selNiv = document.thisform.selNiv;
  const numHoja = document.thisform.numHoja;
  const crMoneda = document.thisform.crMoneda;
  const cbSinPol = document.thisform.cbSinPol;
  const cbFecsn = document.thisform.cbFecsn;
  const cbNoFol = document.thisform.cbNoFol;
  const txtLeyenda = document.thisform.txtLeyenda;

  function restriccion() {
    if (isNullPer(selMes.value)) {
      selMes.focus();
      alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el TIPO DE POLIZA"}});
      return true;
    }
    return false;
  }

  function fechaLetras() {
    if (selMes.value!=0) {
      var ultimoDia = new Date(numAno.value, selMes.value, 0);
      txtFecl.value = ultimoDia.getDate()+" de "+$("#selMes option:selected").text()+" de "+numAno.value;
    } else {
      txtFecl.value = "";
    }
  }

  function getElements(locationPHP) {
    const textoMoneda = (crMoneda.value != "L") ? "Dólares" : "Quetzales";
    const getMes = "?selMes="+selMes.value;
    const getAno = "&numAno="+numAno.value;
    const getFecl = "&txtFecl="+txtFecl.value;
    const getTitulo = "&txtTitulo="+txtTitulo.value;
    const getNiv = "&selNiv="+selNiv.value;
    const getHoja = "&numHoja="+numHoja.value;
    const getMoneda = "&crMoneda="+crMoneda.value;
    const getTextoMoneda = "&textoMoneda="+textoMoneda;
    const getSinPol = "&cbSinPol="+cbSinPol.checked;
    const getFecsn = "&cbFecsn="+cbFecsn.checked;
    const getNoFol = "&cbNoFol="+cbNoFol.checked;
    const getLeyenda = "&txtLeyenda="+(txtLeyenda.value).replace(/(?:\r\n|\r|\n)/g, '|');

    return window.location.origin+window.location.pathname+locationPHP+".php"+getMes+getAno+getFecl+getTitulo+getNiv+getHoja+getMoneda+getTextoMoneda+getSinPol+getFecsn+getNoFol+getLeyenda;
  }

  $(document).ready(function() {
    $(this).find('select:visible:first').focus();
    selMes.value = <?php echo $MesTrab; ?>;
    numAno.value = <?php echo $AnoTrab; ?>;
    fechaLetras();
    txtTitulo.value = "Balance General";
    selNiv.value = 9;
    numHoja.value = 0;
    crMoneda.value = "L";
    cbFecsn.checked = true;
    cbSinPol.checked = true;
    cbNoFol.checked = true;

    // SUBMIT FORM
    $('form').submit(function() {
      return false;
    });

    $('#selMes').change(function() {
      fechaLetras();
    });

    $('#numAno').change(function() {
      fechaLetras();
    });

    // CLICK IMPRIMIR
    $("#btnImprimir").click(function (){
      if (restriccion()) {return};

      window.open(getElements("print"), '_blank');
    });

    // CLICK EXCEL
    $("#btnExcel").click(function (){
      if (restriccion()) {return};

      window.location.href = getElements("excel");
    });
  });

</script>