<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$txtSerie=$_GET["txtSerie"];
$numNum=$_GET["numNum"];
$tipoPol = "010";

# QUERYS
$sDoctoscc = "SELECT *,
                TRIM(dc_clien) AS dc_clien
             FROM doctoscc dc
             LEFT JOIN tipov t ON dc.dc_tipo=t.tv_cod
             WHERE dc_emp='$empCod' AND dc_serie='$txtSerie' AND dc_num='$numNum'";

$sTipopol = "SELECT TRIM(tp_nom) AS tp_nom FROM tipopol WHERE tp_cod='$tipoPol'";

$sPoli_det = "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$numNum' AND pold_tipoi='$txtSerie'";

# EJECUCION DE QUERYS
$db = new dbExec();
$fa["doctoscc"] = $db->sFetchAssoc($sDoctoscc);
$fa["tipopol"] = $db->sFetchAssoc($sTipopol);
$select["poli_det"] = $db->query($sPoli_det);
$db->close();

$tipoPolNom = $fa["tipopol"]["tp_nom"];

class generatePDF extends PDF_MC_Table {
    function Header() {
    }
    
    function Footer() { 
        global $tipoPolNom;
        // Posición:a 1,5 cm del final
        $this->SetY(-2.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,0,"C");
        $this->Ln(.5);
        $this->Cell(0,1,$tipoPolNom,0,0,"C");
    }
}

# GENERAR PDF
$pdf = new generatePDF("P", "cm", "Letter");
//$pdf = new FPDF('P','mm',array(500,150));
$pdf->AddPage();
$pdf->SetMargins(2.5, 1, 2.5);
$pdf->SetFont("Arial","B",20);

$pdf->Cell(20,.7,$empNom,0,1,"C");
$pdf->Ln();

$lineWidth=16.5;
$lineHeight=0.5;

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/13, $lineHeight, utf8_decode("Serie:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7, $lineHeight, $txtSerie);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/9, $lineHeight, utf8_decode("Número:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6, $lineHeight, $numNum);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/8.5, $lineHeight, utf8_decode("CODIGO:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/5.5, $lineHeight, $fa["doctoscc"]["dc_codp"], 0, 0);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/9.5, $lineHeight, utf8_decode("NIT:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6, $lineHeight, $fa["doctoscc"]["dc_nit"], 0, 1);


$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/14, $lineHeight, utf8_decode("Tipo:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/1.73, $lineHeight, $fa["doctoscc"]["tv_nom"]);

$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, utf8_decode("Fecha del Documento:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, strftime("%d/%m/%Y", strtotime($fa["doctoscc"]["dc_fec"])), 0, 1);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, utf8_decode("Cliente:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/1.1, $lineHeight, $fa["doctoscc"]["dc_clien"], 0, 1);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Ventas:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctoscc"]["dc_bien"], 2), 0, 0, "R");

$pdf->Cell($lineWidth/11, $lineHeight);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Servicios:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctoscc"]["dc_serv"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Ventas Exentas:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctoscc"]["dc_exen"], 2), 0, 0, "R");

$pdf->Cell($lineWidth/11, $lineHeight);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Exportación Centro América:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctoscc"]["dc_exp"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Exportación Resto del Mundo:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctoscc"]["dc_expre"], 2), 0, 0, "R");

$pdf->Cell($lineWidth/11, $lineHeight);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Medicamentos:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctoscc"]["dc_medi"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("No Afecto Dec. 29-89:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctoscc"]["dc_noafe"], 2), 0, 0, "R");

$pdf->Cell($lineWidth/11, $lineHeight);

$pdf->Ln();
$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Total Factura Combustible:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctoscc"]["dc_tfaco"], 2), 0, 0, "R");

$pdf->Cell($lineWidth/11, $lineHeight);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Valor Afecto Combustible:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctoscc"]["dc_comb"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Galones Super:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctoscc"]["dc_galos"], 3));

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Galones Regular:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctoscc"]["dc_galor"], 3));

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Galones Diesel:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctoscc"]["dc_galod"], 3), 0, 1);

$pdf->Ln();
$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/1.15, $lineHeight, utf8_decode("Retención ISR:"), 0, 0, "R");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctoscc"]["dc_ret"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/1.15, $lineHeight, utf8_decode("Retención IVA:"), 0, 0, "R");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctoscc"]["dc_reti"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/1.15, $lineHeight, utf8_decode("Subtotal:"), 0, 0, "R");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctoscc"]["dc_sub"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/1.15, $lineHeight, utf8_decode("IVA:"), 0, 0, "R");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctoscc"]["dc_iva"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/1.15, $lineHeight, utf8_decode("Imp.Combust.:"), 0, 0, "R");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctoscc"]["dc_dedu"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/1.15, $lineHeight, utf8_decode("Total:"), 0, 0, "R");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctoscc"]["dc_tot"], 2), 0, 1, "R");

$pdf->Ln();
$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Número de Póliza:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/2, $lineHeight, $tipoPol."-".$numNum);

$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Fecha de Póliza:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, strftime("%d/%m/%Y", strtotime($fa["doctoscc"]["dc_fec"])));
$pdf->Ln($lineHeight);

$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, "Concepto:");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/1.35, $lineHeight, $fa["doctoscc"]["dc_con"]);
$pdf->Ln($lineHeight*3);

$header = array("Cuenta","Nombre de Cuenta","Debe","Haber");
$pdf->SetFont("","B");
$pdf->SetWidths(array(3,8,3,3));
$pdf->SetAligns(array("C","C","C","C"));
$pdf->Row($header, $lineHeight);

$pdf->SetFont("");
$pdf->SetAligns(array("L","L","R","R"));
$debe = 0;
$haber = 0;
while ($rec = $db->fetchAssoc($select['poli_det'])) {
    $debe += $rec["pold_debe"];
    $haber += $rec["pold_haber"];
    $body = array(
        $rec["pold_cta"],
        $rec["pold_ctan"],
        (round($rec["pold_debe"], 2) != 0) ? $rec["pold_debe"] :"",
        (round($rec["pold_haber"], 2) != 0) ? $rec["pold_haber"] :"",
    );
    $pdf->RowBorderLR($body, $lineHeight);
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());

$pdf->SetAligns(array("","R","R","R"));
$body = array(
    "",
    "Totales:",
    number_format($debe,2),
    number_format($haber,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());

$pdf->Ln($lineHeight*6);
$pdf->Cell($lineWidth/6);
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, "Hecho por", "T", 0, "C");
$pdf->Cell($lineWidth/6);
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, "Revisado por", "T", 0, "C");

$pdf->Output(utf8_decode("Póliza ").$tipoPol."-".$numNum.".pdf","I");
?>