<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$bitForm = "cxc1020";
$bitMod = "cxc";
$empCod = $_SESSION['empCod'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultar':
		echo consultar();
		break;

	case 'consultarClien':
		echo consultarClien();
		break;

	case 'consultarTr':
		echo consultarTr();
		break;

	case 'consultarCorr':
		echo consultarCorr();
		break;
	case 'consultarCta':
		echo consultarCta();
		break;
		
	case 'mCerrado':
		echo mCerrado();
		break;

	case 'generarPartida':
		echo generarPartida();
		break;

	case 'generarPartidat':
		echo generarPartidat();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'guardarTr':
		echo guardarTr();
		break;

}

function consultar() {
	global $empCod, $usuNom;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$tipoCod="002.01";
	$numNum=$_POST['numNum'];
	$selBanCod=$_POST['selBanCod'];

	# QUERYS
	$sMovi = "SELECT * FROM movi WHERE mov_emp='$empCod' AND mov_ban='$selBanCod' AND mov_tipo='$tipoCod' AND mov_num='$numNum'";
	$sPoli_det = "SELECT *, TRIM(pold_cta) AS pold_cta FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$tipoCod' AND pold_num='$numNum'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sMovi, "movi");
	$resp["poli_det"] = $db->sFetchAll($sPoli_det);
	$db->close();

	$func = new functions();
	$resp["asdf"]=$sPoli_det;
	//return $func->jsonEncodeArrayEach($resp, array('cheques', 'poli_det'));
	return $func->jsonEncodeArray($resp, 'movi');
}

function consultarClien() {
	global $empCod;
	$txtCodp=utf8_decode($_POST['txtCodp']);

	# QUERYS
	$sClien = "SELECT *, TRIM(cli_nit) AS cli_nit, TRIM(cli_nom) AS cli_nom, TRIM(cli_cta) AS cli_cta FROM cliencc WHERE cli_emp='$empCod' and cli_cod='$txtCodp'";
	
	$sDoctoscc = "SELECT *, TRIM(dc.dc_con) AS dc_con, TRIM(dc.dc_clien) AS dc_clien, (dc_tot-(dc_ret+dc_reti+dc_abo)) AS dc_sal, 0.00 AS dc_abop FROM doctoscc dc LEFT JOIN cliencc cli ON dc.dc_emp=cli.cli_emp and dc.dc_codp=cli.cli_cod WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND (dc_tot-(dc_ret+dc_reti+dc_abo))>0.00";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sClien, "cliencc");
	$resp["doctoscc"] = $db->sFetchAll($sDoctoscc);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cliencc", "doctoscc");
}

function consultarTr() {
	global $empCod, $usuNom;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$tipoCod="003.01";
	$numNum=$_POST['numNum'];
	$selBanCod=$_POST['selBanCod'];

	# QUERYS
	$sMovi = "SELECT * FROM movi WHERE mov_emp='$empCod' AND mov_ban='$selBanCod' AND mov_tipo='$tipoCod' AND mov_num='$numNum'";
	$sPoli_det = "SELECT *, TRIM(pold_cta) AS pold_cta FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$tipoCod' AND pold_num='$numNum'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sMovi, "movi");
	$resp["poli_det"] = $db->sFetchAll($sPoli_det);
	$db->close();

	$func = new functions();
	$resp["asdf"]=$sPoli_det;
	//return $func->jsonEncodeArrayEach($resp, array('cheques', 'poli_det'));
	return $func->jsonEncodeArray($resp, 'movi');
}


function consultarCorr() {
	global $empCod, $usuNom;

	$func = new functions();
	$selBanCod=$_POST['selBanCod'];
	# QUERYS
	$sBancos = "SELECT ban_mon,ban_corr FROM bancos WHERE ban_emp='$empCod' AND ban_num='$selBanCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["bancos"] = $db->sFetchAssoc($sBancos);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "bancos");
}

function mCerrado() {
	global $empCod, $usuNom;

	$func = new functions();
	$dtFec=$_POST['dtFec'];
	$nAnio=date("Y", strtotime($dtFec));
	$nMes=date("n", strtotime($dtFec));

	# QUERYS
	$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$nAnio AND ciem_mes=$nMes";
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ciemes"] = $db->sfetchAssoc($sCiemes);
	$db->close();
	$func = new functions();
	return $func->jsonEncodeArray($resp, "ciemes");
}

function consultarCta() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sCuentas = "SELECT c.*, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$txtCod' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function guardar() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod, $selTipoCod, $numNum, $txtCodp, $nitcli, $numTcam, $dtFec;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numNum=$_POST['numNum'];
	$selTipoCod="002.01";
	$selBanCod=$_POST['selBanCod'];
	$dtFec=$_POST['dtFec'];
	$numTcam=$_POST['numTcam'];	
	$numTot=(empty($_POST['numTot'])) ? 0 : $_POST['numTot'];	
	$totant=$_POST['totant'];
    $txtCodp="99999";
    $ctacli="";
    $nitcli="";
	$txtCon=utf8_decode($_POST['txtCon']);
	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$jsonDocp=json_decode($_POST['tblDocp']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$dh = "D";
    $totQ = round($numTot*$numTcam,2);

	# QUERYS PARA UN REGISTRO
	$sBancos = "SELECT ban_ctac,ban_corr FROM bancos WHERE ban_emp='$empCod' AND ban_num='$selBanCod'";

	$sSaldob = "SELECT * FROM saldob WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";

	$iMovi = "INSERT INTO movi(mov_emp, mov_tipo, mov_ban, mov_num, mov_fec, mov_tot, mov_tcam, mov_con, mov_debacr, mov_ulcam, mov_mod) VALUES ('$empCod','$selTipoCod','$selBanCod','$numNum','$dtFec','$numTot','$numTcam','$txtCon','$dh','$usuNom','cxc')";

	$uMovi = "UPDATE movi SET mov_fec='$dtFec', mov_tcam='$numTcam', mov_tot='$numTot', mov_con='$txtCon', mov_ulcam='$usuNom' WHERE mov_emp='$empCod' AND mov_ban='$selBanCod' AND mov_tipo='$selTipoCod' AND mov_num='$numNum'";

	$iMovAcu = "INSERT INTO mov_acu(ma_emp, ma_tipo, ma_ban, ma_num, ma_fec, ma_debe, ma_con, ma_stat) VALUES ('$empCod','$selTipoCod','$selBanCod','$numNum','$dtFec','$numTot','$txtCon','P')";

	$uMovAcu = "UPDATE mov_acu SET ma_fec='$dtFec', ma_debe='$numTot', ma_con='$txtCon'  WHERE ma_emp='$empCod' AND ma_ban='$selBanCod' AND ma_tipo='$selTipoCod' AND ma_num='$numNum'";

	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_con, pol_ulcam, pol_grabado) VALUES ('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$txtCon','$usuNom','$dtGrabado')";

	$uPolizas = "UPDATE polizas SET pol_con='$txtCon', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_fec='$dtFec' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";

	$sDoctoscca = "SELECT *, TRIM(dc_con) AS dc_con, TRIM(dc_clien) AS dc_clien, (dc_tot-(dc_ret+dc_reti+dc_abo)) AS dc_sal, 0.00 AS dc_abop FROM doctoscc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	function uSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "UPDATE saldob SET salb_saldo=$nvalor WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";
	}

	function iSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "INSERT INTO saldob(salb_emp, salb_num, salb_saldo) VALUES('$empCod','$selBanCod',$nvalor)";
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_cta, pold_ctan, pold_debe, pold_haber) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber')".$func->addValues($obj, $jsonPol);
	}

	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum'";


	# QUERY PARA ACTUALIZAR EN LOS CARGOS
	function iMovicc($codp, $tipod, $seried, $numd, $abono, $tcamc) { 
		global $empCod, $usuNom, $selBanCod, $selTipoCod, $numNum, $txtCodp, $nitcli, $dtFec, $numTcam;
		return "INSERT INTO movicc (mov_emp, mov_codp, mov_nit, mov_fec, mov_tipo, mov_num, mov_abo, mov_tipoc, mov_seriec,mov_numc, mov_ban, mov_tcam) VALUES ('$empCod','$codp','$nitcli','$dtFec','$selTipoCod','$numNum',$abono,'$tipod','$seried','$numd','$selBanCod',$tcamc)";
	}

	function sDoctoscc($codp, $tipod, $seried, $numd) { 
		global $empCod, $usuNom, $selBanCod, $txtCodp;
		return "SELECT dc_emp, dc_tipo, dc_serie,dc_num, dc_abo, dc_tcam FROM doctoscc WHERE dc_emp='$empCod' AND dc_codp='$codp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}
	function uDoctoscc($codp, $tipod, $seried, $numd, $nvalorabo) { 
		global $empCod, $usuNom, $selTipoCod, $selBanCod, $numNum, $txtCodp;
		return "UPDATE doctoscc SET dc_ban='$selBanCod', dc_numdepo='$numNum', dc_tipodepo='$selTipoCod', dc_abo=$nvalorabo WHERE dc_emp='$empCod' AND dc_codp='$codp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	// Revisa si hay algun problema en la partida, para ver si permite grabar o no
	$probpol1="X";
	$probpol2="A";	
	$probpol3="A";	
	$select["bancos"] = $db->query($sBancos);
	$fetchAssoc["bancos"] = $db->fetchAssoc($select["bancos"]);		
	$ctaBanco = trim($fetchAssoc["bancos"]["ban_ctac"]);
	foreach ($jsonPol as $obj) {
		$ctapol = trim($obj->cta);
		$debe = trim($obj->debe);

		$select["cuentas"] = $db->query(sCuentas($ctapol));
		$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
		$ctaC = trim($fetchAssoc["cuentas"]["cta"]);
		if ($db->numRows($select["cuentas"]) == 0) {
			$probpol1 = "A";
		}
		if ($ctapol == $ctaBanco) {
			$probpol2 = "X";
		}
		if ($ctapol == $ctaBanco && $numTot == $debe) {
			$probpol3 = "X";
		}
	}
	//

	if ($probpol1 == "X" && $probpol2 == "X" && $probpol3 == "X") {
		#Para Actualizar el saldo del banco
		$select["saldob"] = $db->query($sSaldob);
		if ($db->numRows($select["saldob"]) == 0) {
			$vSaldo = 0;
			$nvalor = ($vSaldo + $numTot);
			$db->query(iSaldob($nvalor));
		} else {
			$fetchAssoc["saldob"] = $db->fetchAssoc($select["saldob"]);		
			$vSaldo = $fetchAssoc["saldob"]["salb_saldo"];
			$nvalor = ($vSaldo+$totant) + $numTot;
			$db->query(uSaldob($nvalor));
		}		
		//
		
		// PARA ACTUALIZAR  DOCUMENTOS DE CARGO
		foreach ($jsonDocp as $obj) {
			$codp = trim($obj->codp);
			$tipod = trim($obj->tipo);
			$seried = trim($obj->serie);
			$numerod = $obj->numero;
			$abonod = $obj->abono;
			$select["doctoscc"] = $db->query(sDoctoscc($codp, $tipod, $seried, $numerod));
			if ($db->numRows($select["doctoscc"]) > 0) {
				$fetchAssoc["doctoscc"] = $db->fetchAssoc($select["doctoscc"]);		
				$vAbono = $fetchAssoc["doctoscc"]["dc_abo"];
				$tcamc = $fetchAssoc["doctoscc"]["dc_tcam"];
				$nvalorabo = ($vAbono+$abonod);
				$db->query(uDoctoscc($codp,$tipod,$seried,$numerod,$nvalorabo));
				$db->query(iMovicc($codp,$tipod,$seried,$numerod,$abonod,$tcamc));
			}		
		}

		if ($func->stringToBool($_POST['nuevo'])) {
			$resp = $db->iEx($iMovi);
			$resp = $db->iEx($iMovAcu);
			$db->iEx($func->iBitacora(utf8_decode("Se creó en CxC Deposito No.: $numNum  Banco: $selBanCod Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		} else {
			$resp = $db->uEx($uMovi);
			$resp = $db->iEx($uMovAcu);
			$db->iEx($func->iBitacora(utf8_decode("Se modificó en CxC Deposito No.: $numNum  Banco: $selBanCod Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		}

		$db->dEx($dPolizas);
		$db->dEx($iPolizas);

		$db->dEx($dPoli_det);
		if (!$func->jsonEmpty($jsonPol)) {
			$db->iEx($iPoli_det);
		}

		// PARA REVERTIR LOS CIERRES
		foreach ($jsonPolAnt as $obj) {
			$cta = $obj->pold_cta;
			$numAnioAnt=date("Y", strtotime($obj->pold_fec));
			$numMesAnt=date("n", strtotime($obj->pold_fec));

			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

				$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

				$cta = $ctaActa;
			}
		}

		// PARA APLICAR LOS CIERRES
		foreach ($jsonPol as $obj) {
			$cta = $obj->cta;
			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $numAnio, $numMes));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

					$db->query(uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$obj->debe;
					$mhaber=$obj->haber;
					$db->query(iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}

		}
	}
	$resp["doctoscc"] = $db->sFetchAll($sDoctoscca);
	$db->close();
	
	$resp["dtGrabado"]=$dtGrabado;
	$resp["probpol1"]=$probpol1;
	$resp["probpol2"]=$probpol2;
	$resp["probpol3"]=$probpol3;

	return $func->jsonEncodeArray($resp, 'doctoscc');
}


function guardarTr() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod, $selTipoCod, $numNum, $txtCodp, $nitcli, $numTcam, $dtFec;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();


	$numNum=$_POST['numNum'];
	$nuevocorr=$numNum+1;
	$selTipoCod="003.01";
	$selBanCod=$_POST['selBanCod'];
	$dtFec=$_POST['dtFec'];
	$numTcam=$_POST['numTcam'];	
	$numTot=(empty($_POST['numTot'])) ? 0 : $_POST['numTot'];	
	$totant=(empty($_POST['totant'])) ? 0 : $_POST['totant'];
    $txtCodp="99999";
    $ctacli="";
    $nitcli="";
	$txtCon=utf8_decode($_POST['txtCon']);
	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$jsonDocp=json_decode($_POST['tblDocp']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$dh = "D";
    $totQ = round($numTot*$numTcam,2);


	# QUERYS PARA UN REGISTRO
	$sBancos = "SELECT ban_ctac,ban_corr FROM bancos WHERE ban_emp='$empCod' AND ban_num='$selBanCod'";

	$sSaldob = "SELECT * FROM saldob WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";

	$iMovi = "INSERT INTO movi(mov_emp, mov_tipo, mov_ban, mov_num, mov_fec, mov_tot, mov_tcam, mov_con, mov_debacr, mov_ulcam, mov_mod) VALUES ('$empCod','$selTipoCod','$selBanCod','$numNum','$dtFec','$numTot','$numTcam','$txtCon','$dh','$usuNom','cxc')";

	$uMovi = "UPDATE movi SET mov_fec='$dtFec', mov_tcam='$numTcam', mov_tot='$numTot', mov_con='$txtCon', mov_ulcam='$usuNom' WHERE mov_emp='$empCod' AND mov_ban='$selBanCod', mov_mod='cxc' AND mov_tipo='$selTipoCod' AND mov_num='$numNum'";

	$iMovAcu = "INSERT INTO mov_acu(ma_emp, ma_tipo, ma_ban, ma_num, ma_fec, ma_debe, ma_con, ma_stat) VALUES ('$empCod','$selTipoCod','$selBanCod','$numNum','$dtFec','$numTot','$txtCon','P')";

	$uMovAcu = "UPDATE mov_acu SET ma_fec='$dtFec', ma_debe='$numTot', ma_con='$txtCon'  WHERE ma_emp='$empCod' AND ma_ban='$selBanCod' AND ma_tipo='$selTipoCod' AND ma_num='$numNum'";

	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_con, pol_ulcam, pol_grabado) VALUES ('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$txtCon','$usuNom','$dtGrabado')";

	$uPolizas = "UPDATE polizas SET pol_con='$txtCon', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_fec='$dtFec' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";

	$sDoctoscca = "SELECT *, TRIM(dc_con) AS dc_con, TRIM(dc_clien) AS dc_clien, (dc_tot-(dc_ret+dc_reti+dc_abo)) AS dc_sal, 0.00 AS dc_abop FROM doctoscc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	function uSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "UPDATE saldob SET salb_saldo=$nvalor WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";
	}

	function iSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "INSERT INTO saldob(salb_emp, salb_num, salb_saldo) VALUES('$empCod','$selBanCod',$nvalor)";
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_cta, pold_ctan, pold_debe, pold_haber) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber')".$func->addValues($obj, $jsonPol);
	}

	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum'";

	# QUERY PARA ACTUALIZAR EN LOS CARGOS
	function iMovicc($codp, $tipod, $seried, $numd, $abono, $tcamc) { 
		global $empCod, $usuNom, $selBanCod, $selTipoCod, $numNum, $txtCodp, $nitcli, $dtFec, $numTcam;
		return "INSERT INTO movicc (mov_emp, mov_codp, mov_nit, mov_fec, mov_tipo, mov_num, mov_abo, mov_tipoc, mov_seriec, mov_numc, mov_ban, mov_tcam) VALUES ('$empCod','$codp','$nitcli','$dtFec','$selTipoCod','$numNum',$abono,'$tipod','$seried','$numd','$selBanCod',$tcamc)";
	}

	function sDoctoscc($codp, $tipod, $seried, $numd) { 
		global $empCod, $usuNom, $selBanCod, $txtCodp;
		return "SELECT dc_emp, dc_serie,dc_num, dc_abo, dc_tcam FROM doctoscc WHERE dc_emp='$empCod' AND dc_codp='$codp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	function uDoctoscc($codp, $tipod, $seried, $numd, $nvalorabo) { 
		global $empCod, $usuNom, $selTipoCod, $selBanCod, $numNum, $txtCodp;
		return "UPDATE doctoscc SET dc_ban='$selBanCod', dc_numdepo='$numNum', dc_tipodepo='$selTipoCod', dc_abo=$nvalorabo WHERE dc_emp='$empCod' AND dc_codp='$codp' AND dc_tipo='$tipod' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	// Revisa si hay algun problema en la partida, para ver si permite grabar o no
	$probpol1="X";
	$probpol2="A";	
	$probpol3="A";	
	$select["bancos"] = $db->query($sBancos);
	$fetchAssoc["bancos"] = $db->fetchAssoc($select["bancos"]);		
	$ctaBanco = trim($fetchAssoc["bancos"]["ban_ctac"]);
	foreach ($jsonPol as $obj) {
		$ctapol = trim($obj->cta);
		$debe = trim($obj->debe);

		$select["cuentas"] = $db->query(sCuentas($ctapol));
		$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
		$ctaC = trim($fetchAssoc["cuentas"]["cta"]);
		if ($db->numRows($select["cuentas"]) == 0) {
			$probpol1 = "A";
		}
		if ($ctapol == $ctaBanco) {
			$probpol2 = "X";
		}
		if ($ctapol == $ctaBanco && $numTot == $debe) {
			$probpol3 = "X";
		}
	}
	//

	if ($probpol1 == "X" && $probpol2 == "X" && $probpol3 == "X") {
		#Para Actualizar el saldo del banco
		$select["saldob"] = $db->query($sSaldob);
		if ($db->numRows($select["saldob"]) == 0) {
			$vSaldo = 0;
			$nvalor = ($vSaldo + $numTot);
			$db->query(iSaldob($nvalor));
		} else {
			$fetchAssoc["saldob"] = $db->fetchAssoc($select["saldob"]);		
			$vSaldo = $fetchAssoc["saldob"]["salb_saldo"];
			$nvalor = ($vSaldo+$totant) + $numTot;
			$db->query(uSaldob($nvalor));
		}		
		//
		
		// PARA ACTUALIZAR  DOCUMENTOS DE CARGO
		foreach ($jsonDocp as $obj) {
			$codp = trim($obj->codp);
			$tipod = trim($obj->tipo);
			$seried = trim($obj->serie);
			$numerod = $obj->numero;
			$abonod = $obj->abono;
			$select["doctoscc"] = $db->query(sDoctoscc($codp, $tipod, $seried, $numerod));
			if ($db->numRows($select["doctoscc"]) > 0) {
				$fetchAssoc["doctoscc"] = $db->fetchAssoc($select["doctoscc"]);		
				$vAbono = $fetchAssoc["doctoscc"]["dc_abo"];
				$tcamc = $fetchAssoc["doctoscc"]["dc_tcam"];
				$nvalorabo = ($vAbono+$abonod);
				$db->query(uDoctoscc($codp,$tipod,$seried,$numerod,$nvalorabo));
				$db->query(iMovicc($codp,$tipod,$seried,$numerod,$abonod,$tcamc));
			}		
		}

		if ($func->stringToBool($_POST['nuevo'])) {
			$resp = $db->iEx($iMovi);
			$resp = $db->iEx($iMovAcu);
			$db->iEx($func->iBitacora(utf8_decode("Se creó Transferencia de Clientes No.: $numNum  Banco: $selBanCod Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		} else {
			$resp = $db->uEx($uMovi);
			$resp = $db->iEx($uMovAcu);
			$db->iEx($func->iBitacora(utf8_decode("Se modificó Transferencia de Clientes No.: $numNum  Banco: $selBanCod Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		}

		$db->dEx($dPolizas);
		$db->dEx($iPolizas);

		$db->dEx($dPoli_det);
		if (!$func->jsonEmpty($jsonPol)) {
			$db->iEx($iPoli_det);
		}

		// PARA REVERTIR LOS CIERRES
		foreach ($jsonPolAnt as $obj) {
			$cta = $obj->pold_cta;
			$numAnioAnt=date("Y", strtotime($obj->pold_fec));
			$numMesAnt=date("n", strtotime($obj->pold_fec));

			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

				$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

				$cta = $ctaActa;
			}
		}

		// PARA APLICAR LOS CIERRES
		foreach ($jsonPol as $obj) {
			$cta = $obj->cta;
			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $numAnio, $numMes));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

					$db->query(uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$obj->debe;
					$mhaber=$obj->haber;
					$db->query(iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}

		}
	}
	$resp["doctoscc"] = $db->sFetchAll($sDoctoscca);
	$db->close();
	
	$resp["dtGrabado"]=$dtGrabado;
	$resp["probpol1"]=$probpol1;
	$resp["probpol2"]=$probpol2;
	$resp["probpol3"]=$probpol3;

	return $func->jsonEncodeArray($resp, 'doctoscc');
}


function generarPartida() {
	global $empCod;
	$cta=$_POST['cta'];
	$ctadif=$_POST['ctadif'];
	$jsonDocp=json_decode($_POST['tblDocp'], true);

	$func = new functions();
	# QUERYS
	function sCuentas($cta,$abono) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom, $abono AS cta_abono
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ctaBanc"] = (empty($cta)) ? "" : $db->sFetchAssoc(sCuentas((string)$cta,0.00));
	$resp["ctaBandif"] = (empty($ctadif)) ? "" : $db->sFetchAssoc(sCuentas((string)$ctadif,0.00));

	$resp["ctaCli"]=array();
	$j=0;
	foreach ($jsonDocp as $rec) {
		$rec["ctap"] = TRIM($rec["ctap"]);
		$i = $func->multiSearch($resp["ctaCli"], array('cta' => (string)$rec["ctap"]));
		if ($i >= 0) {
			$resp["ctaCli"][$i]["cta_abono"] += $jsonDocp[$j]["abono"];
		} else {
			$fa["ctaCli"] = $db->sFetchAssoc(sCuentas((string)$rec['ctap'],$rec['abono']));
		    array_push($resp["ctaCli"], array("cta"=>$rec["ctap"],"cta_nom"=>$fa["ctaCli"]["cta_nom"],"cta_abono"=>$rec['abono']));
		}
		unset($jsonDocp[$j]);
		$j++;
	}
	
	$db->close();

	return $func->jsonEncodeArrayEach($resp, array('ctaBanc', 'ctaCli', 'ctaBandif'));
}

function generarPartidat() {
	global $empCod;
	$cta=$_POST['cta'];
	$ctadif=$_POST['ctadif'];
	$jsonDocp=json_decode($_POST['tblDocp'], true);

	$func = new functions();
	# QUERYS
	function sCuentas($cta,$abono) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom, $abono AS cta_abono
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ctaBanc"] = (empty($cta)) ? "" : $db->sFetchAssoc(sCuentas((string)$cta,0.00));
	$resp["ctaBandif"] = (empty($ctadif)) ? "" : $db->sFetchAssoc(sCuentas((string)$ctadif,0.00));
	
	$resp["ctaCli"]=array();
	$j=0;
	foreach ($jsonDocp as $rec) {
		$rec["ctap"] = TRIM($rec["ctap"]);
		$i = $func->multiSearch($resp["ctaCli"], array('cta' => (string)$rec["ctap"]));
		if ($i >= 0) {
			$resp["ctaCli"][$i]["cta_abono"] += $jsonDocp[$j]["abono"];
		} else {
			$fa["ctaCli"] = $db->sFetchAssoc(sCuentas((string)$rec['ctap'],$rec['abono']));
		    array_push($resp["ctaCli"], array("cta"=>$rec["ctap"],"cta_nom"=>$fa["ctaCli"]["cta_nom"],"cta_abono"=>$rec['abono']));
		}
		unset($jsonDocp[$j]);
		$j++;
	}

	$db->close();

	return $func->jsonEncodeArrayEach($resp, array('ctaBanc', 'ctaCli', 'ctaBandif'));
}
?>