<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);


# QUERYS
$sAnticpc = "SELECT *,
               TRIM(ant.ant_con) AS ant_con,
               TRIM(cl.cli_nom) AS cli_nom 
             FROM anticpc ant
             LEFT JOIN cliencc cl ON cl.cli_emp=ant.ant_emp AND cl.cli_cod=ant.ant_codp 
             WHERE ant_emp='$empCod' AND ant_stat='P' ORDER BY ant_fec,ant_num";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["anticpc"] = $db->query($sAnticpc);


class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $selTabo, $selTaboNom;
        $this->SetMargins(1.5, 1, 1.35);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNom),0,1,"L");
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        $this->SetY(-2.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
        $this->SetFont("Arial","I",6);
        $this->Ln();
        $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
    }
}

# GENERAR PDF
$pdf = new generatePDF("L","cm", array(22, 28));
$pdf->AddPage();
$pdf->SetMargins(1.5, 1, 1.5);

$lineWidth=17;
$lineHeight=0.4;

$pdf->SetFont("","",8);
$pdf->Ln($lineHeight);
$pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de Anticipos pendientes de aplicar (CxC)"));
    //.strftime("%d/%m/%Y", strtotime($dtFec))),0,0,"C");
$pdf->Ln($lineHeight);

$header = array("Numero","Fecha","Cliente","TC","Valor","Concepto","Documento Emitido");
$pdf->SetFont("","B");
$pdf->SetWidths(array(1.8,1.8,6,1.8,2,9,2));
$pdf->SetAligns(array("C","C","C","C","C","C","C"));
$pdf->Row($header, $lineHeight);
$pdf->SetFont("");
$pdf->SetAligns(array("L","C","L","R","R","L","L"));
$antitot=0;
while ($rec = $db->fetchAssoc($select['anticpc'])) {
    $antitot += $rec["ant_tot"];
    $body = array(
        $rec["ant_num"],
        strftime("%d/%m/%Y", strtotime($rec["ant_fec"])),
        $rec["cli_nom"],
        $rec["ant_tcam"],
        ($rec["ant_tot"] != 0) ? $rec["ant_tot"] : "",
        $rec["ant_con"],
        $rec["ant_ndoc"],
    );
    $pdf->RowBorderLR($body, $lineHeight);
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 25.9, $pdf->GetY());

$pdf->SetAligns(array("","","","","R","R"));
$body = array(
    "",
    "",
    "",
    "Totales:",
    number_format($antitot,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX(), $pdf->GetY(), 25.9, $pdf->GetY());

$pdf->Output(utf8_decode("Anticiposcxc").".pdf","I");

$db->close();
?>