<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$bitForm = "cxp1010";
$bitMod = "cxp";
$empCod = $_SESSION['empCod'];
$empConso = $_SESSION['empConso'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultar':
		echo consultar();
		break;

	case 'consultarCta':
		echo consultarCta();
		break;

	case 'consultarProvcp':
		echo consultarProvcp();
		break;

	case 'consultarCiemes':
		echo consultarCiemes();
		break;

	case 'consultarLisAnti':
		echo consultarLisAnti();
		break;

	case 'AsignaAnti':
		echo AsignaAnti();
		break;

	case 'generarPartida':
		echo generarPartida();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'borrar':
		echo borrar();
		break;
}

function consultar() {
	global $empCod, $usuNom;

	$tipoPol='006';

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$txtSerie=$_POST['txtSerie'];
	$numNum=$_POST['numNum'];
	$txtCod=$_POST['txtCod'];

	# QUERYS
	$sDoctosc = "SELECT *, c.ciem_stat, pr.pro_cta FROM doctosc dc 
				  LEFT JOIN ciemes c ON c.ciem_mes=MONTH(dc.dc_rfec) AND c.ciem_ano=YEAR(dc.dc_rfec) AND c.ciem_emp='$empCod'
				  LEFT JOIN provcp pr ON dc.dc_emp=pr.pro_emp AND dc.dc_codp=pr.pro_cod 
				  WHERE dc_emp='$empCod' AND dc_serie='$txtSerie' AND dc_num='$numNum' AND dc_codp='$txtCod'";

	$sPoli_det = "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_tipoi='$txtSerie' AND pold_num='$numNum' AND pold_nit='$txtCod'";

	function sCiemes($numAno, $numMes){
		return "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$numAno AND ciem_mes=$numMes";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sDoctosc, "doctosc");
	$resp["poli_det"] = $db->sFetchAll($sPoli_det);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "doctosc");
}

function consultarCta() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sCuentas = "SELECT c.*, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$txtCod' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function consultarProvcp() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sProvcp = "SELECT *, TRIM(pro_nom) AS pro_nom FROM provcp WHERE pro_emp='$empCod' AND pro_cod='$txtCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sProvcp, "provcp");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "provcp");
}

function consultarCiemes() {
	global $empCod;

	$func = new functions();
	$numAno=$_POST["numAno"];
	$selMesCod=$_POST["selMesCod"];

	# QUERYS
	$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$numAno AND ciem_mes=$selMesCod";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCiemes, "ciemes");
	$db->close();

	return json_encode($resp);
}

function consultarLisAnti() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$txtSerie=utf8_decode($_POST['txtSerie']);
	$numNum=$_POST['numNum'];
	$txtCod=utf8_decode($_POST['txtCod']);
	$txtNit=utf8_decode($_POST['txtNit']);
	$selTipoCod=$_POST['selTipoCod'];
	$txtProv=utf8_decode($_POST['txtProv']);
	$dtFec=$_POST['dtFec'];

	$dtFecrece=$_POST['dtFecrece'];
	$dtFecp=$_POST['dtFecp'];
	$numTcam=$_POST['numTcam'];
	$numContra=$_POST['numContra'];
	$dtFcontra=$_POST['dtFcontra'];
	$selOrden=$_POST['selOrden'];
	$numOrden=$_POST['numOrden'];
	$dcreProv=$_POST['dcreProv'];

	//$numDia=date("d", strtotime($dtFec));
	$selMesCod=$_POST['selMesCod'];
	$numAno=$_POST['numAno'];
	$rfec=$numAno."-".$selMesCod."-01";

	$rfecAnt=$_POST['rfecAnt'];
	$numAnoAnt=date("Y", strtotime($rfecAnt));
	$numMesAnt=date("n", strtotime($rfecAnt));

	$crRet=$_POST['crRet'];
	$crReti=$_POST['crReti'];
	$crAfe=$_POST['crAfe'];

	$numBien=(empty($_POST['numBien'])) ? 0 : $_POST['numBien'];
	$numServ=(empty($_POST['numServ'])) ? 0 : $_POST['numServ'];
	$numPeque=(empty($_POST['numPeque'])) ? 0 : $_POST['numPeque'];
	$numPeque2=(empty($_POST['numPeque2'])) ? 0 : $_POST['numPeque2'];
	$numImp=(empty($_POST['numImp'])) ? 0 : $_POST['numImp'];
	$numImpre=(empty($_POST['numImpre'])) ? 0 : $_POST['numImpre'];
	$numTasam=(empty($_POST['numTasam'])) ? 0 : $_POST['numTasam'];
	$numMedi=(empty($_POST['numMedi'])) ? 0 : $_POST['numMedi'];
	$numNoafe=(empty($_POST['numNoafe'])) ? 0 : $_POST['numNoafe'];
	$numVehi=(empty($_POST['numVehi'])) ? 0 : $_POST['numVehi'];
	$numVehia=(empty($_POST['numVehia'])) ? 0 : $_POST['numVehia'];
	$crTvehi=(empty($_POST['crTvehi'])) ? "0" : $_POST['crTvehi'];
	$numTfacom=(empty($_POST['numTfacom'])) ? 0 : $_POST['numTfacom'];
	$numGalos=(empty($_POST['numGalos'])) ? 0 : $_POST['numGalos'];
	$numGalor=(empty($_POST['numGalor'])) ? 0 : $_POST['numGalor'];
	$numGalod=(empty($_POST['numGalod'])) ? 0 : $_POST['numGalod'];
	$numComb=(empty($_POST['numComb'])) ? 0 : $_POST['numComb'];
	$deduTot=(empty($_POST['deduTot'])) ? 0 : $_POST['deduTot'];


	$txtCon=utf8_decode($_POST['txtCon']);

	$subb=$_POST['subb'];
	$subs=$_POST['subs'];
	$subpe=$_POST['subpe'];
	$subco=$_POST['subco'];
	$subve=$_POST['subve'];
	$subi=$_POST['subi'];
	$subir=$_POST['subir'];
	$subna=$_POST['subna'];
	$subme=$_POST['subme'];

	$numRet=$_POST['numRet'];
	$numReti=$_POST['numReti'];
	$numSub=$_POST['numSub'];
	$numIva=$_POST['numIva'];
	$numTot=$_POST['numTot'];

	$Qbien = $_POST['Qbien'];
	$Qserv = $_POST['Qserv'];
	$Qpeque = $_POST['Qpeque'];
	$Qpeque2 = $_POST['Qpeque2'];
	$Qimp = $_POST['Qimp'];
	$Qimpre = $_POST['Qimpre'];
	$Qmedi = $_POST['Qmedi'];
	$Qnoafe = $_POST['Qnoafe'];
	$Qvehi = $_POST['Qvehi'];
	$Qtfacom = $_POST['Qtfacom'];
	$Qcomb = $_POST['Qcomb'];
	$Qsubb = $_POST['Qsubb'];
	$Qsubs = $_POST['Qsubs'];
	$Qsubpe = $_POST['Qsubpe'];
	$Qsubco = $_POST['Qsubco'];
	$Qsubve = $_POST['Qsubve'];
	$Qsubi = $_POST['Qsubi'];
	$Qsubir = $_POST['Qsubir'];
	$Qsubna = $_POST['Qsubna'];
	$Qtasam = $_POST['Qtasam'];
	$Qsubme = $_POST['Qsubme'];
	$Qret = $_POST['Qret'];
	$Qreti = $_POST['Qreti'];
	$Qsub = $_POST['Qsub'];
	$Qiva = $_POST['Qiva'];
	$Qtot = $_POST['Qtot'];
	$Qdedu =$_POST['Qdedu'];

    $totcp = ($numTot);

	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);

	$tipoPol='006';
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));


	# QUERYS
	$sAnticp = "SELECT *, TRIM(tp.tp_abrev) AS tp_abrev FROM anticp a LEFT JOIN tipopol tp ON a.ant_tipo=tp.tp_cod WHERE ant_emp='$empCod' AND ant_codp='$txtCod' AND ant_stat='P'";

	// Querys para poder registra el documento que se visualizo
	$iDoctosc = "INSERT INTO doctosc(dc_emp,dc_serie,dc_num,dc_codp,dc_nit,dc_tipo,dc_prov,dc_fec,dc_rfec,dc_retsn,dc_retisn,dc_afe, dc_bien,dc_serv,dc_peque,dc_peque2,dc_imp,dc_impre,dc_medi,dc_noafe,dc_vehi,dc_vehia,dc_tvehi,dc_tfacom,dc_galos,dc_galor, dc_galod,dc_comb,dc_con,dc_subb,dc_subs,dc_subpe,dc_subco,dc_subve,dc_subi,dc_subir,dc_subna,dc_subme,dc_ret,dc_reti,dc_sub, dc_iva,dc_tot,dc_ulcam,dc_conso,dc_tasam,dc_fecrece,dc_fecp,dc_tcam,dc_contra,dc_fcontra,dc_seriecn,dc_numcn,dc_dc,dc_dedu) VALUES ('$empCod','$txtSerie','$numNum','$txtCod','$txtNit','$selTipoCod','$txtProv','$dtFec','$rfec','$crRet','$crReti','$crAfe','$numBien','$numServ','$numPeque','$numPeque2','$numImp','$numImpre','$numMedi','$numNoafe','$numVehi','$numVehia','$crTvehi','$numTfacom','$numGalos','$numGalor','$numGalod','$numComb','$txtCon','$subb','$subs','$subpe','$subco','$subve','$subi','$subir','$subna','$subme','$numRet','$numReti','$numSub','$numIva','$totcp','$usuNom','$empConso','$numTasam','$dtFecrece','$dtFecp','$numTcam','$numContra','$dtFcontra','$selOrden','$numOrden','$dcreProv','$deduTot')";

	$uDoctosc = "UPDATE doctosc SET dc_tipo='$selTipoCod', dc_prov='$txtProv', dc_fec='$dtFec', dc_rfec='$rfec', dc_retsn='$crRet', dc_retisn='$crReti', dc_afe='$crAfe', dc_bien='$numBien', dc_serv='$numServ', dc_peque='$numPeque', dc_peque2='$numPeque2', dc_imp='$numImp', dc_impre='$numImpre', dc_medi='$numMedi', dc_noafe='$numNoafe', dc_vehi='$numVehi', dc_vehia='$numVehia', dc_tvehi='$crTvehi', dc_tfacom='$numTfacom', dc_galos='$numGalos', dc_galor='$numGalor', dc_galod='$numGalod', dc_comb='$numComb', dc_con='$txtCon', dc_subb='$subb', dc_subs='$subs', dc_subpe='$subpe', dc_subco='$subco', dc_subve='$subve', dc_subi='$subi', dc_subir='$subir', dc_subna='$subna', dc_subme='$subme', dc_ret='$numRet', dc_reti='$numReti', dc_sub='$numSub', dc_iva='$numIva', dc_tot='$totcp', dc_ulcam='$usuNom', dc_conso='$empConso', dc_tasam='$numTasam', dc_fecrece='$dtFecrece', dc_fecp='$dtFecp', dc_tcam='$numTcam', dc_contra='$numContra', dc_fcontra='$dtFcontra', dc_seriecn='$selOrden', dc_numcn='$numOrden', dc_dc='$dcreProv', dc_dedu='$deduTot' WHERE dc_emp='$empCod' AND dc_serie='$txtSerie' AND dc_num='$numNum' AND dc_codp='$txtCod'";

	$iIva_comp = "INSERT INTO iva_comp (iva_emp, iva_serie, iva_num, iva_nit, iva_tipo, iva_prov, iva_fec, iva_rfec, iva_retsn, iva_retisn, iva_afe, iva_bien, iva_serv, iva_peque, iva_peque2, iva_imp, iva_impre, iva_medi, iva_noafe, iva_vehi, iva_vehia, iva_tvehi, iva_tfacom, iva_galos, iva_galor, iva_galod, iva_comb, iva_con, iva_subb, iva_subs, iva_subpe, iva_subco, iva_subve, iva_subi, iva_subir, iva_subna, iva_subme, iva_ret, iva_reti, iva_sub, iva_iva, iva_tot, iva_ulcam, iva_conso, iva_cajach, iva_tasam, iva_proco, iva_mod, iva_dedu) VALUES ('$empCod', '$txtSerie', '$numNum', '$txtNit', '$selTipoCod', '$txtProv', '$dtFec', '$rfec', '$crRet', '$crReti', '$crAfe', '$Qbien', '$Qserv', '$Qpeque', '$Qpeque2', '$Qimp', '$Qimpre', '$Qmedi', '$Qnoafe', '$Qvehi', '$numVehia', '$crTvehi', '$Qtfacom', '$numGalos', '$numGalor', '$numGalod', '$Qcomb', '$txtCon', '$Qsubb', '$Qsubs', '$Qsubpe', '$Qsubco', '$Qsubve', '$Qsubi', '$Qsubir', '$Qsubna', '$Qsubme', '$Qret', '$Qreti', '$Qsub', '$Qiva', '$Qtot', '$usuNom', '$empConso', 'N', '$Qtasam', '$txtCod','cxp','$Qdedu')";

	$uIva_comp = "UPDATE iva_comp SET iva_tipo='$selTipoCod', iva_prov='$txtProv', iva_fec='$dtFec', iva_rfec='$rfec', iva_retsn='$crRet', iva_retisn='$crReti', iva_afe='$crAfe', iva_bien='$Qbien', iva_serv='$Qserv', iva_peque='$Qpeque', iva_peque2='$Qpeque2', iva_imp='$Qimp', iva_impre='$Qimpre', iva_medi='$Qmedi', iva_noafe='$Qnoafe', iva_vehi='$Qvehi', iva_vehia='$numVehia', iva_tvehi='$crTvehi', iva_tfacom='$Qtfacom', iva_galos='$numGalos', iva_galor='$numGalor', iva_galod='$numGalod', iva_comb='$Qcomb', iva_con='$txtCon', iva_subb='$Qsubb', iva_subs='$Qsubs', iva_subpe='$Qsubpe', iva_subco='$Qsubco', iva_subve='$Qsubve', iva_subi='$Qsubi', iva_subir='$Qsubir', iva_subna='$Qsubna', iva_subme='$Qsubme', iva_ret='$Qret', iva_reti='$Qreti', iva_sub='$Qsub', iva_iva='$Qiva', iva_tot='$Qtot', iva_ulcam='$usuNom', iva_conso='$empConso', iva_tasam='$Qtasam',iva_dedu='$Qdedu' WHERE iva_emp='$empCod' AND iva_serie='$txtSerie' AND iva_num='$numNum' AND iva_nit='$txtNit'";

	$sPolizas = "SELECT pol_num FROM polizas WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie' AND pol_nit='$txtCod'";

	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_tipoi, pol_nit, pol_con, pol_ulcam, pol_grabado) VALUES ('$empCod','$rfec',0,'$tipoPol','$numNum','$txtSerie','$txtCod','$txtCon','$usuNom','$dtGrabado')";

	$uPolizas = "UPDATE polizas SET pol_con='$txtCon', pol_ulcam='$usuNom', pol_fec='$rfec', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_ban=0 AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie' AND pol_nit='$txtCod'";

	$sProvee = "SELECT * FROM provee WHERE pro_nit='$txtNit'";

	$iProvee = "INSERT INTO provee(pro_nit, pro_nom, pro_retsn) VALUES ('$txtNit','$txtProv','$crRet')";

	$uProvee = "UPDATE provee SET pro_nom='$txtProv', pro_ret='$crRet' WHERE pro_nit='$txtNit'";


	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_tipoi, pold_nit, pold_cta, pold_ctan, pold_debe, pold_haber) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$rfec',0,'$tipoPol','$numNum','$txtSerie','$txtCod','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber')".$func->addValues($obj, $jsonPol);
	}

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban=0 AND pold_tipo='$tipoPol' AND pold_num='$numNum' AND pold_tipoi='$txtSerie' AND pold_nit='$txtCod'";

	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	// Primero se graba el documento que esta visualizado
	if ($func->stringToBool($_POST['nuevo'])) {
		$resp = $db->iEx($iDoctosc);
		$db->iEx($iIva_comp);
		$db->query($func->iBitacora(utf8_decode("Se creó compra en CxP No.: $numNum Serie: $txtSerie Codigo: $txtCod Usuario: ").$usuNom, $bitMod, $bitForm));

		$db->query($iPolizas);
	} else {
		$resp = $db->uEx($uDoctosc);
		$db->uEx($uIva_comp);
		$db->query($func->iBitacora(utf8_decode("Se modificó compra en CxP No.: $numNum Serie: $txtSerie Codigo: $txtCod Usuario: ").$usuNom, $bitMod, $bitForm));

		$select["polizas"] = $db->query($sPolizas);
		($db->numRows($select["polizas"]) > 0) ? $db->query($uPolizas) : $db->query($iPolizas);
	}

	$select["provee"] = $db->query($sProvee);
	if ($db->numRows($select["provee"]) > 0) {
		$db->query($uProvee);
	} else {
		$db->query($iProvee);
	}		

	$db->dEx($dPoli_det);
	if (!$func->jsonEmpty($jsonPol)) {
		$db->iEx($iPoli_det);
	}

	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
	}

	// PARA APLICAR LOS CIERRES
	foreach ($jsonPol as $obj) {
		$cta = $obj->cta;
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$select["cierres"] = $db->query(sCierres($cta, $numAno, $selMesCod));
			if ($db->numRows($select["cierres"]) > 0) {
				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

				$db->query(uCierres($cta, $numAno, $selMesCod, $mdebe, $mhaber));
			} else {
				$mdebe=$obj->debe;
				$mhaber=$obj->haber;

				$db->query(iCierres($cta, $numAno, $selMesCod, $mdebe, $mhaber));
			}
			$cta = $ctaActa;
		}
	}

	$resp["anticp"] = $db->sFetchAll($sAnticp);
	$db->close();

	$func = new functions();
	$resp["asdf"]=$sAnticp;

	return $func->jsonEncodeArray($resp, "anticp");
}


function AsignaAnti() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm, $txtSerie,$numNum,$txtCod,$txtNit;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$txtSerie=utf8_decode($_POST['txtSerie']);
	$numNum=$_POST['numNum'];
	$txtCod=utf8_decode($_POST['txtCod']);
	$txtNit=utf8_decode($_POST['txtNit']);
	$nsaldo=$_POST['nsaldo'];

	$jsonAnti=json_decode($_POST['tblAntiLis']);

	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));


	# QUERYS
	$sDoctosc = "SELECT dc_emp,dc_serie,dc_num,dc_codp,dc_nit,dc_abo,dc_ret,dc_reti,dc_tcam FROM doctosc WHERE dc_emp='$empCod' AND dc_serie='$txtSerie' AND dc_num='$numNum' AND dc_codp='$txtCod'";

	# QUERYS PARA VARIOS REGISTROS
	function sAnticp($numanti) { 
		global $empCod,$txtSerie,$numNum,$txtCod,$txtNit;
		return "SELECT * FROM anticp WHERE ant_emp='$empCod' AND ant_num='$numanti'";
	}

	function uAnticp($numanti) { 
		global $empCod,$txtSerie,$numNum,$txtCod,$txtNit;
		return "UPDATE anticp SET ant_stat='A' WHERE ant_emp='$empCod' AND ant_num='$numanti'";
	}

	function uDoctosc($abono,$banco,$tipo,$numero) { 
		global $empCod,$txtSerie,$numNum,$txtCod,$txtNit;
		return "UPDATE doctosc SET dc_abo=$abono, dc_ban=$banco, dc_tipoch='$tipo', dc_cheque=$numero WHERE dc_emp='$empCod' AND dc_serie='$txtSerie' AND dc_num='$numNum' AND dc_codp='$txtCod'";
	}
	function uIva_comp($banco,$tipo,$numero) { 
		global $empCod,$txtSerie,$numNum,$txtCod,$txtNit;
		return "UPDATE iva_comp SET iva_ban=$banco, iva_tidoc='$tipo', iva_cheque=$numero WHERE iva_emp='$empCod' AND iva_serie='$txtSerie' AND iva_num='$numNum' AND iva_nit='$txtNit'";
	}

	function dMovic($banch, $tipoch, $numch) { 
		global $empCod, $usuNom, $txtSerie,$numNum,$txtCod,$txtNit;
		return "DELETE FROM movic WHERE mov_emp='$empCod' AND mov_codp='$txtCod' AND mov_ban='$banch' AND mov_tipo='$tipoch' AND mov_num='$numch' AND mov_tipoc='$txtSerie' AND mov_numc='$numNum'";
	}

	function iMovic($fecch, $banch, $tipoch, $numch, $aboapli, $tcamch) { 
		global $empCod, $usuNom, $txtSerie,$numNum,$txtCod,$txtNit;
		return "INSERT INTO movic (mov_emp, mov_codp, mov_nit, mov_fec, mov_tipo, mov_num, mov_abo, mov_tipoc, mov_numc, mov_ban, mov_tcam) VALUES ('$empCod','$txtCod','$txtNit','$fecch','$tipoch','$numch',$aboapli,'$txtSerie','$numNum','$banch',$tcamch)";
	}

	function sCheques($banch, $numch) { 
		global $empCod, $usuNom, $txtSerie,$numNum,$txtCod,$txtNit;
		return "SELECT * FROM cheques WHERE ch_emp='$empCod' AND ch_ban='$banch' AND ch_num='$numch'";
	}

	function sMovi($banch, $tipoch, $numch) { 
		global $empCod, $usuNom, $txtSerie,$numNum,$txtCod,$txtNit;
		return "SELECT * FROM movi WHERE mov_emp='$empCod' AND mov_ban='$banch' AND mov_tipo='$tipoch' AND mov_num='$numch'";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();

	// PARA EL ANTICIPO
	$sientro="N";
	foreach ($jsonAnti as $obj) {
		$numanti = $obj->numdlis;
		$sientro="S";
		$select["anticp"] = $db->query(sAnticp($numanti));
		if ($db->numRows($select["anticp"]) > 0) {
			$fetchAssoc["anticp"] = $db->fetchAssoc($select["anticp"]);
			$tipoch=$fetchAssoc["anticp"]["ant_tipo"];
			$banch=$fetchAssoc["anticp"]["ant_ban"];
			$numch=$fetchAssoc["anticp"]["ant_ndoc"];
			$sihay='N';
			if ($tipoch == '004'){
	   			$select["cheques"] = $db->query(sCheques($banch,$numch));
				if ($db->numRows($select["cheques"]) > 0) {
					$fetchAssoc["cheques"] = $db->fetchAssoc($select["cheques"]);
					$valordoc=$fetchAssoc["cheques"]["ch_tot"];
					$fecdoc=$fetchAssoc["cheques"]["ch_fec"];
					$tcamdoc=$fetchAssoc["cheques"]["ch_tcam"];
					$sihay='S';
				} else {
					$valordoc = 0;
				}
			} else {
	   			$select["movi"] = $db->query(sMovi($banch,$tipoch,$numch));
				if ($db->numRows($select["movi"]) > 0) {
					$fetchAssoc["movi"] = $db->fetchAssoc($select["movi"]);
					$valordoc=$fetchAssoc["movi"]["mov_tot"];
					$fecdoc=$fetchAssoc["movi"]["mov_fec"];
					$tcamdoc=$fetchAssoc["movi"]["mov_tcam"];
					$sihay='S';
				} else {
					$valordoc = 0;
				}
			}
			if ($sihay == 'S') {
				$select["doctosc"] = $db->query($sDoctosc);
				if ($db->numRows($select["doctosc"]) > 0) {
					$fetchAssoc["doctosc"] = $db->fetchAssoc($select["doctosc"]);
					$vAbono = $fetchAssoc["doctosc"]["dc_abo"];
					$tcamdc = $fetchAssoc["doctosc"]["dc_tcam"];
                    if ($tcamdc == 1.000000 && $tcamdoc > 1.000000) {
                       $valordoc = round($valordoc*$tcamdoc,2);
                    }
                    if ($tcamdc > 1.000000 && $tcamdoc == 1.000000) {
                       $valordoc = round($valordoc/$tcamdc,2);
                    }
					if ($nsaldo >= $valordoc) {
						$abonoanti = $valordoc;
					} else {
						$abonoanti = $nsaldo;
					}

					$nvalorabo = ($vAbono+$abonoanti);
					$db->query(uDoctosc($nvalorabo,$banch,$tipoch,$numch));
					$db->query(dMovic($banch,$tipoch,$numch));
					$db->query(iMovic($fecdoc, $banch, $tipoch, $numch, $abonoanti, $tcamdc));
					$db->query(uAnticp($numanti));
					$db->query(uIva_comp($banch,$tipoch,$numch));
				}		
			}
		}	
	}

	$db->query($func->iBitacora(utf8_decode("Se asigno anticipo a Documento: CxP No.: $numNum Serie: $txtSerie Codigo: $txtCod Usuario: ").$usuNom, $bitMod, $bitForm));

	$resp = $db->sEx($sDoctosc, "doctosc");
	$db->close();
	$func = new functions();
	//$resp["sientro"]=$sientro;
	return $func->jsonEncodeArray($resp, "doctosc");
}


function generarPartida() {
	global $empCod;
	$numBien=$_POST['numBien'];
	$numServ=$_POST['numServ'];
	$numIva=$_POST['numIva'];
	$deduTot=$_POST['deduTot'];
	$numRet=$_POST['numRet'];
	$numReti=$_POST['numReti'];
	$txtCodp=$_POST['txtCodp'];
	$ctaprov=$_POST['ctaProv'];

	# QUERYS

	function sCuentas($cta) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$ctaGas = "XXXX";
	if ($numBien>0) {
	   $ctaGas="5110102";
	}
	if ($numServ>0) {
	   $ctaGas="5310150 ";
	}
	$ctaTasa="5310112";
	$resp["ctaGas"] = $db->sFetchAssoc(sCuentas((string)$ctaGas));
	$resp["ctaIva"] = ($numIva==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaic"]));
	$resp["ctaComb"] = ($deduTot==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtacomb"]));
	$resp["ctaRet"] = ($numRet==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtarisr"]));
	$resp["ctaReti"] = ($numReti==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtariva"]));
	$resp["ctaProv"] = $db->sFetchAssoc(sCuentas((string)$ctaprov));
    $resp["ctaTasa"] =  $db->sFetchAssoc(sCuentas((string)$ctaTasa));
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, 'ctaIva');
}

function guardar() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm;

	$func = new functions();

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv']) && !$func->stringToBool($_POST['nuevo'])) {
		return json_encode($priv->rErrorModify());
	}

	$txtSerie=utf8_decode($_POST['txtSerie']);
	$numNum=$_POST['numNum'];
	$txtCod=utf8_decode($_POST['txtCod']);
	$txtNit=utf8_decode($_POST['txtNit']);
	$selTipoCod=$_POST['selTipoCod'];
	$txtProv=utf8_decode($_POST['txtProv']);
	$dtFec=$_POST['dtFec'];

	$dtFecrece=$_POST['dtFecrece'];
	$dtFecp=$_POST['dtFecp'];
	$numTcam=$_POST['numTcam'];
	$numContra=$_POST['numContra'];
	$dtFcontra=$_POST['dtFcontra'];
	$selOrden=$_POST['selOrden'];
	$numOrden=$_POST['numOrden'];
	$dcreProv=$_POST['dcreProv'];

	$numDia=date("d", strtotime($dtFec));
	$selMesCod=$_POST['selMesCod'];
	$numAno=$_POST['numAno'];
	$mesact=date("m", strtotime($dtFec));
	if ($selMesCod==$mesact) {
	    $rfec=$numAno."-".$selMesCod."-".$numDia;
	} else {
	    $rfec=$numAno."-".$selMesCod."-01";
	}

	$rfecAnt=$_POST['rfecAnt'];
	$numAnoAnt=date("Y", strtotime($rfecAnt));
	$numMesAnt=date("n", strtotime($rfecAnt));

	$crRet=$_POST['crRet'];
	$crReti=$_POST['crReti'];
	$crAfe=$_POST['crAfe'];

	$numBien=(empty($_POST['numBien'])) ? 0 : $_POST['numBien'];
	$numServ=(empty($_POST['numServ'])) ? 0 : $_POST['numServ'];
	$numPeque=(empty($_POST['numPeque'])) ? 0 : $_POST['numPeque'];
	$numPeque2=(empty($_POST['numPeque2'])) ? 0 : $_POST['numPeque2'];
	$numImp=(empty($_POST['numImp'])) ? 0 : $_POST['numImp'];
	$numImpre=(empty($_POST['numImpre'])) ? 0 : $_POST['numImpre'];
	$numTasam=(empty($_POST['numTasam'])) ? 0 : $_POST['numTasam'];
	$numMedi=(empty($_POST['numMedi'])) ? 0 : $_POST['numMedi'];
	$numNoafe=(empty($_POST['numNoafe'])) ? 0 : $_POST['numNoafe'];
	$numVehi=(empty($_POST['numVehi'])) ? 0 : $_POST['numVehi'];
	$numVehia=(empty($_POST['numVehia'])) ? 0 : $_POST['numVehia'];
	$crTvehi=(empty($_POST['crTvehi'])) ? "0" : $_POST['crTvehi'];
	$numTfacom=(empty($_POST['numTfacom'])) ? 0 : $_POST['numTfacom'];
	$numGalos=(empty($_POST['numGalos'])) ? 0 : $_POST['numGalos'];
	$numGalor=(empty($_POST['numGalor'])) ? 0 : $_POST['numGalor'];
	$numGalod=(empty($_POST['numGalod'])) ? 0 : $_POST['numGalod'];
	$numComb=(empty($_POST['numComb'])) ? 0 : $_POST['numComb'];
	$deduTot=(empty($_POST['deduTot'])) ? 0 : $_POST['deduTot'];
	$txtCon=utf8_decode($_POST['txtCon']);

	$subb=$_POST['subb'];
	$subs=$_POST['subs'];
	$subpe=$_POST['subpe'];
	$subco=$_POST['subco'];
	$subve=$_POST['subve'];
	$subi=$_POST['subi'];
	$subir=$_POST['subir'];
	$subna=$_POST['subna'];
	$subme=$_POST['subme'];

	$numRet=$_POST['numRet'];
	$numReti=$_POST['numReti'];
	$numSub=$_POST['numSub'];
	$numIva=$_POST['numIva'];
	$numTot=$_POST['numTot'];

	$Qbien = $_POST['Qbien'];
	$Qserv = $_POST['Qserv'];
	$Qpeque = $_POST['Qpeque'];
	$Qpeque2 = $_POST['Qpeque2'];
	$Qimp = $_POST['Qimp'];
	$Qimpre = $_POST['Qimpre'];
	$Qmedi = $_POST['Qmedi'];
	$Qnoafe = $_POST['Qnoafe'];
	$Qvehi = $_POST['Qvehi'];
	$Qtfacom = $_POST['Qtfacom'];
	$Qcomb = $_POST['Qcomb'];
	$Qsubb = $_POST['Qsubb'];
	$Qsubs = $_POST['Qsubs'];
	$Qsubpe = $_POST['Qsubpe'];
	$Qsubco = $_POST['Qsubco'];
	$Qsubve = $_POST['Qsubve'];
	$Qsubi = $_POST['Qsubi'];
	$Qsubir = $_POST['Qsubir'];
	$Qsubna = $_POST['Qsubna'];
	$Qtasam = $_POST['Qtasam'];
	$Qsubme = $_POST['Qsubme'];
	$Qret = $_POST['Qret'];
	$Qreti = $_POST['Qreti'];
	$Qsub = $_POST['Qsub'];
	$Qiva = $_POST['Qiva'];
	$Qtot = $_POST['Qtot'];
	$Qdedu =$_POST['Qdedu'];

    $totcp = ($numTot);

	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);

	$tipoPol='006';
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));

	# QUERYS PARA UN REGISTRO
	$iDoctosc = "INSERT INTO doctosc(dc_emp,dc_serie,dc_num,dc_codp,dc_nit,dc_tipo,dc_prov,dc_fec,dc_rfec,dc_retsn,dc_retisn,dc_afe, dc_bien,dc_serv,dc_peque,dc_peque2,dc_imp,dc_impre,dc_medi,dc_noafe,dc_vehi,dc_vehia,dc_tvehi,dc_tfacom,dc_galos,dc_galor, dc_galod,dc_comb,dc_con,dc_subb,dc_subs,dc_subpe,dc_subco,dc_subve,dc_subi,dc_subir,dc_subna,dc_subme,dc_ret,dc_reti,dc_sub, dc_iva,dc_tot,dc_ulcam,dc_conso,dc_tasam,dc_fecrece,dc_fecp,dc_tcam,dc_contra,dc_fcontra,dc_seriecn,dc_numcn,dc_dc,dc_dedu) VALUES ('$empCod','$txtSerie','$numNum','$txtCod','$txtNit','$selTipoCod','$txtProv','$dtFec','$rfec','$crRet','$crReti','$crAfe','$numBien','$numServ','$numPeque','$numPeque2','$numImp','$numImpre','$numMedi','$numNoafe','$numVehi','$numVehia','$crTvehi','$numTfacom','$numGalos','$numGalor','$numGalod','$numComb','$txtCon','$subb','$subs','$subpe','$subco','$subve','$subi','$subir','$subna','$subme','$numRet','$numReti','$numSub','$numIva','$totcp','$usuNom','$empConso','$numTasam','$dtFecrece','$dtFecp','$numTcam','$numContra','$dtFcontra','$selOrden','$numOrden','$dcreProv','$deduTot')";

	$uDoctosc = "UPDATE doctosc SET dc_tipo='$selTipoCod', dc_prov='$txtProv', dc_fec='$dtFec', dc_rfec='$rfec', dc_retsn='$crRet', dc_retisn='$crReti', dc_afe='$crAfe', dc_bien='$numBien', dc_serv='$numServ', dc_peque='$numPeque', dc_peque2='$numPeque2', dc_imp='$numImp', dc_impre='$numImpre', dc_medi='$numMedi', dc_noafe='$numNoafe', dc_vehi='$numVehi', dc_vehia='$numVehia', dc_tvehi='$crTvehi', dc_tfacom='$numTfacom', dc_galos='$numGalos', dc_galor='$numGalor', dc_galod='$numGalod', dc_comb='$numComb', dc_con='$txtCon', dc_subb='$subb', dc_subs='$subs', dc_subpe='$subpe', dc_subco='$subco', dc_subve='$subve', dc_subi='$subi', dc_subir='$subir', dc_subna='$subna', dc_subme='$subme', dc_ret='$numRet', dc_reti='$numReti', dc_sub='$numSub', dc_iva='$numIva', dc_tot='$totcp', dc_ulcam='$usuNom', dc_conso='$empConso', dc_tasam='$numTasam', dc_fecrece='$dtFecrece', dc_fecp='$dtFecp', dc_tcam='$numTcam', dc_contra='$numContra', dc_fcontra='$dtFcontra', dc_seriecn='$selOrden', dc_numcn='$numOrden', dc_dc='$dcreProv', dc_dedu='$deduTot' WHERE dc_emp='$empCod' AND dc_serie='$txtSerie' AND dc_num='$numNum' AND dc_codp='$txtCod'";

	$iIva_comp = "INSERT INTO iva_comp (iva_emp, iva_serie, iva_num, iva_nit, iva_tipo, iva_prov, iva_fec, iva_rfec, iva_retsn, iva_retisn, iva_afe, iva_bien, iva_serv, iva_peque, iva_peque2, iva_imp, iva_impre, iva_medi, iva_noafe, iva_vehi, iva_vehia, iva_tvehi, iva_tfacom, iva_galos, iva_galor, iva_galod, iva_comb, iva_con, iva_subb, iva_subs, iva_subpe, iva_subco, iva_subve, iva_subi, iva_subir, iva_subna, iva_subme, iva_ret, iva_reti, iva_sub, iva_iva, iva_tot, iva_ulcam, iva_conso, iva_cajach, iva_tasam, iva_proco, iva_mod, iva_dedu) VALUES ('$empCod', '$txtSerie', '$numNum', '$txtNit', '$selTipoCod', '$txtProv', '$dtFec', '$rfec', '$crRet', '$crReti', '$crAfe', '$Qbien', '$Qserv', '$Qpeque', '$Qpeque2', '$Qimp', '$Qimpre', '$Qmedi', '$Qnoafe', '$Qvehi', '$numVehia', '$crTvehi', '$Qtfacom', '$numGalos', '$numGalor', '$numGalod', '$Qcomb', '$txtCon', '$Qsubb', '$Qsubs', '$Qsubpe', '$Qsubco', '$Qsubve', '$Qsubi', '$Qsubir', '$Qsubna', '$Qsubme', '$Qret', '$Qreti', '$Qsub', '$Qiva', '$Qtot', '$usuNom', '$empConso', 'N', '$Qtasam', '$txtCod','cxp','$Qdedu')";

	$uIva_comp = "UPDATE iva_comp SET iva_tipo='$selTipoCod', iva_prov='$txtProv', iva_fec='$dtFec', iva_rfec='$rfec', iva_retsn='$crRet', iva_retisn='$crReti', iva_afe='$crAfe', iva_bien='$Qbien', iva_serv='$Qserv', iva_peque='$Qpeque', iva_peque2='$Qpeque2', iva_imp='$Qimp', iva_impre='$Qimpre', iva_medi='$Qmedi', iva_noafe='$Qnoafe', iva_vehi='$Qvehi', iva_vehia='$numVehia', iva_tvehi='$crTvehi', iva_tfacom='$Qtfacom', iva_galos='$numGalos', iva_galor='$numGalor', iva_galod='$numGalod', iva_comb='$Qcomb', iva_con='$txtCon', iva_subb='$Qsubb', iva_subs='$Qsubs', iva_subpe='$Qsubpe', iva_subco='$Qsubco', iva_subve='$Qsubve', iva_subi='$Qsubi', iva_subir='$Qsubir', iva_subna='$Qsubna', iva_subme='$Qsubme', iva_ret='$Qret', iva_reti='$Qreti', iva_sub='$Qsub', iva_iva='$Qiva', iva_tot='$Qtot', iva_ulcam='$usuNom', iva_conso='$empConso', iva_tasam='$Qtasam',iva_dedu='$Qdedu' WHERE iva_emp='$empCod' AND iva_serie='$txtSerie' AND iva_num='$numNum' AND iva_nit='$txtNit'";

	$sPolizas = "SELECT pol_num FROM polizas WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie' AND pol_nit='$txtCod'";

	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_tipoi, pol_nit, pol_con, pol_ulcam, pol_grabado) VALUES ('$empCod','$rfec',0,'$tipoPol','$numNum','$txtSerie','$txtCod','$txtCon','$usuNom','$dtGrabado')";

	$uPolizas = "UPDATE polizas SET pol_con='$txtCon', pol_ulcam='$usuNom', pol_fec='$rfec', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_ban=0 AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie' AND pol_nit='$txtCod'";

	$sProvee = "SELECT * FROM provee WHERE pro_nit='$txtNit'";

	$iProvee = "INSERT INTO provee(pro_nit, pro_nom, pro_retsn) VALUES ('$txtNit','$txtProv','$crRet')";

	$uProvee = "UPDATE provee SET pro_nom='$txtProv', pro_ret='$crRet' WHERE pro_nit='$txtNit'";


	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_tipoi, pold_nit, pold_cta, pold_ctan, pold_debe, pold_haber) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$rfec',0,'$tipoPol','$numNum','$txtSerie','$txtCod','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber')".$func->addValues($obj, $jsonPol);
	}

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban=0 AND pold_tipo='$tipoPol' AND pold_num='$numNum' AND pold_tipoi='$txtSerie' AND pold_nit='$txtCod'";

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	$db->iEx($iIva_comp);
	if ($func->stringToBool($_POST['nuevo'])) {
		$resp = $db->iEx($iDoctosc);
		$db->iEx($iIva_comp);
		$db->query($func->iBitacora(utf8_decode("Se creó compra en CxP No.: $numNum Serie: $txtSerie Codigo: $txtCod Usuario: ").$usuNom, $bitMod, $bitForm));

		$db->query($iPolizas);
	} else {
		$resp = $db->uEx($uDoctosc);
		$db->uEx($uIva_comp);
		$db->query($func->iBitacora(utf8_decode("Se modificó compra en CxP No.: $numNum Serie: $txtSerie Codigo: $txtCod Usuario: ").$usuNom, $bitMod, $bitForm));

		$select["polizas"] = $db->query($sPolizas);
		($db->numRows($select["polizas"]) > 0) ? $db->query($uPolizas) : $db->query($iPolizas);
	}

	$select["provee"] = $db->query($sProvee);
	if ($db->numRows($select["provee"]) > 0) {
		$db->query($uProvee);
	} else {
		$db->query($iProvee);
	}		

	$db->dEx($dPoli_det);
	if (!$func->jsonEmpty($jsonPol)) {
		$db->iEx($iPoli_det);
	}

	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
	}

	// PARA APLICAR LOS CIERRES
	foreach ($jsonPol as $obj) {
		$cta = $obj->cta;
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$select["cierres"] = $db->query(sCierres($cta, $numAno, $selMesCod));
			if ($db->numRows($select["cierres"]) > 0) {
				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

				$db->query(uCierres($cta, $numAno, $selMesCod, $mdebe, $mhaber));
			} else {
				$mdebe=$obj->debe;
				$mhaber=$obj->haber;

				$db->query(iCierres($cta, $numAno, $selMesCod, $mdebe, $mhaber));
			}
			$cta = $ctaActa;
		}
	}

	$db->close();

	return json_encode($resp);
}

function borrar() {
	global $empCod, $usuNom, $bitMod, $bitForm;

	$func = new functions();

	$txtSerie=utf8_decode($_POST['txtSerie']);
	$numNum=$_POST['numNum'];
	$txtCod=utf8_decode($_POST['txtCod']);
	$txtNit=utf8_decode($_POST['txtNit']);
	$selBanCod=0;

	$rfecAnt=$_POST['rfecAnt'];
	$numAnoAnt=date("Y", strtotime($rfecAnt));
	$numMesAnt=date("n", strtotime($rfecAnt));

	$jsonPolAnt=json_decode($_POST['tblPolAnt']);

	$tipoPol = "006";

	# QUERYS
	$dDoctosc = "DELETE FROM doctosc WHERE dc_emp='$empCod' AND dc_serie='$txtSerie' AND dc_num='$numNum' AND dc_codp='$txtCod'";

	$dIva_comp = "DELETE FROM iva_comp WHERE iva_emp='$empCod' AND iva_serie='$txtSerie' AND iva_num='$numNum' AND iva_nit='$txtNit'";

	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie' AND pol_nit='$txtCod'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$tipoPol' AND pold_num='$numNum' AND pold_tipoi='$txtSerie' AND pold_nit='$txtCod'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	$resp = $db->dEx($dDoctosc);
	$db->dEx($dIva_comp);
	$db->dEx($dPolizas);
	$db->dEx($dPoli_det);

	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
	}


	$db->iEx($func->iBitacora(utf8_decode("Se borró compra en CxP No.: $numNum Serie: $txtSerie CODIGO: $txtCod Usuario: ").$usuNom, $bitMod, $bitForm));

	$db->close();

	return json_encode($resp);
}
?>