<?php
include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$txtSerie=$_GET["txtSerie"];
$numNum=$_GET["numNum"];
$txtCod=$_GET["txtCod"];
$tipoPol = "006";

# QUERYS
$sDoctosc = "SELECT *,
                TRIM(dc_prov) AS dc_prov
             FROM doctosc dc
             LEFT JOIN tipoc t ON dc.dc_tipo=t.tc_cod
             LEFT JOIN bancos b ON dc.dc_ban=b.ban_num AND b.ban_emp='$empCod'
             WHERE dc_emp='$empCod' AND dc_serie='$txtSerie' AND dc_num='$numNum' AND dc_codp='$txtCod'";

$sTipopol = "SELECT TRIM(tp_nom) AS tp_nom FROM tipopol WHERE tp_cod='$tipoPol'";

$sPoli_det = "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_ban=0 AND pold_tipo='$tipoPol' AND pold_num='$numNum' AND pold_tipoi='$txtSerie' AND pold_nit='$txtCod'";

# EJECUCION DE QUERYS
$db = new dbExec();
$fa["doctosc"] = $db->sFetchAssoc($sDoctosc);
$fa["tipopol"] = $db->sFetchAssoc($sTipopol);
$select["poli_det"] = $db->query($sPoli_det);
$db->close();

$tipoPolNom = $fa["tipopol"]["tp_nom"];

class generatePDF extends PDF_MC_Table {
    function Header() {
    }
    
    function Footer() { 
        global $tipoPolNom;
        // Posición:a 1,5 cm del final
        $this->SetY(-2.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,0,"C");
        $this->Ln(.5);
        $this->Cell(0,1,$tipoPolNom,0,0,"C");
    }
}

# GENERAR PDF
$pdf = new generatePDF("P","cm", "Letter");
//$pdf = new FPDF('P','mm',array(500,150));
$pdf->AddPage();
$pdf->SetMargins(2.5, 1, 2.5);
$pdf->SetFont("Arial","B",20);

$pdf->Cell(20,.7,$empNom,0,1,"C");
$pdf->Ln();

$lineWidth=16.5;
$lineHeight=0.5;

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/13, $lineHeight, utf8_decode("Serie:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, $txtSerie);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/9, $lineHeight, utf8_decode("Número:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, $numNum);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/9.3, $lineHeight, utf8_decode("CODIGO:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, $txtCod, 0, 1);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/14, $lineHeight, utf8_decode("Tipo:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/3.9, $lineHeight, $fa["doctosc"]["tc_nom"]);

$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/4.5, $lineHeight, utf8_decode("Fecha Documento:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.3, $lineHeight, strftime("%d/%m/%Y", strtotime($fa["doctosc"]["dc_fec"])));
$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/7, $lineHeight, utf8_decode("Recepción:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, strftime("%d/%m/%Y", strtotime($fa["doctosc"]["dc_fec"])), 0, 1);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/6, $lineHeight, utf8_decode("Fecha Pago:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.2, $lineHeight, strftime("%d/%m/%Y", strtotime($fa["doctosc"]["dc_fecp"])));

$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/4.5, $lineHeight, utf8_decode("Tasa de Cambio:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.3, $lineHeight, number_format($fa["doctosc"]["dc_tcam"], 6));
$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Orden Compra:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, $fa["doctosc"]["dc_numcn"], 0, 1);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, utf8_decode("Proveedor:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/1.1, $lineHeight, $fa["doctosc"]["dc_prov"], 0, 1);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, utf8_decode("Nit:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/4.9, $lineHeight, $fa["doctosc"]["dc_nit"]);
$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/5.8, $lineHeight, utf8_decode("No.Contraseña:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/5.4, $lineHeight, $fa["doctosc"]["dc_contra"]);

$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/4.5, $lineHeight, utf8_decode("Fecha Contraseña:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.3, $lineHeight, strftime("%d/%m/%Y", strtotime($fa["doctosc"]["dc_fcontra"])),0,1);

/*$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/10.5, $lineHeight, utf8_decode("Banco:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/1.415, $lineHeight, utf8_decode($fa["iva_comp"]["ban_nom"]));

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/11, $lineHeight, utf8_decode("CH/NC:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, $fa["iva_comp"]["iva_cheque"], 0, 1); */

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Compras:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctosc"]["dc_bien"], 2), 0, 0, "R");

$pdf->Cell($lineWidth/11, $lineHeight);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Servicios:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctosc"]["dc_serv"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Peq. Contribuyente Bienes:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctosc"]["dc_peque"], 2), 0, 0, "R");

$pdf->Cell($lineWidth/11, $lineHeight);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Peq. Contribuyente Servicios:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctosc"]["dc_peque2"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Imp. Centro América:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctosc"]["dc_imp"], 2), 0, 0, "R");

$pdf->Cell($lineWidth/11, $lineHeight);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Imp. Resto del Mundo:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctosc"]["dc_impre"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Medicamentos:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctosc"]["dc_medi"], 2), 0, 0, "R");

$pdf->Cell($lineWidth/11, $lineHeight);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("No Afecto Dec. 29-89:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctosc"]["dc_noafe"], 2), 0, 1, "R");

$pdf->Ln();
$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Valor Vehículo:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctosc"]["dc_vehi"], 2), 0, 0, "R");

$pdf->Cell($lineWidth/11, $lineHeight);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/7, $lineHeight, utf8_decode("Antigüedad:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/8.3, $lineHeight, number_format($fa["doctosc"]["dc_vehia"]).utf8_decode(" años"));

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/15, $lineHeight, utf8_decode("Tipo:"));
$pdf->SetFont("");
$tvehi="";
if (trim($fa["doctosc"]["dc_tvehi"]) == ("C" && "M")) {
    $tvehi = ($fa["doctosc"]["dc_tvehi"] == "C") ? "Carro" : "Moto";
}
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, $tvehi, 0, 1);

$pdf->Ln();
$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Total Factura Combustible:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctosc"]["dc_tfacom"], 2), 0, 0, "R");

$pdf->Cell($lineWidth/11, $lineHeight);

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/3.1, $lineHeight, utf8_decode("Valor Afecto Combustible:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/7.1, $lineHeight, number_format($fa["doctosc"]["dc_comb"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Galones Super:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctosc"]["dc_galos"], 3));

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Galones Regular:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctosc"]["dc_galor"], 3));

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Galones Diesel:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctosc"]["dc_galod"], 3), 0, 1);

$pdf->Ln();
$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/1.15, $lineHeight, utf8_decode("Retención ISR:"), 0, 0, "R");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctosc"]["dc_ret"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/1.15, $lineHeight, utf8_decode("Retención IVA:"), 0, 0, "R");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctosc"]["dc_reti"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/1.15, $lineHeight, utf8_decode("Subtotal:"), 0, 0, "R");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctosc"]["dc_sub"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/1.15, $lineHeight, utf8_decode("IVA:"), 0, 0, "R");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctosc"]["dc_iva"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/1.15, $lineHeight, utf8_decode("Imp/Combust.:"), 0, 0, "R");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctosc"]["dc_dedu"], 2), 0, 1, "R");

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/1.15, $lineHeight, utf8_decode("Total:"), 0, 0, "R");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/6.7, $lineHeight, number_format($fa["doctosc"]["dc_tot"], 2), 0, 1, "R");

$pdf->Ln();
$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Número de Póliza:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/2, $lineHeight, $tipoPol."-".$numNum);

$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Fecha de Póliza:"));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, strftime("%d/%m/%Y", strtotime($fa["doctosc"]["dc_rfec"])));
$pdf->Ln($lineHeight*1);

$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, "Concepto:");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/1.35, $lineHeight, $fa["doctosc"]["dc_con"]);
$pdf->Ln($lineHeight*3);

$header = array("Cuenta","Nombre de Cuenta","Debe","Haber");
$pdf->SetFont("","B");
$pdf->SetWidths(array(3,8,3,3));
$pdf->SetAligns(array("C","C","C","C"));
$pdf->Row($header, $lineHeight);

$pdf->SetFont("");
$pdf->SetAligns(array("L","L","R","R"));
$debe = 0;
$haber = 0;
while ($rec = $db->fetchAssoc($select['poli_det'])) {
    $debe += $rec["pold_debe"];
    $haber += $rec["pold_haber"];
    $body = array(
        $rec["pold_cta"],
        $rec["pold_ctan"],
        (round($rec["pold_debe"], 2) != 0) ? $rec["pold_debe"] :"",
        (round($rec["pold_haber"], 2) != 0) ? $rec["pold_haber"] :"",
    );
    $pdf->RowBorderLR($body, $lineHeight);
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());

$pdf->SetAligns(array("","R","R","R"));
$body = array(
    "",
    "Totales:",
    number_format($debe,2),
    number_format($haber,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());

$pdf->Ln($lineHeight*4);
$pdf->Cell($lineWidth/6);
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, "Hecho por", "T", 0, "C");
$pdf->Cell($lineWidth/6);
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, "Revisado por", "T", 0, "C");

$pdf->Output(utf8_decode("Póliza ").$tipoPol."-".$numNum.".pdf","I");
?>