<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$bitForm = "cxp1020";
$bitMod = "cxp";
$empCod = $_SESSION['empCod'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultar':
		echo consultar();
		break;

	case 'consultarProvcp':
		echo consultarProvcp();
		break;

	case 'consultarTr':
		echo consultarTr();
		break;

	case 'consultarCorr':
		echo consultarCorr();
		break;
	case 'consultarCorrPol':
		echo consultarCorrPol();
		break;
	case 'consultarCta':
		echo consultarCta();
		break;
		
	case 'mCerrado':
		echo mCerrado();
		break;

	case 'generarPartida':
		echo generarPartida();
		break;

	case 'generarPartidat':
		echo generarPartidat();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'guardarTr':
		echo guardarTr();
		break;

}

function consultar() {
	global $empCod, $usuNom;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$tipoCod="004";
	$numNum=$_POST['numNum'];
	$selBanCod=$_POST['selBanCod'];

	# QUERYS
	$sCheques = "SELECT * FROM cheques WHERE ch_emp='$empCod' AND ch_ban='$selBanCod' AND ch_tipo='$tipoCod' AND ch_num='$numNum'";
	$sPoli_det = "SELECT *, TRIM(pold_cta) AS pold_cta FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$tipoCod' AND pold_num='$numNum'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCheques, "cheques");
	$resp["poli_det"] = $db->sFetchAll($sPoli_det);
	$db->close();

	$func = new functions();
	$resp["asdf"]=$sPoli_det;
	//return $func->jsonEncodeArrayEach($resp, array('cheques', 'poli_det'));
	return $func->jsonEncodeArray($resp, 'cheques');
}

function consultarProvcp() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sProvcp = "SELECT *, TRIM(pro_nom) AS pro_nom, TRIM(pro_retsn) AS pro_retsn FROM provcp WHERE pro_emp='$empCod' AND pro_cod='$txtCod'";

	$sDoctosc = "SELECT *, TRIM(dc_con) AS dc_con, TRIM(dc_prov) AS dc_prov, (dc_tot-(dc_ret+dc_reti+dc_abo)) AS dc_sal, 0.00 AS dc_abop FROM doctosc WHERE dc_emp='$empCod' AND dc_codp='$txtCod' AND (dc_tot-(dc_ret+dc_reti+dc_abo))>0.00";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sProvcp, "provcp");
	$resp["doctosc"] = $db->sFetchAll($sDoctosc);
	$db->close();

	$func = new functions();
	$resp["asdf"]=$sDoctosc;

	return $func->jsonEncodeArray($resp, "provcp", "doctosc");
}

function consultarTr() {
	global $empCod, $usuNom;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$tipoCod="018";
	$numNum=$_POST['numNum'];
	$selBanCod=$_POST['selBanCod'];

	# QUERYS
	$sMovi = "SELECT * FROM movi WHERE mov_emp='$empCod' AND mov_ban='$selBanCod' AND mov_tipo='$tipoCod' AND mov_num='$numNum'";
	$sPoli_det = "SELECT *, TRIM(pold_cta) AS pold_cta FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$tipoCod' AND pold_num='$numNum'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sMovi, "movi");
	$resp["poli_det"] = $db->sFetchAll($sPoli_det);
	$db->close();

	$func = new functions();
	$resp["asdf"]=$sPoli_det;
	//return $func->jsonEncodeArrayEach($resp, array('cheques', 'poli_det'));
	return $func->jsonEncodeArray($resp, 'movi');
}


function consultarCorr() {
	global $empCod, $usuNom;

	$func = new functions();
	$selBanCod=$_POST['selBanCod'];
	# QUERYS
	$sBancos = "SELECT ban_mon,ban_corr FROM bancos WHERE ban_emp='$empCod' AND ban_num='$selBanCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["bancos"] = $db->sFetchAssoc($sBancos);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "bancos");
}

function consultarCorrPol() {
	global $empCod, $usuNom;

	$func = new functions();
	$anuselTipo=$_POST['anuselTipo'];
	# QUERYS
	$sCorrpol = "SELECT cp_num FROM corrpol WHERE cp_emp='$empCod' AND cp_tipo='$anuselTipo'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["corrpol"] = $db->sFetchAssoc($sCorrpol);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "corrpol");
}

function mCerrado() {
	global $empCod, $usuNom;

	$func = new functions();
	$dtFec=$_POST['dtFec'];
	$nAnio=date("Y", strtotime($dtFec));
	$nMes=date("n", strtotime($dtFec));

	# QUERYS
	$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$nAnio AND ciem_mes=$nMes";
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ciemes"] = $db->sfetchAssoc($sCiemes);
	$db->close();
	$func = new functions();
	return $func->jsonEncodeArray($resp, "ciemes");
}

function consultarCta() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sCuentas = "SELECT c.*, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$txtCod' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function guardar() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod, $selTipoCod, $numNum, $txtCodp, $nitprov, $numTcam, $dtFec;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numNum=$_POST['numNum'];
	$nuevocorr=$numNum+1;
	$selTipoCod="004";
	$selBanCod=$_POST['selBanCod'];
	$dtFec=$_POST['dtFec'];
	$cbNego=($func->stringToBool($_POST['cbNego'])) ? "N" : "S";
	$numTcam=$_POST['numTcam'];	
	$numTot=(empty($_POST['numTot'])) ? 0 : $_POST['numTot'];	
	$totant=$_POST['totant'];
	$txtBene=utf8_decode($_POST['txtBene']);
    $txtCodp=$_POST['txtCodp'];
    $ctaprov=$_POST['ctaprov'];
    $nitprov=$_POST['nitprov'];
	$txtCon=utf8_decode($_POST['txtCon']);
	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$jsonDocp=json_decode($_POST['tblDocp']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
    $totQ = round($numTot*$numTcam,2);

	# QUERYS PARA UN REGISTRO
	$sBancos = "SELECT ban_ctac,ban_corr FROM bancos WHERE ban_emp='$empCod' AND ban_num='$selBanCod'";

	$sSaldob = "SELECT * FROM saldob WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";

	$iCheques = "INSERT INTO cheques(ch_emp, ch_tipo, ch_ban, ch_num, ch_fec, ch_tot, ch_tcam, ch_bene, ch_con, ch_nego, ch_ulcam,ch_mod) VALUES ('$empCod','$selTipoCod','$selBanCod','$numNum','$dtFec','$numTot','$numTcam','$txtBene','$txtCon','$cbNego','$usuNom','cxp')";

	$uCheques = "UPDATE cheques SET ch_fec='$dtFec', ch_tcam='$numTcam', ch_tot='$numTot', ch_bene='$txtBene', ch_nego='$cbNego', ch_con='$txtCon', ch_ulcam='$usuNom', ch_mod='cxp' WHERE ch_emp='$empCod' AND ch_ban='$selBanCod' AND ch_tipo='$selTipoCod' AND ch_num='$numNum'";

	$iMovAcu = "INSERT INTO mov_acu(ma_emp, ma_tipo, ma_ban, ma_num, ma_fec, ma_haber, ma_bene, ma_con, ma_stat) VALUES ('$empCod','$selTipoCod','$selBanCod','$numNum','$dtFec','$numTot','$txtBene','$txtCon','C')";

	$uMovAcu = "UPDATE mov_acu SET ma_fec='$dtFec', ma_haber='$numTot', ma_bene='$txtBene', ma_con='$txtCon'  WHERE ma_emp='$empCod' AND ma_ban='$selBanCod' AND ma_tipo='$selTipoCod' AND ma_num='$numNum'";

	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_con, pol_ulcam, pol_grabado) VALUES ('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$txtCon','$usuNom','$dtGrabado')";

	$uPolizas = "UPDATE polizas SET pol_con='$txtCon', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_fec='$dtFec' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";

	$uBancos = "UPDATE bancos SET ban_corr=$nuevocorr WHERE ban_emp='$empCod' AND ban_num='$selBanCod'";

	$sDoctosca = "SELECT *, TRIM(dc_con) AS dc_con, TRIM(dc_prov) AS dc_prov, (dc_tot-(dc_ret+dc_reti+dc_abo)) AS dc_sal, 0.00 AS dc_abop FROM doctosc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND (dc_tot-(dc_ret+dc_reti+dc_abo))>0.00";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	function uSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "UPDATE saldob SET salb_saldo=$nvalor WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";
	}

	function iSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "INSERT INTO saldob(salb_emp, salb_num, salb_saldo) VALUES('$empCod','$selBanCod',$nvalor)";
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_cta, pold_ctan, pold_debe, pold_haber) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber')".$func->addValues($obj, $jsonPol);
	}

	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum'";


	# QUERY PARA ASGINAR CHEQUE A IVA COMPRAS
	function uCompras($serie, $numero) { 
		global $empCod, $usuNom, $selBanCod, $selTipoCod, $numNum, $nitprov;
		return "UPDATE iva_comp SET  iva_ban='$selBanCod', iva_tidoc='$selTipoCod', iva_cheque='$numNum' WHERE iva_emp='$empCod' AND iva_serie='$serie' AND iva_num=$numero AND iva_nit='$nitprov'";
	}

	# QUERY PARA ACTUALIZAR EN LOS CARGOS
	function iMovic($seried, $numd, $abono, $tcamc) { 
		global $empCod, $usuNom, $selBanCod, $selTipoCod, $numNum, $txtCodp, $nitprov, $dtFec, $numTcam;
		return "INSERT INTO movic (mov_emp, mov_codp, mov_nit, mov_fec, mov_tipo, mov_num, mov_abo, mov_tipoc, mov_numc, mov_ban, mov_tcam) VALUES ('$empCod','$txtCodp','$nitprov','$dtFec','$selTipoCod','$numNum',$abono,'$seried','$numd','$selBanCod',$tcamc)";
	}

	function sDoctosc($seried, $numd) { 
		global $empCod, $usuNom, $selBanCod, $txtCodp;
		return "SELECT dc_emp, dc_serie,dc_num, dc_abo, dc_tcam FROM doctosc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_serie='$seried' AND dc_num='$numd'";
	}
	function uDoctosc($seried, $numd, $nvalorabo) { 
		global $empCod, $usuNom, $selTipoCod, $selBanCod, $numNum, $txtCodp;
		return "UPDATE doctosc SET dc_ban='$selBanCod', dc_cheque='$numNum', dc_tipoch='$selTipoCod', dc_abo=$nvalorabo WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	// Revisa si hay algun problema en la partida, para ver si permite grabar o no
	$probpol1="X";
	$probpol2="A";	
	$probpol3="A";	
	$select["bancos"] = $db->query($sBancos);
	$fetchAssoc["bancos"] = $db->fetchAssoc($select["bancos"]);		
	$ctaBanco = trim($fetchAssoc["bancos"]["ban_ctac"]);
	$actcorr = $fetchAssoc["bancos"]["ban_corr"];
	foreach ($jsonPol as $obj) {
		$ctapol = trim($obj->cta);
		$haber = trim($obj->haber);

		$select["cuentas"] = $db->query(sCuentas($ctapol));
		$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
		$ctaC = trim($fetchAssoc["cuentas"]["cta"]);
		if ($db->numRows($select["cuentas"]) == 0) {
			$probpol1 = "A";
		}
		if ($ctapol == $ctaBanco) {
			$probpol2 = "X";
		}
		if ($ctapol == $ctaBanco && $numTot == $haber) {
			$probpol3 = "X";
		}
	}
	//

	if ($probpol1 == "X" && $probpol2 == "X" && $probpol3 == "X") {
		#Para Actualizar el saldo del banco
		$select["saldob"] = $db->query($sSaldob);
		if ($db->numRows($select["saldob"]) == 0) {
			$vSaldo = 0;
			$nvalor = ($vSaldo - $numTot);
			$db->query(iSaldob($nvalor));
		} else {
			$fetchAssoc["saldob"] = $db->fetchAssoc($select["saldob"]);		
			$vSaldo = $fetchAssoc["saldob"]["salb_saldo"];
			$nvalor = ($vSaldo+$totant) - $numTot;
			$db->query(uSaldob($nvalor));
		}		
		//
		
		// PARA ACTUALIZAR REGISTRO COMPRAS Y DOCUMENTOS DE CARGO
		foreach ($jsonDocp as $obj) {
			$seried = trim($obj->serie);
			$numerod = $obj->numero;
			$abonod = $obj->abono;
			$db->query(uCompras($seried, $numerod));
			$select["doctosc"] = $db->query(sDoctosc($seried, $numerod));
			if ($db->numRows($select["doctosc"]) > 0) {
				$fetchAssoc["doctosc"] = $db->fetchAssoc($select["doctosc"]);		
				$vAbono = $fetchAssoc["doctosc"]["dc_abo"];
				$tcamc = $fetchAssoc["doctosc"]["dc_tcam"];
				$nvalorabo = ($vAbono+$abonod);
				$db->query(uDoctosc($seried,$numerod,$nvalorabo));
				$db->query(iMovic($seried,$numerod,$abonod,$tcamc));
			}		
		}

		if ($func->stringToBool($_POST['nuevo'])) {
			if ($numNum == $actcorr || $numNum > $actcorr) {
				$nuevocorr = $numNum+1;
				$resp = $db->uEx($uBancos);
			}		
			$resp = $db->iEx($iCheques);
			$resp = $db->iEx($iMovAcu);
			$db->iEx($func->iBitacora(utf8_decode("Se creó en CxP Cheque No.: $numNum  Banco: $selBanCod Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		} else {
			$resp = $db->uEx($uCheques);
			$resp = $db->iEx($uMovAcu);
			$db->iEx($func->iBitacora(utf8_decode("Se modificó en CxP Cheque No.: $numNum  Banco: $selBanCod Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		}

		$db->dEx($dPolizas);
		$db->dEx($iPolizas);

		$db->dEx($dPoli_det);
		if (!$func->jsonEmpty($jsonPol)) {
			$db->iEx($iPoli_det);
		}

		// PARA REVERTIR LOS CIERRES
		foreach ($jsonPolAnt as $obj) {
			$cta = $obj->pold_cta;
			$numAnioAnt=date("Y", strtotime($obj->pold_fec));
			$numMesAnt=date("n", strtotime($obj->pold_fec));

			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

				$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

				$cta = $ctaActa;
			}
		}

		// PARA APLICAR LOS CIERRES
		foreach ($jsonPol as $obj) {
			$cta = $obj->cta;
			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $numAnio, $numMes));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

					$db->query(uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$obj->debe;
					$mhaber=$obj->haber;
					$db->query(iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}

		}
	}
	$resp["doctosc"] = $db->sFetchAll($sDoctosca);
	$db->close();
	
	$resp["dtGrabado"]=$dtGrabado;
	$resp["probpol1"]=$probpol1;
	$resp["probpol2"]=$probpol2;
	$resp["probpol3"]=$probpol3;

	return $func->jsonEncodeArray($resp, 'doctosc');
}


function guardarTr() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod, $selTipoCod, $numNum, $txtCodp, $nitprov, $numTcam, $dtFec;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();


	$numNum=$_POST['numNum'];
	$nuevocorr=$numNum+1;
	$selTipoCod="014";
	$selBanCod=$_POST['selBanCod'];
	$dtFec=$_POST['dtFec'];
	$numTcam=$_POST['numTcam'];	
	$numTot=(empty($_POST['numTot'])) ? 0 : $_POST['numTot'];	
	$totant=(empty($_POST['totant'])) ? 0 : $_POST['totant'];
    $txtCodp=$_POST['txtCodp'];
    $ctaprov=$_POST['ctaprov'];
    $nitprov=$_POST['nitprov'];
	$txtCon=utf8_decode($_POST['txtCon']);
	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$jsonDocp=json_decode($_POST['tblDocp']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$dh = "A";
    $totQ = round($numTot*$numTcam,2);


	# QUERYS PARA UN REGISTRO
	$sBancos = "SELECT ban_ctac,ban_corr FROM bancos WHERE ban_emp='$empCod' AND ban_num='$selBanCod'";

	$sSaldob = "SELECT * FROM saldob WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";

	$iMovi = "INSERT INTO movi(mov_emp, mov_tipo, mov_ban, mov_num, mov_fec, mov_tot, mov_tcam, mov_con, mov_debacr, mov_ulcam, mov_mod) VALUES ('$empCod','$selTipoCod','$selBanCod','$numNum','$dtFec','$numTot','$numTcam','$txtCon','$dh','$usuNom','cxp')";

	$uMovi = "UPDATE movi SET mov_fec='$dtFec', mov_tcam='$numTcam', mov_tot='$numTot', mov_con='$txtCon', mov_ulcam='$usuNom' WHERE mov_emp='$empCod' AND mov_ban='$selBanCod' AND mov_tipo='$selTipoCod' AND mov_num='$numNum'";

	$iMovAcu = "INSERT INTO mov_acu(ma_emp, ma_tipo, ma_ban, ma_num, ma_fec, ma_haber, ma_con, ma_stat) VALUES ('$empCod','$selTipoCod','$selBanCod','$numNum','$dtFec','$numTot','$txtCon','P')";

	$uMovAcu = "UPDATE mov_acu SET ma_fec='$dtFec', ma_haber='$numTot', ma_con='$txtCon'  WHERE ma_emp='$empCod' AND ma_ban='$selBanCod' AND ma_tipo='$selTipoCod' AND ma_num='$numNum'";

	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_con, pol_ulcam, pol_grabado) VALUES ('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$txtCon','$usuNom','$dtGrabado')";

	$uPolizas = "UPDATE polizas SET pol_con='$txtCon', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_fec='$dtFec' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";

	$sDoctosca = "SELECT *, TRIM(dc_con) AS dc_con, TRIM(dc_prov) AS dc_prov, (dc_tot-(dc_ret+dc_reti+dc_abo)) AS dc_sal, 0.00 AS dc_abop FROM doctosc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND (dc_tot-(dc_ret+dc_reti+dc_abo))>0.00";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	function uSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "UPDATE saldob SET salb_saldo=$nvalor WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";
	}

	function iSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "INSERT INTO saldob(salb_emp, salb_num, salb_saldo) VALUES('$empCod','$selBanCod',$nvalor)";
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_cta, pold_ctan, pold_debe, pold_haber) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber')".$func->addValues($obj, $jsonPol);
	}

	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum'";

	# QUERY PARA ASGINAR CHEQUE A IVA COMPRAS
	function uCompras($serie, $numero) { 
		global $empCod, $usuNom, $selBanCod, $selTipoCod, $numNum, $nitprov;
		return "UPDATE iva_comp SET  iva_ban='$selBanCod', iva_tidoc='$selTipoCod', iva_cheque='$numNum' WHERE iva_emp='$empCod' AND iva_serie='$serie' AND iva_num=$numero AND iva_nit='$nitprov'";
	}

	# QUERY PARA ACTUALIZAR EN LOS CARGOS
	function iMovic($seried, $numd, $abono, $tcamc) { 
		global $empCod, $usuNom, $selBanCod, $selTipoCod, $numNum, $txtCodp, $nitprov, $dtFec, $numTcam;
		return "INSERT INTO movic (mov_emp, mov_codp, mov_nit, mov_fec, mov_tipo, mov_num, mov_abo, mov_tipoc, mov_numc, mov_ban, mov_tcam) VALUES ('$empCod','$txtCodp','$nitprov','$dtFec','$selTipoCod','$numNum',$abono,'$seried','$numd','$selBanCod',$tcamc)";
	}

	function sDoctosc($seried, $numd) { 
		global $empCod, $usuNom, $selBanCod, $txtCodp;
		return "SELECT dc_emp, dc_serie,dc_num, dc_abo, dc_tcam FROM doctosc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	function uDoctosc($seried, $numd, $nvalorabo) { 
		global $empCod, $usuNom, $selTipoCod, $selBanCod, $numNum, $txtCodp;
		return "UPDATE doctosc SET dc_ban='$selBanCod', dc_cheque='$numNum', dc_tipoch='$selTipoCod', dc_abo=$nvalorabo WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	// Revisa si hay algun problema en la partida, para ver si permite grabar o no
	$probpol1="X";
	$probpol2="A";	
	$probpol3="A";	
	$select["bancos"] = $db->query($sBancos);
	$fetchAssoc["bancos"] = $db->fetchAssoc($select["bancos"]);		
	$ctaBanco = trim($fetchAssoc["bancos"]["ban_ctac"]);
	$actcorr = $fetchAssoc["bancos"]["ban_corr"];
	foreach ($jsonPol as $obj) {
		$ctapol = trim($obj->cta);
		$haber = trim($obj->haber);

		$select["cuentas"] = $db->query(sCuentas($ctapol));
		$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
		$ctaC = trim($fetchAssoc["cuentas"]["cta"]);
		if ($db->numRows($select["cuentas"]) == 0) {
			$probpol1 = "A";
		}
		if ($ctapol == $ctaBanco) {
			$probpol2 = "X";
		}
		if ($ctapol == $ctaBanco && $numTot == $haber) {
			$probpol3 = "X";
		}
	}
	//

	if ($probpol1 == "X" && $probpol2 == "X" && $probpol3 == "X") {
		#Para Actualizar el saldo del banco
		$select["saldob"] = $db->query($sSaldob);
		if ($db->numRows($select["saldob"]) == 0) {
			$vSaldo = 0;
			$nvalor = ($vSaldo - $numTot);
			$db->query(iSaldob($nvalor));
		} else {
			$fetchAssoc["saldob"] = $db->fetchAssoc($select["saldob"]);		
			$vSaldo = $fetchAssoc["saldob"]["salb_saldo"];
			$nvalor = ($vSaldo+$totant) - $numTot;
			$db->query(uSaldob($nvalor));
		}		
		//
		
		// PARA ACTUALIZAR REGISTRO COMPRAS Y DOCUMENTOS DE CARGO
		foreach ($jsonDocp as $obj) {
			$seried = trim($obj->serie);
			$numerod = $obj->numero;
			$abonod = $obj->abono;
			$db->query(uCompras($seried, $numerod));
			$select["doctosc"] = $db->query(sDoctosc($seried, $numerod));
			if ($db->numRows($select["doctosc"]) > 0) {
				$fetchAssoc["doctosc"] = $db->fetchAssoc($select["doctosc"]);		
				$vAbono = $fetchAssoc["doctosc"]["dc_abo"];
				$tcamc = $fetchAssoc["doctosc"]["dc_tcam"];
				$nvalorabo = ($vAbono+$abonod);
				$db->query(uDoctosc($seried,$numerod,$nvalorabo));
				$db->query(iMovic($seried,$numerod,$abonod,$tcamc));
			}		
		}

		if ($func->stringToBool($_POST['nuevo'])) {
			$resp = $db->iEx($iMovi);
			$resp = $db->iEx($iMovAcu);
			$db->iEx($func->iBitacora(utf8_decode("Se creó Transferencia a Proveedores No.: $numNum  Banco: $selBanCod Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		} else {
			$resp = $db->uEx($uMovi);
			$resp = $db->iEx($uMovAcu);
			$db->iEx($func->iBitacora(utf8_decode("Se modificó Transferencia a Proveedores No.: $numNum  Banco: $selBanCod Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		}

		$db->dEx($dPolizas);
		$db->dEx($iPolizas);

		$db->dEx($dPoli_det);
		if (!$func->jsonEmpty($jsonPol)) {
			$db->iEx($iPoli_det);
		}

		// PARA REVERTIR LOS CIERRES
		foreach ($jsonPolAnt as $obj) {
			$cta = $obj->pold_cta;
			$numAnioAnt=date("Y", strtotime($obj->pold_fec));
			$numMesAnt=date("n", strtotime($obj->pold_fec));

			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

				$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

				$cta = $ctaActa;
			}
		}

		// PARA APLICAR LOS CIERRES
		foreach ($jsonPol as $obj) {
			$cta = $obj->cta;
			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $numAnio, $numMes));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

					$db->query(uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$obj->debe;
					$mhaber=$obj->haber;
					$db->query(iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}

		}
	}
	$resp["doctosc"] = $db->sFetchAll($sDoctosca);
	$db->close();
	
	$resp["dtGrabado"]=$dtGrabado;
	$resp["probpol1"]=$probpol1;
	$resp["probpol2"]=$probpol2;
	$resp["probpol3"]=$probpol3;

	return $func->jsonEncodeArray($resp, 'doctosc');
}


function generarPartida() {
	global $empCod;
	$cta=$_POST['cta'];
	$ctadif=$_POST['ctadif'];
	$ctaprov=$_POST['ctaprov'];

	# QUERYS
	function sCuentas($cta) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ctaBanc"] = (empty($cta)) ? "" : $db->sFetchAssoc(sCuentas((string)$cta));
	$resp["ctaBandif"] = (empty($ctadif)) ? "" : $db->sFetchAssoc(sCuentas((string)$ctadif));
	$resp["ctaProv"] = $db->sFetchAssoc(sCuentas((string)$ctaprov));
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArrayEach($resp, array('ctaBanc', 'ctaProv', 'ctaBandif'));
}

function generarPartidat() {
	global $empCod;
	$cta=$_POST['cta'];
	$ctadif=$_POST['ctadif'];
	$ctaprov=$_POST['ctaprov'];

	# QUERYS
	function sCuentas($cta) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ctaBanc"] = (empty($cta)) ? "" : $db->sFetchAssoc(sCuentas((string)$cta));
	$resp["ctaBandif"] = (empty($ctadif)) ? "" : $db->sFetchAssoc(sCuentas((string)$ctadif));
	$resp["ctaProv"] = $db->sFetchAssoc(sCuentas((string)$ctaprov));
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArrayEach($resp, array('ctaBanc', 'ctaProv', 'ctaBandif'));
}
?>