<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$bitForm = "cxp1030";
$bitMod = "cxp";
$empCod = $_SESSION['empCod'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultar':
		echo consultar();
		break;

	case 'consultarProvcp':
		echo consultarProvcp();
		break;

	case 'consultarLisDocp':
		echo consultarLisDocp();
		break;

	case 'consultarCorr':
		echo consultarCorr();
		break;
	case 'consultarCorrPol':
		echo consultarCorrPol();
		break;
	case 'consultarCta':
		echo consultarCta();
		break;
		
	case 'mCerrado':
		echo mCerrado();
		break;

	case 'generarPartida':
		echo generarPartida();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'anular':
		echo anular();
		break;

	case 'borrar':
		echo borrar();
		break;
}

function consultar() {
	global $empCod, $usuNom;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

    $tipoCod="009";
	$numNum=$_POST['numNum'];
	$selTipoabo=$_POST['selTabo'];

	# QUERYS
	$sAbonos = "SELECT *, TRIM(abo.abo_con) AS abo_con, TRIM(pcp.pro_nom) AS pro_nom FROM abonos abo LEFT JOIN provcp pcp ON abo.abo_emp=pcp.pro_emp AND abo.abo_codp=pcp.pro_cod WHERE abo_emp='$empCod' AND abo_tipo='$selTipoabo' AND abo_num='$numNum'";
	$sAbo_det = "SELECT * FROM abo_det WHERE abd_emp='$empCod' AND abd_tipo='$selTipoabo' AND abd_num='$numNum'";
	$sPoli_det = "SELECT *, TRIM(pold_cta) AS pold_cta FROM poli_det WHERE pold_emp='$empCod' AND pold_ban=0 AND pold_tipo='$tipoCod' AND pold_num='$numNum' AND pold_tipoi='$selTipoabo'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sAbonos, "abonos");
	$resp["abo_det"] = $db->sFetchAll($sAbo_det);
	$resp["poli_det"] = $db->sFetchAll($sPoli_det);
	$db->close();

	$func = new functions();
	//return $func->jsonEncodeArrayEach($resp, array('abonos', 'poli_det', 'abo_det'));
	return $func->jsonEncodeArray($resp, 'abonos', 'poli_det', 'abo_det');
}

function consultarCorr() {
	global $empCod, $usuNom;

	$func = new functions();
	$selTabo=$_POST['selTabo'];
	# QUERYS
	$sTipoabo = "SELECT ta_partsn,ta_corr FROM tipoabo WHERE ta_cod='$selTabo'";
	$sCorrtabo = "SELECT * FROM corrtabo WHERE ctab_emp='$empCod' and ctab_tipo='$selTabo'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["tipoabo"] = $db->sFetchAssoc($sTipoabo);
	$resp["corrtabo"] = $db->sFetchAssoc($sCorrtabo);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "tipoabo", "corrtabo");
}

function consultarProvcp() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sProvcp = "SELECT *, TRIM(pro_nom) AS pro_nom, TRIM(pro_retsn) AS pro_retsn FROM provcp WHERE pro_emp='$empCod' AND pro_cod='$txtCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sProvcp, "provcp");
	$db->close();

	$func = new functions();

	return $func->jsonEncodeArray($resp, "provcp");
}

function consultarLisDocp() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sDoctosc = "SELECT *, TRIM(dc_con) AS dc_con, TRIM(dc_prov) AS dc_prov, (dc_tot-(dc_ret+dc_reti+dc_abo)) AS dc_sal, 0.00 AS dc_abop FROM doctosc WHERE dc_emp='$empCod' AND dc_codp='$txtCod' AND (dc_tot-(dc_ret+dc_reti+dc_abo))>0.00";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["doctosc"] = $db->sFetchAll($sDoctosc);
	$db->close();

	$func = new functions();
	//$resp["asdf"]=$sDoctosc;

	return $func->jsonEncodeArray($resp, "doctosc");
}

function consultarCorrPol() {
	global $empCod, $usuNom;

	$func = new functions();
	$anuselTipo=$_POST['anuselTipo'];
	# QUERYS
	$sCorrpol = "SELECT cp_num FROM corrpol WHERE cp_emp='$empCod' AND cp_tipo='$anuselTipo'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["corrpol"] = $db->sFetchAssoc($sCorrpol);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "corrpol");
}

function mCerrado() {
	global $empCod, $usuNom;

	$func = new functions();
	$dtFec=$_POST['dtFec'];
	$nAnio=date("Y", strtotime($dtFec));
	$nMes=date("n", strtotime($dtFec));

	# QUERYS
	$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$nAnio AND ciem_mes=$nMes";
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ciemes"] = $db->sfetchAssoc($sCiemes);
	$db->close();
	$func = new functions();
	return $func->jsonEncodeArray($resp, "ciemes");
}

function consultarCta() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sCuentas = "SELECT c.*, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$txtCod' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function guardar() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod, $selTipoCod, $selTipoabo, $numNum, $txtCodp, $nitprov, $numTcam, $dtFec, $crTmone, $taafe, $tatrela, $partsn, $nuevocorr;

	$func = new functions();

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv']) && !$func->stringToBool($_POST['nuevo'])) {
		return json_encode($priv->rErrorModify());
	}

	$numNum=$_POST['numNum'];
	$selTipoabo=$_POST['selTabo'];
	$nuevocorr=$numNum+1;
	$selBanCod=0;
	$selTipoCod="009";
	$dtFec=$_POST['dtFec'];
	$txtCodp=$_POST['txtCodp'];
	$txtProv=$_POST['txtProv'];
	$nitprov=$_POST['nitprov'];
	$numBien=(empty($_POST['numBien'])) ? 0 : $_POST['numBien'];
	$numServ=(empty($_POST['numServ'])) ? 0 : $_POST['numServ'];
	$numPeque=(empty($_POST['numPeque'])) ? 0 : $_POST['numPeque'];
	$numTcam=$_POST['numTcam'];
	$taafe=$_POST['taafe'];
	$tatrela=$_POST['tatrela'];
	$partsn=$_POST['partsn'];
	$numTot=round($numBien+$numServ+$numPeque,2);
	$txtCon=utf8_decode($_POST['txtCon']);
	$crTmone=$_POST['crTmone'];
	$Qtoti=$_POST['Qtoti'];
	$Qsub=$_POST['Qsub'];
	$Qsubb=$_POST['Qsubb'];
	$Qsubs=$_POST['Qsubs'];
	$Qiva=$_POST['Qiva'];
	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$jsonDocp=json_decode($_POST['tblDocp']);
	$jsonDocpAnt=json_decode($_POST['tblDocpAnt']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
    $totQ = round($numTot*$numTcam,2);
    $totivaQ = round($totQ*-1,2);
    $bienivaQ = round(($numBien*$numTcam)*-1,2);
    $servivaQ = round(($numServ*$numTcam)*-1,2);
    $pequeQ = round(($numPeque*$numTcam)*-1,2);
    $Qsub = ($Qsub*-1);
    $Qsubb = ($Qsubb*-1);
    $Qsubs = ($Qsubs*-1);
    $Qiva = ($Qiva*-1);

	# QUERYS PARA UN REGISTRO
	$sCorrtabo = "SELECT * FROM corrtabo WHERE ctab_emp='$empCod' AND ctab_tipo='$selTipoabo'";

	$iAbonos = "INSERT INTO abonos(abo_emp, abo_tipo, abo_num, abo_fec, abo_tot, abo_codp, abo_nit, abo_con, abo_tcam, abo_bien, abo_serv, abo_peque, abo_ulcam, abo_tmone) VALUES ('$empCod','$selTipoabo','$numNum','$dtFec','$numTot','$txtCodp','$nitprov','$txtCon','$numTcam','$numBien','$numServ','$numPeque','$usuNom','$crTmone')";

	$uAbonos = "UPDATE abonos SET abo_fec='$dtFec', abo_tcam='$numTcam', abo_tot='$numTot', abo_codp='$txtCodp', abo_nit='$nitprov', abo_con='$txtCon', abo_bien='$numBien', abo_serv='$numServ', abo_peque='$numPeque', abo_ulcam='$usuNom', abo_tmone='$crTmone' WHERE abo_emp='$empCod' AND abo_tipo='$selTipoabo' AND abo_num='$numNum'";

	$iIva_comp = "INSERT INTO iva_comp(iva_emp, iva_tipo, iva_serie, iva_num, iva_fec, iva_rfec, iva_nit, iva_prov, iva_tcam, iva_tot, iva_bien, iva_serv, iva_peque, iva_sub, iva_subb, iva_subs, iva_subpe, iva_iva, iva_con, iva_ulcam, iva_conso, iva_proco) VALUES ('$empCod','$tatrela','$tatrela','$numNum','$dtFec','$dtFec','$nitprov','$txtProv','$numTcam','$totivaQ', '$bienivaQ','$servivaQ','$pequeQ', '$Qsub', '$Qsubb', '$Qsubs', '$pequeQ', '$Qiva', '$txtCon','$usuNom','$empCod','$txtCodp')";

	$dIva_comp = "DELETE FROM iva_comp WHERE iva_emp='$empCod' AND iva_tipo='$tatrela' AND iva_num='$numNum'";

	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_con, pol_ulcam, pol_grabado, pol_tipoi) VALUES ('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$txtCon','$usuNom','$dtGrabado','$selTipoabo')";

	$uPolizas = "UPDATE polizas SET pol_con='$txtCon', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_fec='$dtFec' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum' AND pol_tipoi='$selTipoabo'";

	$uTipoabo = "UPDATE tipoabo SET ta_corr=$nuevocorr WHERE ta_cod='$selTipoabo'";
	$uCorrtabo = "UPDATE corrtabo SET ctab_corr=$nuevocorr WHERE ctab_emp='$empCod' and ctab_tipo='$selTipoabo'";
	$iCorrtabo = "INSERT INTO corrtabo(ctab_emp, ctab_tipo, ctab_corr) VALUES ('$empCod','$selTipoabo','$nuevocorr')";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	function uSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "UPDATE saldob SET salb_saldo=$nvalor WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";
	}

	function iSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "INSERT INTO saldob(salb_emp, salb_num, salb_saldo) VALUES('$empCod','$selBanCod',$nvalor)";
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_cta, pold_ctan, pold_debe, pold_haber, pold_tipoi) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber','$selTipoabo')".$func->addValues($obj, $jsonPol);
	}

	$iAbo_det = "INSERT INTO abo_det (abd_emp, abd_tipo, abd_num, abd_codp, abd_nit, abd_tipoc, abd_numc, abd_sal, abd_abop, abd_tcam, abd_fec, abd_feccd, abd_tmone) VALUES ";
	foreach ($jsonDocp as $obj) {
		$fechao=$obj->fecha;
		$valores=explode("/",$obj->fecha);
		$fecha=$valores[2]."-".$valores[1]."-".$valores[0];
		$iAbo_det = $iAbo_det."('$empCod','$selTipoabo','$numNum','$txtCodp','$nitprov','$obj->serie','$obj->numero','$obj->saldo','$obj->abono','$obj->tcam','$dtFec','$fecha','$crTmone')".$func->addValues($obj, $jsonDocp);
	}

	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum' AND pol_tipoi='$selTipoabo'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum' AND pold_tipoi='$selTipoabo'";

	$dAbo_det = "DELETE FROM abo_det WHERE abd_emp='$empCod' AND abd_tipo='$selTipoabo' AND abd_num='$numNum'";

	$dMovic = "DELETE FROM movic WHERE mov_emp='$empCod' AND mov_tipo='$selTipoabo' AND mov_num='$numNum'";

	# QUERY PARA ACTUALIZAR EN LOS CARGOS
	function iMovic($seried, $numd, $abono) { 
		global $empCod, $usuNom, $selTipoabo, $numNum, $txtCodp, $nitprov, $dtFec, $numTcam;
		return "INSERT INTO movic (mov_emp, mov_codp, mov_nit, mov_fec, mov_tipo, mov_num, mov_abo, mov_tipoc, mov_numc, mov_ban, mov_tcam) VALUES ('$empCod','$txtCodp','$nitprov','$dtFec','$selTipoabo','$numNum',$abono,'$seried','$numd',0,$numTcam)";
	}

	function sDoctosc($seried, $numd) { 
		global $empCod, $usuNom, $txtCodp;
		return "SELECT dc_emp, dc_codp, dc_serie,dc_num, dc_abo FROM doctosc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_serie='$seried' AND dc_num='$numd'";
	}
	function uDoctosc($seried, $numd, $nvalorabo) { 
		global $empCod, $usuNom, $txtCodp;
		return "UPDATE doctosc SET dc_abo=$nvalorabo WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	// Revisa si hay algun problema en la partida, para ver si permite grabar o no
	$probpol1="X";
	$probpol2="A";	
	$probpol3="A";	
	if ($partsn != 'S') {
	  $probpol2="X";	
	  $probpol3="X";	
	}
	$select["corrtabo"] = $db->query($sCorrtabo);
	$fetchAssoc["corrtabo"] = $db->fetchAssoc($select["corrtabo"]);		
	$actcorr = $fetchAssoc["corrtabo"]["ctab_corr"];
	foreach ($jsonPol as $obj) {
		$ctapol = trim($obj->cta);
		$debe = trim($obj->debe);
		$haber = trim($obj->haber);

		$select["cuentas"] = $db->query(sCuentas($ctapol));
		$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
		$ctaC = trim($fetchAssoc["cuentas"]["cta"]);
		if ($db->numRows($select["cuentas"]) == 0) {
			$probpol1 = "A";
		}
		//if ($ctapol == $ctaprov) {
			$probpol2 = "X";
		//}
		//if ($ctapol == $ctaprov && $totQ == $debe) {
			$probpol3 = "X";
		//}
	}
	//

	if ($probpol1 == "X" && $probpol2 == "X" && $probpol3 == "X") {
		
		// PARA ACTUALIZAR  DOCUMENTOS DE CARGO
		// PRIMERO RESTA LO ANTERIOR
		$db->query($dMovic);
		$db->query($dAbo_det);
		foreach ($jsonDocpAnt as $obja) {
			$seried = trim($obja->abd_tipoc);
			$numerod = $obja->abd_numc;
			$abonod = $obja->abd_abop;
			$select["doctosc"] = $db->query(sDoctosc($seried, $numerod));
			if ($db->numRows($select["doctosc"]) > 0) {
				$fetchAssoc["doctosc"] = $db->fetchAssoc($select["doctosc"]);		
				$vAbono = $fetchAssoc["doctosc"]["dc_abo"];
				$nvalorabo = ($vAbono-$abonod);
				$db->query(uDoctosc($seried,$numerod,$nvalorabo));
			}		
		}
		foreach ($jsonDocp as $obj) {
			$seried = trim($obj->serie);
			$numerod = $obj->numero;
			$abonod = $obj->abono;
			$select["doctosc"] = $db->query(sDoctosc($seried, $numerod));
			if ($db->numRows($select["doctosc"]) > 0) {
				$fetchAssoc["doctosc"] = $db->fetchAssoc($select["doctosc"]);
				$vAbono = $fetchAssoc["doctosc"]["dc_abo"];
				$nvalorabo = ($vAbono+$abonod);
				$db->query(uDoctosc($seried,$numerod,$nvalorabo));
				$db->query(iMovic($seried,$numerod,$abonod));
			}		
		}

		if ($func->stringToBool($_POST['nuevo'])) {
			if ($db->numRows($select["corrtabo"]) == 0) {
				$resp = $db->iEx($iCorrtabo);
			} else {
				if ($numNum == $actcorr || $numNum > $actcorr) {
					$nuevocorr = $numNum+1;
					$resp = $db->uEx($uCorrtabo);
				}
			}				
			$resp = $db->iEx($iAbonos);
			$db->query($iAbo_det);			
			$db->iEx($func->iBitacora(utf8_decode("Se creó en CxP Documento No.: $numNum  Tipo: $selTipoabo Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		} else {
			$resp = $db->uEx($uAbonos);
			$db->query($iAbo_det);			
			$db->iEx($func->iBitacora(utf8_decode("Se modificó en CxP Documento No.: $numNum  Tipo: $selTipoabo Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		}

		if ($partsn == 'S') {
			$db->dEx($dPolizas);
			$db->dEx($iPolizas);

			$db->dEx($dPoli_det);
			if (!$func->jsonEmpty($jsonPol)) {
				$db->iEx($iPoli_det);
			}

			// PARA REVERTIR LOS CIERRES
			foreach ($jsonPolAnt as $obj) {
				$cta = $obj->pold_cta;
				$numAnioAnt=date("Y", strtotime($obj->pold_fec));
				$numMesAnt=date("n", strtotime($obj->pold_fec));

				while (!empty($cta)) {
					$select["cuentas"] = $db->query(sCuentas($cta));
					$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

					$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

					$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

					$cta = $ctaActa;
				}
			}

			// PARA APLICAR LOS CIERRES
			foreach ($jsonPol as $obj) {
				$cta = $obj->cta;
				while (!empty($cta)) {
					$select["cuentas"] = $db->query(sCuentas($cta));
					$select["cierres"] = $db->query(sCierres($cta, $numAnio, $numMes));

					$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

					if ($db->numRows($select["cierres"]) > 0) {
						$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
						$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
						$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

						$db->query(uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
					} else {
						$mdebe=$obj->debe;
						$mhaber=$obj->haber;
						$db->query(iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
					}
					$cta = $ctaActa;
				}

			}
		}
		// Para aplicar la nota de credito en el iva, si es un tipo afecto
		if ($taafe == 'S') {
		   $db->dEx($dIva_comp);
		   $db->iEx($iIva_comp);
		}	
	}
	//$resp["tipoabo"] = $db->query($sTipoabo);
	$db->close();
	
	$resp["dtGrabado"]=$dtGrabado;
	$resp["probpol1"]=$probpol1;
	$resp["probpol2"]=$probpol2;
	$resp["probpol3"]=$probpol3;

	//return $func->jsonEncodeArray($resp, "tipoabo");
	return json_encode($resp);
}

function borrar() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selTipoCod, $selTipoabo, $numNum, $txtCodp, $taafe, $tatrela;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numNum=$_POST['numNum'];
	$selTipoabo=$_POST['selTabo'];
	$selBanCod=0;
	$selTipoCod="009";
	$txtCodp=$_POST['txtCodp'];
	$taafe=$_POST['taafe'];
	$tatrela=$_POST['tatrela'];
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$jsonDocpAnt=json_decode($_POST['tblDocpAnt']);
	$anu='**** ANULADO ****';
	$valcero=0;

	# QUERYS PARA UN REGISTRO


	$dAbonos = "DELETE FROM  abonos WHERE abo_emp='$empCod' AND abo_tipo='$selTipoabo' AND abo_num='$numNum'";

	$dIva_comp = "DELETE FROM iva_comp WHERE iva_emp='$empCod' AND iva_tipo='$tatrela' AND iva_num='$numNum'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}


	# QUERYS PARA VARIOS REGISTROS
	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum' AND pol_tipoi='$selTipoabo'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum' AND pold_tipoi='$selTipoabo'";

	$dAbo_det = "DELETE FROM abo_det WHERE abd_emp='$empCod' AND abd_tipo='$selTipoabo' AND abd_num='$numNum'";

	$dMovic = "DELETE FROM movic WHERE mov_emp='$empCod' AND mov_tipo='$selTipoabo' AND mov_num='$numNum'";

	# QUERY PARA ACTUALIZAR EN LOS CARGOS

	function sDoctosc($seried, $numd) { 
		global $empCod, $usuNom, $txtCodp;
		return "SELECT dc_emp, dc_codp, dc_serie,dc_num, dc_abo FROM doctosc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_serie='$seried' AND dc_num='$numd'";
	}
	function uDoctosc($seried, $numd, $nvalorabo) { 
		global $empCod, $usuNom, $txtCodp;
		return "UPDATE doctosc SET dc_abo=$nvalorabo WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();

	$resp = $db->dEx($dAbonos);
	$db->uEx($dAbo_det);
	$db->uEx($dMovic);
	$db->dEx($dIva_comp);
    
	// PRIMERO LO ANTERIOR
	$pasodoc="NO";
	foreach ($jsonDocpAnt as $obja) {
		$seried = trim($obja->abd_tipoc);
		$numerod = $obja->abd_numc;
		$abonod = $obja->abd_abop;
		$select["doctosc"] = $db->query(sDoctosc($seried, $numerod));
		if ($db->numRows($select["doctosc"]) > 0) {
			$fetchAssoc["doctosc"] = $db->fetchAssoc($select["doctosc"]);		
			$vAbono = $fetchAssoc["doctosc"]["dc_abo"];
			$nvalorabo = ($vAbono-$abonod);
			$db->query(uDoctosc($seried,$numerod,$nvalorabo));
		}		
		$pasodoc="SI";
	}

	$db->dEx($dPolizas);
	$db->dEx($dPoli_det);

    $pasopol="NO";
	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		$numAnioAnt=date("Y", strtotime($obj->pold_fec));
		$numMesAnt=date("n", strtotime($obj->pold_fec));

		while (!empty($cta)) {
			$select["cuentas"] = $db->query(sCuentas($cta));
			$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

			$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
		$pasopol="SI";
	}

	//
	$db->iEx($func->iBitacora(utf8_decode("Se Borro CxP Documento Tipo $selTipoabo  No.: $numNum  Usuario: ").$usuNom, $bitMod, $bitForm));

	$db->close();

	$resp["pasodoc"]=$pasodoc;
	$resp["pasopol"]=$pasopol;

	return json_encode($resp);
}

function anular() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selTipoCod, $selTipoabo, $numNum, $txtCodp, $taafe, $tatrela;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numNum=$_POST['numNum'];
	$selTipoabo=$_POST['selTabo'];
	$selBanCod=0;
	$selTipoCod="009";
	$txtCodp=$_POST['txtCodp'];
	$taafe=$_POST['taafe'];
	$tatrela=$_POST['tatrela'];
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$jsonDocpAnt=json_decode($_POST['tblDocpAnt']);
	$anu='**** ANULADO ****';
	$valcero=0;

	# QUERYS PARA UN REGISTRO


	$uAbonos = "UPDATE abonos SET abo_tot='$valcero', abo_con='$anu', abo_bien='$valcero', abo_serv='$valcero', abo_peque='$valcero', abo_ulcam='$usuNom' WHERE abo_emp='$empCod' AND abo_tipo='$selTipoabo' AND abo_num='$numNum'";

	$dIva_comp = "DELETE FROM iva_comp WHERE iva_emp='$empCod' AND iva_tipo='$tatrela' AND iva_num='$numNum'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}


	# QUERYS PARA VARIOS REGISTROS
	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum' AND pol_tipoi='$selTipoabo'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum' AND pold_tipoi='$selTipoabo'";

	$uAbo_det = "UPDATE abo_det SET abd_abop=$valcero WHERE abd_emp='$empCod' AND abd_tipo='$selTipoabo' AND abd_num='$numNum'";

	$uMovic = "UPDATE movic SET mov_abo=$valcero WHERE mov_emp='$empCod' AND mov_tipo='$selTipoabo' AND mov_num='$numNum'";

	# QUERY PARA ACTUALIZAR EN LOS CARGOS

	function sDoctosc($seried, $numd) { 
		global $empCod, $usuNom, $txtCodp;
		return "SELECT dc_emp, dc_codp, dc_serie,dc_num, dc_abo FROM doctosc WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_serie='$seried' AND dc_num='$numd'";
	}
	function uDoctosc($seried, $numd, $nvalorabo) { 
		global $empCod, $usuNom, $txtCodp;
		return "UPDATE doctosc SET dc_abo=$nvalorabo WHERE dc_emp='$empCod' AND dc_codp='$txtCodp' AND dc_serie='$seried' AND dc_num='$numd'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();

	$resp = $db->anEx($uAbonos);
	$db->uEx($uAbo_det);
	$db->uEx($uMovic);
	$db->dEx($dIva_comp);
    
	// PRIMERO LO ANTERIOR
	$pasodoc="NO";
	foreach ($jsonDocpAnt as $obja) {
		$seried = trim($obja->abd_tipoc);
		$numerod = $obja->abd_numc;
		$abonod = $obja->abd_abop;
		$select["doctosc"] = $db->query(sDoctosc($seried, $numerod));
		if ($db->numRows($select["doctosc"]) > 0) {
			$fetchAssoc["doctosc"] = $db->fetchAssoc($select["doctosc"]);		
			$vAbono = $fetchAssoc["doctosc"]["dc_abo"];
			$nvalorabo = ($vAbono-$abonod);
			$db->query(uDoctosc($seried,$numerod,$nvalorabo));
		}		
		$pasodoc="SI";
	}

	$db->dEx($dPolizas);
	$db->dEx($dPoli_det);

    $pasopol="NO";
	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		$numAnioAnt=date("Y", strtotime($obj->pold_fec));
		$numMesAnt=date("n", strtotime($obj->pold_fec));

		while (!empty($cta)) {
			$select["cuentas"] = $db->query(sCuentas($cta));
			$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

			$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
		$pasopol="SI";
	}

	//
	$db->iEx($func->iBitacora(utf8_decode("Se Anulo CxP Documento Tipo $selTipoabo  No.: $numNum  Usuario: ").$usuNom, $bitMod, $bitForm));

	$db->close();

	$resp["pasodoc"]=$pasodoc;
	$resp["pasopol"]=$pasopol;

	return json_encode($resp);
}


function generarPartida() {
	global $empCod;

	$ctaprov=$_POST['ctaprov'];
	$Qiva=$_POST['Qiva'];

	# QUERYS
	function sCuentas($cta) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ctaProv"] = ($ctaprov=="") ? "" : $db->sFetchAssoc(sCuentas((string)$ctaprov));
	$resp["ctaIva"] = ($Qiva==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaic"]));
	$resp["ctaCaja"] = $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtacaj"]));

	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, 'ctaProv');
}

?>