<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$dtFec=date("Y-m-d");
$txtCodp=$_GET["txtCodp"];
$txtSerie=$_GET["txtSerie"];
$numNum=$_GET["numNum"];
$crTmone=$_GET["crTmone"];
if ($crTmone == 'L') {
    $tipomon=$empMoneda;
} else {
    $tipomon='DOLARES';
}   

//$func = new functions();


$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFec, $dtFec, $tipomon;
        $this->SetMargins(1.5, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("ESTADO DE CUENTA DE UN DOCUMENTO ESPECIFICO AL ".strftime("%d/%m/%Y")),0,1,"L");
        $this->SetFont("","B",8);        
        $this->SetFont("","",7);        

        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("CIFRAS EXPRESADAS EN ").$tipomon,0,1,"L");
        $this->SetFont("");
        $this->SetAligns(array("L","L","C","C","C","R","R","R","R","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}


# QUERYS
$sDoctosc = "SELECT *, TRIM(dc_prov) AS dc_prov, TRIM(dc_codp) AS dc_codp, TRIM(dc_nit) AS dc_nit, 
    TRIM(pv.pro_clas) AS dc_clas, TRIM(cla.cla_nom) AS cla_nom FROM doctosc dc 
    LEFT JOIN provcp pv ON dc.dc_emp=pv.pro_emp and dc.dc_codp=pv.pro_cod 
    LEFT JOIN clasi cla ON pv.pro_clas=cla.cla_cod
    WHERE dc_emp='$empCod' and dc_serie='$txtSerie' and dc_num='$numNum' and dc_codp='$txtCodp'";

function sAbonos($codp,$seried,$numd) { 
    global $empCod;
    return "SELECT * FROM movic mc LEFT JOIN tipoabo ta ON mc.mov_tipo=ta.ta_cod WHERE mov_emp='$empCod'  and mov_codp='$codp' and mov_tipoc='$seried' and mov_numc='$numd'";
}    
# EJECUCION DE QUERYS
$db = new dbExec();
$lineHeight=0.35;
$select["doctosc"] = $db->query($sDoctosc);

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();

$func = new functions();

$ti_clasi="XXXZZZ999";
$totcargos=0;
$totret=0;
$totreti=0;
$totabonos=0;
$t_lini=1;
$codp="";
$ti_codp="XXZZZ999";
$nomp="";
$clas="";
$clasnom="";
$saldoact=0;

$arrayProv = array();

while ($rec = $db->fetchAssoc($select["doctosc"])) {
    if ($t_lini == 1) {
        //$pdf->SetFont("","B",8);        
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("PROVEEDOR: ".$rec["dc_codp"]."-".$rec["pro_nom"]),0,1,"L");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("DIRECCION: ".$rec["pro_dir"]),0,1,"L");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("NIT: ".$rec["pro_nit"]."         TELEFONO: ".$rec["pro_tel"]),0,1,"L");
        $pdf->SetFont("","",7);        
        $header = array("SERIE","NUMERO","FEC/DOC","FEC/VENCE","D/VENCIDO","CARGOS","ABONOS","RET/ISR","RET/IVA","SALDO");
        $pdf->SetWidths(array(2,2,1.5,1.8,1.8,2,2,1.7,1.7,2));
        $pdf->SetAligns(array("C","C","C","C","C","C","C","C","C","C"));
        $pdf->Row($header, $lineHeight); 
        $pdf->SetFont("");
        $pdf->SetAligns(array("L","L","C","C","C","R","R","R","R","R"));

        $codp=$rec["dc_codp"];
        $nomp=$rec["pro_nom"];
        $clas=$rec["pro_clas"];
        $clasnom=$rec["cla_nom"];
        //$t_lini=2;
    }
    $t_lini=2;


    $codp=$rec["dc_codp"];
    $clas=$rec["pro_clas"];
    $seried=$rec["dc_serie"];
    $numd=$rec["dc_num"];
    $fec=$rec["dc_fec"];
    $fecp=$rec["dc_fecp"];
    $tcam=$rec["dc_tcam"];
    $tot=$rec["dc_tot"];
    $ret=$rec["dc_ret"];
    $reti=$rec["dc_reti"];
    if ($tot>0) {
        if ($crTmone == 'L' && $tcam>1) {
            $tot=round($tot*$tcam,2);
            $ret=round($ret*$tcam,2);
            $reti=round($reti*$tcam,2);
        }
        if ($crTmone == 'E' && $tcam == 1) {
            $tot=round($tot/$empTcam,2);
            $ret=round($ret/$empTcam,2);
            $reti=round($reti/$empTcam,2);
        }
    } else {
        continue;
    }

    // Para saber cuantos dias
    $diff=$func->dateDiff($dtFec, $fecp);
    $dias=($diff->invert == 1) ? '-'.$diff->days : $diff->days;

    $saldoact = ($saldoact+$tot)-($ret+$reti);

    $totcargos += $tot;
    $totret += $ret;
    $totreti += $reti;

    $body = array(
        $rec["dc_serie"],
        trim($rec["dc_num"]),
        strftime("%d/%m/%Y", strtotime($fec)),
        strftime("%d/%m/%Y", strtotime($fecp)),
        $dias,        
        (round($tot, 2) != 0) ? number_format($tot, 2, '.', ',') : "",        
        "",        
        (round($ret, 2) != 0) ? number_format($ret, 2, '.', ',') : "",        
        (round($reti, 2) != 0) ? number_format($reti, 2, '.', ',') : "",        
        (round($saldoact, 2) != 0) ? number_format($saldoact, 2, '.', ',') : "",        
    ); 
    $pdf->RowBorderHidden($body, $lineHeight);
    if (($pdf->GetY()+$lineHeight) > 19) {
        $pdf->AddPage();
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("PROVEEDOR: ".$rec["dc_codp"]."-".$rec["pro_nom"]),0,1,"L");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("DIRECCION: ".$rec["pro_dir"]),0,1,"L");
        $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("NIT: ".$rec["pro_nit"]."         TELEFONO: ".$rec["pro_tel"]),0,1,"L");
        $pdf->SetFont("","",7);        
        $header = array("SERIE","NUMERO","FEC/DOC","FEC/VENCE","D/VENCIDO","CARGOS","ABONOS","RET/ISR","RET/IVA","SALDO");
        $pdf->SetWidths(array(2,2,1.5,1.8,1.8,2,2,1.7,1.7,2));
        $pdf->SetAligns(array("C","C","C","C","C","C","C","C","C","C"));
        $pdf->Row($header, $lineHeight); 
        $pdf->SetFont("");
        $pdf->SetAligns(array("L","L","C","C","C","R","R","R","R","R"));
    }    

    $sumabo=0;
    $select["movic"] = $db->query(sAbonos($codp,$seried,$numd));
    //$fetchAssoc["movic"] = $db->sFetchAssoc(sAbonos($codp));
    while ($recabo = $db->fetchAssoc($select["movic"])) {
        $vabo=$recabo["mov_abo"];
        $tcamabo=$recabo["mov_tcam"];
        if ($vabo>0) {
            if ($crTmone == 'L' && $tcamabo>1) {
                $vabo=round($vabo*$tcamabo,2);
            }
            if ($crTmone == 'E' && $tcamabo == 1) {
                $vabo=round($vabo/$empTcam,2);
            }
            $sumabo += $vabo;
        }
        $totabonos += $vabo;
        $sumabo+= $vabo;
        $saldoact = ($saldoact-$vabo);
        $body = array(
            trim($recabo["ta_nom"]),
            trim($recabo["mov_num"]),
            strftime("%d/%m/%Y", strtotime($recabo["mov_fec"])),
            "",
            "",
            "",
            (round($vabo, 2) != 0) ? number_format($vabo, 2, '.', ',') : "",        
            "",        
            "",        
            (round($saldoact, 2) != 0) ? number_format($saldoact, 2, '.', ',') : "",        
        ); 
        $pdf->RowBorderHidden($body, $lineHeight);
        if (($pdf->GetY()+$lineHeight) > 25) {
            $pdf->AddPage();
            $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("PROVEEDOR: ".$rec["dc_codp"]."-".$rec["pro_nom"]),0,1,"L");
            $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("DIRECCION: ".$rec["pro_dir"]),0,1,"L");
            $pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("NIT: ".$rec["pro_nit"]."         TELEFONO: ".$rec["pro_tel"]),0,1,"L");
            $pdf->SetFont("","",7);        
            $header = array("SERIE","NUMERO","FEC/DOC","FEC/VENCE","D/VENCIDO","CARGOS","ABONOS","RET/ISR","RET/IVA","SALDO");
            $pdf->SetWidths(array(2,2,1.5,1.8,1.8,2,2,1.7,1.7,2));
            $pdf->SetAligns(array("C","C","C","C","C","C","C","C","C","C"));
            $pdf->Row($header, $lineHeight); 
            $pdf->SetFont("");
            $pdf->SetAligns(array("L","L","C","C","C","R","R","R","R","R"));
        }    
    }
}

//$pdf->ln();
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20, $pdf->GetY());
$pdf->Cell(.04,.4,"          TOTALES DEL DOCUMENTO",0,0,"L");
$body = array(
    "",
    "",
    "",
    "",
    "",
    number_format($totcargos, 2, '.', ','),
    number_format($totabonos, 2, '.', ','),
    number_format($totret, 2, '.', ','),
    number_format($totreti, 2, '.', ','),
    number_format($saldoact, 2, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20, $pdf->GetY());


$pdf->Output(utf8_decode("Estado Cuenta un docto" ).".pdf","I");

$db->close();

?>