<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$selClasi=$_GET["selClasi"];

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFec;
        $this->SetMargins(2, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",17);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de Proveedores al ".strftime("%d/%m/%Y")),0,1,"L");
        //$this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de Proveedores al ".strftime("%d/%m/%Y", strtotime($dtFec))),0,1,"C");

        $this->Ln();
        $this->SetFont("","",7);
        $header = array("Codigo","Nombre Proveedor","Razon social","Direccion","Nit","Telefono","Whatsapp","Ret.S/N","D/Cred.");
        $this->SetFont("","B");
        $this->SetWidths(array(2.5,4,4,4,2.5,1.8,1.8,1.5,1.5));
        $this->SetAligns(array("C","C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("L","L","L","L","L","L","L","C","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
if ($selClasi=='000') {
    $sProvcp = "SELECT *, TRIM(pro_cod) AS pro_cod,
                TRIM(pro_nom) AS pro_nom,
                TRIM(pro_razon) AS pro_razon,
                TRIM(pro_dir) AS pro_dir,
                TRIM(pro_nit) AS pro_nit,
                TRIM(pro_tel) AS pro_tel,
                TRIM(pro_whatsapp) AS pro_whatsapp,
                TRIM(pro_retsn) AS pro_retsn 
                FROM provcp LEFT JOIN clasi ON provcp.pro_clas=clasi.cla_cod WHERE pro_emp='$empCod' ORDER BY pro_emp,pro_clas,pro_nom";
} else {
    $sProvcp = "SELECT *, TRIM(pro_cod) AS pro_cod,
                TRIM(pro_nom) AS pro_nom,
                TRIM(pro_razon) AS pro_razon,
                TRIM(pro_dir) AS pro_dir,
                TRIM(pro_nit) AS pro_nit,
                TRIM(pro_tel) AS pro_tel,
                TRIM(pro_whatsapp) AS pro_whatsapp,
                TRIM(pro_retsn) AS pro_retsn 
                FROM provcp LEFT JOIN clasi ON provcp.pro_clas=clasi.cla_cod WHERE pro_emp='$empCod' AND pro_clas='$selClasi' ORDER BY pro_emp,pro_clas,pro_nom";
}
# EJECUCION DE QUERYS
$db = new dbExec();
$select["provcp"] = $db->query($sProvcp);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("L","cm", array(22, 28));
$pdf->AddPage();
$ti_clasi="XXX";
while ($rec = $db->fetchAssoc($select["provcp"])) {
    if ($ti_clasi!=$rec["cla_cod"]) {
       $pdf->Cell($lineWidth,.7,$rec["cla_nom"],0,0,"L");
       $ti_clasi=$rec["cla_cod"];
       $pdf->ln();
    }
    $body = array(
        $rec["pro_cod"],
        trim($rec["pro_nom"]),
        $rec["pro_razon"],
        $rec["pro_dir"],
        $rec["pro_nit"],
        $rec["pro_tel"],
        $rec["pro_whatsapp"],
        $rec["pro_retsn"],
        $rec["pro_dcre"],
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->Output(utf8_decode("Proveedores").".pdf","I");
?>