<?php 
include_once('../../../php/sessionStart.php'); 
include_once('../../../php/db/dbExec.php');
include_once('../../../php/timezone.php');

$dtFec=date("Y-m-d");
$nAnio=date("Y");
$nMes=date("m");

$empCod = $_SESSION['empCod'];
$empNom = $_SESSION['empNom'];
$empNit = $_SESSION['empNit'];

# QUERYS
$sSerieoc = "SELECT * FROM serieoc WHERE so_emp='$empCod' ORDER BY so_cod";
$sMeses = "SELECT * FROM meses";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["serieoc"] = $db->query($sSerieoc);
$select["meses"] = $db->query($sMeses);
$anoTrab=date("Y", strtotime($_SESSION['empFtrab']));
$mesTrab=date("m", strtotime($_SESSION['empFtrab']));
?>
<?php include_once('../includes/htmlOpen.php'); ?>
    <main class="main" style="">
      <?php 
        $li[0] = '<i class="fas fa-file-invoice"></i>';
        $li[1] = $_GET["opcNom"];
        include_once('../../../php/includes/ol.php');
      ?>

      <!-- MODAL DETALLE ORDEN -->
      <div class="modal fade" id="modalDetao" tabindex="-1" role="dialog" aria-labelledby="modalDetaoTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
          <div class="modal-content bg-dark">
            <div class="modal-header">
              <ul class="nav nav-pills" id="pills-tab" role="tablist">
                <li class="nav-item">
                  <a class="nav-link active" id="pills-00-tab" data-toggle="pill" href="#pills-00" role="tab" aria-controls="pills-00" aria-selected="true"></a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" id="pills-01-tab" data-toggle="pill" href="#pills-01" role="tab" aria-controls="pills-01" aria-selected="false">Buscar Articulos</a>
                </li>
              </ul>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span class="text-light" aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">

              <div class="tab-content bg-transparent border-0" id="pills-tabContent">
                <div class="tab-pane fade show active" id="pills-00" role="tabpanel" aria-labelledby="pills-00-tab">
                  
                  <form action="" name="" autocomplete="off" enctype="multipart/form-data">
                    <div class="form-group">

                      <div class="form-row">
                        <div class="col-2">
                          <label class="font-size-sm text-success" for="txtCoddm">Código</label>
                          <input type="text" class="form-control form-control-sm form-control-as" id="txtCoddm" maxlength="20">
                        </div>
                        <div class="col-7">
                          <label class="font-size-sm text-success" for="txtDescdm">Descripción</label>
                          <input type="text" class="form-control form-control-sm form-control-as" id="txtDescdm" maxlength="120">
                        </div>
                        <div class="col-2">
                          <label class="font-size-sm text-success" for="txtMedidm">Medida</label>
                          <input type="text" class="form-control form-control-sm form-control-as" id="txtMedidm" maxlength="20" disabled>
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="col-2">
                          <label class="font-size-sm text-success" for="numCantdm">Cantidad</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numCantdm">
                        </div>
                        <div class="col-2">
                          <label class="font-size-sm text-success" for="numCosudm">Costo/Unitario</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-5" id="numCosudm">
                        </div>
                        <div class="col-2">
                          <label class="font-size-sm text-success" for="numSubdm">Sub-Total</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-5" id="numSubdm" disabled>
                        </div>
                        <div class="col-1">
                          <label class="font-size-sm text-success" for="numPorDescdm">% Descu.</label>
                          <input type="text" class="form-control form-control-sm form-control-as dec-2" id="numPorDescdm">
                        </div>
                        <div class="col-2">
                          <label class="font-size-sm text-success" for="numValdescdm">Valor Descuento</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numValdescdm">
                        </div>
                        <div class="col-2">
                          <label class="font-size-sm text-success" for="numTotdm">Importe Total</label>
                          <input type="number" class="form-control form-control-sm form-control-as dec-5" id="numTotdm" disabled>
                        </div>
                        <div class="col-md-2">
                          <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" name="cbExentodm" id="cbExentodm">
                            <label class="custom-control-label text-success" for="cbExentodm">Exento</label>
                          </div>
                        </div>
                      </div>

                    </div>

                    <button type="button" class="btn btn-success btn-block" id="btnAgregar">Agregar</button>

                    <button type="button" class="btn btn-success btn-block" id="btnModificar">Modificar</button>
                  </form>

                </div>
                <div class="tab-pane fade" id="pills-01" role="tabpanel" aria-labelledby="pills-01-tab">
                  <?php
                    $a='00';
                    $b='01';
                    include('../busArtic2/index.html');
                  ?>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>


      <div class="container-as">
        <div class="row">
          <div class="col">
            <ul class="nav nav-pills mb-1" id="pills-tab" role="tablist">
              <li class="nav-item">
                <a class="nav-link active" id="pills-0-tab" data-toggle="pill" href="#pills-0" role="tab" aria-controls="pills-0" aria-selected="true">Mantenimiento</a>
              </li>
              <li class="nav-item">
                <a class="nav-link" id="pills-1-tab" data-toggle="pill" href="#pills-1" role="tab" aria-controls="pills-1" aria-selected="true">Buscar Proveedor</a>
              </li>
              <li class="nav-item">
                <a class="nav-link" id="pills-2-tab" data-toggle="pill" href="#pills-2" role="tab" aria-controls="pills-2" aria-selected="true">Buscar Articulos</a>
              </li>
            </ul>
            <div class="tab-content bg-transparent border-0" id="pills-tabContent">
              <div class="tab-pane fade show active" id="pills-0" role="tabpanel" aria-labelledby="pills-0-tab">

                <form action="" name="thisform" autocomplete="off" enctype="multipart/form-data">
                  <div class="form-row">
                    <div class="col-12 col-sm-10">
                      <div class="form-group">
                        <div class="form-row">
                          <div class="col-md-4">
                            <label class="font-size-sm" for="selSerieo">Serie</label>
                            <select class="form-control form-control-sm form-control-as" name="selSerieo" id="selSerieo">
                              <?php
                                while ($rec = $db->fetchAssoc($select['serieoc'])) {
                                  echo  '<option value="'.$rec['so_cod'].'">'.utf8_encode($rec['so_nom']).'</option>';
                                }
                              ?>
                            </select>
                          </div>
                          <div class="col-md-2.5">
                            <label class="font-size-sm" for="numNum">Número de Orden</label>
                            <input type="number" class="form-control form-control-sm form-control-as" id="numNum" placeholder="0">
                          </div>
                          <div class="col-md-2.5">
                            <label class="font-size-sm" for="dtFec">Fecha Orden</label>
                            <input type="date" class="form-control form-control-sm form-control-as" id="dtFec" placeholder="">
                          </div>
                          <div class="col-md-2.5">
                            <label class="font-size-sm" for="txtCoti">No. Cotización</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtCoti" placeholder="" maxlength="20">
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-2">
                            <label class="font-size-sm" for="txtCodp">Código Proveedor</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtCodp" maxlength="20">
                          </div>
                          <div class="col-7">
                            <label class="font-size-sm" for="txtProv">Nombre del Proveedor</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtProv" maxlength="120">
                          </div>
                          <div class="col-2">
                            <label class="font-size-sm" for="txtNitp">Nit Proveedor</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtNitp" maxlength="20">
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-8">
                            <label class="font-size-sm" for="txtDirp">Dirección Proveedor</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtDirp" maxlength="120">
                          </div>
                          <div class="col-3">
                            <label class="font-size-sm" for="txtTelp">Teléfono Proveedor</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtTelp" maxlength="40">
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-9">
                            <label class="font-size-sm" for="txtFacNom">Facturar a nombre de:</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtFacNom" maxlength="120">
                          </div>
                          <div class="col-2">
                            <label class="font-size-sm" for="txtFacNit">Nit</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtFacNit" maxlength="20">
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-11">
                            <label class="font-size-sm" for="txtFacDir">Dirección Facturar:</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtFacDir" maxlength="120">
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-11">
                            <label class="font-size-sm" for="txtDirEnt">Dirección de Entrega:</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtDirEnt" maxlength="150">
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-2.5">
                            <label class="font-size-sm" for="dtFvalida">Valida Hasta:</label>
                            <input type="date" class="form-control form-control-sm form-control-as" id="dtFvalida">
                          </div>
                          <div class="col-3">
                            <label class="font-size-sm" for="txtSoli">Solicitado por:</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtSoli" maxlength="80">
                          </div>
                          <div class="col-2">
                            <label class="font-size-sm" for="numDcre">Días Credito:</label>
                            <input type="number" class="form-control form-control-sm form-control-as" id="numDcre">
                          </div>
                          <div class="col-4">
                            <label class="font-size-sm" for="txtAutorizo">Autorizado por:</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtAutorizo" maxlength="100">
                          </div>
                        </div>
                        <div class="form-row align-items-end">
                          <div class="col-2">
                            <label class="font-size-sm" for="numBien">Bienes</label>
                            <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numBien" placeholder="0.00" min="0">
                          </div>
                          <div class="col-2">
                            <label class="font-size-sm" for="numServ">Servicios</label>
                            <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numServ" placeholder="0.00" min="0">
                          </div>
                          <div class="col-2">
                            <label class="font-size-sm" for="numPeque">Pequeño Contribuyente</label>
                            <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numPeque" placeholder="0.00" min="0">
                          </div>
                          <div class="col-2">
                            <label class="font-size-sm" for="numImporta">Importación</label>
                            <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numImporta" placeholder="0.00" min="0">
                          </div>
                          <div class="col-2">
                            <label class="font-size-sm" for="numTcam">Tasa de Cambio</label>
                            <input type="number" class="form-control form-control-sm form-control-as dec-6" id="numTcam">
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-9">
                            <label class="font-size-sm" for="txtCon">Concepto</label>
                            <textarea class="form-control form-control-sm form-control-as" id="txtCon" rows="2"></textarea>
                          </div>
                          <div class="col-2.5">
                            <label class="font-size-sm pr-1">Moneda de la Transacción</label><br>
                            <div class="custom-control custom-radio custom-control-inline">
                              <input type="radio" id="crTmone1" name="crTmone" class="custom-control-input calcular" value="L">
                              <label class="font-size-sm custom-control-label" for="crTmone1">Local</label>
                            </div>
                            <div class="custom-control custom-radio custom-control-inline">
                              <input type="radio" id="crTmone2" name="crTmone" class="custom-control-input calcular" value="E">
                              <label class="font-size-sm custom-control-label" for="crTmone2">Extranjera</label>
                            </div>
                          </div>
                        </div>
                        <div class="form-row">
                        </div>
                      </div>

                      <h3 class="text-light"></h3>
                      <div class="form-group">
                        <h4 class="text-success">DETALLE PARA LA ORDEN:</h4>
                        <div class="form-row">
                          <div class="col-2">
                            <label class="font-size-sm text-success" for="txtCodd">Código</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtCodd" maxlength="20">
                          </div>
                          <div class="col-7">
                            <label class="font-size-sm text-success" for="txtDescd">Descripción</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtDescd" maxlength="120">
                          </div>
                          <div class="col-2">
                            <label class="font-size-sm text-success" for="txtMedid">Medida</label>
                            <input type="text" class="form-control form-control-sm form-control-as" id="txtMedid" maxlength="20" disabled>
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-2">
                            <label class="font-size-sm text-success" for="numCantd">Cantidad</label>
                            <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numCantd">
                          </div>
                          <div class="col-2">
                            <label class="font-size-sm text-success" for="numCosud">Costo/Unitario</label>
                            <input type="number" class="form-control form-control-sm form-control-as dec-5" id="numCosud">
                          </div>
                          <div class="col-2">
                            <label class="font-size-sm text-success" for="numSubd">Sub-Total</label>
                            <input type="number" class="form-control form-control-sm form-control-as dec-5" id="numSubd" disabled>
                          </div>
                          <div class="col-1">
                            <label class="font-size-sm text-success" for="numPorDescd">% Descu.</label>
                            <input type="text" class="form-control form-control-sm form-control-as dec-2" id="numPorDescd">
                          </div>
                          <div class="col-2">
                            <label class="font-size-sm text-success" for="numValdescd">Valor Descuento</label>
                            <input type="number" class="form-control form-control-sm form-control-as dec-2" id="numValdescd">
                          </div>
                          <div class="col-2">
                            <label class="font-size-sm text-success" for="numTotd">Importe Total</label>
                            <input type="number" class="form-control form-control-sm form-control-as dec-5" id="numTotd" disabled>
                          </div>
                          <div class="col-md-2">
                            <div class="custom-control custom-switch">
                              <input type="checkbox" class="custom-control-input" name="cbExentod" id="cbExentod">
                              <label class="custom-control-label text-success" for="cbExentod">Exento</label>
                            </div>
                          </div>
                        </div>


                      </div>

                      <div class="form-group">
                        <div class="form-row">
                          <div class="col-11 text-left">
                            <button type="button" class="btn btn-success" id="btnAdd">
                              <i class="fas fa-plus-circle"></i> Agregar a tabla
                            </button>
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-12 text-right mb-2">
                          </div>
                        </div>
                        <div class="form-row">
                          <div class="col-md-12">
                            <div class="table-responsive">
                              <table class="table table-hover table-bordered table-dark table-xs" id="tblDetao">
                                <thead>
                                  <tr>
                                    <th scope="col" class="text-center ignore" width="50">ACCIONES</th>
                                    <th scope="col" class="text-center" width="90">CODIGO</th>
                                    <th scope="col" class="text-center" width="200">DESCRIPCIÓN</th>
                                    <th scope="col" class="text-center">MEDIDA</th>
                                    <th scope="col" class="text-center">CANTIDAD</th>
                                    <th scope="col" class="text-center" width="70">COST/UNIT.</th>
                                    <th scope="col" class="text-center" width="80">SUB-TOTAL</th>
                                    <th scope="col" class="text-center">% DESC.</th>
                                    <th scope="col" class="text-center">VALOR/DESC.</th>
                                    <th scope="col" class="text-center" width="90">IMPORTE</th>
                                    <th scope="col" class="text-center" width="10">EXEN TO</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                                <tfoot>
                                  <th scope="col" class="ignore"></th>
                                  <th scope="col"></th>
                                  <th scope="col"></th>
                                  <th scope="col"></th>
                                  <th scope="col"></th>
                                  <th scope="col" class="text-right">Totales</th>
                                  <th scope="col" id="dataTotSub" class="text-right">0.00000</th>
                                  <th scope="col"></th>
                                  <th scope="col" id="dataTotDesc" class="text-right">0.00</th>
                                  <th scope="col" id="dataTotTot" class="text-right">0.00000</th>
                                </tfoot>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="form-group">
                        <div class="form-row">
                        </div>
                      </div>
                    </div>

                    <div class="col-12 col-sm-2">
                      <div class="form-group position-fixed-sm">

                        <div class="form-row">
                          <div class="col-12 mt-2">
                            <button class="btn btn-info btn-block" id="btnGuardarImprimir" type="button">Imprimir / Guardar</button>
                          </div>
                          <div class="col-12 mt-2">
                            <button class="btn btn-success btn-block" id="btnGuardar" type="button">Guardar</button>
                          </div>
                          <div class="col-12 mt-2">
                            <button class="btn btn-danger btn-block" id="btnAnular" type="button">Anular</button>
                          </div>
                          <div class="col-12 mt-2">
                            <button class="btn btn-primary btn-block" id="btnBorrar" type="button">Borrar</button>
                          </div>
                          <div class="col-12 mt-2">
                            <button class="btn btn-warning btn-block" id="btnCerrar" type="button">Cerrar Orden</button>
                          </div>
                        </div>

                          <div class="col-md-12 col-lg-12 text-center mt-3">
                            <div class="upload-btn-wrapper text-center" style="height: 100px; width: 100%;">
                              <img class="rounded-lg" name="imgArtic" width="100%" height="100%" style="object-fit: cover;" />
                              <input type="file" id="fileImg" name="file" onchange="imgSelect(this, document.thisform.imgArtic, imgPhoto); return false;" />
                            </div>
                          </div>



                      </div>
                    </div>
                  </div>
                </form>
              </div>
              <div class="tab-pane fade" id="pills-1" role="tabpanel" aria-labelledby="pills-1-tab">
                <?php
                  $a='0';
                  $b='1';
                  include('../busProvcp/index.html');
                ?>
              </div>

              <div class="tab-pane fade" id="pills-2" role="tabpanel" aria-labelledby="pills-2-tab">
                <?php
                  $a='0';
                  $b='2';
                  include('../busArtic/index.html');
                ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </main>
<?php include_once('../../../php/includes/htmlClose.php'); ?>

<script>
  var pressEnter = false;
  var nuevo = true;
  var nuevoArtic = true;
  var totant = 0;
  var inputDocp = "numNum";
  var tblDetaoAnt;
  var btnAddEdit = "00";
  var nuevoProvee = true;
  var inputArtic = "txtCodd";
  var inputProvee = "txtNit";
  var unimed = "XXX";
  
  
  const numNum = document.thisform.numNum;
  const selSerieo = document.thisform.selSerieo;
  const dtFec = document.thisform.dtFec;
  const txtCoti = document.thisform.txtCoti;
  const txtCodp = document.thisform.txtCodp;
  const txtProv = document.thisform.txtProv;
  const txtNitp = document.thisform.txtNitp;
  const txtDirp = document.thisform.txtDirp;
  const txtTelp = document.thisform.txtTelp;
  const txtFacNom = document.thisform.txtFacNom;
  const txtFacNit = document.thisform.txtFacNit;
  const txtFacDir = document.thisform.txtFacDir;
  const txtDirEnt = document.thisform.txtDirEnt;
  const dtFvalida = document.thisform.dtFvalida;
  const txtSoli = document.thisform.txtSoli;
  const numDcre = document.thisform.numDcre;
  const txtAutorizo = document.thisform.txtAutorizo;
  const numBien = document.thisform.numBien;
  const numServ = document.thisform.numServ;
  const numPeque = document.thisform.numPeque;
  const numImporta = document.thisform.numImporta;
  const numTcam = document.thisform.numTcam;
  const txtCon = document.thisform.txtCon;
  const crTmone = document.thisform.crTmone;
  const txtCodd = document.thisform.txtCodd;
  const txtDescd = document.thisform.txtDescd;
  const txtMedid = document.thisform.txtMedid;
  const numCantd = document.thisform.numCantd;
  const numCosud = document.thisform.numCosud;
  const numSubd = document.thisform.numSubd;
  const numPorDescd = document.thisform.numPorDescd;
  const numValdescd = document.thisform.numValdescd;
  const numTotd = document.thisform.numTotd;
  const cbExentod = document.thisform.cbExentod;

  const txtCoddm = document.getElementById("txtCoddm");
  const txtDescdm = document.getElementById("txtDescdm");
  const txtMedidm = document.getElementById("txtMedidm");
  const numCantdm = document.getElementById("numCantdm");
  const numCosudm = document.getElementById("numCosudm");
  const numSubdm = document.getElementById("numSubdm");
  const numPorDescdm = document.getElementById("numPorDescdm");
  const numValdescdm = document.getElementById("numValdescdm");
  const numTotdm = document.getElementById("numTotdm");
  const cbExentodm = document.getElementById("cbExentodm");

  const imgPhoto = "../../img/photo.jpg";


  function restriccion(consultar = false){
    if (!consultar) {
      if (isNullPer(selSerieo.value)) {
        selSerieo.focus();
        alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar la Serie de Orden"}});
        return true;
      }
      if (isNullPer(numNum.value)  || numNum.value == 0) {
        numNum.focus();
        alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el NO. DE DOCUMENTO"}});
        return true;
      }
      // PARA VER SI EL DETALLE ESTA VACIO
      if ($("#tblDetao tbody").children().length == 0) {
        alWarning({"msg":{"title":"Detalle Vacío","text":"Es necesario Registrar algun detalle para la orden"}});
        return true;
      }
    } else {
      if (isNullPer(selSerieo.value) || isNullPer(numNum.value)) {
        return true;
      }
    }
    return false;
  }


  function restriccionCamposVacios() {
    if (isNullPer(selSerieo.value)) {
      selSerieo.focus();
      alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar la Serie de la orden"}});
      return true;
    }
    if (isNullPer(numNum.value)) {
      numNum.focus();
      alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el NO. DE DOCUMENTO"}});
      return true;
    }
    return false;
  }

  function condicionesobligatorias() {
    if (isNullPer(txtCodp.value)) {
      txtCodp.focus();
      alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el CODIGO DEL PROVEEDOR"}});
      return true;
    }
    if (isNullPer(numBien.value) && isNullPer(numServ.value) && isNullPer(numPeque.value) && isNullPer(numImporta.value)) {
      numBien.focus();
      alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario que ingrese algun valor en BIENES, SERVICIOS, PEQUEÑO CONTRIBUYENTE O IMPORTACION"}});
      return true;
    }
    if (isNullPer(numTcam.value)) {
      numTcam.value = (1).toFixed(6);
      numTcam.focus();
      alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar algun Valor en la Tasa de Cambio"}});
      return true;
    }
  }


  function restriccionCoddm() {
    if (isNullPer(txtCoddm.value)) {
      txtDescdm.value = "";
      return true;
    }
    return false;
  }

  function restriccionCoddm() {
    if (isNullPer($("#"+inputArtic).val())) {
      $("#txtDescdm").val("");
      return true;
    }
    return false;
  }

  function restriccionModal() {
    if (restriccionCoddm()) {
      txtCoddm.focus();
      alWarningTimer({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar Codigo de Articulo","timer":timeOutWarningSm}});
      return true;
    }
    $('#modalDetao').modal('toggle');
    return false;
  }


  function addRowDetao(codd, descd, unimed, medid, cantd, cosud, subd, pordescd, valdescd, totd, exentod){
    const row = "<tr>"
                +"<td scope='col' class='ignore'>"
                  +"<div class='btn-group btn-group-sm' role='group' aria-label='Third group'>"
                    +"<button type='button' class='btn btn-danger btn-sm btn-actions' id='btnDel'><i class='fas fa-trash-alt'></i></button>"
                    +"<button type='button' class='btn btn-primary btn-sm btn-actions' id='btnEdit' data-toggle='modal' data-target='#modalDetao'><i class='fas fa-edit'></i></button>"
                  +"</div>"
                +"</td>"
                +"<td id='dataCodd'>"+codd+"</td>"
                +"<td id='dataDescd'>"+descd+"</td>"
                +"<td id='dataUnimed' class='d-none'>"+unimed+"</td>"
                +"<td id='dataMedid'>"+medid+"</td>"
                +"<td id='dataCantd' class='text-right'>"+cantd+"</td>"
                +"<td id='dataCosud' class='text-right'>"+cosud+"</td>"
                +"<td id='dataSubd' class='text-right'>"+subd+"</td>"
                +"<td id='dataPorDescd' class='text-right'>"+pordescd+"</td>"
                +"<td id='dataValdescd' class='text-right'>"+valdescd+"</td>"
                +"<td id='dataTotd' class='text-right'>"+totd+"</td>"
                +"<td id='dataExentod' class='text-center'>"+exentod+"</td>"
                +"</tr>";
    $("#tblDetao tbody").append(row);
  }


  function consultarOrden(){
    if (restriccion(true)) {return};
    
    //txtNext = dtFec;

    const parametros = new FormData();
    parametros.append("action", "consultar");

    parametros.append("numNum", numNum.value);
    parametros.append("selSerieo", selSerieo.value);

    //txtNext.focus()

    $.ajax({
      data:  parametros,
      url:   window.location.origin+window.location.pathname+"actions.php",
      type:  "post",
      contentType: false,
      processData: false,
      success: function (jsonPhp) {
        console.log(jsonPhp);
        const jsonJS = JSON.parse(jsonPhp);
        tblDetaoAnt = JSON.stringify(jsonJS.ordendc);

        if(jsonJS.error == true){
          alError(jsonJS);
        } else {
          limpiar();
          tblClear("tblDetao");
          sumDetao();

         
          if (jsonJS.ordenc === null) {
            nuevo = true;
          } else {
            dtFec.value = jsonJS.ordenc.od_fec;
            txtCoti.value = jsonJS.ordenc.od_coti;
            txtCodp.value = jsonJS.ordenc.od_codp;
            txtProv.value = jsonJS.ordenc.od_prov;
            txtNitp.value = jsonJS.ordenc.od_nit;
            txtDirp.value = jsonJS.ordenc.od_dirp;
            txtTelp.value = jsonJS.ordenc.od_telp;
            txtFacNom.value = jsonJS.ordenc.od_facnom;
            txtFacDir.value = jsonJS.ordenc.od_facdir;
            txtFacNit.value = jsonJS.ordenc.od_facnit;
            txtDirEnt.value = jsonJS.ordenc.od_dirent;
            dtFvalida.value = jsonJS.ordenc.od_valida;
            txtSoli.value = jsonJS.ordenc.od_soli;
            numDcre.value = jsonJS.ordenc.od_cred;
            txtAutorizo.value = jsonJS.ordenc.od_autorizo;
            numBien.value = jsonJS.ordenc.od_bien;
            numServ.value = jsonJS.ordenc.od_serv;
            numPeque.value = jsonJS.ordenc.od_peque;
            numImporta.value = jsonJS.ordenc.od_import;
            numTcam.value = jsonJS.ordenc.od_tcam;
            txtCon.value = jsonJS.ordenc.od_obs;
            crTmone.value = jsonJS.ordenc.od_tmone;
            jsonJS.ordendc.forEach(function(i){
               addRowDetao(i.odd_cod, i.odd_desc, i.odd_med, i.odd_unimed, i.odd_cant, i.odd_cosu, i.odd_sub, i.odd_pdesc, i.odd_descu, i.odd_tot, i.odd_exensn);
            });  
            sumDetao();
            nuevo = false;
            if (jsonJS.ordenc.od_stat == 'C') {
              numNum.focus();
              alWarning({"msg":{"title":"Orden Cerrada","text":"Esta Orden ya fue cerrada, no puede trabajar con ella"}});
              return true;
            }
          }
        }
      }
    });
  }

  function guardarOrden(imprimir = false){
    if (restriccion()) {return};

    const pIva = <?php echo $_SESSION["pIva"]; ?>;

    var sumtot = (Number(numBien.value)+Number(numServ.value)+Number(numPeque.value)+Number(numImporta.value));
    var totdif = 0;
    if (crTmone.value == 'E') {
      var totdif = round(sumtot*Number(numTcam.value),2)-sumtot;
    } 

    var totall = $("#dataTotTot").text();

    if (sumtot!=totall) {
       alWarning({"msg":{"title":"TIENE UN DESCUADRE","text":"La suma de Bienes,Servicios,Pequeño Contribuyente e importaciones, no cuadra con la suma del detalle, revise"}});
       return true;
    }    
    const numDoc = numNum.value;

    colDetao = ["acciones","codd", "descd", "unimed", "medid", "cantd", "cosud", "subd", "pordescd", "valdescd", "numtot", "cbexentod"];


    const parametros = new FormData();

    parametros.append("action", "guardar");

    parametros.append("nuevo", nuevo);
    parametros.append("numNum", numDoc);
    parametros.append("selSerieo", selSerieo.value);
    parametros.append("dtFec", dtFec.value);
    parametros.append("txtCoti", txtCoti.value);
    parametros.append("txtCodp", txtCodp.value);
    parametros.append("txtProv", txtProv.value);
    parametros.append("txtNitp", txtNitp.value);
    parametros.append("txtDirp", txtDirp.value);
    parametros.append("txtTelp", txtTelp.value);
    parametros.append("txtFacNom", txtFacNom.value);
    parametros.append("txtFacDir", txtFacDir.value);
    parametros.append("txtFacNit", txtFacNit.value);
    parametros.append("txtDirEnt", txtDirEnt.value);
    parametros.append("dtFvalida", dtFvalida.value);
    parametros.append("txtSoli", txtSoli.value);
    parametros.append("numDcre", numDcre.value);
    parametros.append("txtAutorizo", txtAutorizo.value);
    parametros.append("numBien", numBien.value);
    parametros.append("numServ", numServ.value);
    parametros.append("numPeque", numPeque.value);
    parametros.append("numImporta", numImporta.value);
    parametros.append("numTcam", numTcam.value);
    parametros.append("crTmone", crTmone.value);
    parametros.append("txtCon", txtCon.value);
    parametros.append("sumtot", sumtot);
    parametros.append("totdif", totdif);
    parametros.append("tblDetao", tblToJson(colDetao, "tblDetao", 0));
    parametros.append("tblDetaoAnt", tblDetaoAnt);

    numNum.focus();
    
    $.ajax({
      data:  parametros,
      url:   window.location.origin+window.location.pathname+"actions.php",
      type:  "post",
      contentType: false,
      processData: false,
      async: true,
      beforeSend: function () {
        alLoad("Cargando...")
      },
      success: function (jsonPhp) {
        //console.log(jsonPhp);

        setTimeout(function () {

        const jsonJS = JSON.parse(jsonPhp);

        if(jsonJS.error==true){
          alError(jsonJS);
        } else {
          var snhacer = true;

          /*if (jsonJS.probpol1 != "X") {
            alError({"msg":{"type":"error","title":"PROBLEMA EN CUENTAS","text":"Alguna de las cuentas no esta asignada correctamente, verifique.", "ok":"Aceptar"}});
              var snhacer = false;
                     return true;
          } */
          //if (snhacer) {
            if (imprimir) {
              imprimirOrden(numDoc,totall);
            }
            numNum.value = "";
            limpiar();
            tblClear("tblDetao");
            sumDetao();
            alSuccess(jsonJS);

          //}  
        }

        }), 0;
      }
    });
  }

  function imprimirOrden(numDoc,totall){

    var totLetras = "";
    if (crTmone == 'L') {
      totLetras = numeroALetras(totall, 2, {
                    plural: 'quetzales',
                    singular: 'quetzal',
                    centPlural: 'centavos',
                    centSingular: 'centavo'
                  }).toUpperCase()
    } else {
      totLetras = numeroALetras(totall, 2, {
                    plural: 'dólares',
                    singular: 'dólar',
                    centPlural: 'centavos',
                    centSingular: 'centavo'
                  }).toUpperCase()
    }

    const getSerieo = "?selSerieo="+selSerieo.value;
    const getNum = "&numNum="+numDoc;
    const gettotlet = "&totlet="+totLetras;
    //const getSerieoNom = "&selSerieoNom="+$('#selSerieo').find('option:selected').text();

    var url = window.location.origin+window.location.pathname+"print.php"+getSerieo+getNum+gettotlet;

    window.open(url, '_blank');
  }

  function limpiarModalDetao(){
    txtCoddm.value = "";
    txtDescdm.value = "";
    txtMedidm.value = "";
    numCantdm.value = "";
    numCosudm.value = "";
    numSubdm.value = "";
    numPorDescdm.value = "";
    numValdescdm.value = "";
    numTotdm.value = "";
    cbExentodm.checked = 0;
  }

  function limpiar(todo = false){
    dtFec.value= '<?php echo $dtFec; ?>';
    txtCoti.value="";
    txtCodp.value = "";
    txtProv.value = "";
    txtNitp.value = "";
    txtDirp.value = "";
    txtTelp.value = "";
    txtFacNom.value = '<?php echo $empNom; ?>';
    txtFacNit.value = '<?php echo $empNit; ?>';
    txtFacDir.value = 'Ciudad';
    txtDirEnt.value = ""; 
    dtFvalida.value = '<?php echo $dtFec; ?>';
    txtSoli.value = "";
    numDcre.value = 0;
    txtAutorizo.value = "";
    numBien.value = (0).toFixed(2);
    numServ.value = (0).toFixed(2);
    numPeque.value = (0).toFixed(2);
    numImporta.value = (0).toFixed(2);
    numTcam.value = (1).toFixed(6);
    txtCon.value = "";
    crTmone.value = 'L';
    txtCon.value = "";

    fileImg.value = "";
    txtCodd.value = "";
    txtDescd.value = "";
    txtMedid.value = "";
    numCantd.value = 0;
    numCosud.value = 0;
    numSubd.value = 0;
    numPorDescd.value = 0;
    numValdescd.value = 0;
    numTotd.value = 0;
    cbExentod.checked = 0;
    txtDescd.disabled = false;
  }

  function limpiarDetao(){
    txtDescd.value = "";
    txtMedid.value = "";
    numCantd.value = (0).toFixed(2);
    numCosud.value = (0).toFixed(5);
    numSubd.value = (0).toFixed(5);
    numPorDescd.value = (0).toFixed(2);
    numValdescd.value = (0).toFixed(2);
    numTotd.value = (0).toFixed(5);
    cbExentod.checked = 0;
  }


  function sumDetao(){
    $("#tblDetao #dataTotSub").text(tblSumCol("tblDetao", "dataSubd").toFixed(5));
    $("#tblDetao #dataTotDesc").text(tblSumCol("tblDetao", "dataValdescd").toFixed(2));
    $("#tblDetao #dataTotTot").text(tblSumCol("tblDetao", "dataTotd").toFixed(5));
  }


  $(document).ready(function() {
    $(this).find('select:visible:first').focus();
    //document.thisform.dtFec.value = '<?php echo $dtFec; ?>';
    //document.thisform.dtFvalida.value = '<?php echo $dtFec; ?>';
    txtFacNom.value = '<?php echo $empNom; ?>';
    txtFacNit.value = '<?php echo $empNit; ?>';
    txtFacDir.value = 'Ciudad';
    txtDirEnt.value = ""; 
    numTcam.value = 1.000000.toFixed(6);
    crTmone.value ="L";

    dtFec.value = dateToday();
    dtFvalida.value = dateToday();

    imgArtic.src = imgPhoto;

    // SHOW MODAL
    $('#modalDetao').on('shown.bs.modal', function() {
      if (!isMobile()) {
        $(this).find('input:visible:first').focus();
      }
    });

    // SUBMIT FORM
    $('form').submit(function() {
      return false;
    });

    // FOCUS NUMERO DE CHEQUE
    $("#selSerieo").focus(function() {
      limpiar();
    });

    // FOCUS NUMERO DE ORDEN
    $("#numNum").focus(function() {

      limpiar();
      tblClear("tblDetao");
      sumDetao();

      const parametros = new FormData();
      parametros.append("action", "consultarCorr");

      parametros.append("numNum", numNum.value);
      parametros.append("selSerieo", selSerieo.value);

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        async: false,
        success: function (jsonPhp) {
          //console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);
            if (jsonJS.serieoc === null) {
              numNum.value = 1;
            } else {
              numNum.value = jsonJS.serieoc.so_corr;
            }
          }
      });
    });

    // VALID NUMERO
    $("#numNum")
    .blur(function (){
      setTimeout(function(){
        if (!$('#selSerieo').is(':focus') && $("#tblDetao tbody").children().length == 0) {
          consultarOrden();
        }
      },0);
    })
    .change(function (){
      consultarOrden();
    });


    // VALID CODIGO
    $("#txtCodp")
    .focus(function() {
      inputProvcp = $(this).attr('id');
    })
    .keydown(function(e){
      if(ctrlBus(e)) { document.getElementById("pills-1-tab").click(); }
    })
    .change(function (){
      txtThis = this;
      const parametros = new FormData();
      parametros.append("action", "consultarProvcp");
      parametros.append("txtCod", txtCodp.value);

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        success: function (jsonPhp) {
          //console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
            nuevoProvee = true;
          } else {
            if (jsonJS.provcp === null) {
              nuevoProvee = true;
              txtCodp.focus();
              txtProv.value = "";
              ctaprov="XXXX";
              nitprov="XXXX";
              alWarning({"msg":{"title":"No Existe","text":"Este proveedor no existe, debe registrarlo"}});
               return true;
            } else {
              if (nuevo) {
                txtProv.value = jsonJS.provcp.pro_nom;
                txtNitp.value = jsonJS.provcp.pro_nit;
                txtDirp.value = jsonJS.provcp.pro_dir;
                txtTelp.value = jsonJS.provcp.pro_tel;
                numDcre.value = jsonJS.provcp.pro_dcre;
              }
              nuevoProvee = false;
            }
          }
        }
      });
    });

    // VALID CODIGO
    $("#txtCodd")
    .focus(function() {
      inputArtic = $(this).attr('id');
      imgArtic.src = imgPhoto;
      txtCodd.value="";
      limpiarDetao();
      if (restriccionCamposVacios()) {return};
      if (condicionesobligatorias()) {return};

    })
    .keydown(function(e){
      if(ctrlBus(e)) { document.getElementById("pills-2-tab").click(); }
    })
    .change(function (){
      txtThis = this;
      const parametros = new FormData();
      parametros.append("action", "consultarArtic");
      parametros.append("txtCodd", txtCodd.value);

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        success: function (jsonPhp) {
          console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
            nuevoArtic = true;
            unimed="";
          } else {
            if (jsonJS.artic === null) {
              nuevoArtic = true;
              txtCodd.focus();
              txtDescd.value = "";
              txtMedid.value="XXXX";
              unimed="XXX";
              imgArtic.src = imgPhoto;
              alWarning({"msg":{"title":"No Existe","text":"Este Articulo no existe, debe registrarlo"}});
               return true;
            } else {
              txtCodd.value = jsonJS.artic.art_cod;
              txtDescd.value = jsonJS.artic.art_desc;
              txtMedid.value = jsonJS.artic.um_nom;
              unimed = jsonJS.artic.art_medi;
              imgExist(imgArtic, jsonJS.imgArtic, imgPhoto);

              if (jsonJS.artic.art_serv == 1) {
                txtDescd.disabled = false;
              } else {
                txtDescd.disabled = true;
              }
              nuevoArtic = false;
            }
          }
        }
      });
    });

    // FOCUS FECHA
    $("#txtDescd").focus(function (){
      if (restriccionCamposVacios()) {return};
      if (condicionesobligatorias()) {return};
      if (isNullPer(txtCodd.value)) {
        txtCodd.focus();
        alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el Codigo del Articulo o Si es Servicio ingrese SERV en mayuscula"}});
        return true;
        return true;
      }
    });

    // VALID Cantidad detalle
    $("#numCantd")
    .blur(function (){
      numSubd.value = round(numCantd.value*numCosud.value,5).toFixed(5);
      numTotd.value = round(numSubd.value-numValdescd.value,5).toFixed(5);
    })

    // VALID Costo Unitario
    $("#numCosud")
    .blur(function (){
      numSubd.value = round(numCantd.value*numCosud.value,5).toFixed(5);
      numTotd.value = round(numSubd.value-numValdescd.value,5).toFixed(5);
    })
    // VALID % Descuento
    $("#numPorDescd")
    .focus(function (){
      if (isNullPer(txtCodd.value)) {
        txtCodd.focus();
        alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el Codigo del Articulo o Si es Servicio ingrese SERV en mayuscula"}});
        return true;
      }
    })
    .blur(function (){
      numSubd.value = round(numCantd.value*numCosud.value,5).toFixed(5);
      numValdescd.value = round(numSubd.value*numPorDescd.value/100,2).toFixed(2);
      numTotd.value = round(numSubd.value-numValdescd.value,5).toFixed(5);
    })
    // VALID % Descuento
    $("#numValdescd")
    .blur(function (){
      numSubd.value = round(numCantd.value*numCosud.value,5).toFixed(5);
      numTotd.value = round(numSubd.value-numValdescd.value,5).toFixed(5);
    })

    // FOCUS FECHA
    $("#dtFec").focus(function (){
      if (restriccionCamposVacios()) {return};
    });

    // FOCUS VALOR CHEQUE, BENEFICIARIO, CONCEPTO
    $("#numBien, #numServ, #numPeque, #numImporta, #numTcam, #txtCon").focus(function (){
      if (restriccionCamposVacios()) {return};
      if (isNullPer(txtCodp.value)) {
        txtCodp.focus();
        alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el CODIGO DEL PROVEEDOR"}});
        return true;
      }
    });

    // VALID CODIGO MODAL
    $("#txtCoddm")
    .focus(function() {
      inputArtic = $(this).attr('id');
      imgArtic.src = imgPhoto;
    })
    .keydown(function(e){
      if(ctrlBus(e)) { document.getElementById("pills-01-tab").click(); }
    })
    .change(function (){
      txtThis = this;
      const parametros = new FormData();
      parametros.append("action", "consultarArtic");
      parametros.append("txtCodd", txtCoddm.value);

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        success: function (jsonPhp) {
          console.log(jsonPhp);
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
            nuevoArtic = true;
          } else {
            if (jsonJS.artic === null) {
              nuevoArtic = true;
              txtCoddm.focus();
              txtDescdm.value = "";
              txtMedidm.value="XXXX";
              imgArtic.src = imgPhoto;
              alWarning({"msg":{"title":"No Existe","text":"Este Articulo no existe, debe registrarlo"}});
               return true;
            } else {
              txtCoddm.value = jsonJS.artic.art_cod;
              txtDescdm.value = jsonJS.artic.art_desc;
              txtMedidm.value = jsonJS.artic.um_nom;
              imgExist(imgArtic, jsonJS.imgArtic, imgPhoto);
              nuevoArtic = false;
            }
          }
        }
      });
    });

    // FOCUS DESCRIPCION MODAL
    $("#txtDescdm").focus(function (){
      if (isNullPer(txtCoddm.value)) {
        txtCoddm.focus();
        alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el Codigo del Articulo o Si es Servicio ingrese SERV en mayuscula"}});
        return true;
        return true;
      }
    });

    // VALID Cantidad detalle modal
    $("#numCantdm")
    .blur(function (){
      numSubdm.value = round(numCantdm.value*numCosudm.value,5).toFixed(5);
      numTotdm.value = round(numSubdm.value-numValdescdm.value,5).toFixed(5);
    })

    // VALID Costo Unitario Modal
    $("#numCosudm")
    .blur(function (){
      numSubdm.value = round(numCantdm.value*numCosudm.value,5).toFixed(5);
      numTotdm.value = round(numSubdm.value-numValdescdm.value,5).toFixed(5);
    })
    // VALID % Descuento Modal
    $("#numPorDescdm")
    .focus(function (){
      if (isNullPer(txtCoddm.value)) {
        txtCoddm.focus();
        alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el Codigo del Articulo o Si es Servicio ingrese SERV en mayuscula"}});
        return true;
      }
    })
    .blur(function (){
      numSubdm.value = round(numCantdm.value*numCosudm.value,5).toFixed(5);
      numValdescdm.value = round(numSubdm.value*numPorDescdm.value/100,2).toFixed(2);
      numTotdm.value = round(numSubdm.value-numValdescdm.value,5).toFixed(5);
    })
    // VALID % Descuento Modal
    $("#numValdescdm")
    .blur(function (){
      numSubdm.value = round(numCantdm.value*numCosudm.value,5).toFixed(5);
      numTotdm.value = round(numSubdm.value-numValdescdm.value,5).toFixed(5);
    })

    // CLICK BORRAR
    $("#btnBorrar").click(function (){
      const numDoc = numNum.value;
      const serieo = selSerieo.value;

      numNum.focus();

      const fnT = function(){

        const parametros = new FormData();
        parametros.append("action", "borrar");
        parametros.append("selSerieo", selSerieo.value);
        parametros.append("selSerieoNom", $('#selSerieo').find('option:selected').text());
        parametros.append("numNum", numDoc);

        $.ajax({
          data:  parametros,
          url:   window.location.origin+window.location.pathname+"actions.php",
          type:  "post",
          contentType: false,
          processData: false,
          beforeSend: function () {
            alLoad("Cargando...")
          },
          success: function (jsonPhp) {
            //console.log(jsonPhp);
            const jsonJS = JSON.parse(jsonPhp);

            if(jsonJS.error==true){
              alError(jsonJS);
            } else {
              numNum.value = "";
              limpiar();
              tblClear("tblDetao");
              sumDetao();
              alSuccess(jsonJS);
            }
          }
        });
      }

      const fnF = function(){
        return true;
      }

      usuClave(fnT, fnF);
    });

    // CLICK CERRAR
    $("#btnCerrar").click(function (){
      const numDoc = numNum.value;
      const serieo = selSerieo.value;

      numNum.focus();

      const fnT = function(){

        const parametros = new FormData();
        parametros.append("action", "cerrarorden");
        parametros.append("selSerieo", selSerieo.value);
        parametros.append("selSerieoNom", $('#selSerieo').find('option:selected').text());
        parametros.append("numNum", numDoc);

        $.ajax({
          data:  parametros,
          url:   window.location.origin+window.location.pathname+"actions.php",
          type:  "post",
          contentType: false,
          processData: false,
          beforeSend: function () {
            alLoad("Cargando...")
          },
          success: function (jsonPhp) {
            //console.log(jsonPhp);
            const jsonJS = JSON.parse(jsonPhp);

            if(jsonJS.error==true){
              alError(jsonJS);
            } else {
              numNum.value = "";
              limpiar();
              tblClear("tblDetao");
              sumDetao();
              alSuccess(jsonJS);
            }
          }
        });
      }

      const fnF = function(){
        return true;
      }

      usuClave(fnT, fnF);
    });

    // CLICK ANULAR
    $("#btnAnular").click(function (){
      const numDoc = numNum.value;
      const serieo = selSerieo.value;

      numNum.focus();

      const fnT = function(){

        const parametros = new FormData();
        parametros.append("action", "anular");
        parametros.append("selSerieo", serieo);
        parametros.append("selSerieoNom", $('#selSerieo').find('option:selected').text());
        parametros.append("numNum", numDoc);
        parametros.append("tblDetaoAnt", tblDetaoAnt);


        $.ajax({
          data:  parametros,
          url:   window.location.origin+window.location.pathname+"actions.php",
          type:  "post",
          contentType: false,
          processData: false,
          beforeSend: function () {
            alLoad("Cargando...")
          },
          success: function (jsonPhp) {
            //console.log(jsonPhp);
            const jsonJS = JSON.parse(jsonPhp);

            if(jsonJS.error==true){
              alError(jsonJS);
            } else {
              numNum.value = "";
              limpiar();
              tblClear("tblDetao");
              sumDetao();
              alSuccess(jsonJS);
            }
          }
        });
      }

      const fnF = function(){
        return true;
      }

      usuClave(fnT, fnF);
    });

    // CLICK GUARDAR
    $("#btnGuardar").click(function (){
      if (condicionesobligatorias()) {return};
      if ($("#tblDetao tbody").children().length == 0) {
        alWarning({"msg":{"title":"NO HA REGISTRADO DETALLE","text":"Primero debe registrar detalle para la orden."}});
        return;
      }
      guardarOrden();
    });

    // CLICK GRABAR E IMPRIMIR
    $("#btnGuardarImprimir").click(function (){
      if (condicionesobligatorias()) {return};
      if ($("#tblDetao tbody").children().length == 0) {
        alWarning({"msg":{"title":"NO HA REGISTRADO DETALLE","text":"Primero debe registrar detalle para la orden."}});
        return;
      }
      guardarOrden(true);
    });
    
    // CLICK AGREGAR
    $("#btnAgregar").click(function () {
      if (restriccionModal()) {return};
      addRowPol(txtCta.value, txtCtaNom.value, isNullNumber(numDebe.value).toFixed(2), isNullNumber(numHaber.value).toFixed(2));
      limpiarModalPol();
      sumPol();
      $("#btnAdd").focus();
    });
  });

  // CLICK ADD
  $("body").on("click", "#btnAdd", function () {
    if (restriccionCamposVacios()) {return};
    if (condicionesobligatorias()) {return};
    if (txtCodd.value == "") {
      alWarning({"msg":{"title":"CAMPO OBLIGATORIO EN DETALLE","text":"No ha ingresado codigo de la linea en el detalle"}});
      return;
    }
    if (txtDescd.value == "") {
      alWarning({"msg":{"title":"CAMPO OBLIGATORIO EN DETALLE","text":"No ha ingresado Descripcion de la linea en el detalle"}});
      return;
    }
    if (cbExentod.checked == 0) {
      var exentosn = 'N';
    } else {
      var exentosn = 'S';
    } 
    addRowDetao(txtCodd.value, txtDescd.value, unimed, txtMedid.value, isNullNumber(numCantd.value).toFixed(2), isNullNumber(numCosud.value).toFixed(5), isNullNumber(numSubd.value).toFixed(5), isNullNumber(numPorDescd.value).toFixed(2), isNullNumber(numValdescd.value).toFixed(2), isNullNumber(numTotd.value).toFixed(5), exentosn);
    sumDetao();
    txtCodd.value="";
    txtCodd.focus();
  });

  // CLICK DEL
  $("body").on("click", "#btnDel", function() {
    const row = $(this).parents("tr");
    alDelete(function fn(){
      row.remove();
      sumDetao();
    });
  });

  // CLICK EDIT
  $("body").on("click", "#btnEdit", function() {
    $('#pills-00-tab').text("Modificar");
    $('#btnAgregar').hide();
    $('#btnModificar').show();

    const dataCodd = $(this).parents("tr").find("#dataCodd");
    const dataDescd = $(this).parents("tr").find("#dataDescd");
    const dataMedid = $(this).parents("tr").find("#dataMedid");
    const dataCantd = $(this).parents("tr").find("#dataCantd");
    const dataCosud = $(this).parents("tr").find("#dataCosud");
    const dataSubd = $(this).parents("tr").find("#dataSubd");
    const dataPorDescd = $(this).parents("tr").find("#dataPorDescd");
    const dataValdescd = $(this).parents("tr").find("#dataValdescd");
    const dataTotd = $(this).parents("tr").find("#dataTotd");
    const dataExentod = $(this).parents("tr").find("#dataExentod");

    txtCoddm.value = dataCodd.text();
    txtDescdm.value = dataDescd.text();
    txtMedidm.value = dataMedid.text();
    numCantdm.value = dataCantd.text();
    numCosudm.value = dataCosud.text();
    numSubdm.value = dataSubd.text();
    numPorDescdm.value = dataPorDescd.text();
    numValdescdm.value = dataValdescd.text();
    numTotdm.value = dataTotd.text();
    exentosn = dataExentod.text();
    if (exentosn=='N') {
       cbExentodm.checked = 0
    } else {
       cbExentodm.checked = 1
    }
    $("body").on("click", "#btnModificar", function() {
      if (restriccionModal()) {return};
      if (cbExentodm.checked == 0) {
        var exentosn = 'N';
      } else {
        var exentosn = 'S';
      } 
      dataCodd.text(txtCoddm.value);
      dataDescd.text(txtDescdm.value);
      dataMedid.text(txtMedidm.value);
      dataCantd.text(isNullNumber(numCantdm.value).toFixed(2));
      dataCosud.text(isNullNumber(numCosudm.value).toFixed(5));
      dataSubd.text(isNullNumber(numSubdm.value).toFixed(5));
      dataPorDescd.text(isNullNumber(numPorDescdm.value).toFixed(2));
      dataValdescd.text(isNullNumber(numValdescdm.value).toFixed(2));
      dataTotd.text(isNullNumber(numTotdm.value).toFixed(5));
      dataExentod.text(exentosn);

      limpiarModalDetao();
      sumDetao();
    });
  });

  // MODALPOL HIDDEN
  $('#modalDetao').on('hidden.bs.modal', function (e) {
    $("body").off("click", "#btnModificar");
  });


  // FOCUS PILL
  $('a[data-toggle="pill"]').on('shown.bs.tab', function (e) {
    if (!isMobile()) {
      const target = e.target.attributes.href.value;
      const relatedTarget = e.relatedTarget.attributes.href.value;

      if (target != "#pills-0") {
        $(target+' input:visible:first').focus();
      } else if (target == "#pills-0" && isNullPer(numNum.value)) {
        numNum.focus();
      } else if (relatedTarget == "#pills-1") {
        txtCodp.focus();
      } else {
        (relatedTarget == "#pills-2") ? txtCodd.focus() : 0;
        (relatedTarget == "#pills-01") ? txtCoddm.focus() : 0;
      }
      //$(target+' input:visible:first').focus();
    }
  });

</script>
