<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];
$txtCodp=$_GET["txtCodp"];
$txtProv=$_GET["txtProv"];


//$func = new functions();

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $txtCodp, $txtProv,$dtFeci, $dtFecf;
        $this->SetMargins(1.5, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("LISTADO DE ORDENES DE COMPRA DEL ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf))),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, "PROVEEDOR:  ".utf8_decode(TRIM($txtProv)),0,1,"L");

        $this->Ln();
        $this->SetFont("","",8);
        $this->SetFont("","B");
        $this->SetWidths(array(1.7,2.3,1.8,2,6,7,1.6,2.2));
        $this->SetAligns(array("C","C","C","C","C","C","C","C"));

        $this->SetFont("");
        $this->SetAligns(array("L","L","C","C","L","L","R","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sOrdenes = "SELECT *, 
   TRIM(od.od_codp) AS od_codp,
   TRIM(od.od_prov) AS od_prov,
   TRIM(od.od_dirp) AS od_dirp,
   TRIM(od.od_telp) AS od_telp,
   TRIM(od.od_facnom) AS od_facnom,
   TRIM(od.od_facdir) AS od_facdir,
   TRIM(od.od_dirent) AS od_dirent,
   TRIM(od.od_soli) AS od_soli,
   TRIM(od.od_autorizo) AS od_autorizo,
   TRIM(od.od_obs) AS od_obs
   FROM ordendc odd LEFT JOIN ordenc od ON odd.odd_emp=od.od_emp and odd.odd_serie=od.od_serie and odd.odd_num=od.od_num 
   WHERE odd_emp='$empCod' and odd_fec>='$dtFeci' and odd_fec<='$dtFecf' and odd_codp='$txtCodp' ORDER BY odd_serie,odd_num";

# EJECUCION DE QUERYS
$db = new dbExec();
$lineHeight=0.40;
$select["ordendc"] = $db->query($sOrdenes);

# GENERAR PDF
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();
$func = new functions();

$ti_serie="XXXZZZ999";
$ti_num=9999;
$subtot=0;
$tottot=0;
$t_lini=1;
$codp="";
$nomp="";
$clas="";
$clasnom="";


while ($rec = $db->fetchAssoc($select["ordendc"])) {
    if ($t_lini == 1) {
        //$pdf->SetFont("","B",8);        
        $pdf->SetFont("","",7);
        $pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("NUMERO:"),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/4, $lineHeight, $rec["od_num"],0,0,"L");
        $pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("FECHA:"),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/8, $lineHeight, date('d-m-Y', strtotime($rec["od_fec"])),0,1,"L");
        //$lineHeight = .42;
        $pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("PROVEDOR:"),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/1.6, $lineHeight, utf8_decode($rec["od_prov"]),0,1,"L");
        $pdf->MultiAlignCell($lineWidth/4.9, $lineHeight, utf8_decode("SOLICITADO POR: "),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/1.93, $lineHeight, utf8_decode($rec["od_soli"]),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/6.9, $lineHeight, utf8_decode("DIAS CREDITO: :"),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/8, $lineHeight, utf8_decode($rec["od_cred"]),0,1,"L");
        $pdf->MultiAlignCell($lineWidth/4.9, $lineHeight, utf8_decode("TASA DE CAMBIO:"),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode($rec["od_tcam"]),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/8, $lineHeight, utf8_decode("VALIDA HASTA:"),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/5.2, $lineHeight, strftime("%d/%m/%Y", strtotime($rec["od_valida"])),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("MONEDA:"),0,0,"L");
        if ($rec["od_tmone"] == "L") {
           $moneda="LOCAL";
        } else {
           $moneda="DOLARES";
        }   
        $pdf->SetFont("","");
        $pdf->MultiAlignCell($lineWidth/8, $lineHeight, $moneda,0,1,"L");
        $pdf->MultiAlignCell($lineWidth/4.9, $lineHeight, utf8_decode("OBSERVACIONES: "),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/1, $lineHeight, utf8_decode($rec["od_obs"]),0,1,"L");
        $pdf->Ln();
        //$pdf->Ln();
        $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"MEDIDA","CANTIDAD","UNITARIO","SUBTOTAL","%DEC","VAL/DESC","TOTAL");
        $widths = array(1.8,5,1.3,1.7,2,2,1.3,1.6,2.3);
        $pdf->SetWidths($widths);
        $pdf->SetAligns(array("C","C","C","C","C","C","C","C","C"));
        $pdf->Row($header, $lineHeight);
        $pdf->SetAligns(array("L","L","C","R","R","R","R","R","R"));
    }
    if ($ti_serie!=$rec["odd_serie"]  || $ti_num!=$rec["odd_num"]) {
        if ($t_lini > 1) {
            $pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.5, $pdf->GetY());
            $pdf->Cell(.04,.4,"          TOTAL ESTA ORDEN DE COMPRA",0,0,"L");
            $body = array(
                "",
                "",
                "",
                "",
                "",
                "",
                "",
                "",
                number_format($subtot, 5, '.', ','),
            ); 
            $pdf->RowBorderHidden($body, $lineHeight);
            $pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.5, $pdf->GetY());
            $pdf->ln();
            $pdf->SetFont("","");
            $pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("NUMERO:"),0,0,"L");
            $pdf->MultiAlignCell($lineWidth/4, $lineHeight, $rec["od_num"],0,0,"L");
            $pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("FECHA:"),0,0,"L");
            $pdf->MultiAlignCell($lineWidth/4, $lineHeight, date('d-m-Y', strtotime($rec["od_fec"])),0,1,"L");
            //$lineHeight = .42;
            $pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("PROVEDOR:"),0,0,"L");
            $pdf->MultiAlignCell($lineWidth/1.6, $lineHeight, utf8_decode($rec["od_prov"]),0,1,"L");
            $pdf->MultiAlignCell($lineWidth/4.9, $lineHeight, utf8_decode("SOLICITADO POR: "),0,0,"L");
            $pdf->MultiAlignCell($lineWidth/1.93, $lineHeight, utf8_decode($rec["od_soli"]),0,0,"L");
            $pdf->MultiAlignCell($lineWidth/6.9, $lineHeight, utf8_decode("DIAS CREDITO: :"),0,0,"L");
            $pdf->MultiAlignCell($lineWidth/8, $lineHeight, utf8_decode($rec["od_cred"]),0,1,"L");
            $pdf->MultiAlignCell($lineWidth/4.9, $lineHeight, utf8_decode("TASA DE CAMBIO:"),0,0,"L");
            $pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode($rec["od_tcam"]),0,0,"L");
            $pdf->MultiAlignCell($lineWidth/8, $lineHeight, utf8_decode("VALIDA HASTA:"),0,0,"L");
            $pdf->MultiAlignCell($lineWidth/5.2, $lineHeight, strftime("%d/%m/%Y", strtotime($rec["od_valida"])),0,0,"L");
            $pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("MONEDA:"),0,0,"L");
            if ($rec["od_tmone"] == "L") {
               $moneda="LOCAL";
            } else {
               $moneda="DOLARES";
            }   
            $pdf->SetFont("","");
            $pdf->MultiAlignCell($lineWidth/8, $lineHeight, $moneda,0,1,"L");
            $pdf->MultiAlignCell($lineWidth/4.9, $lineHeight, utf8_decode("OBSERVACIONES: "),0,0,"L");
            $pdf->MultiAlignCell($lineWidth/1, $lineHeight, utf8_decode($rec["od_obs"]),0,1,"L");
            $pdf->Ln();
            //$pdf->Ln();
            $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"MEDIDA","CANTIDAD","UNITARIO","SUBTOTAL","%DEC","VAL/DESC","TOTAL");
            $widths = array(1.8,5,1.3,1.7,2,2,1.3,1.6,2.3);
            $pdf->SetWidths($widths);
            $pdf->SetAligns(array("C","C","C","C","C","C","C","C","C"));
            $pdf->Row($header, $lineHeight);
            $pdf->SetAligns(array("L","L","C","R","R","R","R","R","R"));
        }             
        $subtot=0;
        $ti_serie=$rec["odd_serie"];
        $ti_num=$rec["odd_num"];

        $t_lini=2;
    } 
    $subtot += $rec["odd_tot"];
    $tottot += $rec["odd_tot"];

    $body = array(
        $rec["odd_cod"],
        $rec["odd_desc"],
        $rec["odd_unimed"],
        ($rec["odd_cant"] > 0) ? number_format($rec["odd_cant"],2) : "",
        ($rec["odd_cosu"] > 0) ? number_format($rec["odd_cosu"],5) : "",
        ($rec["odd_sub"] > 0) ? number_format($rec["odd_sub"],5) : "",
        ($rec["odd_pdesc"] > 0) ? number_format($rec["odd_pdesc"],2) : "",
        ($rec["odd_descu"] > 0) ? number_format($rec["odd_descu"],2) : "",
        ($rec["odd_tot"] > 0) ? number_format($rec["odd_tot"],5) : "",
    ); 
    $pdf->RowBorderHidden($body, $lineHeight);
    if (($pdf->GetY()+$lineHeight) > 25) {
        $pdf->AddPage();
        $pdf->SetFont("","");
        $pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("NUMERO:"),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/4, $lineHeight, $rec["od_num"],0,0,"L");
        $pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("FECHA:"),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/4, $lineHeight, date('d-m-Y', strtotime($rec["od_fec"])),0,1,"L");
        //$lineHeight = .42;
        $pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("PROVEDOR:"),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/1.6, $lineHeight, utf8_decode($rec["od_prov"]),0,1,"L");
        $pdf->MultiAlignCell($lineWidth/4.9, $lineHeight, utf8_decode("SOLICITADO POR: "),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/1.93, $lineHeight, utf8_decode($rec["od_soli"]),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/6.9, $lineHeight, utf8_decode("DIAS CREDITO: :"),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/8, $lineHeight, utf8_decode($rec["od_cred"]),0,1,"L");
        $pdf->MultiAlignCell($lineWidth/4.9, $lineHeight, utf8_decode("TASA DE CAMBIO:"),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode($rec["od_tcam"]),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/8, $lineHeight, utf8_decode("VALIDA HASTA:"),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/5.2, $lineHeight, strftime("%d/%m/%Y", strtotime($rec["od_valida"])),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("MONEDA:"),0,0,"L");
        if ($rec["od_tmone"] == "L") {
           $moneda="LOCAL";
        } else {
           $moneda="DOLARES";
        }   
        $pdf->SetFont("","");
        $pdf->MultiAlignCell($lineWidth/8, $lineHeight, $moneda,0,1,"L");
        $pdf->MultiAlignCell($lineWidth/4.9, $lineHeight, utf8_decode("OBSERVACIONES: "),0,0,"L");
        $pdf->MultiAlignCell($lineWidth/1, $lineHeight, utf8_decode($rec["od_obs"]),0,1,"L");
        $pdf->Ln();
        //$pdf->Ln();
        $header = array("CODIGO",utf8_decode("DESCRIPCIÓN"),"MEDIDA","CANTIDAD","UNITARIO","SUBTOTAL","%DEC","VAL/DESC","TOTAL");
        $widths = array(1.8,5,1.3,1.7,2,2,1.3,1.6,2.3);
        $pdf->SetWidths($widths);
        $pdf->SetAligns(array("C","C","C","C","C","C","C","C","C"));
        $pdf->Row($header, $lineHeight);
        $pdf->SetAligns(array("L","L","C","R","R","R","R","R","R"));
    }    
}

$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.5, $pdf->GetY());
$pdf->Cell(.04,.4,"          TOTAL ESTA ORDEN DE COMPRA",0,0,"L");
$body = array(
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    number_format($subtot, 5, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.5, $pdf->GetY());
$pdf->ln();

$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.5, $pdf->GetY());
$pdf->Cell(.04,.4,"          TOTAL GENERAL",0,0,"L");
$body = array(
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    number_format($tottot, 5, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 20.5, $pdf->GetY());

$pdf->Output(utf8_decode("Lista Ordenes" ).".pdf","I");

$db->close();

?>