<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$bitForm = "iva1010";
$bitMod = "iva";
$empCod = $_SESSION['empCod'];
$empConso = $_SESSION['empConso'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);
$dcs = $_SESSION['pSuper'];
$dcr = $_SESSION['pRegu'];
$dcd = $_SESSION['pDiesel'];

switch ($_POST['action']) {
	case 'consultar':
		echo consultar();
		break;

	case 'consultarCta':
		echo consultarCta();
		break;

	case 'consultarProvee':
		echo consultarProvee();
		break;

	case 'consultarCiemes':
		echo consultarCiemes();
		break;

	case 'generarPartida':
		echo generarPartida();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'borrar':
		echo borrar();
		break;
	case 'guardarCarga':
		echo guardarCarga();
		break;
	case 'borrarCarga':
		echo borrarCarga();
		break;
}

function consultar() {
	global $empCod, $usuNom, $tipoPol, $txtSerie, $numNum;

	$tipoPol='006';

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$txtSerie=$_POST['txtSerie'];
	$numNum=$_POST['numNum'];
	$txtNit=$_POST['txtNit'];

	# QUERYS
	$sIva_comp = "SELECT i.*, c.ciem_stat FROM iva_comp i 
				  LEFT JOIN ciemes c ON c.ciem_mes=MONTH(i.iva_rfec) AND c.ciem_ano=YEAR(i.iva_rfec) AND c.ciem_emp='$empCod'
				  WHERE iva_emp='$empCod' AND iva_serie='$txtSerie' AND iva_num='$numNum' AND iva_nit='$txtNit'";

	function sPoli_det($proco){
	   global $empCod, $tipoPol, $txtSerie, $numNum;
	   return "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_tipoi='$txtSerie' AND pold_num='$numNum' AND pold_nit='$proco'";
	}

	function sCiemes($numAno, $numMes){
		return "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$numAno AND ciem_mes=$numMes";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$fa["iva_comp"] = $db->sFetchAssoc($sIva_comp);
	$mod=$fa["iva_comp"]["iva_mod"];
	if ($mod == 'cxp') {
	  $proco=$fa["iva_comp"]["iva_proco"];
	} else {
	  $proco=$txtNit;
	} 
	$resp = $db->sEx($sIva_comp, "iva_comp");
	$resp["poli_det"] = $db->sFetchAll(sPoli_det($proco));
	$db->close();

	$resp["mod"]=$mod;
	$resp["proco"]=$proco;	

	$func = new functions();
	return $func->jsonEncodeArray($resp, "iva_comp");
}

function consultarCta() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sCuentas = "SELECT c.*, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$txtCod' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function consultarProvee() {
	global $empCod;
	$txtNit=utf8_decode($_POST['txtNit']);

	# QUERYS
	$sProvee = "SELECT TRIM(pro_nom) AS pro_nom FROM provee WHERE pro_nit='$txtNit'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sProvee, "provee");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "provee");
}

function consultarCiemes() {
	global $empCod;

	$func = new functions();
	$numAno=$_POST["numAno"];
	$selMesCod=$_POST["selMesCod"];

	# QUERYS
	$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$numAno AND ciem_mes=$selMesCod";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCiemes, "ciemes");
	$db->close();

	return json_encode($resp);
}

function generarPartida() {
	global $empCod;
	$numIva=$_POST['numIva'];
	$deduTot=$_POST['deduTot'];
	$numRet=$_POST['numRet'];
	$numReti=$_POST['numReti'];

	# QUERYS
	function sCuentas($cta) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ctaIva"] = ($numIva==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaic"]));
	$resp["ctaComb"] = ($deduTot==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtacomb"]));
	$resp["ctaRet"] = ($numRet==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtarisr"]));
	$resp["ctaReti"] = ($numReti==0) ? 0 : $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtariva"]));
	$resp["ctaCaj"] = $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtacaj"]));
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, 'ctaIva');
}

function guardar() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm, $proco;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$txtSerie=utf8_decode($_POST['txtSerie']);
	$numNum=$_POST['numNum'];
	$txtNit=utf8_decode($_POST['txtNit']);
	$selTipoCod=$_POST['selTipoCod'];
	$txtProv=utf8_decode($_POST['txtProv']);
	$dtFec=$_POST['dtFec'];

	$numDia=date("d", strtotime($dtFec));
	$selMesCod=$_POST['selMesCod'];
	$numAno=$_POST['numAno'];
	$mesact=date("m", strtotime($dtFec));
	if ($selMesCod==$mesact) {
	    $rfec=$numAno."-".$selMesCod."-".$numDia;
	} else {
	    $rfec=$numAno."-".$selMesCod."-01";
	}

	$rfecAnt=$_POST['rfecAnt'];
	$numAnoAnt=date("Y", strtotime($rfecAnt));
	$numMesAnt=date("n", strtotime($rfecAnt));

	$selBanCod=$_POST['selBanCod'];
	$numCheque=(empty($_POST['numCheque'])) ? 0 : $_POST['numCheque'];
	$crRet=$_POST['crRet'];
	$crReti=$_POST['crReti'];
	$crCaja=$_POST['crCaja'];
	$crAfe=$_POST['crAfe'];
	$numBien=(empty($_POST['numBien'])) ? 0 : $_POST['numBien'];
	$numServ=(empty($_POST['numServ'])) ? 0 : $_POST['numServ'];
	$numPeque=(empty($_POST['numPeque'])) ? 0 : $_POST['numPeque'];
	$numPeque2=(empty($_POST['numPeque2'])) ? 0 : $_POST['numPeque2'];
	$numImp=(empty($_POST['numImp'])) ? 0 : $_POST['numImp'];
	$numImpre=(empty($_POST['numImpre'])) ? 0 : $_POST['numImpre'];
	$numTasam=(empty($_POST['numTasam'])) ? 0 : $_POST['numTasam'];
	$numMedi=(empty($_POST['numMedi'])) ? 0 : $_POST['numMedi'];
	$numNoafe=(empty($_POST['numNoafe'])) ? 0 : $_POST['numNoafe'];
	$numVehi=(empty($_POST['numVehi'])) ? 0 : $_POST['numVehi'];
	$numVehia=(empty($_POST['numVehia'])) ? 0 : $_POST['numVehia'];
	$crTvehi=(empty($_POST['crTvehi'])) ? "0" : $_POST['crTvehi'];
	$numTfacom=(empty($_POST['numTfacom'])) ? 0 : $_POST['numTfacom'];
	$numGalos=(empty($_POST['numGalos'])) ? 0 : $_POST['numGalos'];
	$numGalor=(empty($_POST['numGalor'])) ? 0 : $_POST['numGalor'];
	$numGalod=(empty($_POST['numGalod'])) ? 0 : $_POST['numGalod'];
	$numComb=(empty($_POST['numComb'])) ? 0 : $_POST['numComb'];
	$txtCon=utf8_decode($_POST['txtCon']);

	$subb=$_POST['subb'];
	$subs=$_POST['subs'];
	$subpe=$_POST['subpe'];
	$subco=$_POST['subco'];
	$subve=$_POST['subve'];
	$subi=$_POST['subi'];
	$subir=$_POST['subir'];
	$subna=$_POST['subna'];
	$subme=$_POST['subme'];

	$numRet=$_POST['numRet'];
	$numReti=$_POST['numReti'];
	$numSub=$_POST['numSub'];
	$numIva=$_POST['numIva'];
	$numTot=$_POST['numTot'];
	$deduTot=$_POST['deduTot'];

	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);

	$tipoPol='006';
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));

	$mod=$_POST['mod'];
	$proco=$_POST['proco'];
	if ($mod != 'cxp') {
		$proco = $txtNit;
	}


	# QUERYS PARA UN REGISTRO
	$iIva_comp = "INSERT INTO iva_comp (iva_emp, iva_serie, iva_num, iva_nit, iva_tipo, iva_prov, iva_fec, iva_rfec, iva_ban, iva_cheque, iva_retsn, iva_retisn, iva_caja, iva_afe, iva_bien, iva_serv, iva_peque, iva_peque2, iva_imp, iva_impre, iva_medi, iva_noafe, iva_vehi, iva_vehia, iva_tvehi, iva_tfacom, iva_galos, iva_galor, iva_galod, iva_comb, iva_con, iva_subb, iva_subs, iva_subpe, iva_subco, iva_subve, iva_subi, iva_subir, iva_subna, iva_subme, iva_ret, iva_reti, iva_sub, iva_iva, iva_tot, iva_ulcam, iva_conso, iva_cajach, iva_tasam, iva_dedu) VALUES ('$empCod', '$txtSerie', '$numNum', '$txtNit', '$selTipoCod', '$txtProv', '$dtFec', '$rfec', '$selBanCod', '$numCheque', '$crRet', '$crReti', '$crCaja', '$crAfe', '$numBien', '$numServ', '$numPeque', '$numPeque2', '$numImp', '$numImpre', '$numMedi', '$numNoafe', '$numVehi', '$numVehia', '$crTvehi', '$numTfacom', '$numGalos', '$numGalor', '$numGalod', '$numComb', '$txtCon', '$subb', '$subs', '$subpe', '$subco', '$subve', '$subi', '$subir', '$subna', '$subme', '$numRet', '$numReti', '$numSub', '$numIva', '$numTot', '$usuNom', '$empConso', 'N', '$numTasam','$deduTot')";

	$uIva_comp = "UPDATE iva_comp SET iva_tipo='$selTipoCod', iva_prov='$txtProv', iva_fec='$dtFec', iva_rfec='$rfec', iva_ban='$selBanCod', iva_cheque='$numCheque', iva_retsn='$crRet', iva_retisn='$crReti', iva_caja='$crCaja', iva_afe='$crAfe', iva_bien='$numBien', iva_serv='$numServ', iva_peque='$numPeque', iva_peque2='$numPeque2', iva_imp='$numImp', iva_impre='$numImpre', iva_medi='$numMedi', iva_noafe='$numNoafe', iva_vehi='$numVehi', iva_vehia='$numVehia', iva_tvehi='$crTvehi', iva_tfacom='$numTfacom', iva_galos='$numGalos', iva_galor='$numGalor', iva_galod='$numGalod', iva_comb='$numComb', iva_con='$txtCon', iva_subb='$subb', iva_subs='$subs', iva_subpe='$subpe', iva_subco='$subco', iva_subve='$subve', iva_subi='$subi', iva_subir='$subir', iva_subna='$subna', iva_subme='$subme', iva_ret='$numRet', iva_reti='$numReti', iva_sub='$numSub', iva_iva='$numIva', iva_tot='$numTot', iva_ulcam='$usuNom', iva_conso='$empConso', iva_tasam='$numTasam', iva_dedu='$deduTot' WHERE iva_emp='$empCod' AND iva_serie='$txtSerie' AND iva_num='$numNum' AND iva_nit='$txtNit'";

	$sPolizas = "SELECT pol_num FROM polizas WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie' AND pol_nit='$proco'";

	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_tipoi, pol_nit, pol_con, pol_ulcam, pol_grabado) VALUES ('$empCod','$rfec',0,'$tipoPol','$numNum','$txtSerie','$proco','$txtCon','$usuNom','$dtGrabado')";

	$uPolizas = "UPDATE polizas SET pol_con='$txtCon', pol_ulcam='$usuNom', pol_fec='$rfec', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_ban=0 AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie' AND pol_nit='$proco'";

	$iProvee = "INSERT INTO provee(pro_nit, pro_nom, pro_retsn) VALUES ('$txtNit','$txtProv','$crRet')";

	$uProvee = "UPDATE provee SET pro_nom='$txtProv', pro_ret='$crRet' WHERE pro_nit='$txtNit'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_tipoi, pold_nit, pold_cta, pold_ctan, pold_debe, pold_haber) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$rfec',0,'$tipoPol','$numNum','$txtSerie','$proco','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber')".$func->addValues($obj, $jsonPol);
	}

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban=0 AND pold_tipo='$tipoPol' AND pold_num='$numNum' AND pold_tipoi='$txtSerie' AND pold_nit='$proco'";

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	if ($func->stringToBool($_POST['nuevo'])) {
		$resp = $db->iEx($iIva_comp);
		$db->query($func->iBitacora(utf8_decode("Se creó compra No.: $numNum Serie: $txtSerie NIT: $txtNit Usuario: ").$usuNom, $bitMod, $bitForm));

		$db->query($iPolizas);
	} else {
		$resp = $db->uEx($uIva_comp);
		$db->query($func->iBitacora(utf8_decode("Se modificó compra No.: $numNum Serie: $txtSerie NIT: $txtNit Usuario: ").$usuNom, $bitMod, $bitForm));

		$select["polizas"] = $db->query($sPolizas);
		($db->numRows($select["polizas"]) > 0) ? $db->query($uPolizas) : $db->query($iPolizas);
	}
	($func->stringToBool($_POST['nuevoProvee'])) ? $db->query($iProvee) : $db->query($uProvee);

	$db->dEx($dPoli_det);
	if (!$func->jsonEmpty($jsonPol)) {
		$db->iEx($iPoli_det);
	}

	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
	}

	// PARA APLICAR LOS CIERRES
	foreach ($jsonPol as $obj) {
		$cta = $obj->cta;
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$select["cierres"] = $db->query(sCierres($cta, $numAno, $selMesCod));
			if ($db->numRows($select["cierres"]) > 0) {
				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

				$db->query(uCierres($cta, $numAno, $selMesCod, $mdebe, $mhaber));
			} else {
				$mdebe=$obj->debe;
				$mhaber=$obj->haber;

				$db->query(iCierres($cta, $numAno, $selMesCod, $mdebe, $mhaber));
			}
			$cta = $ctaActa;
		}
	}
	$db->close();

	return json_encode($resp);
}

function borrar() {
	global $empCod, $usuNom, $bitMod, $bitForm;

	$func = new functions();

	$txtSerie=utf8_decode($_POST['txtSerie']);
	$numNum=$_POST['numNum'];
	$txtNit=utf8_decode($_POST['txtNit']);
	$selBanCod=$_POST['selBanCod'];

	$rfecAnt=$_POST['rfecAnt'];
	$numAnoAnt=date("Y", strtotime($rfecAnt));
	$numMesAnt=date("n", strtotime($rfecAnt));

	$jsonPolAnt=json_decode($_POST['tblPolAnt']);

	$tipoPol = "006";

	# QUERYS
	$dIva_comp = "DELETE FROM iva_comp WHERE iva_emp='$empCod' AND iva_serie='$txtSerie' AND iva_num='$numNum' AND iva_nit='$txtNit'";

	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban=0 AND pol_tipo='$tipoPol' AND pol_num='$numNum' AND pol_tipoi='$txtSerie' AND pol_nit='$txtNit'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban=0 AND pold_tipo='$tipoPol' AND pold_num='$numNum' AND pold_tipoi='$txtSerie' AND pold_nit='$txtNit'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	$resp = $db->dEx($dIva_comp);
	$db->dEx($dPolizas);
	$db->dEx($dPoli_det);

	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
	}


	$db->iEx($func->iBitacora(utf8_decode("Se borró compra No.: $numNum Serie: $txtSerie NIT: $txtNit Usuario: ").$usuNom, $bitMod, $bitForm));

	$db->close();

	return json_encode($resp);
}

function guardarCarga() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm, $tipoPol, $selTipoCod, $mod, $dcs, $dcr, $dcd, $dtGrabado;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$jsonCompras=json_decode($_POST['tblCompras']);
	$tipoPol='006';
	$selTipoCod="010";
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$mod='iva';


	# QUERYS PARA UN REGISTRO
	function sIva_comp($serie,$num,$nit) { 
		global $empCod;
	    return "SELECT * FROM iva_comp WHERE iva_emp='$empCod' AND iva_serie='$serie' AND iva_num='$num' AND iva_nit='$nit'";
	}

	function dIva_comp($serie,$num,$nit) { 
		global $empCod;
	    return "DELETE FROM iva_comp WHERE iva_emp='$empCod' AND iva_serie='$serie' AND iva_num='$num' AND iva_nit='$nit'";
	}

	function iIva_comp($serie,$num,$nit,$prov,$fecha,$rfec,$numTot,$numBien,$numServ,$numPeque,$numComb,$numTfacom,$numIva,$numSubb,$numSubs,$numSubpe,$numSubco,$numSub,$numGalos,$numGalor,$numGalod,$obs,$srd,$dedu,$banco,$cheque,$noafe) { 
		global $empCod,$usuNom,$empConso,$selTipoCod;
	    return "INSERT INTO iva_comp (iva_emp, iva_serie, iva_num, iva_nit, iva_tipo, iva_prov, iva_fec, iva_rfec, iva_ban, iva_cheque, iva_retsn, iva_retisn, iva_caja, iva_afe, iva_bien, iva_serv, iva_peque, iva_comb, iva_con, iva_tfacom, iva_subb, iva_subs, iva_subpe, iva_subco, iva_ret, iva_reti, iva_galos, iva_galor, iva_galod, iva_sub, iva_iva, iva_tot, iva_ulcam, iva_conso, iva_cajach, iva_tasam, iva_srd, iva_dedu, iva_noafe, iva_subna) VALUES ('$empCod', '$serie', '$num', '$nit', '$selTipoCod', '$prov', '$fecha', '$rfec', $banco, $cheque, 'N', 'N', 'N', 'S', '$numBien', '$numServ', '$numPeque', '$numComb', '$obs', '$numTfacom', '$numSubb', '$numSubs', '$numSubpe', '$numSubco', 0, 0, '$numGalos', '$numGalor', '$numGalod', '$numSub', '$numIva', '$numTot', '$usuNom', '$empConso', 'N', 0, '$srd','$dedu','$noafe','$noafe')";
	}

	function sPoli_det($serie,$num,$nit) { 
		global $empCod,$tipoPol;
	    return "SELECT * FROM poli_det 
	    WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$num' AND pold_tipoi='$serie' AND pold_nit='$nit'";
	}

	function dPoli_det($serie,$num,$nit) { 
		global $empCod,$tipoPol;
	    return "DELETE FROM poli_det 
	    		 WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$num' AND pold_tipoi='$serie' AND pold_nit='$nit'";
	}

	function dPolizas($serie,$num,$nit) { 
		global $empCod,$tipoPol;
	    return "DELETE FROM polizas 
	    		 WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$num' AND pol_tipoi='$serie' AND pol_nit='$nit'";
	}

	function iPolizas($fecha,$serie,$num,$nit,$obs) { 
		global $empCod,$tipoPol,$usuNom,$dtGrabado;
	    return "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_tipoi, pol_nit, pol_con, pol_ulcam, pol_grabado) 
	    		  VALUES ('$empCod','$fecha',0,'$tipoPol','$num','$serie','$nit','$obs','$usuNom','$dtGrabado')";
	}

	function iPoli_det($fecha,$serie,$num,$nit,$cta,$ctan,$debe,$haber) { 
		global $empCod,$tipoPol,$usuNom,$dtGrabado;
	    return "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_tipoi, pold_nit, pold_cta, pold_ctan, pold_debe, pold_haber) 
	    		  VALUES ('$empCod','$fecha',0,'$tipoPol','$num','$serie','$nit','$cta','$ctan','$debe','$haber')";
	}

	function sProvee($nit) { 
		global $empCod;
	    return "SELECT * FROM provee WHERE pro_nit='$nit'";
	}

	function iProvee($nit,$prov) { 
		global $empCod;
	    return "INSERT INTO provee(pro_nit, pro_nom, pro_retsn) VALUES ('$nit','$prov','N')";
	}

	function uProvee($nit,$prov) { 
		global $empCod;
	    return "UPDATE provee SET pro_nom='$prov' WHERE pro_nit='$nit'";
	}

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# EJECUCION DE QUERYS 

	$pIva = $_SESSION["pIva"];

	$ctaIva = $_SESSION["empCtaic"];
	$ctaComb = $_SESSION["empCtacomb"];

	// Para leer la tabla de compras se va a cargar
	foreach ($jsonCompras as $objc) {
		$db = new dbExec();

		$txtSerie=TRIM($objc->serie);
		$numNum=$objc->factura;
		$txtNit=TRIM($objc->nit);
		$txtProv=TRIM($objc->prov);
		$dtFec=$objc->fecha;
		$numAno=$objc->ano;
		$numMes=$objc->mes;
		$numTot=$objc->monto;
		$numTote=$objc->montoe;
		$flagb=strtoupper(TRIM($objc->flagb));
		$flags=strtoupper(TRIM($objc->flags));
		$flagp=strtoupper(TRIM($objc->flagp));
		$flagc=strtoupper(TRIM($objc->flagc));
		$numGalos=$objc->galos;
		$numGalor=$objc->galor;
		$numGalod=$objc->galod;
		$ctaCar=$objc->ctacar;
		$ctaComp=$objc->ctacomp;
		$ctaExen=$objc->ctaexen;
		$txtCon=TRIM($objc->obs);
		$banco=TRIM($objc->banco);
		$cheque=TRIM($objc->cheque);
//		$gravado=TRIM($objc->gravado);
//		$cbexen=TRIM($objc->cbexen);

		$srd="";
		if ($numGalos>0) {
		   $srd='S';
		}
		if ($numGalor>0) {
		   $srd='R';
		}
		if ($numGalod>0) {
		   $srd='D';
		}
		//$numDia=date("d", strtotime($dtFec));
		$selMesCod=date("n", strtotime($dtFec));
		$numAnoCod=date("Y", strtotime($dtFec));
		if ($selMesCod==$numMes && $numAnoCod==$numAno) {
			$rfec=$dtFec;
		} else {
			$rfec=$numAno.'-'.$numMes.'-01';
		}	
		$rfecAnt=$rfec;
		$numAnoAnt=date("Y", strtotime($rfec));
		$numMesAnt=date("n", strtotime($rfec));

		$dedus=0;
		$dedur=0;
		$dedud=0;
		$dedu=0;
		$tfacom=0;
		$bien=0;
		$serv=0;
		$peque=0;
		$comb=0;
		$sub=0;
		$subb=0;
		$subs=0;
		$subpe=0;
		$subco=0;
		$noafe=0;

		if ($flagc=="X" || $flagc=='x') {
			$tfacom=$numTot;
			$dedus=round(($dcs*$numGalos),2);
			$dedur=round(($dcr*$numGalor),2);
			$dedud=round(($dcd*$numGalod),2);
			$dedu=$dedus+$dedur+$dedud;
			$comb=round(($tfacom-$dedu),2);
			$subco=round(($comb/(($pIva/100)+1)),2);
		}
		if ($flagb=="X" || $flagb=='x') {
			$bien=$numTot;
			$subb=round(($bien/(($pIva/100)+1)),2);
		}
		if ($flags=="X" || $flags=='x') {
			$serv=$numTot;
			$subs=round(($serv/(($pIva/100)+1)),2);
		}
		if ($flagp=="X" || $flagp=='x') {
			$peque=$numTot;
			$subpe=$peque;
		}

		if ($numTote) {
			$noafe=$numTote;
		}
		$tot=round(($bien+$serv+$comb+$peque+$noafe),2);
		$sub=round(($subb+$subs+$subco+$subpe+$noafe),2);
		$iva=round(($tot-$sub),2);

	    // Revisa si ya fue grabado este documento con anterioridad, si es asi, revierte poliza y borra documento
		$select["iva_comp"] = $db->query(sIva_comp($txtSerie,$numNum,$txtNit));
		if ($db->numRows($select["iva_comp"]) > 0) {
			// PARA REVERTIR LOS CIERRES
			$select["poli_det"] = $db->query(sPoli_det($txtSerie,$numNum,$txtNit));
		    while ($recDet = $db->fetchAssoc($select["poli_det"])) {
		        $cta = $recDet["pold_cta"];
		        $debe = $recDet["pold_debe"];
		        $haber = $recDet["pold_haber"];
				$numAnoAnt=date("Y", strtotime($recDet["pold_fec"]));
				$numMesAnt=date("n", strtotime($recDet["pold_fec"]));
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);
					$fetchAssoc["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$haber;
					$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));
					$cta = $ctaActa;
				}
		    }
		    // Borra el registro de compras y las polizas que le afecten
			$db->query(dIva_comp($txtSerie,$numNum,$txtNit));
			$db->query(dPolizas($txtSerie,$numNum,$txtNit));
			$db->query(dPoli_det($txtSerie,$numNum,$txtNit));
		}

		$resp =	$db->query(iIva_comp($txtSerie,$numNum,$txtNit,$txtProv,$dtFec,$rfec,$tot,$bien,$serv,$peque,$comb,$tfacom,$iva,$subb,$subs,$subpe,$subco,$sub,$numGalos,$numGalor,$numGalod,$txtCon,$srd,$dedu,$banco,$cheque,$noafe));

	    // Revisa si ya existe el proveedor
		$select["provee"] = $db->query(sProvee($txtNit));
		if ($db->numRows($select["provee"]) > 0) {
			$db->query(uProvee($txtNit,$txtProv));
		} else {
			$db->query(iProvee($txtNit,$txtProv));
		}

		$resp= $db->query(iPolizas($rfec,$txtSerie,$numNum,$txtNit,$txtCon));

		// CUENTA DE CARGO
		$cta = $ctaCar;
		$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
		$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
		$debe=$sub-$numTote;
		$haber=0;
		$db->query(iPoli_det($rfec,$txtSerie,$numNum,$txtNit,$cta,$ctaNom,$debe,$haber));
		// PARA APLICAR LOS CIERRES
		while (!empty($cta)) {
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
			if ($db->numRows($select["cierres"]) > 0) {
				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
				$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
			} else {
				$mdebe=$debe;
				$mhaber=$haber;
				$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
			}
			$cta = $ctaActa;
		}
		// Para lo no afecto
		if ($numTote >0) {
			$cta = $ctaExen;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=$numTote;
			$haber=0;
			$db->query(iPoli_det($rfec,$txtSerie,$numNum,$txtNit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
		}

		// CUENTA DE IVA
		if ($iva > 0) {
			$cta = $ctaIva;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=$iva;
			$haber=0;
			$db->query(iPoli_det($rfec,$txtSerie,$numNum,$txtNit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
		}
		// CUENTA IMPUESTO SOBRE COMBUSTIBLES
		if ($dedu > 0) {
			$cta = $ctaComb;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=$dedu;
			$haber=0;
			$db->query(iPoli_det($rfec,$txtSerie,$numNum,$txtNit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
		}
		// CUENTA DE ABONO
		if (($tot+$dedu) > 0) {
			$cta = $ctaComp;
			$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
			$ctaNom = trim($fetchAssoc["cuentas"]["cta_nom"]);
			$debe=0;
			$haber=$tot+$dedu;
			$db->query(iPoli_det($rfec,$txtSerie,$numNum,$txtNit,$cta,$ctaNom,$debe,$haber));
			// PARA APLICAR LOS CIERRES
			while (!empty($cta)) {
				$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$select["cierres"] = $db->query(sCierres($cta, $numAno, $numMes));
				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$haber;
					$db->query(uCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$debe;
					$mhaber=$haber;
					$db->query(iCierres($cta, $numAno, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
		}
		$db->close();
	}

	$db = new dbExec();
	$db->query($func->iBitacora(utf8_decode("Se creó compras Cargado desde archivo Excel Usuario: ").$usuNom, $bitMod, $bitForm));
	$db->close();

	return json_encode($resp);
}

function borrarCarga() {
	global $empCod, $usuNom, $empConso, $bitMod, $bitForm, $tipoPol, $selTipoCod, $mod;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$jsonCompras=json_decode($_POST['tblCompras']);
	$tipoPol='006';
	$selTipoCod="010";
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
	$mod='iva';


	# QUERYS PARA UN REGISTRO
	function sIva_comp($serie,$num,$nit) { 
		global $empCod;
	    return "SELECT * FROM iva_comp WHERE iva_emp='$empCod' AND iva_serie='$serie' AND iva_num='$num' AND iva_nit='$nit'";
	}

	function dIva_comp($serie,$num,$nit) { 
		global $empCod;
	    return "DELETE FROM iva_comp WHERE iva_emp='$empCod' AND iva_serie='$serie' AND iva_num='$num' AND iva_nit='$nit'";
	}

	function sPoli_det($serie,$num,$nit) { 
		global $empCod,$tipoPol;
	    return "SELECT * FROM poli_det 
	    WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$num' AND pold_tipoi='$serie' AND pold_nit='$nit'";
	}

	function dPoli_det($serie,$num,$nit) { 
		global $empCod,$tipoPol;
	    return "DELETE FROM poli_det 
	    		 WHERE pold_emp='$empCod' AND pold_tipo='$tipoPol' AND pold_num='$num' AND pold_tipoi='$serie' AND pold_nit='$nit'";
	}

	function dPolizas($serie,$num,$nit) { 
		global $empCod,$tipoPol;
	    return "DELETE FROM polizas 
	    		 WHERE pol_emp='$empCod' AND pol_tipo='$tipoPol' AND pol_num='$num' AND pol_tipoi='$serie' AND pol_nit='$nit'";
	}

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# EJECUCION DE QUERYS 

	// Para leer la tabla de compras se va a cargar
	foreach ($jsonCompras as $objc) {
		$db = new dbExec();
		$txtSerie=$objc->serie;
		$numNum=$objc->factura;
		$txtNit=$objc->nit;
		$txtProv=$objc->prov;
		$dtFec=$objc->fecha;


	    // Revisa si ya fue grabado este documento con anterioridad, si es asi, revierte poliza y borra documento
		$select["iva_comp"] = $db->query(sIva_comp($txtSerie,$numNum,$txtNit));
		if ($db->numRows($select["iva_comp"]) > 0) {
			// PARA REVERTIR LOS CIERRES
			$select["poli_det"] = $db->query(sPoli_det($txtSerie,$numNum,$txtNit));
		    while ($recDet = $db->fetchAssoc($select["poli_det"])) {
		        $cta = $recDet["pold_cta"];
		        $debe = $recDet["pold_debe"];
		        $haber = $recDet["pold_haber"];
				$numAnoAnt=date("Y", strtotime($recDet["pold_fec"]));
				$numMesAnt=date("n", strtotime($recDet["pold_fec"]));
				while (!empty($cta)) {
					$fetchAssoc["cuentas"] = $db->sFetchAssoc(sCuentas($cta));
					$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);
					$fetchAssoc["cierres"] = $db->sFetchAssoc(sCierres($cta, $numAnoAnt, $numMesAnt));
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$haber;
					$db->query(uCierres($cta, $numAnoAnt, $numMesAnt, $mdebe, $mhaber));
					$cta = $ctaActa;
				}
		    }
		    // Borra el registro de compras y las polizas que le afecten
			$resp = $db->query(dIva_comp($txtSerie,$numNum,$txtNit));
			$db->query(dPolizas($txtSerie,$numNum,$txtNit));
			$db->query(dPoli_det($txtSerie,$numNum,$txtNit));
		}
		$db->close();

	}

	$db = new dbExec();
	$db->query($func->iBitacora(utf8_decode("Se borro compra Se habia Cargado desde archivo Excel Usuario: ").$usuNom, $bitMod, $bitForm));
	$db->close();

	return json_encode($resp);
}

?>