<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */
	/** Error reporting */
	 error_reporting(E_ALL);
	ini_set('display_errors', TRUE);
	ini_set('display_startup_errors', TRUE);
	date_default_timezone_set('Europe/London');

	if (PHP_SAPI == 'cli')
		die('This example should only be run from a Web Browser');

	require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';
	require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel/IOFactory.php';

include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once('../../../php/privileges.php');

$objPHPExcel = new PHPExcel();

// Esto es para abrir y leer el Excel
$archivo = $_FILES['file']['tmp_name'];
$inputFileType = PHPExcel_IOFactory::identify($archivo);
$objReader = PHPExcel_IOFactory::createReader($inputFileType);
$objPHPExcel = $objReader->load($archivo);

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);

switch ($_POST['action']) {

	case 'cargarArchivo':
		echo cargarArchivo();
		break;
}

function cargarArchivo() {
	global $empCod, $objPHPExcel;

	$func = new functions();

//	$cbExen=$_POST["cbExen"];

	function sCuentas($cta,$valor,$valorh) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom, $valor AS cta_valor, $valorh AS cta_valorh 
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}

	# EJECUCION DE QUERYS
	$db = new dbExec();


	// Indicamos que usaremos la primera hoja del excel
	$objPHPExcel->setActiveSheetIndex(0);

	// Revisa cual es la ultima fila y columna trabajada
	$highestRow = $objPHPExcel->getActiveSheet()->getHighestRow(); 
	$highestColumn = $objPHPExcel->getActiveSheet()->getHighestColumn();   
/*
	echo $highestRow;   
	$nom="prueba";
	$resp["fileCompras"]=array();  */
	$resp["fileCompras"]=array();
	$nom="prueba";
	$prov="XXXX999";
	$j=0;
	// Aqui se obtienen los valores de cada celda, hasta el ultimo valor
	for ($row = 4; $prov!=''; $row++){   
	//	echo $objPHPExcel->getActiveSheet()->getCell("A".$row)->getValue()." - ";
    //		echo $objPHPExcel->getActiveSheet()->getCell("B".$row)->getValue()." - ";
    //		echo $objPHPExcel->getActiveSheet()->getCell("C".$row)->getValue(); 

		$prov= trim($objPHPExcel->getActiveSheet()->getCell("A".$row)->getValue());
		if ($prov == '') {
			continue;
		}
		$nit= utf8_decode($objPHPExcel->getActiveSheet()->getCell("B".$row)->getValue());

		$fecha1 = $objPHPExcel->getActiveSheet()->getCell("C".$row)->getValue()+1;
		$fecha = date("Y-m-d", PHPExcel_Shared_Date::ExcelToPHP($fecha1)); 

		$mes= $objPHPExcel->getActiveSheet()->getCell("D".$row)->getValue();
		$ano= $objPHPExcel->getActiveSheet()->getCell("E".$row)->getValue();
		$serie= $objPHPExcel->getActiveSheet()->getCell("F".$row)->getValue();
		$factura= $objPHPExcel->getActiveSheet()->getCell("G".$row)->getValue();
		$monto= $objPHPExcel->getActiveSheet()->getCell("H".$row)->getValue();
		$montoe= $objPHPExcel->getActiveSheet()->getCell("I".$row)->getValue();
		$iva= $objPHPExcel->getActiveSheet()->getCell("J".$row)->getValue();
		$ctacar= $objPHPExcel->getActiveSheet()->getCell("K".$row)->getValue();
		$ctacomp= $objPHPExcel->getActiveSheet()->getCell("L".$row)->getValue();
		$ctaexen= $objPHPExcel->getActiveSheet()->getCell("M".$row)->getValue();

		$flagb= $objPHPExcel->getActiveSheet()->getCell("N".$row)->getValue();
		$flags= $objPHPExcel->getActiveSheet()->getCell("O".$row)->getValue();
		$flagp= $objPHPExcel->getActiveSheet()->getCell("P".$row)->getValue();
		$flagc= $objPHPExcel->getActiveSheet()->getCell("Q".$row)->getValue();
		$galos= $objPHPExcel->getActiveSheet()->getCell("R".$row)->getValue();
		$galor= $objPHPExcel->getActiveSheet()->getCell("S".$row)->getValue();
		$galod= $objPHPExcel->getActiveSheet()->getCell("T".$row)->getValue();
		$obs= $objPHPExcel->getActiveSheet()->getCell("U".$row)->getValue();  
		$banco= $objPHPExcel->getActiveSheet()->getCell("V".$row)->getValue();
		$cheque= $objPHPExcel->getActiveSheet()->getCell("W".$row)->getValue();
		$gravado= $objPHPExcel->getActiveSheet()->getCell("X".$row)->getValue();

		if (is_null($monto)) {
			$monto=0;
	    }
		if (is_null($montoe)) {
			$montoe=0;
	    }
		if (is_null($iva)) {
			$iva=0;
	    }
		if (is_null($ctacar)) {
			$ctacar='';
	    }
		if (is_null($ctacomp)) {
			$ctacomp='';
	    }
		if (is_null($ctaexen)) {
			$ctaexen='';
	    }
		if (is_null($flagb)) {
			$flagb='';
	    }
		if (is_null($flags)) {
			$flags='';
	    }
		if (is_null($flagp)) {
			$flagp='';
	    }
		if (is_null($flagc)) {
			$flagc='';
	    }
		if (is_null($galos)) {
			$galos=0;
	    }
		if (is_null($galor)) {
			$galor=0;
	    }
		if (is_null($galod)) {
			$galod=0;
	    }
		if (is_null($obs)) {
			$obs=0;
	    }
		if (is_null($banco)) {
			$banco=0;
	    }
		if (is_null($cheque)) {
			$cheque=0;
	    }
//		if (is_null($gravado)) {
			$gravado="";
//	    }

		$flagb=strtoupper($flagb);
		$flags=strtoupper($flags);
		$flagp=strtoupper($flagp);
		$flagc=strtoupper($flagc);

        array_push($resp["fileCompras"], array("prov"=>$prov,"nit"=>$nit,"fecha"=>$fecha,"mes"=>$mes,"ano"=>$ano,"serie"=>$serie,"factura"=>$factura,"monto"=>$monto,"montoe"=>$montoe,"iva"=>$iva,"ctacar"=>$ctacar,"ctacomp"=>$ctacomp,"ctaexen"=>$ctaexen,"flagb"=>$flagb,"flags"=>$flags,"flagp"=>$flagp,"flagc"=>$flagc,"galos"=>$galos,"galor"=>$galor,"galod"=>$galod,"obs"=>$obs,"banco"=>$banco,"cheque"=>$cheque)); //,"gravado"=>$gravado,"cbexen"=>$cbExen));

		$j++;
	}    

    $resp["ctaRisr"] = $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtarisr"],0,0));
	$db->close();

	$resp["nombre"] = $nom;
	//return $func->jsonEncodeArray($resp, 'ctaRisr');
	return json_encode($resp);

}

?>