<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$numNum=$_GET["numNum"];
$dtDel=$_GET["dtDel"];
$dtAl=$_GET["dtAl"];

$lineWidth=20;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtDel, $dtAl, $numNum;
        $this->SetMargins(2, 1, 1);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",13);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo()."                             ",0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Reporte de Anticipos a planilla"),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Correpondiente a la planilla No. ".$numNum."  Del ".strftime("%d/%m/%Y", strtotime($dtDel))." al ".strftime("%d/%m/%Y", strtotime($dtAl))),0,1,"L");

        $this->Ln();
        $this->SetFont("","",9);
        $header = array("Codigo","Nombre Empleado","Dias/Trab","Anticipo");
        $this->SetFont("","B");
        $this->SetWidths(array(2,8,3,3));
        $this->SetAligns(array("C","C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("L","L","R","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sAnti = "SELECT *, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
                TRIM(gru.gru_nom) AS gru_nom, TRIM(dep.dep_nom) AS dep_nom
                FROM antipla ant
                LEFT JOIN maestro mae ON ant.ant_emp=mae.mae_emp AND ant.ant_cod = mae.mae_cod 
                LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
                LEFT JOIN grupo gru ON mae.mae_emp=gru.gru_emp AND mae.mae_gru = gru.gru_cod 
                LEFT JOIN dep dep ON mae.mae_emp=dep.dep_emp AND mae.mae_dep = dep.dep_cod 
                WHERE ant_emp='$empCod' AND ant_numpla='$numNum' ORDER BY ant_emp,mae_gru,mae_dep,ant_cod";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["antipla"] = $db->query($sAnti);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();
$grupop=99999;
$depp=99999;
$t_lini=1;
$subdep=0;
$totdep=0;
while ($rec = $db->fetchAssoc($select["antipla"])) {
    if (($rec["mae_gru"].$rec["mae_dep"]) != ($grupop.$depp)) {
        if ($t_lini > 1) {
          $pdf->line($pdf->GetX()+0, $pdf->GetY(), 18.1, $pdf->GetY());
          $body = array(
                "",
                "          SUBTOTAL DE ESTE DEPARTAMENTO ",
                "",
                number_format($subdep, 2, '.', ','),
            ); 
            $pdf->RowBorderHidden($body, $lineHeight);
            $subdep=0;
            $pdf->line($pdf->GetX()+0, $pdf->GetY(), 18.1, $pdf->GetY());
        }   
       $pdf->Cell($lineWidth,.7, "GRUPO Y DEPARTAMENTO: ".$rec["gru_nom"].", ".$rec["dep_nom"],0,0,"L");
       $grupop=$rec["mae_gru"];
       $depp=$rec["mae_dep"];
       $pdf->ln();
       $t_lini=2;
    }
    $body = array(
        $rec["ant_cod"],
        trim($rec["mae_nom"]." ".$rec["mae_ape"]),
        number_format($rec["ant_dtra"], 2, '.', ','),
        number_format($rec["ant_sord"], 2, '.', ','),
    );
    $subdep+=$rec["ant_sord"];
    $totdep+=$rec["ant_sord"];    
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 18.1, $pdf->GetY());
$body = array(
    "",
    "          SUBTOTAL DE ESTE DEPARTAMENTO ",
    "",
    number_format($subdep, 2, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$subdep=0;
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 18.1, $pdf->GetY());
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 18.1, $pdf->GetY());
$body = array(
    "",
    "          TOTAL GENERAL ",
    "",
    number_format($totdep, 2, '.', ','),
); 
$pdf->RowBorderHidden($body, $lineHeight);
$subdep=0;
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 18.1, $pdf->GetY());

$pdf->Ln(2);
$pdf->Cell($lineWidth,.7, "Vo.Bo __________________________                            Hecho Por: _________________________",0,1,"L");



$pdf->Output(utf8_decode("Anticipos").".pdf","I");
?>