<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$bitForm = "ban1010";
$bitMod = "ban";
$empCod = $_SESSION['empCod'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultar':
		echo consultar();
		break;

	case 'consultarCorr':
		echo consultarCorr();
		break;
	case 'consultarCorrPol':
		echo consultarCorrPol();
		break;
	case 'consultarCta':
		echo consultarCta();
		break;
		
	case 'mCerrado':
		echo mCerrado();
		break;

	case 'generarPartida':
		echo generarPartida();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'anugrabar':
		echo anugrabar();
		break;

	case 'anular':
		echo anular();
		break;

	case 'borrar':
		echo borrar();
		break;
}

function consultar() {
	global $empCod, $usuNom;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$tipoCod="004";
	$numNum=$_POST['numNum'];
	$selBanCod=$_POST['selBanCod'];

	# QUERYS
	$sCheques = "SELECT * FROM cheques WHERE ch_emp='$empCod' AND ch_ban='$selBanCod' AND ch_tipo='$tipoCod' AND ch_num='$numNum'";
	$sPoli_det = "SELECT *, TRIM(pold_cta) AS pold_cta FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$tipoCod' AND pold_num='$numNum'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCheques, "cheques");
	$resp["poli_det"] = $db->sFetchAll($sPoli_det);
	$resp["bene"] = str_replace('?',"'",($db->sFetchAssoc($sCheques)["ch_bene"]));
	$db->close();

	$func = new functions();
	//$resp["asdf"]=$sPoli_det;
	//return $func->jsonEncodeArrayEach($resp, array('cheques', 'poli_det'));
	return $func->jsonEncodeArray($resp, 'cheques');
}

function consultarCorr() {
	global $empCod, $usuNom;

	$func = new functions();
	$selBanCod=$_POST['selBanCod'];
	# QUERYS
	$sBancos = "SELECT ban_mon,ban_corr FROM bancos WHERE ban_emp='$empCod' AND ban_num='$selBanCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["bancos"] = $db->sFetchAssoc($sBancos);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "bancos");
}

function consultarCorrPol() {
	global $empCod, $usuNom;

	$func = new functions();
	$anuselTipo=$_POST['anuselTipo'];
	# QUERYS
	$sCorrpol = "SELECT cp_num FROM corrpol WHERE cp_emp='$empCod' AND cp_tipo='$anuselTipo'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["corrpol"] = $db->sFetchAssoc($sCorrpol);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "corrpol");
}

function mCerrado() {
	global $empCod, $usuNom;

	$func = new functions();
	$dtFec=$_POST['dtFec'];
	$nAnio=date("Y", strtotime($dtFec));
	$nMes=date("n", strtotime($dtFec));

	# QUERYS
	$sCiemes = "SELECT ciem_stat FROM ciemes WHERE ciem_emp='$empCod' AND ciem_ano=$nAnio AND ciem_mes=$nMes";
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["ciemes"] = $db->sfetchAssoc($sCiemes);
	$db->close();
	$func = new functions();
	return $func->jsonEncodeArray($resp, "ciemes");
}

function consultarCta() {
	global $empCod;
	$txtCod=utf8_decode($_POST['txtCod']);

	# QUERYS
	$sCuentas = "SELECT c.*, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas c WHERE cta='$txtCod' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function guardar() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod;

	$func = new functions();

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv']) && !$func->stringToBool($_POST['nuevo'])) {
		return json_encode($priv->rErrorModify());
	}

	$numNum=$_POST['numNum'];
	$nuevocorr=$numNum+1;
	$selTipoCod="004";
	$selBanCod=$_POST['selBanCod'];
	$dtFec=$_POST['dtFec'];
	$cbNego=($func->stringToBool($_POST['cbNego'])) ? "N" : "S";
	$numTcam=$_POST['numTcam'];	
	$numTot=$_POST['numTot'];	
	$totant=$_POST['totant'];	

	$txtBene=utf8_decode($_POST['txtBene']);
	$txtBene=str_replace("'","?",$txtBene);
	$txtBene=str_replace("’","?",$txtBene);

	$txtCon=utf8_decode($_POST['txtCon']);
	$jsonPol=json_decode($_POST['tblPol']);
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));
	$dtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));
    $totQ = round($numTot*$numTcam,2);

	# QUERYS PARA UN REGISTRO
	$sBancos = "SELECT ban_ctac,ban_corr FROM bancos WHERE ban_emp='$empCod' AND ban_num='$selBanCod'";

	$sSaldob = "SELECT * FROM saldob WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";

	$iCheques = "INSERT INTO cheques(ch_emp, ch_tipo, ch_ban, ch_num, ch_fec, ch_tot, ch_tcam, ch_bene, ch_con, ch_nego, ch_ulcam) VALUES ('$empCod','$selTipoCod','$selBanCod','$numNum','$dtFec','$numTot','$numTcam','$txtBene','$txtCon','$cbNego','$usuNom')";

	$uCheques = "UPDATE cheques SET ch_fec='$dtFec', ch_tcam='$numTcam', ch_tot='$numTot', ch_bene='$txtBene', ch_nego='$cbNego', ch_con='$txtCon', ch_ulcam='$usuNom' WHERE ch_emp='$empCod' AND ch_ban='$selBanCod' AND ch_tipo='$selTipoCod' AND ch_num='$numNum'";

	$iMovAcu = "INSERT INTO mov_acu(ma_emp, ma_tipo, ma_ban, ma_num, ma_fec, ma_haber, ma_bene, ma_con, ma_stat) VALUES ('$empCod','$selTipoCod','$selBanCod','$numNum','$dtFec','$numTot','$txtBene','$txtCon','C')";

	$uMovAcu = "UPDATE mov_acu SET ma_fec='$dtFec', ma_haber='$numTot', ma_bene='$txtBene', ma_con='$txtCon'  WHERE ma_emp='$empCod' AND ma_ban='$selBanCod' AND ma_tipo='$selTipoCod' AND ma_num='$numNum'";

	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_con, pol_ulcam, pol_grabado) VALUES ('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$txtCon','$usuNom','$dtGrabado')";

	$uPolizas = "UPDATE polizas SET pol_fec='$dtFec', pol_con='$txtCon', pol_ulcam='$usuNom', pol_grabado='$dtGrabado' WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";

	$uBancos = "UPDATE bancos SET ban_corr=$nuevocorr WHERE ban_emp='$empCod' AND ban_num='$selBanCod'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$numAnio,$numMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	function uSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "UPDATE saldob SET salb_saldo=$nvalor WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";
	}

	function iSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "INSERT INTO saldob(salb_emp, salb_num, salb_saldo) VALUES('$empCod','$selBanCod',$nvalor)";
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_cta, pold_ctan, pold_debe, pold_haber) VALUES ";
	foreach ($jsonPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$dtFec','$selBanCod','$selTipoCod','$numNum','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber')".$func->addValues($obj, $jsonPol);
	}

	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum'";

	# EJECUCION DE QUERYS 
	$db = new dbExec();

	// Revisa si hay algun problema en la partida, para ver si permite grabar o no
	$probpol1="X";
	$probpol2="A";	
	$probpol3="A";	
	$select["bancos"] = $db->query($sBancos);
	$fetchAssoc["bancos"] = $db->fetchAssoc($select["bancos"]);		
	$ctaBanco = trim($fetchAssoc["bancos"]["ban_ctac"]);
	$actcorr = $fetchAssoc["bancos"]["ban_corr"];
	foreach ($jsonPol as $obj) {
		$ctapol = trim($obj->cta);
		$haber = trim($obj->haber);

		$select["cuentas"] = $db->query(sCuentas($ctapol));
		$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
		//$ctaC = trim($fetchAssoc["cuentas"]["cta"]);
		if ($db->numRows($select["cuentas"]) == 0) {
			$probpol1 = "A";
		}
		if ($ctapol == $ctaBanco) {
			$probpol2 = "X";
		}
		if ($ctapol == $ctaBanco && $totQ == $haber) {
			$probpol3 = "X";
		}
	}
	//

	if ($probpol1 == "X" && $probpol2 == "X" && $probpol3 == "X") {
		#Para Actualizar el saldo del banco
		$select["saldob"] = $db->query($sSaldob);
		if ($db->numRows($select["saldob"]) == 0) {
			$vSaldo = 0;
			$nvalor = ($vSaldo - $numTot);
			$db->query(iSaldob($nvalor));
		} else {
			$fetchAssoc["saldob"] = $db->fetchAssoc($select["saldob"]);		
			$vSaldo = $fetchAssoc["saldob"]["salb_saldo"];
			$nvalor = ($vSaldo+$totant) - $numTot;
			$db->query(uSaldob($nvalor));
		}		
		//
		if ($func->stringToBool($_POST['nuevo'])) {
			if ($numNum == $actcorr || $numNum > $actcorr) {
				$nuevocorr = $numNum+1;
				$resp = $db->uEx($uBancos);
			}		
			$resp = $db->iEx($iCheques);
			$resp = $db->iEx($iMovAcu);
			$db->iEx($func->iBitacora(utf8_decode("Se creó Cheque No.: $numNum  Banco: $selBanCod Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		} else {
			$resp = $db->uEx($uCheques);
			$resp = $db->iEx($uMovAcu);
			$db->iEx($func->iBitacora(utf8_decode("Se modificó Cheque No.: $numNum  Banco: $selBanCod Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));
		}

		$db->dEx($dPolizas);
		$db->dEx($iPolizas);

		$db->dEx($dPoli_det);
		if (!$func->jsonEmpty($jsonPol)) {
			$db->iEx($iPoli_det);
		}

		// PARA REVERTIR LOS CIERRES
		foreach ($jsonPolAnt as $obj) {
			$cta = $obj->pold_cta;
			$numAnioAnt=date("Y", strtotime($obj->pold_fec));
			$numMesAnt=date("n", strtotime($obj->pold_fec));

			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

				$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

				$cta = $ctaActa;
			}
		}

		// PARA APLICAR LOS CIERRES
		foreach ($jsonPol as $obj) {
			$cta = $obj->cta;
			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $numAnio, $numMes));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

					$db->query(uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
				} else {
					$mdebe=$obj->debe;
					$mhaber=$obj->haber;
					$db->query(iCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}

		}
	}

	$db->close();
	
	$resp["dtGrabado"]=$dtGrabado;
	$resp["probpol1"]=$probpol1;
	$resp["probpol2"]=$probpol2;
	$resp["probpol3"]=$probpol3;
	return json_encode($resp);
}

function borrar() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod;

	$func = new functions();

	$numNum=$_POST['numNum'];
	$selTipoCod="004";
	$totant=$_POST['totant'];	
	$selBanCod=$_POST['selBanCod'];
	$dtFec=$_POST['dtFec'];
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));

	# QUERYS
	$sSaldob = "SELECT * FROM saldob WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";

	$dCheques = "DELETE FROM cheques WHERE ch_emp='$empCod' AND ch_ban='$selBanCod' AND ch_tipo='$selTipoCod' AND ch_num='$numNum'";

	$dMovAcu = "DELETE FROM mov_acu WHERE ma_emp='$empCod' AND ma_ban='$selBanCod' AND ma_tipo='$selTipoCod' AND ma_num='$numNum'";

	$dPolizas = "DELETE FROM polizas WHERE pol_emp='$empCod' AND  pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "UPDATE saldob SET salb_saldo=$nvalor WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";
	}

	function iSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "INSERT INTO saldob(salb_emp, salb_num, salb_saldo) VALUES('$empCod','$selBanCod',$nvalor)";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	$resp = $db->dEx($dPolizas);
	$db->dEx($dCheques);
	$db->dEx($dMovAcu);
	$db->dEx($dPoli_det);

	// PARA REVERTIR LOS CIERRES
	foreach ($jsonPolAnt as $obj) {
		$cta = $obj->pold_cta;
		$numAnioAnt=date("Y", strtotime($obj->pold_fec));
		$numMesAnt=date("n", strtotime($obj->pold_fec));
		while (!empty($cta)) {
			$select["cuentas"] = $db->query(sCuentas($cta));
			$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

			$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
			$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

			$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
			$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
			$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

			$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

			$cta = $ctaActa;
		}
	}

	#Para Actualizar el saldo del banco
	$select["saldob"] = $db->query($sSaldob);
	if ($db->numRows($select["saldob"]) == 0) {
	} else {
		$fetchAssoc["saldob"] = $db->fetchAssoc($select["saldob"]);		
		$vSaldo = $fetchAssoc["saldob"]["salb_saldo"];
		$nvalor = ($vSaldo+$totant);
		$db->query(uSaldob($nvalor));
	}		
	//


	$db->iEx($func->iBitacora(utf8_decode("Se borró Cheque No.: $numNum Banco: $selBanCod Fecha: $dtFec Usuario: ").$usuNom, $bitMod, $bitForm));

	$db->close();

	return json_encode($resp);
}
function anular() {
	global $empCod, $usuNom, $bitMod, $bitForm, $selBanCod;

	$func = new functions();

	$numNum=$_POST['numNum'];
	$selTipoCod="004";
	$selBanCod=$_POST['selBanCod'];
	$totant=$_POST['totant'];	
	$dtFec=$_POST['dtFec'];
	$dtFecAnu=$_POST['dtFecAnu'];
	$jsonPolAnt=json_decode($_POST['tblPolAnt']);
	$numAnio=date("Y", strtotime($dtFec));
	$numMes=date("n", strtotime($dtFec));
	$numAnioAnt=date("Y", strtotime($dtFec));
	$numMesAnt=date("n", strtotime($dtFec));
	$numAnioAnu=date("Y", strtotime($dtFecAnu));
	$numMesAnu=date("n", strtotime($dtFecAnu));
	$Anulado="**** ANULADO ****";
	$txtConAnu=$_POST['txtConAnu'];	
	$valAnu=0.00;
	# QUERYS
	$sSaldob = "SELECT * FROM saldob WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";

	$uCheques = "UPDATE cheques SET ch_tot=$valAnu, ch_bene='$Anulado', ch_con='$txtConAnu', ch_fecanu='$dtFecAnu' WHERE ch_emp='$empCod' AND ch_ban='$selBanCod' AND ch_tipo='$selTipoCod' AND ch_num='$numNum'";

	$uMovAcu = "UPDATE mov_acu SET ma_debe=$valAnu, ma_haber=$valAnu, ma_bene='$Anulado', ma_con='$txtConAnu', ma_stat='A' WHERE ma_emp='$empCod' AND ma_ban='$selBanCod' AND ma_tipo='$selTipoCod' AND ma_num='$numNum'";

	$uPolizas = "UPDATE polizas SET pol_con='$txtConAnu' WHERE pol_emp='$empCod' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";

	$uPoli_det = "UPDATE poli_det SET pold_debe=$valAnu, pold_haber=$valAnu WHERE pold_emp='$empCod' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $numAnio, $numMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$numAnio AND cie_mes=$numMes AND cie_cta='$cta'";
	}

	function uSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "UPDATE saldob SET salb_saldo=$nvalor WHERE salb_emp='$empCod' AND salb_num='$selBanCod'";
	}

	function iSaldob($nvalor) { 
		global $empCod, $usuNom, $selBanCod;
		return "INSERT INTO saldob(salb_emp, salb_num, salb_saldo) VALUES('$empCod','$selBanCod',$nvalor)";
	}

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	$resp = $db->uEx($uCheques);
	$db->uEx($uMovAcu);
    
	// PARA ANULAR PARTIDA Y REVERTIR CIERRES SOLO SI ES EL MISMO MES DE LA ANULACION
	if ($numAnio == $numAnioAnu && $numMes == $numMesAnu) { 
		$resp = $db->anEx($uPolizas);
		$db->uEx($uPoli_det);
		// PARA REVERTIR LOS CIERRES
		foreach ($jsonPolAnt as $obj) {
			$cta = $obj->pold_cta;
			$numAnioAnt=date("Y", strtotime($obj->pold_fec));
			$numMesAnt=date("n", strtotime($obj->pold_fec));
			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $numAnioAnt, $numMesAnt));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

				$db->query(uCierres($cta, $numAnioAnt, $numMesAnt, $mdebe, $mhaber));

				$cta = $ctaActa;
			}
		}
		$resp['otromes']=false;
	} else {
		$resp['otromes']=true;	
	}

	#Para Actualizar el saldo del banco
	$select["saldob"] = $db->query($sSaldob);
	if ($db->numRows($select["saldob"]) == 0) {
	} else {
		$fetchAssoc["saldob"] = $db->fetchAssoc($select["saldob"]);		
		$vSaldo = $fetchAssoc["saldob"]["salb_saldo"];
		$nvalor = ($vSaldo+$totant);
		$db->query(uSaldob($nvalor));
	}		
	//
	$db->iEx($func->iBitacora(utf8_decode("Se Anulo Cheque No.: $numNum Banco: $selBanCod Fecha Anulacion: $dtFecAnu Usuario: ").$usuNom, $bitMod, $bitForm));

	$db->close();

	return json_encode($resp);
}

function anugrabar() {
	global $empCod, $usuNom, $bitMod, $bitForm;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$anunumNum=$_POST['anunumNum'];
	$anuselTipoCod=$_POST['anuselTipoCod'];
	$anuselBanCod=$_POST['anuselBanCod'];
	$anudtFec=$_POST['anudtFec'];
	$anutxtCon=utf8_decode($_POST['anutxtCon']);
	$jsonanuPol=json_decode($_POST['anutblPol']);
	$anunumAnio=date("Y", strtotime($anudtFec));
	$anunumMes=date("n", strtotime($anudtFec));
	$anudtGrabado=date("Y-m-d H:i:s", STRTOTIME(date('h:i:sa')));

	# QUERYS PARA UN REGISTRO
	$iPolizas = "INSERT INTO polizas(pol_emp, pol_fec, pol_ban, pol_tipo, pol_num, pol_con, pol_ulcam, pol_grabado) VALUES ('$empCod','$anudtFec','$anuselBanCod','$anuselTipoCod','$anunumNum','$anutxtCon','$usuNom','$anudtGrabado')";

	$sPolizas = "SELECT pol_emp,pol_tipo,pol_ban,pol_num,pol_fec FROM polizas WHERE pol_emp='$empCod' AND pol_fec='$anudtFec' AND pol_ban='$anuselBanCod' AND pol_tipo='$anuselTipoCod' AND pol_num='$anunumNum'";

	function sCuentas($cta) { 
		global $empCod;
		return "SELECT * FROM cuentas WHERE cta_emp='$empCod' AND cta='$cta'";
	}

	function sCierres($cta, $anunumAnio, $anunumMes) { 
		global $empCod;
		return "SELECT * FROM cierres WHERE cie_emp='$empCod' AND cie_ano=$anunumAnio AND cie_mes=$anunumMes AND cie_cta='$cta'";
	}

	function uCierres($cta, $anunumAnio, $anunumMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "UPDATE cierres SET cie_mdebe=$mdebe, cie_mhaber=$mhaber, cie_ulcam='$usuNom' WHERE cie_emp='$empCod' AND cie_ano=$anunumAnio AND cie_mes=$anunumMes AND cie_cta='$cta'";
	}

	function iCierres($cta, $anunumAnio, $anunumMes, $mdebe, $mhaber) { 
		global $empCod, $usuNom;
		return "INSERT INTO cierres(cie_emp, cie_ano, cie_mes, cie_cta, cie_mdebe, cie_mhaber, cie_ulcam) VALUES('$empCod',$anunumAnio,$anunumMes,'$cta',$mdebe,$mhaber,'$usuNom')";	    
	}

	# QUERYS PARA VARIOS REGISTROS
	$iPoli_det = "INSERT INTO poli_det (pold_emp, pold_fec, pold_ban, pold_tipo, pold_num, pold_cta, pold_ctan, pold_debe, pold_haber) VALUES ";
	foreach ($jsonanuPol as $obj) {
		$obj->cta = utf8_decode($obj->cta);
		$obj->ctaNom = utf8_decode($obj->ctaNom);
		$iPoli_det = $iPoli_det."('$empCod','$anudtFec','$anuselBanCod','$anuselTipoCod','$anunumNum','$obj->cta','$obj->ctaNom','$obj->debe','$obj->haber')".$func->addValues($obj, $jsonanuPol);
	} 

	$dPoli_det = "DELETE FROM poli_det WHERE pold_emp='$empCod' AND pold_fec='$anudtFec' AND pold_ban='$anuselBanCod' AND pold_tipo='$anuselTipoCod' AND pold_num='$anunumNum'";

	# EJECUCION DE QUERYS 
	$db = new dbExec();

    # Para poner avisos, si la variable error es verdadero lo mostrara.
	$resp['msgWarning'] = array(
		'error'=>false,
	);

	// Verifica si ya fue grabada la poliza
	$select["polizas"] = $db->query($sPolizas);
	if ($db->numRows($select["polizas"]) == 0) {
		$resp = $db->iEx($iPolizas);
		$db->iEx($func->iBitacora(utf8_decode("Se creó póliza No.: $anunumNum Tipo: $anuselTipoCod Banco: $anuselBanCod Fecha: $anudtFec Usuario: ").$usuNom, $bitMod, $bitForm));

		$db->dEx($dPoli_det);
		if (!$func->jsonEmpty($jsonanuPol)) {
			$db->iEx($iPoli_det);
		}

		/* // PARA REVERTIR LOS CIERRES
		foreach ($jsonanuPol as $obj) {
			$cta = $obj->pold_cta;
			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $numAnio, $numMes));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
				$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]-$obj->pold_debe;
				$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]-$obj->pold_haber;

				$db->query(uCierres($cta, $numAnio, $numMes, $mdebe, $mhaber));

				$cta = $ctaActa;
			}
		} */

		// PARA APLICAR LOS CIERRES
		foreach ($jsonanuPol as $obj) {
			$cta = $obj->cta;
			while (!empty($cta)) {
				$select["cuentas"] = $db->query(sCuentas($cta));
				$select["cierres"] = $db->query(sCierres($cta, $anunumAnio, $anunumMes));

				$fetchAssoc["cuentas"] = $db->fetchAssoc($select["cuentas"]);
				$ctaActa = trim($fetchAssoc["cuentas"]["cta_acta"]);

				if ($db->numRows($select["cierres"]) > 0) {
					$fetchAssoc["cierres"] = $db->fetchAssoc($select["cierres"]);
					$mdebe=$fetchAssoc["cierres"]["cie_mdebe"]+$obj->debe;
					$mhaber=$fetchAssoc["cierres"]["cie_mhaber"]+$obj->haber;

					$db->query(uCierres($cta, $anunumAnio, $anunumMes, $mdebe, $mhaber));
				} else {
					$mdebe=$obj->debe;
					$mhaber=$obj->haber;

					$db->query(iCierres($cta, $anunumAnio, $anunumMes, $mdebe, $mhaber));
				}
				$cta = $ctaActa;
			}
		} 
		$resp['msgWarning'] = array(
		'error'=>true,
		'msg'=>array(
			'title'=>'POLIZA REGISTRADA',
			'text'=>'Se registro la poliza que revierte la partida del cheque, por ser de otro mes'
			),
		); 
	} else {
		$resp['msgWarning'] = array(
		'error'=>true,
		'msg'=>array(
			'title'=>'POLIZA YA EXISTE',
			'text'=>'La poliza que quiere registrar ya esta grabada, intente con otro numero'
			),
		); 
	}

	$db->close();
	return json_encode($resp);
}

function generarPartida() {
	global $empCod, $empCtaic;
	$cta=$_POST['cta'];
	$selBanCod=$_POST['selBanCod'];
	$numChequei=$_POST['numChequei'];

	$func = new functions();

	# QUERYS
	/*function sCuentas($cta,$debe,$haber) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom, $debe AS cta_debe, $haber AS cta_haber
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}*/
	function sCuentas($cta,$valor) {
		global $empCod;
		return "SELECT TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom, $valor AS cta_valor
				FROM cuentas c WHERE cta='$cta' AND cta_emp='$empCod'";
	}

    $sIva_comp="SELECT
					iva_iva, iva_ret, iva_reti, iva_dedu, iva_tasam, 
					TRIM(iva_cta1) AS iva_cta1,
					TRIM(iva_cta2) AS iva_cta2, 
					TRIM(iva_cta3) AS iva_cta3, 
					TRIM(iva_cta4) AS iva_cta4,
					iva_ctav1,
					iva_ctav2,
					iva_ctav3,
					iva_ctav4
				FROM iva_comp WHERE iva_emp='$empCod' AND iva_ban='$selBanCod' AND iva_cheque='$numChequei'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	// Para la cuenta de Bancos
	$resp["ctaBanc"] = ($cta=="") ? "" : $db->sFetchAssoc(sCuentas((string)$cta,0,0));

	// Para las cuentas de gastos si se grabaron facturas de compras
	// Para la cuenta de Inventarios
	$arrayCtaComp = array(
		array('cta' => 'iva_cta1', 'valor' => 'iva_ctav1'),
		array('cta' => 'iva_cta2', 'valor' => 'iva_ctav2'),
		array('cta' => 'iva_cta3', 'valor' => 'iva_ctav3'),
		array('cta' => 'iva_cta4', 'valor' => 'iva_ctav4')
	);
	$arrayIva_comp = $db->sFetchAll($sIva_comp);
	$ret=0;
	$reti=0;
	$iva=0;
	$dedu=0;
	$tasam=0;
	$hayFac = (sizeof($arrayIva_comp) != 0) ? 'S' : 'N';
	$resp["ctaGasto"]=array();
	$j=0;
	foreach ($arrayIva_comp as $rec) {
		$iva+=$rec["iva_iva"];
		$ret+=$rec["iva_ret"];
		$reti+=$rec["iva_reti"];
		$dedu+=$rec["iva_dedu"];
		$tasam+=$rec["iva_tasam"];
		foreach ($arrayCtaComp as $recCta) {
			if ($rec[$recCta["cta"]]!="" && $rec[$recCta["valor"]]!=0) {
				$i = $func->multiSearch($resp["ctaGasto"], array('cta' => (string)$rec[$recCta["cta"]]));
				if ($i >= 0) {
					$resp["ctaGasto"][$i]["cta_valor"] += $arrayIva_comp[$j][$recCta["valor"]];
				} else {
					$fa["ctaGasto"] = $db->sFetchAssoc(sCuentas((string)$rec[$recCta["cta"]],$rec[$recCta["valor"]]));
				    array_push($resp["ctaGasto"], array("cta"=>$rec[$recCta["cta"]],"cta_nom"=>$fa["ctaGasto"]["cta_nom"],"cta_valor"=>$rec[$recCta["valor"]]));
				}
			}
		}

		unset($arrayIva_comp[$j]);
		$j++;
	}
    $resp["ctaRisr"] = $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtarisr"],$ret,0));
    $resp["ctaRiva"] = $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtariva"],$reti,0));
    $resp["ctaComb"] = $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtacomb"],$dedu,0));
    $resp["ctaIva"] = $db->sFetchAssoc(sCuentas((string)$_SESSION["empCtaic"],$iva,0));
	$db->close();

	$resp["hayFac"]=$hayFac;
	return $func->jsonEncodeArray($resp, 'ctaBanc');
}

?>