<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$dtFecI=$_GET["dtFecI"];
$dtFecF=$_GET["dtFecF"];
$selBanCod=$_GET["selBanCod"];
$selBanNom=$_GET["selBanNom"];
$selTipoCod=$_GET["selTipoCod"];
$selTipoNom=$_GET["selTipoNom"];

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFecI, $dtFecF, $selBanCod, $selBanNom, $selTipoNom, $selTipoCod;
        $this->SetMargins(1.5, 1, 2.5);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",13);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");
        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",12);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de documentos emitidos Del ".strftime("%d/%m/%Y", strtotime($dtFecI))." al ".strftime("%d/%m/%Y", strtotime($dtFecF))),0,1,"L");
//        $this->Ln();
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Cuenta: ".$selBanNom),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Tipo de Documento: ".$selTipoNom),0,1,"L");

//        $this->Ln(); 

        $header = array("Numero","Fecha","Concepto","Valor");
        $this->SetFont("","B",8);
        $this->SetWidths(array(2,2,11.5,2.5));
        $this->SetAligns(array("C","C","C","C"));
        $this->Row($header, $lineHeight); 

        $this->SetFont("");
        $this->SetAligns(array("L","C","L","R")); 
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sMovi = "SELECT *, TRIM(mov_con) AS mov_con FROM movi 
            WHERE mov_emp='$empCod' AND mov_tipo='$selTipoCod' AND mov_ban='$selBanCod' AND mov_fec>='$dtFecI' AND mov_fec<='$dtFecF' ORDER BY mov_fec";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["movi"] = $db->query($sMovi);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();
$lineHeight=0.4;
$valtot=0;
while ($rec = $db->fetchAssoc($select["movi"])) {
    $valtot += $rec["mov_tot"];
    $body = array(
        $rec["mov_num"],
        strftime("%d/%m/%Y", strtotime($rec["mov_fec"])),
        utf8_encode($rec["mov_con"]),
        number_format($rec["mov_tot"],2),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->SetAligns(array("","","R","R"));
$body = array(
    "",
    "",
    "Total: ",
    number_format($valtot,2),
);
$pdf->line($pdf->GetX()+14, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->RowBorderHidden($body, $lineHeight);

$pdf->line($pdf->GetX()+14, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->line($pdf->GetX()+14, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075); 

$pdf->Output(utf8_decode("Listado Documentos por Fecha").".pdf","I");
?>