<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);

$dtFecI=$_GET["dtFecI"];
$dtFecF=$_GET["dtFecF"];
$selBan=$_GET["selBan"];

$lineWidth=19.3;
$lineHeight=0.35;

# QUERYS
$sMovAcu0 = "SELECT ma_emp,ma_ban,
            SUM(ma_debe) AS ma_sdebe, 
            SUM(ma_haber) AS ma_shaber 
            FROM mov_acu WHERE ma_emp='$empCod' AND ma_ban='$selBan' AND ma_fec>='$dtFecI' GROUP BY '$empCod','$selBan'";

$sMovAcu = "SELECT *,
            TRIM(ma_bene) AS ma_bene,
            TRIM(ma_con) AS ma_con 
            FROM mov_acu LEFT JOIN tipopol ON mov_acu.ma_tipo=tipopol.tp_cod WHERE ma_emp='$empCod' AND ma_ban='$selBan' AND ma_fec>='$dtFecI' AND ma_fec<='$dtFecF' ORDER BY ma_fec,ma_tipo";
    
$sSaldob = "SELECT * FROM saldob WHERE salb_emp='$empCod' AND salb_num=$selBan";

$sBancos = "SELECT *,
            TRIM(ban_nom) AS ban_nom,
            TRIM(ban_ctab) AS ban_ctab 
            FROM bancos WHERE ban_emp='$empCod' AND ban_num=$selBan";

# EJECUCION DE QUERYS
$db = new dbExec();

$select["mov_acu"] = $db->query($sMovAcu0);
$recma0 = $db->fetchAssoc($select['mov_acu']);
$sDebemov=$recma0["ma_sdebe"];
$sHabermov=$recma0["ma_shaber"];

$select["bancos"]=$db->query($sBancos);
$recban = $db->fetchAssoc($select['bancos']);
$banNom=$recban["ban_nom"];
$banCtab=$recban["ban_ctab"];

$select["saldob"]=$db->query($sSaldob);
$recsal = $db->fetchAssoc($select['saldob']);
$Saldo=$recsal["salb_saldo"];

$salIni=($Saldo-$sDebemov)+$sHabermov;
$Saldo=0;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth,$dtFecI, $dtFecF, $selBan,$salIni,$Saldo,$banNom,$banCtab;
        $func = new functions();
        $this->SetMargins(1.35, 1, 1.35);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNom),0,1,"L");
        $this->SetFont("","I",8);
        $this->SetY(.6);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","B",10);
        $this->Cell($lineWidth, $lineHeight, utf8_decode("MOVIMIENTOS DEL ".strftime("%d/%m/%Y", strtotime($dtFecI))." AL ".strftime("%d/%m/%Y", strtotime($dtFecF))),0,1,"L");
        $this->Cell($lineWidth, $lineHeight, utf8_decode("BANCO: ".$banNom."  CUENTA: ".$banCtab),0,1,"L");
        $this->SetFont("","B",10);
        $this->Cell($lineWidth/1.2, $lineHeight, "Saldo Inicial: ",0,0,"R");
        $this->Cell($lineWidth/6, $lineHeight, number_format($salIni, 2, '.', ','),0,1,"R");

        $this->SetFont("","B",8);        
        $header = array("Tipo","Numero","Fecha","Beneficiario","Concepto","Ingresos","Egresos","Saldo Actual");
        $this->SetFont("","B");
        $this->SetWidths(array(2,2,1.8,6,7,2,2,2));
        $this->SetAligns(array("C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetFont("", "", 7);
        $this->SetAligns(array("L","L","L","L","L","R","R","R"));

    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        $func = new functions();

        $this->SetY(-1.5);
        $this->SetFont("Arial","I",6);
        $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
    }
}

# GENERAR PDF
$pdf = new generatePDF("L","cm", array(22, 28));
$pdf->AddPage();

$debe = 0;
$haber = 0;
$Saldo = $salIni;

$select["mov_acu"] = $db->query($sMovAcu);
while ($rec = $db->fetchAssoc($select['mov_acu'])) {
    $debe += $rec["ma_debe"];
    $haber += $rec["ma_haber"];
    $Saldo = ($Saldo+$rec["ma_debe"])-$rec["ma_haber"];

    $body = array(
        $rec["tp_abrev"],
        $rec["ma_num"],
        strftime("%d/%m/%Y", strtotime($rec["ma_fec"])),
        $rec["ma_bene"],
        $rec["ma_con"],
        (round($rec["ma_debe"],2) != 0) ? number_format($rec["ma_debe"], 2, '.', ',') : "",
        (round($rec["ma_haber"],2) != 0) ? number_format($rec["ma_haber"], 2, '.', ',') : "",
        number_format($Saldo, 2, '.', ','),
        );
     $pdf->RowBorderHidden($body, $lineHeight);
}

$pdf->line($pdf->GetX()+16.5, $pdf->GetY(), 26, $pdf->GetY());

$pdf->SetAligns(array("","","","","C","R","R"));
$body = array("","","","","Totales: ",
    number_format($debe,2, '.', ','),
    number_format($haber,2, '.', ','),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+16.5, $pdf->GetY(), 26, $pdf->GetY());
$pdf->line($pdf->GetX()+16.5, $pdf->GetY()+.075, 26, $pdf->GetY()+.075);

$db->close();

$pdf->Output(utf8_decode("Saldos al Dia").".pdf","I");
?>