<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$dtFecI=$_GET["dtFecI"];
$dtFecF=$_GET["dtFecF"];
$selTipoCod=$_GET["selTipoCod"];

$lineWidth=17;
$lineHeight=0.35;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFecI, $dtFecF;
        $this->SetMargins(2.5, 1, 2.5);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",17);
        $this->Cell($lineWidth,.7,$empNom,0,0,"C");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->Cell($lineWidth, $lineHeight, utf8_decode("Listado de polizas del ".strftime("%d/%m/%Y", strtotime($dtFecI))." al ".strftime("%d/%m/%Y", strtotime($dtFecF))),0,1,"C");
        $this->Ln();
    }
    
    function Footer() {
    }
}

# QUERYS
if ($selTipoCod == "999") {
    $sPolizas = "SELECT * FROM polizas p LEFT JOIN tipopol tp ON p.pol_tipo=tp.tp_cod WHERE pol_emp='$empCod' AND pol_fec>='$dtFecI' AND pol_fec<='$dtFecF'";
} else {
    $sPolizas = "SELECT * FROM polizas p LEFT JOIN tipopol tp ON p.pol_tipo=tp.tp_cod WHERE pol_emp='$empCod' AND pol_fec>='$dtFecI' AND pol_fec<='$dtFecF' AND pol_tipo='$selTipoCod'";
}

function sPoli_det($dtFec, $selBanCod, $selTipoCod, $numNum) {
    global $empCod;
    return "SELECT *,
                TRIM(pold_cta) AS pold_cta,
                TRIM(pold_ctan) AS pold_ctan 
            FROM poli_det WHERE pold_emp='$empCod' AND pold_fec='$dtFec' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum'";
}

# EJECUCION DE QUERYS
$db = new dbExec();
$select["polizas"] = $db->query($sPolizas);

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();

$totDebe = 0;
$totHaber = 0;
while ($rec = $db->fetchAssoc($select['polizas'])) {
    $pdf->SetFont("","B",8);
    $pdf->Cell($lineWidth/8, $lineHeight, utf8_decode("Tipo Poliza: "));
    $pdf->SetFont("");
    $pdf->Cell($lineWidth/5, $lineHeight, $rec["tp_nom"]);

    $pdf->SetFont("","B",8);
    $pdf->Cell($lineWidth/5, $lineHeight, utf8_decode("Número de Póliza: "));
    $pdf->SetFont("");
    $pdf->Cell($lineWidth/5, $lineHeight, $rec["pol_tipo"]."-".$rec["pol_num"]);

    $pdf->SetFont("","B");
    $pdf->Cell($lineWidth/6, $lineHeight, utf8_decode("Fecha de Póliza: "));
    $pdf->SetFont("");
    $pdf->Cell($lineWidth/4, $lineHeight, strftime("%d/%m/%Y", strtotime($rec["pol_fec"])),0,1);

    $pdf->SetFont("","B");
    $pdf->Cell($lineWidth/8, $lineHeight, "Concepto: ");
    $pdf->SetFont("");
    $pdf->MultiCell($lineWidth/1.35, $lineHeight, $rec["pol_con"]);
    $pdf->Ln($lineHeight*3);

    $header = array("Cuenta","Nombre de Cuenta","Debe","Haber");
    $pdf->SetFont("","B");
    $pdf->SetWidths(array(3,8,3,3));
    $pdf->SetAligns(array("C","C","C","C"));
    $pdf->Row($header, $lineHeight);

    $pdf->SetFont("");
    $pdf->SetAligns(array("L","L","R","R"));
    $debe = 0;
    $haber = 0;

    $select["poli_det"] = $db->query(sPoli_det($rec["pol_fec"], $rec["pol_ban"], $rec["pol_tipo"], $rec["pol_num"]));
    
    while ($recTbl = $db->fetchAssoc($select['poli_det'])) {
        $debe += $recTbl["pold_debe"];
        $haber += $recTbl["pold_haber"];
        $body = array(
            $recTbl["pold_cta"],
            $recTbl["pold_ctan"],
            ($recTbl["pold_debe"] != 0) ? number_format($recTbl["pold_debe"],2) : "",
            ($recTbl["pold_haber"] != 0) ? number_format($recTbl["pold_haber"],2) : "",
        );
        $pdf->RowBorderHidden($body, $lineHeight);
    }
    $pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());

    $pdf->SetAligns(array("","R","R","R"));
    $body = array(
        "",
        "Totales del documento: ",
        number_format($debe,2),
        number_format($haber,2),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
    $pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
    $pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);

    $pdf->Ln($lineHeight);

    $totDebe += $debe;
    $totHaber += $haber;
}
$body = array(
    "",
    "Totales Generales: ",
    number_format($totDebe,2),
    number_format($totHaber,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);

$db->close();

$pdf->Output(utf8_decode("Listado de Polizas por Fecha").".pdf","I");
?>