<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');

$bitForm = "usu1010";
$bitMod = "usu";
$empCod = $_SESSION['empCod'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultar':
		echo consultar();
		break;

	case 'consultarCta':
		echo consultarCta();
		break;

	case 'consultarEmp':
		echo consultarEmp();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'borrar':
		echo borrar();
		break;
}

function consultar() {
	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$txtCod=$_POST['txtCod'];

	# QUERYS
	$sEmpresas = "SELECT emp.*,
				TRIM(emp.emp_nom) AS emp_nom,
				TRIM(ctaic.cta_nom) AS emp_ctaicnom,
				TRIM(ctaiv.cta_nom) AS emp_ctaivnom,
				TRIM(ctarisr.cta_nom) AS emp_ctarisrnom,
				TRIM(ctariva.cta_nom) AS emp_ctarivanom,
				TRIM(ctacaj.cta_nom) AS emp_ctacajnom,
				TRIM(ctacomb.cta_nom) AS emp_ctacombnom,
				TRIM(ctaven.cta_nom) AS emp_ctavennom,
				TRIM(ctaserv.cta_nom) AS emp_ctaservnom,
				TRIM(ctaexport.cta_nom) AS emp_ctaexportnom,
				TRIM(conso.emp_nom) AS emp_consonom
				FROM empresas AS emp
				LEFT JOIN cuentas ctaic     ON emp.emp_cod=ctaic.cta_emp AND emp.emp_ctaic=ctaic.cta
				LEFT JOIN cuentas ctaiv     ON emp.emp_cod=ctaiv.cta_emp AND emp.emp_ctaiv=ctaiv.cta
				LEFT JOIN cuentas ctarisr   ON emp.emp_cod=ctarisr.cta_emp AND emp.emp_ctarisr=ctarisr.cta
				LEFT JOIN cuentas ctariva   ON emp.emp_cod=ctariva.cta_emp AND emp.emp_ctariva=ctariva.cta
				LEFT JOIN cuentas ctacaj    ON emp.emp_cod=ctacaj.cta_emp AND emp.emp_ctacaj=ctacaj.cta
				LEFT JOIN cuentas ctacomb   ON emp.emp_cod=ctacomb.cta_emp AND emp.emp_ctacomb=ctacomb.cta
				LEFT JOIN cuentas ctaven    ON emp.emp_cod=ctaven.cta_emp AND emp.emp_ctaven=ctaven.cta
				LEFT JOIN cuentas ctaserv   ON emp.emp_cod=ctaserv.cta_emp AND emp.emp_ctaserv=ctaserv.cta
				LEFT JOIN cuentas ctaexport ON emp.emp_cod=ctaexport.cta_emp AND emp.emp_ctaexport=ctaexport.cta
				LEFT JOIN empresas conso ON emp.emp_conso=conso.emp_cod
				WHERE emp.emp_cod='$txtCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sEmpresas, "empresas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "empresas");
}

function consultarCta() {
	global $empCod;
	$txtCta=$_POST['txtCta'];

	# QUERYS
	$sCuentas = "SELECT *, TRIM(cta) AS cta, TRIM(cta_nom) AS cta_nom
				FROM cuentas WHERE cta='$txtCta' AND cta_emp='$empCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sCuentas, "cuentas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "cuentas");
}

function consultarEmp() {
	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$txtCod=$_POST['txtCod'];

	# QUERYS
	$sEmpresas = "SELECT TRIM(emp.emp_nom) AS emp_nom  
				FROM empresas AS emp
				WHERE emp.emp_cod='$txtCod'";
	
	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sEmpresas, "empresas");
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, "empresas");
}

function guardar() {
	global $empCod, $usuNom, $bitMod, $bitForm;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$txtCod=$_POST['txtCod'];
	$txtNom=utf8_decode($_POST['txtNom']);
	$txtNomc=utf8_decode($_POST['txtNomc']);
	$txtNit=utf8_decode($_POST['txtNit']);
	$dtFinie=$_POST['dtFinie'];
	$dtFciee=$_POST['dtFciee'];
	$dtFtrab=$_POST['dtFtrab'];
	$numTasa=7.8000;
	$txtMoneda=$_POST['txtMoneda'];
	$txtCtaic=$_POST['txtCtaic'];
	$txtCtaiv=$_POST['txtCtaiv'];
	$txtCtarisr=$_POST['txtCtarisr'];
	$txtCtariva=$_POST['txtCtariva'];
	$txtCtacaj=$_POST['txtCtacaj'];
	$txtCtacomb=$_POST['txtCtacomb'];
	$txtCtaven=$_POST['txtCtaven'];
	$txtCtaserv=$_POST['txtCtaserv'];
	$txtCtaexport=$_POST['txtCtaexport'];
	$txtConso=$_POST['txtConso'];
	$cbPequesn=($func->stringToBool($_POST['cbPequesn'])) ? "S" : "N";
	$cbExensn=($func->stringToBool($_POST['cbExensn'])) ? "S" : "N";

	# QUERYS PARA UN REGISTRO
	$iEmpresas = "INSERT INTO empresas(emp_cod, emp_nom, emp_nomc, emp_nit, emp_finie, emp_fciee, emp_ftrab, emp_tasa, emp_ctaic, emp_ctaiv, emp_ctarisr, emp_ctariva, emp_ctacaj, emp_ctacomb, emp_conso, emp_ulcam, emp_exensn,emp_moneda, emp_pequesn, emp_ctaven, emp_ctaserv, emp_ctaexport) VALUES ('$txtCod','$txtNom','$txtNomc','$txtNit','$dtFinie','$dtFciee','$dtFtrab','$numTasa','$txtCtaic','$txtCtaiv','$txtCtarisr','$txtCtariva','$txtCtacaj','$txtCtacomb','$txtConso','$usuNom','$cbExensn','$txtMoneda','$cbPequesn','$txtCtaven','$txtCtaserv','$txtCtaexport')";

	$uEmpresas = "UPDATE empresas SET emp_nom='$txtNom',emp_nomc='$txtNomc',emp_nit='$txtNit',emp_finie='$dtFinie',emp_fciee='$dtFciee',emp_ftrab='$dtFtrab',emp_tasa='$numTasa',emp_ctaic='$txtCtaic',emp_ctaiv='$txtCtaiv',emp_ctarisr='$txtCtarisr',emp_ctariva='$txtCtariva',emp_ctacaj='$txtCtacaj',emp_ctacomb='$txtCtacomb',emp_conso='$txtConso',emp_exensn='$cbExensn',emp_moneda='$txtMoneda',emp_pequesn='$cbPequesn',emp_ctaven='$txtCtaven',emp_ctaserv='$txtCtaserv',emp_ctaexport='$txtCtaexport' WHERE emp_cod='$txtCod'";

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	if ($func->stringToBool($_POST['nuevo'])) {
		$resp = $db->iEx($iEmpresas);
		$db->iEx($func->iBitacora(utf8_decode("Se creó empresa, Empresa: $txtCod Usuario: ").$usuNom, $bitMod, $bitForm));
	} else {
		$resp = $db->uEx($uEmpresas);
		$db->iEx($func->iBitacora(utf8_decode("Se modificó empresa, Empresa: $txtCod Usuario: ").$usuNom, $bitMod, $bitForm));
	}
	$db->close();

   	$_SESSION['empCod'] = $txtCod;
   	$_SESSION['empNom'] = $txtNom;
   	$_SESSION['empFinie'] = $dtFinie;
   	$_SESSION['empFciee'] = $dtFciee;    
   	$_SESSION['empFtrab'] = $dtFtrab;
   	$_SESSION['empNomc'] = $txtNomc;
   	$_SESSION['empConso'] = $txtConso;
   	$_SESSION['empNit'] = $txtNit;
   	$_SESSION['empMoneda'] = $txtMoneda;
   	$_SESSION['empCtaic'] = $txtCtaic;
   	$_SESSION['empCtaiv'] = $txtCtaiv;
   	$_SESSION['empCtarisr'] = $txtCtarisr;
   	$_SESSION['empCtariva'] = $txtCtariva;
   	$_SESSION['empCtacaj'] = $txtCtacaj;
   	$_SESSION['empCtacomb'] = $txtCtacomb;
   	$_SESSION['empCtaven'] = $txtCtaven;
   	$_SESSION['empCtaserv'] = $txtCtaserv;
   	$_SESSION['empCtaexport'] = $txtCtaexport;
   	//$_SESSION['empPrensa'] = $txtPrensa;
   	$_SESSION['empExensn'] = $cbExensn;

	return json_encode($resp);
}

function borrar() {
	global $empCod, $usuNom, $bitMod, $bitForm;

	$func = new functions();

	$txtCod=$_POST['txtCod'];

	# QUERYS
	$dEmpresas = "DELETE FROM empresas WHERE emp_cod='$txtCod'";

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	$resp = $db->dEx($dEmpresas);
	$db->iEx($func->iBitacora(utf8_decode("Se borró empresa, Empresa: $txtCod Usuario: ").$usuNom, $bitMod, $bitForm));
	$db->close();

	return json_encode($resp);
}
?>