<?php
$lineWidth=19.5;
$lineHeight=0.4;

$pdf->AddPage();

// Para anular factura
if ($rec["fact_tot"] == 0) {
    $pdf->SetFont('Arial','B',100);
    $pdf->SetTextColor(255, 144, 144);
    $pdf->SetY(12);
    $pdf->Cell($lineWidth, 1, "ANULADA",0,0,"C");
}

$pdf->SetFont("Arial","B",7);
$pdf->SetTextColor(0,0,0);

$lineHeight7 = .3;
$img = '../img/LOGO_CYNTHIA.jpg';
$pdf->Image($img,.3,.4,4.8,2.8);
$pdf->SetMargins(1, 1, 1);
$pdf->SetY(1);
$pdf->Cell(0, 0, "", 0, 1);
$pdf->Cell($lineWidth/5, $lineHeight7, "");
$pdf->SetFont("Times","BI",15);
$pdf->Cell($lineWidth/3, $lineHeight7+.5, TRIM(SUBSTR($empNom,0,30)),0,1,"C");
$pdf->Cell($lineWidth/5, $lineHeight7, "");
$pdf->SetFont("Times","BI",15);
$pdf->Cell($lineWidth/3, $lineHeight7+.5, TRIM(SUBSTR($empNom,31,30)),0,1,"C");
$pdf->SetFont("Arial","B",9);
$pdf->Cell($lineWidth/5, $lineHeight7, "");
$pdf->Cell($lineWidth/3, $lineHeight7, 'NIT: '.$empNit,0,1,"C");
$pdf->Cell($lineWidth/5, $lineHeight7, "");
$pdf->Cell($lineWidth/3, $lineHeight7, $empNomc,0,1,"C");
$pdf->Cell($lineWidth/5, $lineHeight7, "");
$pdf->MultiAlignCell($lineWidth/3, .3, $empDir,0,1,"C");

$pdf->SetFont("Arial","B",8);
// Derecha
$y = 1.3;
$x = 14;
$pdf->SetY($y);
$pdf->SetX($x);
$pdf->Cell($lineWidth/3,1, "DOCUMENTO TRIBUTARIO ELECTRONICO",0,1,"C");

//if (isset($DocumentGUID)) {
 //   if ($totgen<0) {
      $pdf->SetY($y+=$lineHeight);
      $pdf->SetX($x);
      $pdf->SetFont("Arial","B",13);
      $pdf->Cell($lineWidth/3,1, "NOTA DE CREDITO",0,1,"C");
      $pdf->SetFont("Arial","B",8);
//    }
    $pdf->SetY($y+=$lineHeight);
    $pdf->SetX($x);
    $pdf->Cell($lineWidth/3,1, "NUMERO DE AUTORIZACION:",0,1,"C");
    $pdf->SetY($y+=$lineHeight);
    $pdf->SetX($x);
    $pdf->Cell($lineWidth/3,1, $rec["fact_documentguid"],0,1,"C");
    $pdf->SetY($y+=$lineHeight);
    $pdf->SetX($x);
    $pdf->Cell($lineWidth/3,1, "SERIE: ".$rec["fact_tipo"],0,1,"C");
    $pdf->SetY($y+=$lineHeight);
    $pdf->SetX($x);
    $pdf->Cell($lineWidth/3,1, "NO. ".$rec["fact_num"],0,1,"C");
$pdf->SetY(5);

$pdf->line($pdf->GetX(), $pdf->GetY(), $lineWidth+1, $pdf->GetY());

$pdf->SetY($pdf->GetY()+.25);

$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("NOMBRE:"),0,0,"L");
$pdf->MultiAlignCell($lineWidth/1.5, $lineHeight, utf8_decode($rec["fact_nom"]),0,0,"L");
$pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("FECHA:"),0,0,"L");
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, strftime("%d/%m/%Y", strtotime($rec["fact_fec"])),0,1,"L");
$pdf->Ln();
$pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("DIRECCIÓN:"),0,0,"L");
$pdf->MultiAlignCell($lineWidth/1.5, .3, utf8_decode($rec["fact_dir"]),0,0,"L");
$pdf->MultiAlignCell($lineWidth/10, $lineHeight, utf8_decode("NIT:"),0,0,"L");
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, utf8_decode(str_replace('-','',$rec["fact_nit"])),0,1,"L");

$pdf->SetY($pdf->GetY()+.75);

if ($rec["fact_tcam"] <= 1.00) {
    $tmone="Q";
} else {
    $tmone="$";
}

$header = array("CANTIDAD",utf8_decode("DESCRIPCIÓN"),"PRECIO UNITARIO","VALOR ".$tmone);
$widths = array(1.75,12.5,2.75,2.5);
$pdf->SetWidths($widths);
$pdf->SetAligns(array("C","C","C","C"));
$pdf->Row($header, $lineHeight);

$pdf->SetAligns(array("C","L","R","R"));

// Lineas separadoras del detalle
$detX = 0;
$detY = $pdf->GetY()+13.1;
$pdf->line($pdf->GetX(), $pdf->GetY(), $pdf->GetX(), $detY);
foreach ($widths as $x) {
    $detX+=$x;
    $pdf->line($pdf->GetX()+$detX, $pdf->GetY(), $pdf->GetX()+$detX, $detY);
}

$pdf->Ln();
while ($recDet = $db->fetchAssoc($select["notas_det"])) {
    $body = array(
        ($recDet["factd_cant"] > 0) ? $recDet["factd_cant"] : "",
        utf8_decode($recDet["factd_desc"]),
        ($recDet["factd_preu"] > 0) ? number_format($recDet["factd_preu"],6) : "",
        ($recDet["factd_tot"] > 0) ? number_format($recDet["factd_tot"],2) : ""
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$body = array(
    "",
    "NOTA DE CREDITO APLICADA A FACTURA: SERIE ".$rec["fact_tipof"]." NUMERO: ".$rec["fact_numf"]." DE FECHA: ".strftime("%d/%m/%Y", strtotime($rec["fact_fecf"])).".",
    "",
    ""
);
$pdf->RowBorderHidden($body, $lineHeight);

$pdf->SetY(20.7);

$moneda = ($rec["fact_tcam"]<=1.00) ? "QUETZALES" : utf8_decode("DÓLARES");
$pdf->SetFont("","",6);
$pdf->MultiAlignCell(15.7, $lineHeight, "EN LETRAS: $totLetras $moneda",'TLB',0,"L");
$pdf->SetFont("","",8);
$pdf->Cell(1.3, $lineHeight, "TOTAL:",'TBR',0,"R");
$pdf->Cell(2.5, $lineHeight, number_format($rec["fact_tot"], 2),1,1,"R");

$pdf->Ln();

$pdf->MultiAlignCell($lineWidth/2, $lineHeight, "AUTORIZADO\n\n________________________\nFIRMA",1,0,"C");
$pdf->MultiAlignCell($lineWidth/2, $lineHeight, "CLIENTE\n\n________________________\nRECIBI CONFORME",1,0,"C");

$pdf->Ln(2);

$FechaHoraCertificacion = "";
$NombreCertificador = "";

//if (isset($DocumentGUID) || isset($DocumentGUIDAnulacion)) {
    $DocumentGUID = (isset($rec["fact_documentguid"])) ? $rec["fact_documentguid"] : $DocumentGUIDAnulacion;
    $wsCOFIDI = new wsCOFIDIExec();
    foreach ($wsCOFIDI->sExDocumentGUID($DocumentGUID) as $Body) {
        $ResponseData1 = $Body->RequestTransactionResponse->RequestTransactionResult->ResponseData->ResponseData1;
        $xml = base64_decode($ResponseData1);

        $sxe = new SimpleXMLElement($xml);
        $FechaHoraCertificacion = $sxe->xpath('//dte:FechaHoraCertificacion')[0];
        $NombreCertificador = $sxe->xpath('//dte:NombreCertificador')[0];
    }
//}



$pdf->Cell($lineWidth, .1, "",1,1);
$pdf->Cell($lineWidth, $lineHeight, "DATOS FISCALES",1,1,"C");
$pdf->SetFont("Arial","B");
$pdf->Cell($lineWidth, $lineHeight, utf8_decode("Fecha de certificación: ").$FechaHoraCertificacion,1,1);
$pdf->Cell($lineWidth, $lineHeight, utf8_decode("CERTIFICADOR: ").$NombreCertificador."- NIT:62469045",1,1);
?>