<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$selTipodoci=$_GET["selTipodoci"];
$dtFeci=$_GET["dtFeci"];
$dtFecf=$_GET["dtFecf"];

# QUERYS
if ($selTipodoci=='000') {
    $sDoctose = "SELECT *, TRIM(de.de_obs) AS de_obs, TRIM(td.td_nom) AS td_nom
       FROM doce_det ded LEFT JOIN doctose de ON ded.ded_emp=de.de_emp and ded.ded_tipo=de.de_tipo and ded.ded_num=de.de_num 
       LEFT JOIN tipodoci td ON  ded.ded_tipo=td.td_cod 
       LEFT JOIN serieoc so ON  de.de_serieoc=so.so_cod 
       LEFT JOIN bodegas bod ON  de.de_bodent=bod.bod_cod 
       WHERE ded_emp='$empCod' and ded_fec>='$dtFeci' and ded_fec<='$dtFecf' ORDER BY ded_fec,ded_tipo,ded_num";
} else {
    $sDoctose = "SELECT *, TRIM(de.de_obs) AS de_obs, TRIM(td.td_nom) AS td_nom
       FROM doce_det ded LEFT JOIN doctose de ON ded.ded_emp=de.de_emp and ded.ded_tipo=de.de_tipo and ded.ded_num=de.de_num 
       LEFT JOIN tipodoci td ON  ded.ded_tipo=td.td_cod 
       LEFT JOIN serieoc so ON  de.de_serieoc=so.so_cod 
       LEFT JOIN bodegas bod ON  de.de_bodent=bod.bod_cod 
       WHERE ded_emp='$empCod' and ded_tipo='$selTipodoci' and ded_fec>='$dtFeci' and ded_fec<='$dtFecf' ORDER BY ded_fec,ded_tipo,ded_num";
}           
# EJECUCION DE QUERYS
$db = new dbExec();
$select["doce_det"] = $db->query($sDoctose);

$func = new functions();

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
    die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$iIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($i=0; $i < 1; $i++) { 
    $objPHPExcel->createSheet();
}

# HOJAS
$sheet['entradas']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()->setCreator("Asesoría en Sistemas, S.A.")
                        ->setLastModifiedBy("Asesoría en Sistemas, S.A.")
                        ->setTitle("Office 2007 XLSX Test Document")
                        ->setSubject("Office 2007 XLSX Test Document")
                        ->setDescription("")
                        ->setKeywords("office 2007 openxml php")
                        ->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$i=$iIni;
$j=5;
$objPHPExcel->setActiveSheetIndex($sheet['entradas'])
            ->setCellValueByColumnAndRow($i, 1, $empNom)
            ->setCellValueByColumnAndRow($i, 2, "LISTADO DE DOCUMENTOS DE ENTRADA DEL ".strftime("%d/%m/%Y", strtotime($dtFeci))." AL ".strftime("%d/%m/%Y", strtotime($dtFecf)));

# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'bold' => true,
        'size' => 12,
    ),
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styFec = array(
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styEncabezado = array(
    'font' => array(
        'bold' => true,
        'size' => 9,
        //'color' => array('rgb' => '001a57')
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
);

$styLineas = array(
    'font' => array(
        'bold' => false,
        'size' => 9,
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);
//foreach(range('A','I') as $colID) { 
//    $objPHPExcel->getActiveSheet()->getColumnDimension($colID)->setAutoSize(true); 
//}

$objPHPExcel->getActiveSheet()->mergeCells('A1:D1')->getStyle('A1')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A2:D2')->getStyle('A2')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A3:D3')->getStyle('A3')->applyFromArray($styEmp);
//$objPHPExcel->getActiveSheet()->getStyle('A5:H5')->applyFromArray($styEncabezado);

$ti_tipo="XXXZZZ999";
$ti_num=9999;
$subtot=0;
$tottot=0;
$t_lini=1;
$codp="";
$nomp="";
$clas="";
$clasnom="";

$j=6;
$inidoc=6;
$iniprov=6;
while ($rec = $db->fetchAssoc($select["doce_det"])) {
    if ($t_lini == 1) {
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow(0, $j, "TIPO DE DOCUMENTO: ".$rec["td_nom"]."         NUMERO:  ".$rec["ded_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["ded_fec"])));
        if ($rec["td_afecos"]=='S' && $rec["td_inveini"]=='N') {
          $j+=1;
          $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow(0, $j, utf8_decode("ORDEN DE COMPRA:   ".trim($rec["so_nom"])." - ".$rec["de_numoc"]));
        }            
        $j+=1;
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow(0, $j, utf8_decode("BODEGA:  ".trim($rec["bod_nom"])."          ES PARA PRORRATEO:  ".$rec["de_prorsn"]));
        $j+=1;
        $objPHPExcel->getActiveSheet()
            ->setCellValueByColumnAndRow(0, $j, utf8_encode("OBSERVACIONES: ".$rec["de_obs"]));
        $j+=1;

        $i=$iIni;
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($i++, $j, 'CODIGO')
                    ->setCellValueByColumnAndRow($i++, $j, 'DESCRIPCION')
                    ->setCellValueByColumnAndRow($i++, $j, 'MEDIDA')
                    ->setCellValueByColumnAndRow($i++, $j, 'CANTIDAD')
                    ->setCellValueByColumnAndRow($i++, $j, 'UNITARIO')
                    ->setCellValueByColumnAndRow($i++, $j, 'TOTAL')
                    ->setCellValueByColumnAndRow($i++, $j, 'BONIFICA')
                    ->setCellValueByColumnAndRow($i++, $j, 'EXENTO');
        $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':H'.$j)->applyFromArray($styEncabezado); 
        $j+=1;
        $inidoc=6;
    }
    if ($ti_tipo!=$rec["ded_tipo"]  || $ti_num!=$rec["ded_num"]) {
        if ($t_lini > 1) {
            $i=$iIni;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, "    TOTAL ESTE DOCUMENTO")
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, "")
                ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$inidoc.':F'.($j-1).')');
            $objPHPExcel->getActiveSheet()->getStyle('F'.$j.':F'.$j)->applyFromArray($styEncabezado); 
            $j+=2;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow(0, $j, "TIPO DE DOCUMENTO: ".$rec["td_nom"]."         NUMERO:  ".$rec["ded_num"]."         FECHA:  ".strftime("%d/%m/%Y", strtotime($rec["ded_fec"])));
            if ($rec["td_afecos"]=='S' && $rec["td_inveini"]=='N') {
              $j+=1;
              $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow(0, $j, utf8_decode("ORDEN DE COMPRA:   ".trim($rec["so_nom"])." - ".$rec["de_numoc"]));
            }            
            $j+=1;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow(0, $j, utf8_decode("BODEGA:  ".trim($rec["bod_nom"])."          ES PARA PRORRATEO:  ".$rec["de_prorsn"]));
            $j+=1;
            $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow(0, $j, utf8_encode("OBSERVACIONES: ".$rec["de_obs"]));
            $j+=1;

            $i=$iIni;
            $objPHPExcel->getActiveSheet()
                        ->setCellValueByColumnAndRow($i++, $j, 'CODIGO')
                        ->setCellValueByColumnAndRow($i++, $j, 'DESCRIPCION')
                        ->setCellValueByColumnAndRow($i++, $j, 'MEDIDA')
                        ->setCellValueByColumnAndRow($i++, $j, 'CANTIDAD')
                        ->setCellValueByColumnAndRow($i++, $j, 'UNITARIO')
                        ->setCellValueByColumnAndRow($i++, $j, 'TOTAL')
                        ->setCellValueByColumnAndRow($i++, $j, 'BONIFICA')
                        ->setCellValueByColumnAndRow($i++, $j, 'EXENTO');
            $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':H'.$j)->applyFromArray($styEncabezado); 
            $j+=1;
            $inidoc=$j;
        }             
        $subtot=0;
        $ti_tipo=$rec["ded_tipo"];
        $ti_num=$rec["ded_num"];
        $t_lini=2;
    } 
    $subtot += $rec["ded_cost"];
    $tottot += $rec["ded_cost"];

    $i=$iIni;
    $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, trim($rec["ded_cod"]))
                ->setCellValueByColumnAndRow($i++, $j, trim($rec["ded_desc"]))
                ->setCellValueByColumnAndRow($i++, $j, trim($rec["ded_unimed"]))
                ->setCellValueByColumnAndRow($i++, $j, $rec["ded_cant"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["ded_cosu"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["ded_cost"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["ded_boni"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["ded_exesn"]);
    $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':H'.$j)->applyFromArray($styLineas);
    $j+=1;
}
$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "    TOTAL ESTE DOCUMENTO")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, '=SUM(F'.$inidoc.':F'.($j-1).')');
$objPHPExcel->getActiveSheet()->getStyle('F'.$j.':F'.$j)->applyFromArray($styEncabezado); 
$j+=2;
$i=$iIni;
$objPHPExcel->getActiveSheet()
	->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "    TOTAL GENERAL") 
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(B6:B'.($j-1).',"    TOTAL ESTE DOCUMENTO",F6:F'.($j-1).')');
$objPHPExcel->getActiveSheet()->getStyle('F'.$j.':F'.$j)->applyFromArray($styEncabezado);


$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(17);

$objPHPExcel->getActiveSheet()->getStyle('D6'.':D'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('E6'.':E'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00000');
$objPHPExcel->getActiveSheet()->getStyle('F6'.':F'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00000');
$objPHPExcel->getActiveSheet()->getStyle('G6'.':G'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('A6'.':C'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);
$objPHPExcel->getActiveSheet()->getStyle('H6'.':H'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['entradas'])->setTitle('Entradas');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="ListaEntradas.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>