<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod = $_SESSION['empCod'];
$empNom = $_SESSION['empNom'];

$selDepto=$_GET["selDepto"];
$selsubDepto=$_GET["selSubDepto"];
$selBodega=$_GET["selBodega"];
$BodegaNom=$_GET["BodegaNom"];
$dtFec=$_GET["dtFec"];
$crTse=$_GET["crTse"];
$txtGrupo=$_GET["txtGrupo"];
if ($crTse=="T") {
   $crTsenom="Todos los articulos";
} else {
   $crTsenom="Solo articulos con Existencia";
}   

# QUERYS
if (empty($txtGrupo)) {
    if ($selDepto=='0000') {
        if ($selsubDepto=='0000') {
            $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                        TRIM(art_desc) AS art_desc,
                        TRIM(art_desd) AS art_desd,
                        TRIM(art_marca) AS art_marca,
                        TRIM(art_prov) AS art_prov,
                        TRIM(art_codf) AS art_codf,
                        TRIM(art_codbarr) AS art_codbarr
                        FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                        LEFT JOIN subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                        LEFT JOIN unimed um ON art.art_medi=um.um_cod
                        INNER JOIN exiart ea ON art.art_emp=ea.ea_emp AND art.art_cod=ea.ea_cod
                        WHERE art_emp='$empCod' AND art_bienser='B' GROUP BY art.art_emp,art.art_cod ORDER BY art_emp,art_dep,art_subdep,art_desc";
        } else {
            $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                        TRIM(art_desc) AS art_desc,
                        TRIM(art_desd) AS art_desd,
                        TRIM(art_marca) AS art_marca,
                        TRIM(art_prov) AS art_prov,
                        TRIM(art_codf) AS art_codf,
                        TRIM(art_codbarr) AS art_codbarr
                        FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                        LEFT JOIN  subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                        LEFT JOIN unimed um ON art.art_medi=um.um_cod
                        INNER JOIN exiart ea ON art.art_emp=ea.ea_emp AND art.art_cod=ea.ea_cod
                        WHERE art_emp='$empCod' AND art_subdep='$selsubDepto' AND art_bienser='B' GROUP BY art.art_emp,art.art_cod ORDER BY art_emp,art_dep,art_subdep,art_desc";
        }
    } else {
        if ($selsubDepto=='0000') {
            $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                        TRIM(art_desc) AS art_desc,
                        TRIM(art_desd) AS art_desd,
                        TRIM(art_marca) AS art_marca,
                        TRIM(art_prov) AS art_prov,
                        TRIM(art_codf) AS art_codf,
                        TRIM(art_codbarr) AS art_codbarr
                        FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                        LEFT JOIN  subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                        LEFT JOIN unimed um ON art.art_medi=um.um_cod
                        INNER JOIN exiart ea ON art.art_emp=ea.ea_emp AND art.art_cod=ea.ea_cod
                        WHERE art_emp='$empCod' AND art_dep='$selDepto' AND art_bienser='B' GROUP BY art.art_emp,art.art_cod ORDER BY art_emp,art_dep,art_subdep,art_desc";
        } else {
            $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                        TRIM(art_desc) AS art_desc,
                        TRIM(art_desd) AS art_desd,
                        TRIM(art_marca) AS art_marca,
                        TRIM(art_prov) AS art_prov,
                        TRIM(art_codf) AS art_codf,
                        TRIM(art_codbarr) AS art_codbarr
                        FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                        LEFT JOIN  subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                        LEFT JOIN unimed um ON art.art_medi=um.um_cod
                        INNER JOIN exiart ea ON art.art_emp=ea.ea_emp AND art.art_cod=ea.ea_cod
                        WHERE art_emp='$empCod' AND art_dep='$selDepto' AND art_subdep='$selsubDepto' AND art_bienser='B' GROUP BY art.art_emp,art.art_cod ORDER BY art_emp,art_dep,art_subdep,art_desc";
        }
    }
} else {
    $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                TRIM(art_desc) AS art_desc,
                TRIM(art_desd) AS art_desd,
                TRIM(art_marca) AS art_marca,
                TRIM(art_prov) AS art_prov,
                TRIM(art_codf) AS art_codf,
                TRIM(art_codbarr) AS art_codbarr
                FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                LEFT JOIN subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                LEFT JOIN unimed um ON art.art_medi=um.um_cod
                INNER JOIN exiart ea ON art.art_emp=ea.ea_emp AND art.art_cod=ea.ea_cod
                WHERE art_emp='$empCod' AND art_bienser='B' AND art_cod LIKE '%$txtGrupo%' GROUP BY art.art_emp,art.art_cod ORDER BY art_emp,art_dep,art_subdep,art_desc";
}

function sExiart($codd) { 
    global $empCod, $usuNom, $selBodega;
    return "SELECT * FROM exiart WHERE ea_emp='$empCod' AND ea_cod='$codd' AND ea_bod='$selBodega'";
}

function sExiartTodas($codd) { 
    global $empCod, $usuNom, $selBodega;
    return "SELECT *, SUM(ea_exist) AS ea_existtot FROM exiart WHERE ea_emp='$empCod' AND ea_cod='$codd' GROUP BY '$empCod','$codd'";
}

function sMoviie0($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFec;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_entra) AS mov_sentra
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodent='$selBodega' AND mov_fec>'$dtFec' GROUP BY '$empCod','$codd'";
}
function sMoviis0($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFec;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_sale) AS mov_ssale
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_bodsal='$selBodega' AND mov_fec>'$dtFec' GROUP BY '$empCod','$codd'";
}

function sMoviie0Todas($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFec;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_entra) AS mov_sentra
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_fec>'$dtFec' GROUP BY '$empCod','$codd'";
}
function sMoviis0Todas($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFec;
    return "SELECT mov_emp,mov_cod,mov_bodent,mov_bodsal,
            SUM(mov_sale) AS mov_ssale
            FROM movii WHERE mov_emp='$empCod' AND mov_cod='$codd' AND mov_fec>'$dtFec' GROUP BY '$empCod','$codd'";
}

function sCierrei($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFec ;
    return "SELECT * FROM cierresi WHERE ci_emp='$empCod' AND ci_cod='$codd' AND ci_fec='$dtFec'";
}

function sCierreiTodas($codd) { 
    global $empCod, $usuNom, $selBodega, $dtFec;
    return "SELECT * FROM cierresi WHERE ci_emp='$empCod' AND ci_cod='$codd' AND ci_fec='$dtFec'";
}

# EJECUCION DE QUERYS
$db = new dbExec();

$func = new functions();

$select["artic"] = $db->query($sArtic);

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
	die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$iIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($i=0; $i < 1; $i++) { 
	$objPHPExcel->createSheet();
}

# HOJAS
$sheet['articulos']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()->setCreator("Asesoría en Sistemas, S.A.")
						->setLastModifiedBy("Asesoría en Sistemas, S.A.")
						->setTitle("Office 2007 XLSX Test Document")
						->setSubject("Office 2007 XLSX Test Document")
						->setDescription("")
						->setKeywords("office 2007 openxml php")
						->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$i=$iIni;
$j=6;
$objPHPExcel->setActiveSheetIndex($sheet['articulos'])
			->setCellValueByColumnAndRow($i, 1, $empNom)
			->setCellValueByColumnAndRow($i, 2, "Listado Costeado de Inventarios al ".strftime("%d/%m/%Y", strtotime($dtFec)))
            ->setCellValueByColumnAndRow($i, 3, $BodegaNom)
            ->setCellValueByColumnAndRow($i, 4, $crTsenom)
			->setCellValueByColumnAndRow($i++, $j, 'Familia')
			->setCellValueByColumnAndRow($i++, $j, 'SubFamilia')
			->setCellValueByColumnAndRow($i++, $j, 'Codigo')
			->setCellValueByColumnAndRow($i++, $j, 'Descripcion')
			->setCellValueByColumnAndRow($i++, $j, 'Medida')
			->setCellValueByColumnAndRow($i++, $j, ' Existencia')
			->setCellValueByColumnAndRow($i++, $j, 'Costo/Unit.')
            ->setCellValueByColumnAndRow($i++, $j, 'Costo Total');
# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'bold' => true,
        'size' => 17,
    ),
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styFec = array(
	'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styEncabezado = array(
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);

$bordersThin = array(
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);

$borderBottomDouble = array(
    'borders' => array(
        'bottom' => array(
            'style' => PHPExcel_Style_Border::BORDER_DOUBLE
        )
    )
);

$borderTopThin = array(
    'borders' => array(
        'top' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);


foreach(range('A','T') as $colID) { 
    $objPHPExcel->getActiveSheet()->getColumnDimension($colID)->setAutoSize(true); 
}

$objPHPExcel->getActiveSheet()->mergeCells('A1:H1')->getStyle('A1')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A2:H2')->getStyle('A2')->applyFromArray($styFec);
$objPHPExcel->getActiveSheet()->mergeCells('A3:H3')->getStyle('A3')->applyFromArray($styFec);
$objPHPExcel->getActiveSheet()->mergeCells('A4:H4')->getStyle('A4')->applyFromArray($styFec);
$objPHPExcel->getActiveSheet()->getStyle('A6:H6')->applyFromArray($styEncabezado);

# VALORES PRIMER HOJA
$i=$iIni;
$j=7;
while ($rec = $db->fetchAssoc($select['artic'])) {

    $codd=$rec["art_cod"];
    $cosp=$rec["art_cosp"];
    /// Para verificar costo a determinada fecha, si le hicieron cierre
    $select["cierresi"] = $db->query(sCierrei($codd));
    $cierre = $db->fetchAssoc($select["cierresi"]);
    if ($db->numRows($select["cierresi"]) > 0) {
        $cosp=$cierre["ci_cosp"];
    }

    if ($selBodega=='0000') {
        // Para revisar las existencias peps
        $select["exiart"] = $db->query(sExiartTodas($codd));
        while ($recexist = $db->fetchAssoc($select["exiart"])) {
            $Exist = $recexist["ea_existtot"];

            $select["movii"] = $db->query(sMoviie0Todas($codd));
            $recme0 = $db->fetchAssoc($select['movii']);
            $sEntramov=$recme0["mov_sentra"];

            $select["movii"] = $db->query(sMoviis0Todas($codd));
            $recms0 = $db->fetchAssoc($select['movii']);
            $sSalemov=$recms0["mov_ssale"];

            $Exipas=($Exist-$sEntramov)+$sSalemov;
            if ($crTse=='E' && $Exipas<=0) {
                continue;
            }
            $costot=round($Exipas*$cosp,5);

            $objPHPExcel->getActiveSheet()
                        ->setCellValueByColumnAndRow($i++, $j, utf8_encode(trim($rec['dep_nom'])))
                        ->setCellValueByColumnAndRow($i++, $j, utf8_encode(trim($rec['sdep_nom'])))
                        ->setCellValueByColumnAndRow($i++, $j, $rec['art_cod'])
                        ->setCellValueByColumnAndRow($i++, $j, utf8_encode(trim($rec['art_desc'])))
                        ->setCellValueByColumnAndRow($i++, $j, utf8_encode(trim($rec['um_nom'])))
                        ->setCellValueByColumnAndRow($i++, $j, $Exipas)
                        ->setCellValueByColumnAndRow($i++, $j, $cosp)
                        ->setCellValueByColumnAndRow($i++, $j, $costot);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$j, $rec["art_cod"], PHPExcel_Cell_DataType::TYPE_STRING);                        
            $j+=1;
            $i=$iIni;
        }
    } else {
        // Para revisar las existencias peps
        $select["exiart"] = $db->query(sExiart($codd));
        while ($recexist = $db->fetchAssoc($select["exiart"])) {
            $Exist = $recexist["ea_exist"];

            $select["movii"] = $db->query(sMoviie0($codd));
            $recme0 = $db->fetchAssoc($select['movii']);
            $sEntramov=$recme0["mov_sentra"];

            $select["movii"] = $db->query(sMoviis0($codd));
            $recms0 = $db->fetchAssoc($select['movii']);
            $sSalemov=$recms0["mov_ssale"];

            $Exipas=($Exist-$sEntramov)+$sSalemov;
            if ($crTse=='E' && $Exipas<=0) {
                continue;
            }  
            $costot=round($Exipas*$cosp,5);
            $objPHPExcel->getActiveSheet()
                                ->setCellValueByColumnAndRow($i++, $j, utf8_encode(trim($rec['dep_nom'])))
                                ->setCellValueByColumnAndRow($i++, $j, utf8_encode(trim($rec['sdep_nom'])))
                                ->setCellValueByColumnAndRow($i++, $j, trim($rec['art_cod']))
                                ->setCellValueByColumnAndRow($i++, $j, utf8_encode(trim($rec['art_desc'])))
                                ->setCellValueByColumnAndRow($i++, $j, utf8_encode(trim($rec['um_nom'])))
                                ->setCellValueByColumnAndRow($i++, $j, $Exipas)
                                ->setCellValueByColumnAndRow($i++, $j, $cosp)
                                ->setCellValueByColumnAndRow($i++, $j, $costot);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$j, $rec["art_cod"], PHPExcel_Cell_DataType::TYPE_STRING);                                
            $j+=1;
            $i=$iIni;
        } 
    }
	$i=$iIni;
}

// TOTALES DEL MOVIMIENTO
$objPHPExcel->getActiveSheet()->getStyle('H'.$j.':H'.$j)->applyFromArray($borderTopThin);
$objPHPExcel->getActiveSheet()->getStyle('H'.$j.':H'.$j)->applyFromArray($borderBottomDouble);

$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow(6, $j, 'Total')
    ->setCellValueByColumnAndRow(7, $j, '=SUM(H7:H'.($j-1).')'); 

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(25);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(45);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);

$objPHPExcel->getActiveSheet()->getStyle('F5'.':F'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('G5'.':H'.$j)->getNumberFormat()->setFormatCode('###,###,##0.00000');
$objPHPExcel->getActiveSheet()->getStyle('A5'.':E'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['articulos'])->setTitle('articulos');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);

$db->close();

// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="RCosteado.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;

?>