<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$selDepto=$_GET["selDepto"];
$selsubDepto=$_GET["selSubDepto"];
$selBodega=$_GET["selBodega"];
$BodegaNom=$_GET["BodegaNom"];
$dtFecd=$_GET["dtFecd"];
$dtFeca=$_GET["dtFeca"];

$lineWidth=17;
$lineHeight=0.8;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFecd, $dtFeca,$crInclue, $BodegaNom;
        $this->SetMargins(1, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",17);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",9);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, .4, utf8_decode("Reporte de Articulos Por Vencer del ".strftime("%d/%m/%Y", strtotime($dtFecd))." al ".strftime("%d/%m/%Y", strtotime($dtFeca))),0,1,"L");
        //$this->Ln();
        $this->MultiAlignCell($lineWidth, .4, utf8_decode($BodegaNom),0,1,"L");
        $this->SetFont("","",9);

        $header = array("Codigo","Descripcion","Medida","F/Vence","Existencia","Proveedor");
        $this->SetFont("","B");
        $this->SetWidths(array(2.5,7,1.5,1.8,1.8,4.8));
        $this->SetAligns(array("C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetFont("","",8);
        $this->SetAligns(array("L","L","C","C","R","L"));
    }
    
    function Footer() {
        $func = new functions();

        $this->SetY(-1.5);
        $this->SetFont("Arial","I",6);
        $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
    }
}

# QUERYS
if ($selDepto=='0000') {
    if ($selsubDepto=='0000') {
        $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                    TRIM(art_desc) AS art_desc,
                    TRIM(art_desd) AS art_desd,
                    TRIM(art_marca) AS art_marca,
                    TRIM(art_prov) AS art_prov,
                    TRIM(art_codf) AS art_codf,
                    TRIM(art_codbarr) AS art_codbarr,
                    TRIM(pro_nom) AS pro_nom
                    FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                    LEFT JOIN subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                    LEFT JOIN unimed um ON art.art_medi=um.um_cod
                    LEFT JOIN exiart_peps ep ON ep.ea_emp=art.art_emp AND ep.ea_cod=art.art_cod 
                    LEFT JOIN provcp pc ON ep.ea_emp=pc.pro_emp AND ep.ea_codp=pc.pro_cod
                    WHERE art_emp='$empCod' AND art_bienser='B' AND ep.ea_bod='$selBodega' AND ep.ea_fvence>='$dtFecd' AND ep.ea_fvence<='$dtFeca' AND ep.ea_exist>0 ORDER BY art_emp,art_dep,art_subdep,art_desc";
    } else {
        $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                    TRIM(art_desc) AS art_desc,
                    TRIM(art_desd) AS art_desd,
                    TRIM(art_marca) AS art_marca,
                    TRIM(art_prov) AS art_prov,
                    TRIM(art_codf) AS art_codf,
                    TRIM(art_codbarr) AS art_codbarr,
                    TRIM(pro_nom) AS pro_nom
                    FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                    LEFT JOIN  subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                    LEFT JOIN unimed um ON art.art_medi=um.um_cod
                    LEFT JOIN exiart_peps ep ON ep.ea_emp=art.art_emp AND ep.ea_cod=art.art_cod 
                    LEFT JOIN provcp pc ON ep.ea_emp=pc.pro_emp AND ep.ea_codp=pc.pro_cod
                    WHERE art_emp='$empCod' AND art_subdep='$selsubDepto' AND art_bienser='B' AND ep.ea_bod='$selBodega' AND ep.ea_fvence>='$dtFecd' AND ep.ea_fvence<='$dtFeca' AND ep.ea_exist>0 ORDER BY art_emp,art_dep,art_subdep,art_desc";
    }
} else {
    if ($selsubDepto=='0000') {
        $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                    TRIM(art_desc) AS art_desc,
                    TRIM(art_desd) AS art_desd,
                    TRIM(art_marca) AS art_marca,
                    TRIM(art_prov) AS art_prov,
                    TRIM(art_codf) AS art_codf,
                    TRIM(art_codbarr) AS art_codbarr,
                    TRIM(pro_nom) AS pro_nom
                    FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                    LEFT JOIN  subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                    LEFT JOIN unimed um ON art.art_medi=um.um_cod
                    LEFT JOIN exiart_peps ep ON ep.ea_emp=art.art_emp AND ep.ea_cod=art.art_cod 
                    LEFT JOIN provcp pc ON ep.ea_emp=pc.pro_emp AND ep.ea_codp=pc.pro_cod
                    WHERE art_emp='$empCod' AND art_dep='$selDepto' AND art_bienser='B' AND ep.ea_bod='$selBodega' AND ep.ea_fvence>='$dtFecd' AND ep.ea_fvence<='$dtFeca' AND ep.ea_exist>0 ORDER BY art_emp,art_dep,art_subdep,art_desc";
    } else {
        $sArtic = "SELECT *, TRIM(art_cod) AS art_cod,
                    TRIM(art_desc) AS art_desc,
                    TRIM(art_desd) AS art_desd,
                    TRIM(art_marca) AS art_marca,
                    TRIM(art_prov) AS art_prov,
                    TRIM(art_codf) AS art_codf,
                    TRIM(art_codbarr) AS art_codbarr,
                    TRIM(pro_nom) AS pro_nom
                    FROM artic art LEFT JOIN deptosi di ON art.art_dep=di.dep_cod 
                    LEFT JOIN  subdeptosi sdi ON art.art_dep=sdi.sdep_dep AND art.art_subdep=sdi.sdep_cod
                    LEFT JOIN unimed um ON art.art_medi=um.um_cod
                    LEFT JOIN exiart_peps ep ON ep.ea_emp=art.art_emp AND ep.ea_cod=art.art_cod 
                    LEFT JOIN provcp pc ON ep.ea_emp=pc.pro_emp AND ep.ea_codp=pc.pro_cod
                    WHERE art_emp='$empCod' AND art_dep='$selDepto' AND art_subdep='$selsubDepto' AND art_bienser='B' AND ep.ea_bod='$selBodega' AND ep.ea_fvence>='$dtFecd' AND ep.ea_fvence<='$dtFeca' AND ep.ea_exist>0 ORDER BY art_emp,art_dep,art_subdep,art_desc";
    }
}

# EJECUCION DE QUERYS
$db = new dbExec();
$func = new functions();

$select["artic"] = $db->query($sArtic);

# GENERAR PDF
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();
$ti_Depto="XXXX";
$ti_sDepto="XXXX";
while ($rec = $db->fetchAssoc($select["artic"])) {
    if ($ti_Depto.$ti_sDepto!=$rec["art_dep"].$rec["art_subdep"]) {
       $pdf->SetFont("","B");
       $pdf->Cell($lineWidth,.7,trim($rec["dep_nom"]).", ".rtrim($rec["sdep_nom"]),0,0,"L");
       $pdf->SetFont("","");
       $ti_Depto=$rec["art_dep"];
       $ti_sDepto=$rec["art_subdep"];
       $pdf->ln();
    }
    $codd=$rec["art_cod"];
    $body = array(
        $rec["art_cod"],
        trim($rec["art_desc"]),
        trim($rec["um_nom"]),
        strftime("%d/%m/%Y", strtotime($rec["ea_fvence"])),
        number_format($rec["ea_exist"], 2, '.', ','),
        trim($rec["pro_nom"]),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$db->close();
$pdf->Output(utf8_decode("PorVencer").".pdf","I");
?>