<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

class generatePDF extends PDF_MC_Table {
    function Header() {
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        $this->SetY(-2.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
    $sTipodoci = "SELECT td.*, TRIM(td.td_nom) AS td_nom,
                TRIM(td.td_relatv) AS td_relatv,
                TRIM(tv.tv_nom) AS td_relatvnom,
                TRIM(td.td_relatpol) AS td_relatpol,
                TRIM(tpol.tp_nom) AS td_relatpolnom
                FROM tipodoci as td
                LEFT JOIN tipov tv ON td.td_relatv = tv.tv_cod
                LEFT JOIN tipopol tpol ON td.td_relatpol = tpol.tp_cod ORDER BY td_cod";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["tipodoci"] = $db->query($sTipodoci);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("L","cm", "letter");
$pdf->AddPage();
$pdf->SetMargins(1.8, 1, 2.5);
$pdf->SetFont("Arial","B",12);

$pdf->Cell(20,.7,$empNom,0,1,"C");

$lineWidth=17;
$lineHeight=0.5;

$pdf->SetFont("","",9);
$pdf->Ln($lineHeight);
$pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de Tipos de Documentos de Inventario"));
    //.strftime("%d/%m/%Y", strtotime($dtFec))),0,0,"C");
$pdf->Ln($lineHeight*2);

$header = array("Codigo","Nombre","E o S","Afe/Cos","Mov/ Bodegas","Rep/Ventas","Partida","Inve/Inicial","Rela/Ventas","Rela/Polizas");
$pdf->SetFont("","B");
$pdf->SetWidths(array(2,6,1,2,1.6,2,1.5,1.9,3,3));
$pdf->SetAligns(array("C","C","C","C","C","C","C","C","C","C"));
$pdf->Row($header, $lineHeight);

$pdf->SetFont("");
$pdf->SetAligns(array("L","L","C","C","C","C","C","C","L","L"));

while ($rec = $db->fetchAssoc($select["tipodoci"])) {
    $body = array(
        trim($rec["td_cod"],),
        trim($rec["td_nom"]),
        trim($rec["td_eos"]),
        trim($rec["td_afecos"]),
        trim($rec["td_movbod"]),
        trim($rec["td_repven"]),
        trim($rec["td_partsn"]),
        trim($rec["td_inveini"]),
        trim($rec["td_relatvnom"]),
        trim($rec["td_relatpolnom"]),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->Output(utf8_decode("Listado de Tipos de Inventario").".pdf","I");
?>