<?php
include_once('../../../php/db/dbExec.php');

# QUERYS
$sEmpresas = "SELECT * FROM empresas where emp_cod='zzz' ORDER BY emp_nom ASC";
$sCaja = "SELECT * FROM caja WHERE caj_stat!='B'";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["empresas"] = $db->query($sEmpresas);
$select["caja"] = $db->query($sCaja);
$db->close();
?>
<!DOCTYPE html>
<!--
* CoreUI - Free Bootstrap Admin Template
* @version v2.1.10
* @link https://coreui.io
* Copyright (c) 2018 creativeLabs Łukasz Holeczek
* Licensed under MIT (https://coreui.io/license)
-->

<html lang="es">
  <?php include('../../../php/includes/headLocal.php'); ?>
  <body class="app flex-row align-items-center" style="background-image: url(img/login.jpg); background-size: cover;">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-md-8">
          <div class="card-group">
            <div class="card p-4">
              <div class="card-body">
                <form action="menu/" method="post" autocomplete="off" name="formLogin">
                  <h1>Iniciar Sesión</h1>
                  <p class="text-muted">Ingresa tu cuenta</p>
                  <div class="input-group mb-3">
                    <input class="form-control" name="txtUsuCod" type="text" placeholder="Usuario" id="txtUsuCod" value="" >
                  </div>
                  <div class="input-group mb-3">
                    <input class="form-control" name="txtUsuCla" type="password" placeholder="Contraseña" id="txtUsuCla" value="" >
                  </div>
                  <div class="input-group mb-4">
                    <select class="form-control round-circle" id="selectEmp" name="selEmpCod" value="">
                      <option value="0">Seleccionar Empresa</option> 
                      <?php
                        while ($rec = $db->fetchAssoc($select['empresas'])) {
                          echo  '<option value="'.$rec['emp_cod'].'">'.utf8_encode($rec['emp_nom']).'</option>';
                        } 
                      ?>
                    </select>
                  </div>
                  <div class="input-group mb-4">
                    <select class="form-control round-circle" id="selCajCod" name="selCajCod" value="">
                      <option value="">Seleccione Bodega Que Trabajara</option>  -->
                      <?php
                        while ($rec = $db->fetchAssoc($select['caja'])) {
                          echo  '<option value="'.$rec['caj_cod'].'">'.utf8_encode($rec['caj_nom']).'</option>';
                        }
                      ?>
                    </select>
                  </div>

                  <div class="row">
                    <div class="col-12">
                      <button class="btn btn-success btn-block px-4" type="button" onclick="entrar();return false;">Entrar</button>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-12 text-right">
                      <button class="btn btn-link text-success btn-block px-0" type="button">¿Olvidaste tu contraseña?</button>
                    </div>
                  </div>
                </form>
              </div>
            </div>
            <div class="card text-white bg-primary py-5 d-md-down-none" style="width:44%">
              <div class="card-body text-center">
                <div>
                  <h2>Contacto</h2>
                  <p><a class="text-white" href="mailto:asesoriaensistemas@asjireh.com" target="_blank">asesoriaensistemas@asjireh.com</a></p>
                  <p><a class="text-white" href="tel:+50254015022" target="_blank">(502) 5401-5022</a></p>
                  <p><a class="text-white" href="tel:+50255625322" target="_blank">(502) 5562-5322</a></p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </body>
  <!-- alert y ajax -->
  <script type="text/javascript" src="../../js/alerts.js"></script>
  <script>
    const txtUsuCod = document.formLogin.txtUsuCod;
    const txtUsuCla = document.formLogin.txtUsuCla;
    const selEmpCod = document.formLogin.selEmpCod;
    const selCajCod = document.formLogin.selCajCod;

    var sel = document.formLogin.selectEmp;
    var $cod = "";
    var $nom = "";

    function entrar(){
      if (selCajCod.value=="") {
        selCajCod.focus();
        alWarning({"msg":{"title":"Confirme Bodega","text":"Confirme Bodega donde trabajara."}});
        return true;
      }
      var parametros = {
        "txtUsuCod" : document.formLogin.txtUsuCod.value,
        "txtUsuCla" : document.formLogin.txtUsuCla.value,
        "selEmpCod" : document.formLogin.selEmpCod.value,
        "selCajCod" : document.formLogin.selCajCod.value
      };
      $.ajax({
        data:  parametros,
        url:   window.location+"/validacion.php", 
        type:  "post",
        beforeSend: function () {
            alLoad("Cargando...")
        },
        success: function (jsonPhp) {
          var jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error==false){
            location.href = "menu/?opcNom=Inicio"
          } else {
            alError(jsonJS);
          }
        }
      });
    }

    $(document).ready(function() {
      document.formLogin.txtUsuCod.focus();

      // Bloqueamos el SELECT de las empresas
//      $("#selectEmp").prop('disabled', true);

      // Guardamos el select de empresas en variable emprecur
      var emprecur = $("#selectEmp");

      // Guardamos el select de empresas en variable emprecur
      var cajacur = $("#selCajCod");

      //txtUsuCod.value="";

      // SUBMIT FORM
      $('form').submit(function() {
        return false;
      });

      // VALID usuCod
      $("#txtUsuCod")
      .focus(function (){
        console.log(txtUsuCod.value);

        // Limpiamos el select
        cajacur.find('option').remove();

        const parametros = new FormData();
        parametros.append("action", "consultar");

        parametros.append("txtUsuCod", txtUsuCod.value);

        $.ajax({
          data:  parametros,
          url:   window.location.origin+window.location.pathname+"actions.php",
          type:  "post",
          contentType: false,
          processData: false,
          success: function (jsonPhp) {
            //console.log(jsonPhp);
            const jsonJS = JSON.parse(jsonPhp);

            if(jsonJS.error == true){
              alError(jsonJS);
            } else {
              jsonJS.caja.forEach(function(i){
                  $cod=i.caj_cod;
                  $nom=i.caj_nom;
                  cajacur.append('<option value="'+$cod+'">'+$nom+'</option>');
              });
              cajacur.append('<option value="'+$cod+'">'+$nom+'</option>');
            }
          }
        });
      })
      .change(function (){
          // Limpiamos el select
          cajacur.find('option').remove();
          // Limpiamos el select
          emprecur.find('option').remove();

          const parametros = new FormData();
          parametros.append("action", "consultar");

          parametros.append("txtUsuCod", txtUsuCod.value);

          $.ajax({
            data:  parametros,
            url:   window.location.origin+window.location.pathname+"actions.php",
            type:  "post",
            contentType: false,
            processData: false,
            success: function (jsonPhp) {
              //console.log(jsonPhp);
              const jsonJS = JSON.parse(jsonPhp);

              if(jsonJS.error == true){
                alError(jsonJS);
              } else {
                jsonJS.caja.forEach(function(i){
                    $cod=i.caj_cod;
                    $nom=i.caj_nom;
                    cajacur.append('<option value="'+$cod+'">'+$nom+'</option>');
                });

                jsonJS.empresas.forEach(function(i){
                    $cod=i.emp_cod;
                    $nom=i.emp_nom;
                    emprecur.append('<option value="'+$cod+'">'+$nom+'</option>');
                });
              }
            }
          });
      });

/*
      // VALID usuCod
      $("#txtUsuCod").focus(function (){
          // Limpiamos el select
          cajacur.find('option').remove();

          const parametros = new FormData();
          parametros.append("action", "consultar");

          parametros.append("txtUsuCod", txtUsuCod.value);

          $.ajax({
            data:  parametros,
            url:   window.location.origin+window.location.pathname+"actions.php",
            type:  "post",
            contentType: false,
            processData: false,
            success: function (jsonPhp) {
              //console.log(jsonPhp);
              const jsonJS = JSON.parse(jsonPhp);

              if(jsonJS.error == true){
                alError(jsonJS);
              } else {
                jsonJS.caja.forEach(function(i){
                    $cod=i.caj_cod;
                    $nom=i.caj_nom;
                    cajacur.append('<option value="'+$cod+'">'+$nom+'</option>');
                });
                selCajCod.value=$cod;
              }
            }
          });
      });
*/

      /*$("#selectEmp").change(function (){
        document.formLogin.empNomPublic.value = $(this).find('option:selected').text();
      });*/

    });
  </script>
</html>