<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);

$dtFecI=$_GET["dtFecI"];
$dtFecF=$_GET["dtFecF"];
$txtCtai=$_GET["txtCtai"];
$txtCtaiNom=$_GET["txtCtaiNom"];
$cbFecsn=$_GET["cbFecsn"];

$numAno=date("Y", strtotime($dtFecI));
$numMes=date("m", strtotime($dtFecI));

$lineWidth=19.3;
$lineHeight=0.35;

# QUERYS
$sCierres = "SELECT
                c.cie_mes,
                cta.cta_niv,
                cta.cta_con,
                TRIM(c.cie_cta) AS cie_cta,
                TRIM(cta.cta_nom) AS cta_nom,
                TRIM(cta.cta_acta) AS cta_acta,
                (0) AS salIni,
                c.cie_mdebe,
                c.cie_mhaber,
                (SUM(cie_mdebe)-SUM(cie_mhaber)) AS salMes
            FROM cierres c 
            INNER JOIN cuentas cta ON c.cie_emp=cta.cta_emp AND c.cie_cta=cta.cta
            WHERE c.cie_emp='$empCod'  AND c.cie_cta='$txtCtai' AND c.cie_ano='$numAno' AND c.cie_mes<='$numMes' GROUP BY c.cie_cta, cie_mes='$numMes'";

$sPoliDet = "SELECT *,
                TRIM(pd.pold_cta) AS pold_cta,
                TRIM(pd.pold_ctan) AS pold_ctan,
                TRIM(p.pol_con) AS pol_con
            FROM poli_det pd LEFT JOIN polizas p ON pd.pold_emp=p.pol_emp AND pd.pold_ban=p.pol_ban AND pd.pold_tipo=p.pol_tipo AND pd.pold_fec=p.pol_fec AND pd.pold_num=p.pol_num AND pd.pold_tipoi=p.pol_tipoi AND pd.pold_nit=p.pol_nit 
                LEFT JOIN tipopol tpol ON pd.pold_tipo=tpol.tp_cod 
                WHERE pd.pold_emp='$empCod' AND pd.pold_cta='$txtCtai' AND pd.pold_fec>='$dtFecI' AND pd.pold_fec<='$dtFecF' ORDER BY pold_fec";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["cierres"] = $db->query($sCierres);
$select["poli_det"]=$db->query($sPoliDet);

$arrayCie=$db->fetchAll($select["cierres"]);

$salIni=0;
$Saldo=0;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFecI, $dtFecF, $txtCtai, $txtCtaiNom, $cbFecsn, $arrayCie, $Saldo, $salIni, $numMes, $txtCtai, $txtCtaiNom;
        $func = new functions();
        $this->SetMargins(1.35, 1, 1.35);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNom),0,1,"C");
        $this->SetFont("","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","B",10);
        $this->Cell($lineWidth, $lineHeight, utf8_decode("INTEGRACION DE UNA CUENTA DEL ".strftime("%d/%m/%Y", strtotime($dtFecI))." AL ".strftime("%d/%m/%Y", strtotime($dtFecF))),0,1,"C");
        $this->SetFont("","B",12);        
        $this->MultiAlignCell($lineWidth, $lineHeight, "CUENTA:  ".$txtCtai." - ".$txtCtaiNom,0,1,"L");
        $this->Ln();

        // Para Llegar al saldo inicial de la fecha inicial
        $k=0;
        foreach ($arrayCie as $rec) {
            $rec["salIni"]=$salIni;
            $k++;
            if ($rec["cie_mes"]!=$numMes) {
                $salIni=$rec["salMes"];

                if ($k<sizeof($arrayCie)) {
                    if ($arrayCie[$k]["cie_cta"]==$rec["cie_cta"]) {
                        continue;
                    }
                }
                $rec["salIni"]=$salIni;
            }

            $this->SetFont("","B",10);
            $this->Cell($lineWidth/1.2, $lineHeight, "Saldo Inicial: ",0,0,"R");
            $this->Cell($lineWidth/6, $lineHeight, number_format($rec["salIni"], 2, '.', ','),0,1,"R");
        }

        $this->SetFont("","B",8);        
        $header = array("No.Docto","Serie","Prov.","Tipo","Fecha","Concepto","Debe","Haber","Saldo");
        $this->SetFont("","B");
        $this->SetWidths(array(2,1.8,2,1,1.5,5,2,2,2));
        $this->SetAligns(array("C","C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetFont("", "", 7);
        $this->SetAligns(array("L","L","L","L","L","L","R","R","R"));

    }
    
    function Footer() {
        global $cbFecsn;
        // Posición: a 1,5 cm del final
        $func = new functions();

        $this->SetY(-1.5);
        $this->SetFont("Arial","I",6);
        if ($func->stringToBool($cbFecsn)) {
            $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
        }
    }
}

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();

$debe = 0;
$haber = 0;
$Saldo = $salIni;
while ($rec = $db->fetchAssoc($select['poli_det'])) {
    $debe += $rec["pold_debe"];
    $haber += $rec["pold_haber"];
    $Saldo = ($Saldo+$rec["pold_debe"])-$rec["pold_haber"];

    $body = array(
        $rec["pold_num"],
        $rec["pold_tipoi"],
        $rec["pold_nit"],
        $rec["tp_abrev"],
        strftime("%d/%m/%Y", strtotime($rec["pold_fec"])),
        $rec["pol_con"],
        (round($rec["pold_debe"],2) != 0) ? number_format($rec["pold_debe"], 2, '.', ',') : "",
        (round($rec["pold_haber"],2) != 0) ? number_format($rec["pold_haber"], 2, '.', ',') : "",
        number_format($Saldo, 2, '.', ','),
        );
     $pdf->RowBorderHidden($body, $lineHeight);
}

$pdf->line($pdf->GetX()+9, $pdf->GetY(), 19.5, $pdf->GetY());

$pdf->SetAligns(array("","","","","","C","R","R"));
$body = array("","","","","","Totales: ",
    number_format($debe,2, '.', ','),
    number_format($haber,2, '.', ','),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+9, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->line($pdf->GetX()+9, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);

$pdf->Ln();

$Smes = ($debe-$haber);
$Sactual = ($salIni+$debe)-$haber;


$pdf->SetAligns(array("L","L","R","","","L","R","R"));
$pdf->Ln($lineHeight*2);
$pdf->line($pdf->GetX()+0, $pdf->GetY(), 7, $pdf->GetY());

$pdf->Cell($lineWidth/9, $lineHeight, "Saldo Inicial: ");
$pdf->Cell($lineWidth/6, $lineHeight, number_format($salIni,2, '.', ','),0,1,"R");

$pdf->Cell($lineWidth/9, $lineHeight, "Suma Debe: ");
$pdf->Cell($lineWidth/6, $lineHeight, number_format($debe,2, '.', ','),0,1,"R");

$pdf->Cell($lineWidth/9, $lineHeight, "Suma Haber: ");
$pdf->Cell($lineWidth/6, $lineHeight, number_format($haber,2, '.', ','),0,1,"R");

$pdf->Cell($lineWidth/9, $lineHeight, "Suma Mes: ");
$pdf->Cell($lineWidth/6, $lineHeight, number_format($Smes,2, '.', ','),0,1,"R");

$pdf->Cell($lineWidth/9, $lineHeight, "Suma Actual: ");
$pdf->Cell($lineWidth/6, $lineHeight, number_format($Sactual,2, '.', ','),0,1,"R");

$pdf->line($pdf->GetX()+0, $pdf->GetY(), 7, $pdf->GetY());
$pdf->line($pdf->GetX()+0, $pdf->GetY()+.075, 7, $pdf->GetY()+.075);

$db->close();

$pdf->Output(utf8_decode("Integraciones").".pdf","I");
?>