<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

global $empCod, $usuNom, $bitMod, $bitForm, $selBan, $dtFec, $numNum, $Banctab, $Banctac;

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

$numNum=$_GET["numNum"];
$numCoddm=(empty($_GET['numCoddm'])) ? 0 : $_GET['numCoddm'];
$selBan=$_GET["selBan"];
$Banctab=$_GET["Banctab"];
$Banctac=$_GET["Banctac"];
$dtFec=$_GET["dtFec"];

$lineWidth=19;
$lineHeight=0.42;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFec, $numNum, $txtCodp, $txtNomp, $Banctab;
        $this->SetMargins(1.5, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("LISTADO DE CHEQUES EMITIDOS CON FECHA: ".strftime("%d/%m/%Y", strtotime($dtFec))),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, "PLANILLA No. : ".$numNum,0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, "CUENTA BANCARIA: ".$Banctab,0,1,"L");

        $this->Ln();
        $this->SetFont("","",9);
        $header = array("CODIGO","NOMBRE PARA EL CHEQUE","NUMERO/CHEQUE","MONTO");
        $this->SetFont("","B");
        $this->SetWidths(array(2,10,3.5,3));
        $this->SetAligns(array("C","C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("L","L","L","R"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sNomper = "SELECT np.*, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
            TRIM(mae.mae_nomch) AS mae_nomch, TRIM(tpu.tpu_nom) AS tpu_nom
            FROM nomper np
            LEFT JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
            LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
            WHERE np_emp='$empCod' AND np_numpla='$numNum' AND mae_fpago>2 AND mae_fpago<5 AND np_chafe=1";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["nomper"] = $db->query($sNomper);
$totpag=0;
# GENERAR PDF
//$pdf = new generatePDF("L","cm", "Letter");
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();
$func = new functions();

while ($rec = $db->fetchAssoc($select["nomper"])) {
    $body = array(
        $rec["np_cod"],
        trim($rec["mae_nomch"]),
        $rec["np_cheque"],        
        number_format($rec["np_liqrec"], 2, '.', ','),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
    $totpag+=$rec["np_liqrec"];
}
$pdf->line($pdf->GetX()+10, $pdf->GetY(), 20, $pdf->GetY());
$body = array(
    "",
    "",
    "   TOTAL",        
    number_format($totpag, 2, '.', ','),        
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->Output(utf8_decode("ListachequesNPI").".pdf","I");
$db->close();
?>