<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$numChi=$_GET["numChi"];
$numChf=$_GET["numChf"];
$selBanCod=$_GET["selBanCod"];
$selBanNom=$_GET["selBanNom"];

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $numChi, $numChf, $selBanCod, $selBanNom;
        $this->SetMargins(1.5, 1, 2.5);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",13);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");
        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",12);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de cheques emitidos Del ".$numChi." al ".$numChf),0,1,"L");
//        $this->Ln();
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Cuenta: ".$selBanNom),0,1,"L");
//        $this->Ln(); 

        $header = array("Numero","Fecha","Beneficiario/Concepto","Valor");
        $this->SetFont("","B",8);
        $this->SetWidths(array(2,2,11.5,2.5));
        $this->SetAligns(array("C","C","C","C"));
        $this->Row($header, $lineHeight); 

        $this->SetFont("");
        $this->SetAligns(array("L","C","L","R")); 
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sCheques = "SELECT *, TRIM(ch_bene) AS ch_bene, TRIM(ch_con) AS ch_con FROM cheques 
            WHERE ch_emp='$empCod' AND ch_num>='$numChi' AND ch_num<='$numChf' AND ch_ban='$selBanCod'";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["cheques"] = $db->query($sCheques);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();
$lineHeight=0.4;
$valtot=0;
while ($rec = $db->fetchAssoc($select["cheques"])) {
    $valtot += $rec["ch_tot"];
    $body = array(
        $rec["ch_num"],
        strftime("%d/%m/%Y", strtotime($rec["ch_fec"])),
        utf8_encode($rec["ch_bene"]),
        number_format($rec["ch_tot"],2),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array(
        "",
        "",
        utf8_encode($rec["ch_con"]),
        "",
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->SetAligns(array("","","R","R"));
$body = array(
    "",
    "",
    "Total: ",
    number_format($valtot,2),
);
$pdf->line($pdf->GetX()+14, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->RowBorderHidden($body, $lineHeight);

$pdf->line($pdf->GetX()+14, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->line($pdf->GetX()+14, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075); 

$pdf->Output(utf8_decode("Listado Cheques por Numero").".pdf","I");
?>