<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$tipoPol="018";
$numTr=$_GET["numTr"];
$selBanCod=$_GET["selBanCod"];
$selBanNom=$_GET["selBanNom"];

$lineWidth=17;
$lineHeight=0.5;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $numTr, $selBanCod, $selBanNom, $tipoPol;
        $this->SetMargins(1.5, 1, 2.5);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",13);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");
        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",12);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Listado de Documento relacionados a una Transferencia"),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Cuenta: ".$selBanNom)." Cheque No. ".$numTr,0,1,"L");
//        $this->Ln(); 

        $header = array("Serie","Numero","Fecha","Proveedor","Valor");
        $this->SetFont("","B",8);
        $this->SetWidths(array(2,2.2,2,9.5,2.5));
        $this->SetAligns(array("C","C","C","C","C"));
        $this->Row($header, $lineHeight); 

        $this->SetFont("");
        $this->SetAligns(array("L","L","C","L","R")); 
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sIva_comp = "SELECT *, trim(iva_prov) AS iva_prov, trim(iva_serie) AS iva_serie FROM iva_comp i 
                  LEFT JOIN provee p ON i.iva_nit=p.pro_nit 
                  WHERE iva_emp='$empCod' AND iva_ban='$selBanCod' AND iva_cheque='$numTr'";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["iva_comp"] = $db->query($sIva_comp);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();
$lineHeight=0.4;
$valtot=0;
while ($rec = $db->fetchAssoc($select["iva_comp"])) {
    $valtot += $rec["iva_tot"]+$rec["iva_dedu"];
    $body = array(
        $rec["iva_serie"],
        $rec["iva_num"],
        strftime("%d/%m/%Y", strtotime($rec["iva_fec"])),
        trim(utf8_encode($rec["iva_prov"])),
        number_format($rec["iva_tot"]+$rec["iva_dedu"],2),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->SetAligns(array("","","","R","R"));
$body = array(
    "",
    "",
    "",
    "Total: ",
    number_format($valtot,2),
);
$pdf->line($pdf->GetX()+14, $pdf->GetY(), 19.8, $pdf->GetY());
$pdf->RowBorderHidden($body, $lineHeight);

$pdf->line($pdf->GetX()+14, $pdf->GetY(), 19.8, $pdf->GetY());
$pdf->line($pdf->GetX()+14, $pdf->GetY()+.075, 19.8, $pdf->GetY()+.075); 

$pdf->Output(utf8_decode("Listado Documentos a una Transfer").".pdf","I");
?>