<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');

$empCod = $_SESSION['empCod'];
$empNom = $_SESSION['empNom'];

# Para jalar año de la variable que sea tipo fecha
$AnoTrab=date("Y", strtotime($_SESSION['empFtrab']));
$TipoPol="001";

# QUERYS
$sPoliini = "SELECT *,
            TRIM(pi.poli_cta) AS poli_cta,
            TRIM(pi.poli_ctan) AS poli_ctan,
            TRIM(pi.poli_con) AS poli_con,
            trim(tp.tp_nom) AS tp_nom
            FROM poliini pi LEFT JOIN tipopol tp ON pi.poli_tipo=tp.tp_cod WHERE poli_emp='$empCod' AND poli_ano='$AnoTrab'";

$uPoliini = "UPDATE poliini SET poli_stat='I' WHERE poli_emp='$empCod' AND poli_ano='$AnoTrab'";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["poliini"]=$db->query($sPoliini);

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
	die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$colIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($col=0; $col < 1; $col++) { 
	$objPHPExcel->createSheet();
}

# HOJAS
$sheet['polizas']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()
	->setCreator("Asesoría en Sistemas, S.A.")
	->setLastModifiedBy("Asesoría en Sistemas, S.A.")
	->setTitle("Office 2007 XLSX Test Document")
	->setSubject("Office 2007 XLSX Test Document")
	->setDescription("")
	->setKeywords("office 2007 openxml php")
	->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$col=$colIni;
$objPHPExcel->setActiveSheetIndex($sheet['polizas'])
	->setCellValueByColumnAndRow($col, 1, $empNom)
	->setCellValueByColumnAndRow($col, 2, utf8_decode("POLIZAS DE APERTURA CORRESPONDIENTE A ").((string)($AnoTrab)));

# VALORES PRIMER HOJA
$bordersThin = array(
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);

$borderBottomDouble = array(
    'borders' => array(
        'bottom' => array(
            'style' => PHPExcel_Style_Border::BORDER_DOUBLE
        )
    )
);

$borderTopThin = array(
    'borders' => array(
        'top' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);

$rowVal = 4;
$row = $rowVal;
$col=$colIni;
$totDebe = 0;
$totHaber = 0;

$tipot="";
$numt=0;
$debe = 0;
$haber = 0;
$linea=1;
$row++;
$rowIni = $row;
while ($rec = $db->fetchAssoc($select['poliini'])) {
	# ENCABEZADO DEL DOCUMENTO
    if (($rec["poli_tipo"]!=$tipot) || ($rec["poli_num"]!=$numt)) {
        if ($linea!=1) {
			$col = $colIni+1;
			$objPHPExcel->getActiveSheet()
				->setCellValueByColumnAndRow($col++, $row, 'Totales del documento')
				->setCellValueByColumnAndRow($col++, $row, '=SUM(C'.$rowIni.':C'.($row-1).')')
				->setCellValueByColumnAndRow($col, $row, '=SUM(D'.$rowIni.':D'.($row-1).')');

			# FORMATO NUMERICO
			$objPHPExcel->getActiveSheet()->getStyle('C'.$rowIni.':C'.$row)->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('D'.$rowIni.':D'.$row)->getNumberFormat()->setFormatCode('#,##0.00');

			# ESTILO TOTAL
			$objPHPExcel->getActiveSheet()->getStyle('C'.$row.':D'.$row)->applyFromArray($borderTopThin);
			$objPHPExcel->getActiveSheet()->getStyle('C'.$row.':D'.$row)->applyFromArray($borderBottomDouble);
			$row+=2;
        }
		# ENCABEZADO DEL DOCUMENTO
		$col=$colIni;
		$objPHPExcel->setActiveSheetIndex($sheet['polizas'])
			->setCellValueByColumnAndRow($col,	 $row++, 'Tipo de Póliza: '.$rec['tp_nom'])
			->setCellValueByColumnAndRow($col,	 $row, 'Número de Póliza: '.$rec['poli_tipo'].'-'.$rec['poli_num'])
			->setCellValueByColumnAndRow($col+2, $row++, 'Fecha: '.strftime("%d/%m/%Y", strtotime($rec["poli_fec"])))
			->setCellValueByColumnAndRow($col,	 $row++, 'Concepto: '.utf8_encode($rec['poli_con']))
			->setCellValueByColumnAndRow($col++, $row, 'Cuenta')
			->setCellValueByColumnAndRow($col++, $row, 'Nombre de Cuenta')
			->setCellValueByColumnAndRow($col++, $row, 'Debe')
			->setCellValueByColumnAndRow($col++, $row, 'Haber');

		# ESTILO ENCABEZADO DEL DOCUMENTO
		$objPHPExcel->getActiveSheet()->getStyle('A'.$row.':D'.$row)->applyFromArray($bordersThin);
		$row++;
		$rowIni = $row;
        $tipot=$rec["poli_tipo"];
        $numt=$rec["poli_num"];
        $linea=2;
    }

	$col=$colIni;
	$objPHPExcel->getActiveSheet()
		->setCellValueByColumnAndRow($col++, $row, $rec['poli_cta'])
		->setCellValueByColumnAndRow($col++, $row, utf8_encode($rec['poli_ctan']))
		->setCellValueByColumnAndRow($col++, $row, ($rec["poli_debe"] != 0) ? $rec["poli_debe"] : "")
		->setCellValueByColumnAndRow($col, $row, ($rec["poli_haber"] != 0) ? $rec["poli_haber"] : "");
	$row++;
}
$col = $colIni+1;
$objPHPExcel->getActiveSheet()
	->setCellValueByColumnAndRow($col++, $row, 'Totales del documento')
	->setCellValueByColumnAndRow($col++, $row, '=SUM(C'.$rowIni.':C'.($row-1).')')
	->setCellValueByColumnAndRow($col, $row, '=SUM(D'.$rowIni.':D'.($row-1).')');

# FORMATO NUMERICO
$objPHPExcel->getActiveSheet()->getStyle('C'.$rowIni.':C'.$row)->getNumberFormat()->setFormatCode('#,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('D'.$rowIni.':D'.$row)->getNumberFormat()->setFormatCode('#,##0.00');

# ESTILO TOTAL
$objPHPExcel->getActiveSheet()->getStyle('C'.$row.':D'.$row)->applyFromArray($borderTopThin);
$objPHPExcel->getActiveSheet()->getStyle('C'.$row.':D'.$row)->applyFromArray($borderBottomDouble);
$row++;
$row++;

$col = $colIni+1;
$objPHPExcel->getActiveSheet()
	->setCellValueByColumnAndRow($col++, $row, 'Totales Generales')
	->setCellValueByColumnAndRow($col++, $row, '=SUMIF(B'.($rowVal+2).':B'.($row-2).',"Totales del documento",C'.($rowVal+2).':C'.($row-2).')')
	->setCellValueByColumnAndRow($col, $row, '=SUMIF(B'.($rowVal+2).':B'.($row-2).',"Totales del documento",D'.($rowVal+2).':D'.($row-2).')');

# FORMATO NUMERICO
$objPHPExcel->getActiveSheet()->getStyle('C'.$row)->getNumberFormat()->setFormatCode('#,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('D'.$row)->getNumberFormat()->setFormatCode('#,##0.00');

# ESTILO TOTAL
$objPHPExcel->getActiveSheet()->getStyle('C'.$row.':D'.$row)->applyFromArray($borderTopThin);
$objPHPExcel->getActiveSheet()->getStyle('C'.$row.':D'.$row)->applyFromArray($borderBottomDouble);

$objPHPExcel->getActiveSheet()->getStyle('A6'.':A'.$row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'bold' => true,
        'size' => 17,
    ),
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styFec = array(
	'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(17);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(17);

# FORMATOS
$objPHPExcel->getActiveSheet()->getStyle('C6'.':D'.$row)->getNumberFormat()->setFormatCode('#,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('A6'.':A'.$row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

//$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true); 

$objPHPExcel->getActiveSheet()->mergeCells('A1:D1')->getStyle('A1')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->mergeCells('A2:D2')->getStyle('A2')->applyFromArray($styFec);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['polizas'])->setTitle('Polizas');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="Poliza de Apertura.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>