<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);

# Para jalar año de la variable que sea tipo fecha
$AnoTrab=date("Y", strtotime($_SESSION['empFtrab']));
$TipoPol="001";

$lineWidth=17;
$lineHeight=0.35;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $dtFecI, $dtFecF,$txtTitulo,$numHoja,$cbFecsn,$cbNoFol,$AnoTrab;
        $func = new functions();
        $this->SetMargins(2.5, 1, 2.5);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNom),0,1,"C");
        $this->SetFont("Arial","B",9);        
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("POLIZAS DE APERTURA CORRESPONDIENTES A ").((string)($AnoTrab)),0,1,"C");

        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Hoja: ".((string)($this->PageNo()))),0,1,"R");
        $this->Ln();
    }
    
    function Footer() {
        global $cbFecsn;
        // Posición: a 1,5 cm del final
        $func = new functions();

        $this->SetY(-2);
        $this->SetFont("Arial","I",7);
        if ($func->stringToBool($cbFecsn)) {
            $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
        }
    }
}

# QUERYS
$sPoliini = "SELECT *,
            TRIM(pi.poli_cta) AS poli_cta,
            TRIM(pi.poli_ctan) AS poli_ctan,
            TRIM(pi.poli_con) AS poli_con,
            trim(tp.tp_nom) AS tp_nom
            FROM poliini pi LEFT JOIN tipopol tp ON pi.poli_tipo=tp.tp_cod WHERE poli_emp='$empCod' AND poli_ano='$AnoTrab'";

$uPoliini = "UPDATE poliini SET poli_stat='I' WHERE poli_emp='$empCod' AND poli_ano='$AnoTrab'";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["poliini"]=$db->query($sPoliini);

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();

$totDebe = 0;
$totHaber = 0;

$tipot="";
$numt=0;
$debe = 0;
$haber = 0;
$linea=1;
while ($rec = $db->fetchAssoc($select['poliini'])) {
    if (($rec["poli_tipo"]!=$tipot) || ($rec["poli_num"]!=$numt)) {

        if ($linea!=1) {
            $pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
            $pdf->SetAligns(array("","R","R","R"));
            $body = array(
                "",
                "Total Este Documento: ",
                number_format($debe,2),
                number_format($haber,2),
            );
            $pdf->RowBorderHidden($body, $lineHeight);
            $pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
            $pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);
            $debe = 0;
            $haber = 0;
            $pdf->Ln();
        }

        $pdf->SetFont("","B",8);
        $pdf->Cell($lineWidth/8, $lineHeight, utf8_decode("Tipo Poliza: "));
        $pdf->SetFont("");
        $pdf->Cell($lineWidth/6, $lineHeight, $rec["tp_nom"]);

        $pdf->SetFont("","B",8);
        $pdf->Cell($lineWidth/6, $lineHeight, utf8_decode("Número de Póliza: "));
        $pdf->SetFont("");
        $pdf->Cell($lineWidth/6, $lineHeight, $rec["poli_tipo"]."-".$rec["poli_num"]);

        $pdf->SetFont("","B");
        $pdf->Cell($lineWidth/6, $lineHeight, utf8_decode("Fecha de Póliza: "));
        $pdf->SetFont("");
        $pdf->Cell($lineWidth/5, $lineHeight, strftime("%d/%m/%Y", strtotime($rec["poli_fec"])),0,1);

        $pdf->SetFont("","B");
        $pdf->Cell($lineWidth/8, $lineHeight, "Concepto: ");
        $pdf->SetFont("");
        $pdf->MultiCell($lineWidth/1.35, $lineHeight, $rec["poli_con"]);
        $pdf->Ln($lineHeight*3);

        $header = array("Cuenta","Nombre de Cuenta","Debe","Haber");
        $pdf->SetFont("","B");
        $pdf->SetWidths(array(3,8,3,3));
        $pdf->SetAligns(array("C","C","C","C"));
        $pdf->Row($header, $lineHeight);

        $pdf->SetFont("");
        $pdf->SetAligns(array("L","L","R","R"));
        $debe = 0;
        $haber = 0;

        $tipot=$rec["poli_tipo"];
        $numt=$rec["poli_num"];
        $linea=2;
    }

    $debe += $rec["poli_debe"];
    $haber += $rec["poli_haber"];
    $totDebe += $rec["poli_debe"];
    $totHaber += $rec["poli_haber"];
    $body = array(
        $rec["poli_cta"],
        $rec["poli_ctan"],
        ($rec["poli_debe"] != 0) ? number_format($rec["poli_debe"],2) : "",
        ($rec["poli_haber"] != 0) ? number_format($rec["poli_haber"],2) : "",
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}

$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->SetAligns(array("","R","R","R"));
$body = array(
        "",
        "Total Este Documento: ",
        number_format($debe,2),
        number_format($haber,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);
$pdf->Ln();


$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->SetAligns(array("","R","R","R"));
$body = array(
    "",
    "Totales Generales: ",
    number_format($totDebe,2),
    number_format($totHaber,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);

# Para poner status de impreso en la poliza de cierre
$db->query($uPoliini);

$db->close();

$pdf->Output(utf8_decode("Polizas de Apertura").".pdf","I");
?>