<?php 
include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);
$pTcam=$_SESSION["pTcam"];
$empNit=utf8_decode($_SESSION['empNit']);

$selMes=$_GET["selMes"];
$selMesNom=$_GET["selMesNom"];
$numAno=$_GET["numAno"];
$selMesf=$_GET["selMesf"];
$selMesNomf=$_GET["selMesNomf"];
$numAnof=$_GET["numAnof"];
$cbFecsn=$_GET["cbFecsn"];
$cbNoIva=$_GET["cbNoIva"];
$txtNit=$_GET["txtNit"];
$txtProv=$_GET["txtProv"];
$Uldia=$_GET["Uldia"];
$Fecfin = (strval($numAnof)."-".strval($selMesf)."-".strval($Uldia));
$numDiai = 1;
$Fecini = (strval($numAno)."-".strval($selMes)."-".strval($numDiai));

$lineWidth=20;
$lineHeight=0.35;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $empNomc, $empNit, $selMes, $selMesNom, $numAno, $selMesf, $selMesNomf, $numAnof, $txtNit, $txtProv, $Fecini, $Fecfin, $cbFecsn, $cbNoIva, $lineWidth, $lineHeight;
        $this->SetMargins(1, 1, 2);

        $func = new functions();
        $this->SetFont("Arial","",9);
        $this->Cell(0, 0, "", 0, 1);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNom),0,1,"L");
        //$this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNomc),0,1,"C");

        if ($func->stringToBool($cbNoFol)) {
            $this->SetFont("Arial","I",8);
            $this->SetY(.7);
            $this->Cell(0,1, utf8_decode("Folio: ".(string)($this->PageNo())),0,1,"R");
        }

        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("COMPRAS REGISTRADAS A UN PROVEEDOR"),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Mes Inicial  ".trim($selMesNom)."  Año ".$numAno."  Mes Final  ".trim($selMesNomf)."  Año ".$numAnof."                    Nit: ".$empNit),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Proveedor: ".trim($txtNit)."     ".trim($txtProv)),0,1,"L");
        $this->Ln();

        $this->SetFont("","",7);
        $header = array("FECHA","SERIE","NUMERO","NIT", "PROVEEDOR", "COMBUSTIBLE", "COMPRAS", "SERVICIOS", "IMPORTACION", "IVA", "IMP/COMBUS.Y OTROS", "TOTAL");
        $this->SetWidths(array(1.5,2.2,2.2,2.2,4,2,1.6,2,2,1.8,2,2));
        $this->SetAligns(array("C","C","C","C","C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetAligns(array("C","L","L","L","L","R","R","R","R","R","R","R"));
    }
    
    function Footer() {
        global $cbFecsn;
        // Posición: a 1,5 cm del final
        $func = new functions();
        $this->SetY(-2);
        $this->SetFont("Arial","I",7);
        if ($func->stringToBool($cbFecsn)) {
            $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
        }
    }
}
# QUERYS
if ($cbNoIva) {
    $sIva_comp = "SELECT *,
                    TRIM(ic.iva_serie) AS iva_serie,
                    TRIM(ic.iva_nit) AS iva_nit,
                    TRIM(ic.iva_prov) AS iva_prov
                FROM iva_comp ic 
                WHERE ic.iva_emp='$empCod' AND ic.iva_rfec>='$Fecini' AND ic.iva_rfec<='$Fecfin' AND ic.iva_nit='$txtNit' ORDER BY ic.iva_emp,ic.iva_fec";
} else {
    $sIva_comp = "SELECT *,
                    TRIM(ic.iva_serie) AS iva_serie,
                    TRIM(ic.iva_nit) AS iva_nit,
                    TRIM(ic.iva_prov) AS iva_prov
                FROM iva_comp ic 
                WHERE ic.iva_emp='$empCod' AND ic.iva_rfec>='$Fecini' AND ic.iva_rfec<='$Fecfin' AND ic.iva_afe='S' AND ic.iva_nit='$txtNit' ORDER BY ic.iva_emp,ic.iva_fec";
}

# EJECUCION DE QUERYS
$db = new dbExec();
# GENERAR PDF
$pdf = new generatePDF("L","cm", array(22, 28));
$pdf->AddPage();

$func = new functions();
$linea=1;
$cantdoc=0;
$select["iva_comp"] = $db->query($sIva_comp);
while ($rec = $db->fetchAssoc($select['iva_comp'])) {
    // TASA DE CAMBIO
    $cantdoc += 1;
    $tsubco += $rec["iva_subco"];
    $tsubb = ($tsubb+$rec["iva_subb"]+$rec["iva_subme"]+$rec["iva_subve"]+$rec["iva_subna"]+$rec["iva_subac"]+$rec["iva_peque"]);
    $tsubs += $rec["iva_subs"]+$rec["iva_peque2"];
    $tsubi = $tsubi+$rec["iva_subi"]+$rec["iva_subir"];
    $tiva += $rec["iva_iva"];
    $tdedu += $rec["iva_dedu"];
    $ttot = $ttot+$rec["iva_tot"]+$rec["iva_dedu"];

    $rsubco += $rec["iva_subco"];
    $rsubb += $rec["iva_subb"];
    $rsubme += $rec["iva_subme"];
    $rsubve += $rec["iva_subve"];
    $rsubna += $rec["iva_subna"];
    $rsubac += $rec["iva_subac"];
    $rsubpe += $rec["iva_subpe"];
    $rsubs +=  $rec["iva_subs"];
    $rsubi +=  $rec["iva_subi"];
    $rsubir += $rec["iva_subir"];
    $riva += $rec["iva_iva"];
    $rdedu += ($rec["iva_dedu"]+$rec["iva_tasam"]);
    $rtot += $rec["iva_tot"];
    $rtott = $rtott+($rec["iva_tot"]+$rec["iva_dedu"]+$rec["iva_tasam"]); 

    $body = array(
        strftime("%d/%m/%Y", strtotime($rec["iva_fec"])),
        $rec["iva_serie"],
        $rec["iva_num"],
        $rec["iva_nit"],
        $rec["iva_prov"],
        (round($rec["iva_subco"], 2) != 0) ? number_format($rec["iva_subco"], 2, '.', ',') : "",
        (round($rec["iva_subb"]+$rec["iva_subme"]+$rec["iva_subve"]+$rec["iva_subna"]+$rec["iva_subac"]+$rec["iva_peque"], 2) != 0) ? number_format($rec["iva_subb"]+$rec["iva_subme"]+$rec["iva_subve"]+$rec["iva_subna"]+$rec["iva_subac"]+$rec["iva_subpe"], 2, '.', ',') : "",
        (round($rec["iva_subs"]+$rec["iva_peque2"], 2) != 0) ? number_format($rec["iva_subs"]+$rec["iva_peque2"], 2, '.', ',') : "",
        (round($rec["iva_subi"]+$rec["iva_subir"], 2) != 0) ? number_format($rec["iva_subi"]+$rec["iva_subir"], 2, '.', ',') : "",
        (round($rec["iva_iva"], 2) != 0) ? number_format($rec["iva_iva"], 2, '.', ',') : "",
        (round($rec["iva_dedu"]+$rec["iva_tasam"], 2) != 0) ? number_format($rec["iva_dedu"]+$rec["iva_tasam"], 2, '.', ',') : "",
        number_format($rec["iva_tot"]+$rec["iva_dedu"], 2, '.', ','),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
    //  (round($totSalIni, 2) != 0) ? number_format($totSalIni, 2, '.', ',') : "",

    $linea=2;
}

// TOTALES DEL MOVIMIENTO
//$pdf->Ln();
$pdf->line($pdf->GetX()+7, $pdf->GetY(), 26.5, $pdf->GetY());
$body = array(
    "",
    "",
    "",
    "",
    "TOTALES",
    number_format($tsubco, 2, '.', ','),
    number_format($tsubb, 2, '.', ','),
    number_format($tsubs, 2, '.', ','),
    number_format($tsubi, 2, '.', ','),
    number_format($tiva, 2, '.', ','),
    number_format($tdedu, 2, '.', ','),
    number_format($ttot, 2, '.', ','),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+7, $pdf->GetY(), 26.5, $pdf->GetY());

$db->close();
ob_end_clean();
ob_start();
$pdf->Output(utf8_decode("LIBRO DE COMPRAS").".pdf","I"); 

?>