<?php 
include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);
$pTcam=$_SESSION["pTcam"];
$empNit=utf8_decode($_SESSION['empNit']);

$selMes=$_GET["selMes"];
$selMesNom=$_GET["selMesNom"];
$numAno=$_GET["numAno"];
$numHoja=$_GET["numHoja"];
$cbFecsn=$_GET["cbFecsn"];
$cbNoFol=$_GET["cbNoFol"];

$lineWidth=20;
$lineHeight=0.35;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $empNomc, $empNit, $selMes, $selMesNom, $numAno, $numHoja, $cbFecsn, $cbNoFol, $lineWidth, $lineHeight;
        $this->SetMargins(1, 1, 2);

        $func = new functions();
        $this->SetFont("Arial","",9);
        $this->Cell(0, 0, "", 0, 1);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNom),0,1,"L");
        //$this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNomc),0,1,"C");

        if ($func->stringToBool($cbNoFol)) {
            $this->SetFont("Arial","I",8);
            $this->SetY(.7);
            $this->Cell(0,1, utf8_decode("Folio: ".((string)($this->PageNo())+$numHoja)),0,1,"R");
        }

        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("LIBRO DE VENTAS Y SERVICIOS (RESUMIDO)"),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Mes ".trim($selMesNom)."  Año ".$numAno."                    Nit: ".$empNit),0,1,"L");
        //$this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Cifras Expresadas en ".$textoMoneda),0,1,"C");
        $this->Ln();

        $this->SetFont("","",7);
        $header = array("FECHA","SERIE","DEL","AL","CLIENTE", "VENTAS", "EXENTO", "SERVICIOS", "EXPORTACION", "IVA", "TOTAL");
        $this->SetWidths(array(1.5,2,2,2,2.5,1.5,1.5,1.6,1.5,1.5,1.5));
        $this->SetAligns(array("C","C","C","C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);
        $this->SetAligns(array("C","L","L","L","L","R","R","R","R","R","R"));
    }
    
    function Footer() {
        global $cbFecsn;
        // Posición: a 1,5 cm del final
        $func = new functions();
        $this->SetY(-2);
        $this->SetFont("Arial","I",7);
        if ($func->stringToBool($cbFecsn)) {
            $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
        }
    }
}
# QUERYS
$sIva_ven = "SELECT *,
                TRIM(iv.ivav_serie) AS ivav_serie,
                MIN(iv.ivav_num) AS ivav_menor,
                MAX(iv.ivav_num) AS ivav_mayor, 
                (SUM(iv.ivav_subb)+SUM(iv.ivav_subme)+SUM(iv.ivav_subve)+SUM(iv.ivav_subco)) AS ivav_sumsubb,
                (SUM(iv.ivav_subna)+SUM(iv.ivav_exen)) AS ivav_sumexen, 
                SUM(iv.ivav_subs) AS ivav_sumsubs,
                (SUM(iv.ivav_sube)+SUM(iv.ivav_suber)) AS ivav_sumsube, 
                SUM(iv.ivav_iva) AS ivav_sumiva,
                SUM(iv.ivav_tot) AS ivav_sumtot,
                SUM(1) AS ivav_cantf 
            FROM iva_ven iv LEFT JOIN tipov tv ON tv.tv_cod=iv.ivav_tipo
            WHERE iv.ivav_emp='$empCod' AND year(iv.ivav_fec)=$numAno AND month(iv.ivav_fec)=$selMes AND iv.ivav_afe='S' 
            GROUP BY iv.ivav_fec,iv.ivav_serie ORDER BY ivav_emp,ivav_fec";

# EJECUCION DE QUERYS
$db = new dbExec();
# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();

$func = new functions();
$linea=1;
$cantdoc=0;
$sumncval=0;
$sumnccant=0;
$select["iva_ven"] = $db->query($sIva_ven);
while ($rec = $db->fetchAssoc($select['iva_ven'])) {
    // TASA DE CAMBIO
    $cantdoc += $rec["ivav_cantf"];
    $tsubna = $tsubna+($rec["ivav_sumexen"]);
    $tsubb = ($tsubb+$rec["ivav_sumsubb"]);
    $tsubs += $rec["ivav_sumsubs"];
    $tsube = $tsube+$rec["ivav_sumsube"];
    $tiva += $rec["ivav_sumiva"];
    $ttot += $rec["ivav_sumtot"];

    $rsubna += ($rec["ivav_sumexen"]);
    $rsubb  += ($rec["ivav_sumsubb"]);
    $rsubs  +=  $rec["ivav_sumsubs"];
    $rsube +=  ($rec["ivav_sumsube"]);
    $riva += $rec["ivav_sumiva"];
    $rtot += $rec["ivav_sumtot"];
    if ($rec["ivav_tot"]<0) {
        $sumnccant += $rec["ivav_cantf"];
        $sumncval += ($rec["ivav_sumtot"]*-1);
    }

    $body = array(
        strftime("%d/%m/%Y", strtotime($rec["ivav_fec"])),
        $rec["tv_nom"],
        $rec["ivav_menor"],
        $rec["ivav_mayor"],
        'CLIENTES VARIOS',
        (round($rec["ivav_sumsubb"], 2) != 0) ? number_format($rec["ivav_sumsubb"], 2, '.', ',') : "",
        (round($rec["ivav_sumexen"], 2) != 0) ? number_format($rec["ivav_sumexen"], 2, '.', ',') : "",
        (round($rec["ivav_sumsubs"], 2) != 0) ? number_format($rec["ivav_sumsubs"], 2, '.', ',') : "",
        (round($rec["ivav_sumsube"], 2) != 0) ? number_format($rec["ivav_sumsube"], 2, '.', ',') : "",
        (round($rec["ivav_sumiva"], 2) != 0) ? number_format($rec["ivav_sumiva"], 2, '.', ',') : "",
        number_format($rec["ivav_sumtot"], 2, '.', ','),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
    //  (round($totSalIni, 2) != 0) ? number_format($totSalIni, 2, '.', ',') : "",

    $linea=2;
    if (($pdf->GetY()+$lineHeight) > 25) {
        $pdf->line($pdf->GetX()+7, $pdf->GetY(), 20.6, $pdf->GetY());
        $body = array(
            "",
            "",
            "",
            "",
            "      VAN ................",
            number_format($tsubb, 2, '.', ','),
            number_format($tsubna, 2, '.', ','),
            number_format($tsubs, 2, '.', ','),
            number_format($tsube, 2, '.', ','),
            number_format($tiva, 2, '.', ','),
            number_format($ttot, 2, '.', ','),
        );
        $pdf->RowBorderHidden($body, $lineHeight);
        $pdf->line($pdf->GetX()+7, $pdf->GetY(), 20.6, $pdf->GetY());
        $pdf->AddPage();
        $pdf->line($pdf->GetX()+7, $pdf->GetY(), 20.6, $pdf->GetY());
        $body = array(
            "",
            "",
            "",
            "",
            "      VIENEN ............",
            number_format($tsubb, 2, '.', ','),
            number_format($tsubna, 2, '.', ','),
            number_format($tsubs, 2, '.', ','),
            number_format($tsube, 2, '.', ','),
            number_format($tiva, 2, '.', ','),
            number_format($ttot, 2, '.', ','),
        );
        $pdf->RowBorderHidden($body, $lineHeight);
        $pdf->line($pdf->GetX()+7, $pdf->GetY(), 20.6, $pdf->GetY());

    }
}

// TOTALES DEL MOVIMIENTO
//$pdf->Ln();
$pdf->line($pdf->GetX()+7, $pdf->GetY(), 20.6, $pdf->GetY());
$body = array(
    "",
    "",
    "",
    "",
    "TOTALES",
    number_format($tsubb, 2, '.', ','),
    number_format($tsubna, 2, '.', ','),
    number_format($tsubs, 2, '.', ','),
    number_format($tsube, 2, '.', ','),
    number_format($tiva, 2, '.', ','),
    number_format($ttot, 2, '.', ','),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX()+7, $pdf->GetY(), 20.6, $pdf->GetY());

if (($pdf->GetY()+$lineHeight) > 22) {
        $pdf->AddPage();
}
// RESUMEN
$pdf->Ln();
$pdf->SetFont("","",7);
$header = array("RESUMEN:","","No. Documentos",$cantdoc);
$pdf->SetWidths(array(3,2,3,2));
$pdf->SetAligns(array("L","R","L","R"));
$pdf->Row($header, $lineHeight);
$body = array("VENTAS",number_format($rsubb, 2, '.', ','),"SERVICIOS",number_format($rsubs, 2, '.', ','));
$pdf->Row($body, $lineHeight);
$body = array(utf8_decode("EXENTAS"),number_format($rsubna, 2, '.', ','),"EXPORTACIONES",number_format($rsube, 2, '.', ','));
$pdf->Row($body, $lineHeight);
$body = array("IVA",number_format($riva, 2, '.', ','),"TOTAL",number_format($rtot, 2, '.', ','));
$pdf->Row($body, $lineHeight);
$pdf->Ln();
$body = array("CANTIDAD NC", $sumnccant,"VALOR NOTAS CRED.",number_format($sumncval, 2, '.', ','));
$pdf->Row($body, $lineHeight);

$db->close();
ob_end_clean();
ob_start();
$pdf->Output(utf8_decode("LIBRO DE VENTAS RESUMIDO").".pdf","I"); 

?>