<?php 
include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);
$pTcam=$_SESSION["pTcam"];
$empNit=utf8_decode($_SESSION['empNit']);

$selMes=$_GET["selMes"];
$selMesNom=$_GET["selMesNom"];
$numAno=$_GET["numAno"];
$cbFecsn=$_GET["cbFecsn"];

$lineWidth=20;
$lineHeight=0.55;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $empNomc, $empNit, $selMes, $selMesNom, $numAno, $cbFecsn, $lineWidth, $lineHeight;
        $this->SetMargins(2.5, 1, 2);

        $func = new functions();
        $this->SetFont("Arial","B",12);
        $this->Cell(0, 0, "", 0, 1);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNom),0,1,"L");
        //$this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNomc),0,1,"C");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1, utf8_decode("Hoja: ".((string)($this->PageNo()))),0,1,"R");
        $this->SetFont("Arial","B",12);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("INFORMACION PARA LLENAR FORMULARIO DEL IVA"),0,1,"L");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Mes ".trim($selMesNom)."  Año ".$numAno."                    Nit: ".$empNit),0,1,"L");
        //$this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Cifras Expresadas en ".$textoMoneda),0,1,"C");
        $this->Ln();

        $this->SetFont("","",10);
        $header = array("TITULO","VALOR");
        $this->SetWidths(array(10,4));
        $this->SetAligns(array("C","C"));
        $this->Row($header, $lineHeight);
        $this->SetAligns(array("L","R"));
    }
    
    function Footer() {
        global $cbFecsn;
        // Posición: a 1,5 cm del final
        $func = new functions();
        $this->SetY(-2);
        $this->SetFont("Arial","I",7);
        if ($func->stringToBool($cbFecsn)) {
            $this->Cell(8.5,1,strftime("%d/%m/%Y %T"),0,0,"L");
        }
        $this->SetFont("Arial","UB",8);
        $this->SetTextColor(35, 128, 220);
        $this->Cell(8.5,1,"Ir a Declaraguate (SAT) >",0,0,"R");
        $this->Link(15.8,26,4,1, 'https://declaraguate.sat.gob.gt/declaraguate-web/');
        //$this->link(1,1,20,1, "http://asjireh.com");
    }
}
# QUERYS
$sIva_ven = "SELECT *,
                SUM(iv.ivav_subb) AS ivav_tsubb,
                SUM(iv.ivav_subme) AS ivav_tsubme,
                SUM(iv.ivav_subve) AS ivav_tsubve,
                SUM(iv.ivav_subco) AS ivav_tsubco,
                SUM(iv.ivav_subna) AS ivav_tsubna,
                SUM(iv.ivav_exen) AS ivav_texen, 
                SUM(iv.ivav_subs) AS ivav_tsubs,
                SUM(iv.ivav_sube) AS ivav_tsube,
                SUM(iv.ivav_suber) AS ivav_tsuber, 
                SUM(iv.ivav_iva) AS ivav_tiva,
                SUM(iv.ivav_tot) AS ivav_ttot,
                SUM(1) AS ivav_cantf 
            FROM iva_ven iv 
            WHERE iv.ivav_emp='$empCod' AND year(iv.ivav_fec)=$numAno AND month(iv.ivav_fec)=$selMes AND iv.ivav_afe='S' AND iv.ivav_tot>=0.00 GROUP BY year(iv.ivav_fec),month(iv.ivav_fec) ORDER BY ivav_emp";

$sIva_ven52 = "SELECT *,
                SUM(iv.ivav_subb) AS ivav_tsubb,
                SUM(iv.ivav_subme) AS ivav_tsubme,
                SUM(iv.ivav_subve) AS ivav_tsubve,
                SUM(iv.ivav_subco) AS ivav_tsubco,
                SUM(iv.ivav_subna) AS ivav_tsubna,
                SUM(iv.ivav_exen) AS ivav_texen, 
                SUM(iv.ivav_subs) AS ivav_tsubs,
                SUM(iv.ivav_sube) AS ivav_tsube,
                SUM(iv.ivav_suber) AS ivav_tsuber, 
                SUM(iv.ivav_iva) AS ivav_tiva,
                SUM(iv.ivav_tot) AS ivav_ttot,
                SUM(1) AS ivav_cantf 
            FROM iva_ven iv 
            WHERE iv.ivav_emp='$empCod' AND year(iv.ivav_fec)=$numAno AND month(iv.ivav_fec)=$selMes AND iv.ivav_afe='S' AND iv.ivav_tipo='052' GROUP BY year(iv.ivav_fec),month(iv.ivav_fec) ORDER BY ivav_emp";

$sIva_ven55 = "SELECT *,
                SUM(iv.ivav_subb) AS ivav_tsubb,
                SUM(iv.ivav_subme) AS ivav_tsubme,
                SUM(iv.ivav_subve) AS ivav_tsubve,
                SUM(iv.ivav_subco) AS ivav_tsubco,
                SUM(iv.ivav_subna) AS ivav_tsubna,
                SUM(iv.ivav_exen) AS ivav_texen, 
                SUM(iv.ivav_subs) AS ivav_tsubs,
                SUM(iv.ivav_sube) AS ivav_tsube,
                SUM(iv.ivav_suber) AS ivav_tsuber, 
                SUM(iv.ivav_iva) AS ivav_tiva,
                SUM(iv.ivav_tot) AS ivav_ttot,
                SUM(1) AS ivav_cantf 
            FROM iva_ven iv 
            WHERE iv.ivav_emp='$empCod' AND year(iv.ivav_fec)=$numAno AND month(iv.ivav_fec)=$selMes AND iv.ivav_afe='S' AND iv.ivav_tipo='055' GROUP BY year(iv.ivav_fec),month(iv.ivav_fec) ORDER BY ivav_emp";

$sIva_venNC = "SELECT *,
                SUM(iv.ivav_subb) AS ivav_tsubb,
                SUM(iv.ivav_subme) AS ivav_tsubme,
                SUM(iv.ivav_subve) AS ivav_tsubve,
                SUM(iv.ivav_subco) AS ivav_tsubco,
                SUM(iv.ivav_subna) AS ivav_tsubna,
                SUM(iv.ivav_exen) AS ivav_texen, 
                SUM(iv.ivav_subs) AS ivav_tsubs,
                SUM(iv.ivav_sube) AS ivav_tsube,
                SUM(iv.ivav_suber) AS ivav_tsuber, 
                SUM(iv.ivav_iva) AS ivav_tiva,
                SUM(iv.ivav_tot) AS ivav_ttot,
                SUM(1) AS ivav_cantf 
            FROM iva_ven iv 
            WHERE iv.ivav_emp='$empCod' AND year(iv.ivav_fec)=$numAno AND month(iv.ivav_fec)=$selMes AND iv.ivav_afe='S' AND iv.ivav_tot<0.00 GROUP BY year(iv.ivav_fec),month(iv.ivav_fec) ORDER BY ivav_emp";

$sIva_com = "SELECT *, 
            SUM(ic.iva_subb) AS iva_tsubb,
            SUM(ic.iva_subs) AS iva_tsubs,
            SUM(ic.iva_subco) AS iva_tsubco,
            SUM(ic.iva_subi)  AS iva_tsubi,
            SUM(ic.iva_subpe) AS iva_tsubpe,
            SUM(ic.iva_subme) AS iva_tsubme,
            SUM(ic.iva_subve) AS iva_tsubve,
            SUM(ic.iva_subac) AS iva_tsubac, 
            SUM(ic.iva_subna) AS iva_tsubna,            
            SUM(1) AS iva_cantf 
            FROM iva_comp ic WHERE ic.iva_emp='$empCod' AND year(ic.iva_rfec)=$numAno AND month(ic.iva_rfec)=$selMes AND ic.iva_afe='S' AND iva_tot>=0.00 GROUP BY year(ic.iva_rfec),month(ic.iva_rfec) ORDER BY iva_emp";

$sIva_comNC = "SELECT *, 
            SUM(ic.iva_subb) AS iva_tsubb,
            SUM(ic.iva_subs) AS iva_tsubs,
            SUM(ic.iva_subco) AS iva_tsubco,
            SUM(ic.iva_subi)  AS iva_tsubi,
            SUM(ic.iva_subpe) AS iva_tsubpe,
            SUM(ic.iva_subme) AS iva_tsubme,
            SUM(ic.iva_subve) AS iva_tsubve,
            SUM(ic.iva_subac) AS iva_tsubac, 
            SUM(ic.iva_subna) AS iva_tsubna,            
            SUM(1) AS iva_cantf 
            FROM iva_comp ic WHERE ic.iva_emp='$empCod' AND year(ic.iva_rfec)=$numAno AND month(ic.iva_rfec)=$selMes AND ic.iva_afe='S' AND iva_tot<0.00 GROUP BY year(ic.iva_rfec),month(ic.iva_rfec) ORDER BY iva_emp";

$sIva_com52 = "SELECT *, 
            SUM(ic.iva_subb) AS iva_tsubb,
            SUM(ic.iva_subs) AS iva_tsubs,
            SUM(ic.iva_subco) AS iva_tsubco,
            SUM(ic.iva_subi)  AS iva_tsubi,
            SUM(ic.iva_subme) AS iva_tsubme,
            SUM(ic.iva_subpe) AS iva_tsubpe,
            SUM(ic.iva_subve) AS iva_tsubve,
            SUM(ic.iva_subac) AS iva_tsubac, 
            SUM(ic.iva_subna) AS iva_tsubna,            
            SUM(1) AS iva_cantf 
            FROM iva_comp ic WHERE ic.iva_emp='$empCod' AND year(ic.iva_rfec)=$numAno AND month(ic.iva_rfec)=$selMes AND ic.iva_afe='S'  AND ic.iva_tot>=0.00 AND ic.iva_tipo='052' GROUP BY year(ic.iva_rfec),month(ic.iva_rfec) ORDER BY iva_emp";

# EJECUCION DE QUERYS
$db = new dbExec();
# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();

$func = new functions();
$linea=1;
$cantdoc=0;
$lineHeight=0.50;
$select["iva_ven"] = $db->query($sIva_ven);
while ($rec = $db->fetchAssoc($select['iva_ven'])) {
    // TASA DE CAMBIO
    $pdf->Ln();
    $pdf->SetFont("","U",12);
    $body = array('VENTAS - DEBITO FISCAL POR OPERACIONES LOCALES','',);
    $pdf->RowBorderHidden($body, $lineHeight);
    $pdf->Ln();    
    $pdf->SetFont("","",10);
    $body = array('Ventas exentas y Servicios exentos',number_format($rec["ivav_texen"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('Ventas Medicamentos',number_format($rec["ivav_tsubme"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('Ventas No Afectas ',number_format($rec["ivav_tsubna"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('Ventas Vehiculos ',number_format($rec["ivav_tsubve"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('Ventas Gravadas ',number_format($rec["ivav_tsubb"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('Servicios Gravados ',number_format($rec["ivav_tsubs"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $pdf->line($pdf->GetX(), $pdf->GetY(), 16.5, $pdf->GetY());
    $body = array('                TOTAL DEBITOS ',number_format($rec["ivav_texen"]+$rec["ivav_tsubme"]+$rec["ivav_tsubna"]+$rec["ivav_tsubve"]+$rec["ivav_tsubb"]+$rec["ivav_tsubs"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $pdf->line($pdf->GetX(), $pdf->GetY(), 16.5, $pdf->GetY());
    $body = array('Total de facturas Emitidas incluye FYDUCA y Especiales',number_format($rec["ivav_cantf"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
}
$select["iva_ven"] = $db->query($sIva_ven52);
while ($rec = $db->fetchAssoc($select['iva_ven'])) {
    $body = array('FYDUCA Emitidas ',number_format($rec["ivav_cantf"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
}
$select["iva_ven"] = $db->query($sIva_ven55);
while ($rec = $db->fetchAssoc($select['iva_ven'])) {
    $body = array('Facturas Especiales Emitidas ',number_format($rec["ivav_cantf"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
}

$select["iva_ven"] = $db->query($sIva_venNC);
while ($rec = $db->fetchAssoc($select['iva_ven'])) {
    $sumNCv=$rec["ivav_tsubb"]+$rec["ivav_tsubs"]+$rec["ivav_tsube"]+$rec["ivav_tsuber"]+$rec["ivav_tsubna"];
    $canNCv=$rec["ivav_cantf"];
}

$select["iva_com"] = $db->query($sIva_comNC);
while ($rec = $db->fetchAssoc($select['iva_com'])) {
    $sumNCc=$rec["iva_tsubb"]+$rec["iva_tsubs"]+$rec["iva_tsubi"]+$rec["iva_tsubir"]+$rec["iva_tsubna"];
    $canNCc=$rec["iva_cantf"];
}

$select["iva_com"] = $db->query($sIva_com52);
while ($rec = $db->fetchAssoc($select['iva_com'])) {
    $sumFyduca=$rec["iva_tsubb"]+$rec["iva_tsubs"]+$rec["iva_tsube"]+$rec["iva_tsuber"];
    $canfFyduca=$rec["ivav_cantf"];
}

$select["iva_com"] = $db->query($sIva_com);
while ($rec = $db->fetchAssoc($select['iva_com'])) {
    // TASA DE CAMBIO
    $pdf->Ln();
    $pdf->SetFont("","U",12);
    $body = array('COMPRAS - CREDITO FISCAL','',);
    $pdf->RowBorderHidden($body, $lineHeight);
    $pdf->Ln();    
    $pdf->SetFont("","",10);
    $body = array('Compras Medicamentos',number_format($rec["iva_tsubme"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array(utf8_decode('Compras y Servicios Pequeño Contribuyente'),number_format($rec["iva_tsubpe"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('Compras y que no generan Credito Fiscal',number_format($rec["iva_tsubna"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('Compras Vehiculos ',number_format($rec["iva_tsubve"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('Compras Combustibles ',number_format($rec["iva_tsubco"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('Otras Compras ',number_format($rec["iva_tsubb"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('Servicios Aquiridos ',number_format($rec["iva_tsubs"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('Importaciones Centro America ',number_format($rec["iva_tsube"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('Importaciones Resto del Mundo ',number_format($rec["iva_tsuber"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('Activos ',number_format($rec["iva_tsubac"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('Adquisicion con FYDUCA ',number_format($sumFyduca, 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $pdf->line($pdf->GetX(), $pdf->GetY(), 16.5, $pdf->GetY());
    $body = array('                TOTAL CREDITOS ',number_format(($rec["iva_tsubme"]+$rec["iva_tsubpe"]+$rec["iva_tsubna"]+$rec["iva_tsubco"]+$rec["iva_tsubve"]+$rec["iva_tsubb"]+$rec["iva_tsubs"]+$rec["iva_tsube"]+$rec["iva_tsuber"]+$rec["iva_tsubac"]+$sumFyduca), 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $pdf->line($pdf->GetX(), $pdf->GetY(), 16.5, $pdf->GetY());
    $body = array('Total de facturas Emitidas incluye FYDUCA y Especiales',number_format($rec["iva_cantf"], 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);
    $body = array('FYDUCA Recibidas ',number_format($canfFyduca, 2, '.', ','),);
    $pdf->RowBorderHidden($body, $lineHeight);

}
$pdf->Ln();    
$pdf->Ln();    
$pdf->SetFont("","U",12);
$body = array('NOTAS DE CREDITO','',);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->Ln();
$pdf->SetFont("","",10);
$body = array('Cantidad de Notas de Credito Emitidas',number_format($canNCv, 2, '.', ','),);
$pdf->RowBorderHidden($body, $lineHeight);
$body = array('Valor de Notas de Credito Emitidas',number_format($sumNCv, 2, '.', ','),);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->Ln();    
$body = array('Cantidad de Notas de Credito Recibidas',number_format($canNCc, 2, '.', ','),);
$pdf->RowBorderHidden($body, $lineHeight);
$body = array('Valor de Notas de Credito Recibidas',number_format($sumNCc, 2, '.', ','),);
$pdf->RowBorderHidden($body, $lineHeight);
//$pdf->Ln();
$pdf->line($pdf->GetX(), $pdf->GetY(), 16.5, $pdf->GetY());

$db->close();
ob_end_clean();
ob_start();
$pdf->Output(utf8_decode("FORMULARIO PARA PAGO DE IVA").".pdf","I"); 

?>