<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */

include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once('../../../php/maxExecTime.php');
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empMoneda=utf8_decode($_SESSION["empMoneda"]);
$empTcam=utf8_decode($_SESSION["pTcam"]);

$numNum=$_GET["numNum"];
$dtDel=$_GET["dtDel"];
$dtAl=$_GET["dtAl"];
$selBodegapro=$_GET['selBodegapro'];
$selDep=$_GET['selDep'];
$selPuesto=$_GET['selPuesto'];
$crTrepo=$_GET['crTrepo'];

# QUERYS
if ($selDep=="000") {
    if ($selPuesto=="000") {
        $sNomper = "SELECT np.*, gru.*, dep.*, mae.mae_gru, mae.mae_dep, mae.mae_tpue,  TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape, mae_igsssn,
                    TRIM(gru_nom) AS gru_nom, TRIM(dep_nom) AS dep_nom, mae.mae_fpago, TRIM(tpu.tpu_nom) AS tpu_nom 
                    FROM nomper np
                    LEFT JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
                    LEFT JOIN tpuesto tpu ON np.np_tpue = tpu.tpu_cod 
                    LEFT JOIN grupo gru ON np.np_emp=gru.gru_emp AND np.np_gru = gru.gru_cod 
                    LEFT JOIN dep dep ON np.np_emp=dep.dep_emp AND np.np_dep = dep.dep_cod 
                    WHERE np_emp='$empCod' AND np_numpla='$numNum' and np.np_bodega='$selBodegapro' ORDER BY np_dep, np.np_tpue,mae.mae_nom,mae.mae_ape";
    } else {
        $sNomper = "SELECT np.*, gru.*, dep.*, mae.mae_gru, mae.mae_dep, mae.mae_tpue,  TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape, mae_igsssn, 
                    TRIM(gru_nom) AS gru_nom, TRIM(dep_nom) AS dep_nom, mae.mae_fpago, TRIM(tpu.tpu_nom) AS tpu_nom 
                    FROM nomper np
                    LEFT JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
                    LEFT JOIN tpuesto tpu ON np.np_tpue = tpu.tpu_cod 
                    LEFT JOIN grupo gru ON np.np_emp=gru.gru_emp AND np.np_gru = gru.gru_cod 
                    LEFT JOIN dep dep ON np.np_emp=dep.dep_emp AND np.np_dep = dep.dep_cod 
                    WHERE np_emp='$empCod' AND np_numpla='$numNum' and np.np_bodega='$selBodegapro' and np.np_tpue='$selPuesto' ORDER BY np_dep, np.np_tpue,mae.mae_nom,mae.mae_ape";
    }       
} else {
    if ($selPuesto=="000") {
        $sNomper = "SELECT np.*, gru.*, dep.*, mae.mae_gru, mae.mae_dep, mae.mae_tpue,  TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape, mae_igsssn, 
                    TRIM(gru_nom) AS gru_nom, TRIM(dep_nom) AS dep_nom, mae.mae_fpago, TRIM(tpu.tpu_nom) AS tpu_nom 
                    FROM nomper np
                    LEFT JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
                    LEFT JOIN tpuesto tpu ON np.np_tpue = tpu.tpu_cod 
                    LEFT JOIN grupo gru ON np.np_emp=gru.gru_emp AND np.np_gru = gru.gru_cod 
                    LEFT JOIN dep dep ON np.np_emp=dep.dep_emp AND np.np_dep = dep.dep_cod 
                    WHERE np_emp='$empCod' AND np_numpla='$numNum' and np.np_bodega='$selBodegapro' and np_dep='$selDep' ORDER BY np_dep, np.np_tpue,mae.mae_nom,mae.mae_ape";
    } else {
        $sNomper = "SELECT np.*, gru.*, dep.*, mae.mae_gru, mae.mae_dep, mae.mae_tpue,  TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape, mae_igsssn, 
                    TRIM(gru_nom) AS gru_nom, TRIM(dep_nom) AS dep_nom, mae.mae_fpago, TRIM(tpu.tpu_nom) AS tpu_nom 
                    FROM nomper np
                    LEFT JOIN maestro mae ON np.np_emp=mae.mae_emp AND np.np_cod = mae.mae_cod 
                    LEFT JOIN tpuesto tpu ON np.np_tpue = tpu.tpu_cod 
                    LEFT JOIN grupo gru ON np.np_emp=gru.gru_emp AND np.np_gru = gru.gru_cod 
                    LEFT JOIN dep dep ON np.np_emp=dep.dep_emp AND np.np_dep = dep.dep_cod 
                    WHERE np_emp='$empCod' AND np_numpla='$numNum' and np.np_bodega='$selBodegapro' and np_dep='$selDep' and np.np_tpue='$selPuesto' ORDER BY np_dep, np.np_tpue,mae.mae_nom,mae.mae_ape";
    }       
}       

# EJECUCION DE QUERYS
$db = new dbExec();
$select["nomper"] = $db->query($sNomper);

$func = new functions();

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
    die('This example should only be run from a Web Browser');

require_once dirname(__FILE__) . '/../../../php/PHPExcel/Classes/PHPExcel.php';

$iIni=0;
$objPHPExcel = new PHPExcel();

# CREAR HOJAS
for ($i=0; $i < 1; $i++) { 
    $objPHPExcel->createSheet();
}

# HOJAS
$sheet['planilla']=0;

# ESTABLECER PROPIEDADES DEL DOCUMENTO
$objPHPExcel->getProperties()->setCreator("Asesoría en Sistemas, S.A.")
                        ->setLastModifiedBy("Asesoría en Sistemas, S.A.")
                        ->setTitle("Office 2007 XLSX Test Document")
                        ->setSubject("Office 2007 XLSX Test Document")
                        ->setDescription("")
                        ->setKeywords("office 2007 openxml php")
                        ->setCategory("Contabilidad General");

# ENCABEZADO PRIMER HOJA
$i=$iIni;
$j=7;
$objPHPExcel->setActiveSheetIndex($sheet['planilla'])
            ->setCellValueByColumnAndRow($i+9, 2, TRIM($empNom))
            ->setCellValueByColumnAndRow($i+9, 3, "PLANILLA DE SALARIOS NUMERO: ".$numNum)

            ->setCellValueByColumnAndRow($i+9, 4, "Correspondiente del ".strftime("%d/%m/%Y", strtotime($dtDel))." al ".strftime("%d/%m/%Y", strtotime($dtAl)))
            ->setCellValueByColumnAndRow($i++, $j, 'No.')
            ->setCellValueByColumnAndRow($i++, $j, 'CODIGO')
            ->setCellValueByColumnAndRow($i++, $j, 'NOMBRE Y APELLIDOS')
            ->setCellValueByColumnAndRow($i++, $j, 'PUESTO DE TRABAJO')
            ->setCellValueByColumnAndRow($i++, $j, 'DIAS TRABAJADOS')
            ->setCellValueByColumnAndRow($i++, $j, 'SEPTIMOS')
            ->setCellValueByColumnAndRow($i++, $j, 'TOTAL dias')
            ->setCellValueByColumnAndRow($i++, $j, 'HORAS EXTRAS')
            ->setCellValueByColumnAndRow($i++, $j, 'SALARIO DIARIO')
            ->setCellValueByColumnAndRow($i++, $j, 'ORDINARIO')
            ->setCellValueByColumnAndRow($i++, $j, 'EXTRAORDINARIO')
            ->setCellValueByColumnAndRow($i++, $j, 'VALOR SEPTIMO')
            ->setCellValueByColumnAndRow($i++, $j, 'OTROS')
            ->setCellValueByColumnAndRow($i++, $j, 'TOTAL DEVENGADO')
            ->setCellValueByColumnAndRow($i++, $j, 'IGSS')
            ->setCellValueByColumnAndRow($i++, $j, 'OTROS DESCUENTOS')
            ->setCellValueByColumnAndRow($i++, $j, 'TOTAL deducciones')
            ->setCellValueByColumnAndRow($i++, $j, 'BONO DECRETO 78-89')
            ->setCellValueByColumnAndRow($i++, $j, 'BONO INCENTIVO')
            ->setCellValueByColumnAndRow($i++, $j, 'BONO14 AGUINALDO')
            ->setCellValueByColumnAndRow($i++, $j, 'VACACIONES')
            ->setCellValueByColumnAndRow($i++, $j, 'SUELDO LIQUIDO')
            ->setCellValueByColumnAndRow($i++, $j, 'FIRMA DE RECIBIDO Y CONFORME');

# ESTILO ENCABEZADO PRIMERA HOJA
$styEmp = array(
    'font' => array(
        'name' => 'Arial',
        'bold' => true,
        'size' => 72,
        //'color' => array('rgb' => 'FFFFFF')
        'color' => array('rgb' => '16365C')

    ),
/*    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),      */
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => '354D73') ),
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
//        'wrap' => true,
        'merge' => true,
        )
);
$styEmp1 = array(
    'font' => array(
        'name' => 'Arial',
        'bold' => true,
        'size' => 30,
        //'color' => array('rgb' => 'FFFFFF')
        'color' => array('rgb' => '16365C')

    ),
/*    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),    */
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => '354D73') ),
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    //    'wrap' => true,
        )    
);


$styFec = array(
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    )
);

$styEncabezado = array(
    'font' => array(
        'name' => 'Arial',
        'bold' => true,
        'size' => 16,
        'name' => 'Arial',
        //'color' => array('rgb' => 'FFFFFF')
        'color' => array('rgb' => '16365C')

    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'E6B8B7') ),
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
    'alignment' => array(
        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        'wrap' => true,
        )    
);

$styTotales = array(
    'font' => array(
        'bold' => true,
        'size' => 16,
        'color' => array('rgb' => 'FFFFFF')
        //'color' => array('rgb' => '001a57')

    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
        )
    ),
    'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => '354D73') )
    //'fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID, 'color' => array('rgb' => 'c3c3c3') )
);

$styLineas = array(
    'font' => array(
        'name' => 'Arial',
        'bold' => false,
        'size' => 26,
    ),
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);
//foreach(range('A','I') as $colID) { 
//    $objPHPExcel->getActiveSheet()->getColumnDimension($colID)->setAutoSize(true); 
//}

$objPHPExcel->getActiveSheet()->getStyle('A2:W2')->applyFromArray($styEmp);
$objPHPExcel->getActiveSheet()->getStyle('A3:W3')->applyFromArray($styEmp1);
$objPHPExcel->getActiveSheet()->getStyle('A4:W4')->applyFromArray($styEmp1);
$objPHPExcel->getActiveSheet()->getStyle('A7:W7')->applyFromArray($styEncabezado);

$totdepo=0;
$totch=0;
$totefec=0;
$grupop=99999;
$depp=99999;
$t_lini=1;
$j=8;
$inidep=8;
$nocorr=1;
while ($rec = $db->fetchAssoc($select["nomper"])) {
    if ($crTrepo=='S' && $rec["mae_igsssn"] =='N') {
        continue;
    }
    if ($crTrepo=='N' && $rec["mae_igsssn"] =='S') {
        continue;
    }
    if (($rec["np_gru"].$rec["np_dep"]) != ($grupop.$depp)) {
        if ($t_lini>1) {
           $i=$iIni;
           $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($i++, $j, "")
                    ->setCellValueByColumnAndRow($i++, $j, "")
                    ->setCellValueByColumnAndRow($i++, $j, "           TOTAL ESTE DEPARTAMENTO")
                    ->setCellValueByColumnAndRow($i++, $j, "")
                    ->setCellValueByColumnAndRow($i++, $j, "")
                    ->setCellValueByColumnAndRow($i++, $j, "")
                    ->setCellValueByColumnAndRow($i++, $j, "")
                    ->setCellValueByColumnAndRow($i++, $j, "")
                    ->setCellValueByColumnAndRow($i++, $j, "")
                    ->setCellValueByColumnAndRow($i++, $j, '=SUM(J'.$inidep.':J'.($j-1).')') 
                    ->setCellValueByColumnAndRow($i++, $j, '=SUM(K'.$inidep.':K'.($j-1).')') 
                    ->setCellValueByColumnAndRow($i++, $j, '=SUM(L'.$inidep.':L'.($j-1).')') 
                    ->setCellValueByColumnAndRow($i++, $j, '=SUM(M'.$inidep.':M'.($j-1).')') 
                    ->setCellValueByColumnAndRow($i++, $j, '=SUM(N'.$inidep.':N'.($j-1).')') 
                    ->setCellValueByColumnAndRow($i++, $j, '=SUM(O'.$inidep.':O'.($j-1).')') 
                    ->setCellValueByColumnAndRow($i++, $j, '=SUM(P'.$inidep.':P'.($j-1).')') 
                    ->setCellValueByColumnAndRow($i++, $j, '=SUM(Q'.$inidep.':Q'.($j-1).')') 
                    ->setCellValueByColumnAndRow($i++, $j, '=SUM(R'.$inidep.':R'.($j-1).')') 
                    ->setCellValueByColumnAndRow($i++, $j, '=SUM(S'.$inidep.':S'.($j-1).')') 
                    ->setCellValueByColumnAndRow($i++, $j, '=SUM(T'.$inidep.':T'.($j-1).')') 
                    ->setCellValueByColumnAndRow($i++, $j, '=SUM(U'.$inidep.':U'.($j-1).')') 
                    ->setCellValueByColumnAndRow($i++, $j, '=SUM(V'.$inidep.':V'.($j-1).')');
                $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':V'.$j)->applyFromArray($styTotales);
            $j+=1;
            $inidep=$j;
        }

        $i=$iIni;
        $objPHPExcel->getActiveSheet()
                    ->setCellValueByColumnAndRow($i++, $j, $rec["dep_nom"]);
        $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':G'.$j)->applyFromArray($styLineas);

        $grupop=$rec["np_gru"];
        $depp=$rec["np_dep"];
        $j+=1;
        $t_lini=2;
    }
    $i=$iIni;
    $objPHPExcel->getActiveSheet()
                ->setCellValueByColumnAndRow($i++, $j, $nocorr)
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_cod"])
                ->setCellValueByColumnAndRow($i++, $j, utf8_encode($rec["mae_nom"]." ".$rec["mae_ape"]))
                ->setCellValueByColumnAndRow($i++, $j, $rec["tpu_nom"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_dtra"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_dsept"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_dtra"]+$rec["np_dsept"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_hsim"]+$rec["np_hdob"])
                ->setCellValueByColumnAndRow($i++, $j, round($rec["np_snom"]/15,2))
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sord"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sexts"]+$rec["np_sextd"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_ssept"])
                ->setCellValueByColumnAndRow($i++, $j, ($rec["np_bonii"]+$rec["np_bonoe"]+$rec["np_depre"]+$rec["np_viati"]+$rec["np_comi"]+$rec["np_otrp"]))
                ->setCellValueByColumnAndRow($i++, $j, ($rec["np_sord"]+$rec["np_sexts"]+$rec["np_sextd"]+$rec["np_ssept"]+$rec["np_bonii"]+$rec["np_bonoe"]+$rec["np_depre"]+$rec["np_viati"]+$rec["np_comi"]+$rec["np_otrp"]))
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_igss"])
                ->setCellValueByColumnAndRow($i++, $j, ($rec["np_isr"]+$rec["np_anti"]+$rec["np_unif"]+$rec["np_lent"]+$rec["np_preb"]+$rec["np_pree"]+$rec["np_desj"]+$rec["np_otrd"]))
                ->setCellValueByColumnAndRow($i++, $j, ($rec["np_igss"]+$rec["np_isr"]+$rec["np_anti"]+$rec["np_unif"]+$rec["np_lent"]+$rec["np_preb"]+$rec["np_pree"]+$rec["np_desj"]+$rec["np_otrd"]))
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_boni"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_sferi"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_bono14"]+$rec["np_agui"])
                ->setCellValueByColumnAndRow($i++, $j, $rec["np_vaca"])
                ->setCellValueByColumnAndRow($i++, $j, ($rec["np_sord"]+$rec["np_sexts"]+$rec["np_sextd"]+$rec["np_ssept"]+$rec["np_bonii"]+$rec["np_bonoe"]+$rec["np_depre"]+$rec["np_viati"]+$rec["np_comi"]+$rec["np_otrp"]+$rec["np_boni"]+$rec["np_sferi"]+$rec["np_bono14"]+$rec["np_agui"]+$rec["np_vaca"])-($rec["np_igss"]+$rec["np_isr"]+$rec["np_anti"]+$rec["np_unif"]+$rec["np_lent"]+$rec["np_preb"]+$rec["np_pree"]+$rec["np_desj"]+$rec["np_otrd"])); 
    $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':W'.$j)->applyFromArray($styLineas);
    $j+=1;
    if ($rec["np_fpago"]<=2) {
        $totdepo+=$rec["np_liqrec"];
    } 
    if ($rec["np_fpago"]>2 && $rec["np_fpago"]!=5) {
        $totch+=$rec["np_liqrec"];
    } 
    if ($rec["np_fpago"]==5) {
        $totefec+=$rec["np_liqrec"];
    } 
    $nocorr+=1;
}
$i=$iIni;
$objPHPExcel->getActiveSheet()
        ->setCellValueByColumnAndRow($i++, $j, "")
        ->setCellValueByColumnAndRow($i++, $j, "")
        ->setCellValueByColumnAndRow($i++, $j, "           TOTAL ESTE DEPARTAMENTO")
        ->setCellValueByColumnAndRow($i++, $j, "")
        ->setCellValueByColumnAndRow($i++, $j, "")
        ->setCellValueByColumnAndRow($i++, $j, "")
        ->setCellValueByColumnAndRow($i++, $j, "")
        ->setCellValueByColumnAndRow($i++, $j, "")
        ->setCellValueByColumnAndRow($i++, $j, "")
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(J'.$inidep.':J'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(K'.$inidep.':K'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(L'.$inidep.':L'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(M'.$inidep.':M'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(N'.$inidep.':N'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(O'.$inidep.':O'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(P'.$inidep.':P'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(Q'.$inidep.':Q'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(R'.$inidep.':R'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(S'.$inidep.':S'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(T'.$inidep.':T'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(U'.$inidep.':U'.($j-1).')') 
        ->setCellValueByColumnAndRow($i++, $j, '=SUM(V'.$inidep.':V'.($j-1).')');
    $objPHPExcel->getActiveSheet()->getStyle('A'.$j.':V'.$j)->applyFromArray($styTotales);
$j+=1;
$inidep=$j;

$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "                          TOTAL GENERAL")
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, "") 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(C8:C'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",J8:J'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(C8:C'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",K8:K'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(C8:C'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",L8:L'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(C8:C'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",M8:M'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(C8:C'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",N8:N'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(C8:C'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",O8:O'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(C8:C'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",P8:P'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(C8:C'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",Q8:Q'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(C8:C'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",R8:R'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(C8:C'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",S8:S'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(C8:C'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",T8:T'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(C8:C'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",U8:U'.($j-1).')') 
    ->setCellValueByColumnAndRow($i++, $j, '=SUMIF(C8:C'.($j-1).',"           TOTAL ESTE DEPARTAMENTO",V8:V'.($j-1).')');
$objPHPExcel->getActiveSheet()->getStyle('A'.$j.':V'.$j)->applyFromArray($styTotales);

$j+=2;
$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "DEPOSITO A CUENTA")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, $totdepo);
$j+=1;
$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "PAGO CON CHEQUE")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, $totch);
$j+=1;
$i=$iIni;
$objPHPExcel->getActiveSheet()
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, "EFECTIVO")
    ->setCellValueByColumnAndRow($i++, $j, "")
    ->setCellValueByColumnAndRow($i++, $j, $totefec);
$objPHPExcel->getActiveSheet()->getStyle('H'.($j-2).':J'.$j)->applyFromArray($styTotales);


$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(100);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(40);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(22);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(22);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(22);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(30);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(22);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(22);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(22);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(22);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(22);
$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(22);
$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(22);
$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(30);
$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(30);
$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(22);
$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(22);
$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(25);
$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(30);
$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(22);
$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(35);

$objPHPExcel->getActiveSheet()->getStyle('E8'.':H'.$j)->getNumberFormat()->setFormatCode('###,##0.0');
$objPHPExcel->getActiveSheet()->getStyle('I8'.':V'.$j)->getNumberFormat()->setFormatCode('###,##0.00');
$objPHPExcel->getActiveSheet()->getStyle('A8'.':A'.$j)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

# ESTABLECER TITULOS
$objPHPExcel->setActiveSheetIndex($sheet['planilla'])->setTitle('Planilla Administracion');

# AL ABRIR EL DOCUMENTO ABRIR EN PRIMERA HOJA
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="Planilla Aministracion.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>