<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$numNum=$_GET["numNum"];
$selTipoCod=$_GET["selTipoCod"];
$selBanCod=$_GET["selBanCod"];
$dtFec=$_GET["dtFec"];
$txtCon=$_GET["txtCon"];
$jsonPol=json_decode($_GET['tblPol']);
$dtGrabado=(empty($_GET["dtGrabado"])) ? strftime("%d/%m/%Y %T") : $_GET["dtGrabado"];
$btn=utf8_decode($_GET["btn"]);

class generatePDF extends PDF_MC_Table {
    function Header() {
    }
    
    function Footer() {
        global $btn, $dtGrabado;
        // Posición: a 1,5 cm del final
        $this->SetY(-2.5);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,0,"C");
        $this->Ln(.5);
        $this->Cell(0,1,$btn." ".$dtGrabado,0,0,"C");
    }
}

# QUERYS
$sPolizas = "SELECT * FROM polizas WHERE pol_emp='$empCod' AND pol_fec='$dtFec' AND pol_ban='$selBanCod' AND pol_tipo='$selTipoCod' AND pol_num='$numNum'";
$sPoli_det = "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_fec='$dtFec' AND pold_ban='$selBanCod' AND pold_tipo='$selTipoCod' AND pold_num='$numNum'";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["polizas"] = $db->query($sPolizas);
$select["poli_det"] = $db->query($sPoli_det);
$db->close();

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 28));
$pdf->AddPage();
$pdf->SetMargins(2.5, 1, 2.5);
$pdf->SetFont("Arial","B",20);

$pdf->Cell(20,.7,$empNom,0,1,"C");
$pdf->Ln();

$lineWidth=17;
$lineHeight=0.5;

$pdf->SetFont("","B",10);
$pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Número de Póliza: "));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/2, $lineHeight, $selTipoCod."-".$numNum);

$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/5, $lineHeight, utf8_decode("Fecha de Póliza: "));
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, strftime("%d/%m/%Y", strtotime($dtFec)));
$pdf->Ln($lineHeight*2);

$pdf->SetFont("","B");
$pdf->MultiAlignCell($lineWidth/8, $lineHeight, "Concepto: ");
$pdf->SetFont("");
$pdf->MultiAlignCell($lineWidth/1.35, $lineHeight, $txtCon);
$pdf->Ln($lineHeight*6);


$header = array("Cuenta","Nombre de Cuenta","Debe","Haber");
$pdf->SetFont("","B");
$pdf->SetWidths(array(3,8,3,3));
$pdf->SetAligns(array("C","C","C","C"));
$pdf->Row($header, $lineHeight);

$pdf->SetFont("");
$pdf->SetAligns(array("L","L","R","R"));
$debe = 0;
$haber = 0;
foreach ($jsonPol as $obj) {
    $debe += $obj->debe;
    $haber += $obj->haber;
    $body = array(
        $obj->ctaCod,
        $obj->ctaNom,
        ($obj->debe != 0) ? $obj->debe : "",
        ($obj->haber != 0) ? $obj->haber : "",
    );
    $pdf->RowBorderLR($body, $lineHeight);
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());

$pdf->SetAligns(array("","R","R","R"));
$body = array(
    "",
    "Totales: ",
    number_format($debe,2),
    number_format($haber,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());

$pdf->Ln($lineHeight*6);
$pdf->Cell($lineWidth/6);
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, "Hecho por", "T", 0, "C");
$pdf->Cell($lineWidth/6);
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, "Revisado por", "T", 0, "C");

$pdf->Output(utf8_decode("Póliza ").$selTipoCod."-".$numNum.".pdf","I");
?>