<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once('../../../php/functions.php');
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

global $empCod, $usuNom, $bitMod, $bitForm, $selBan, $dtFec, $numNum, $Banctab, $Banctac, $txtCodp, $txtNomp;

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

$numAno=$_GET["numAno"];
$selMes=$_GET["selMes"];
$Mesnom=$_GET["Mesnom"];

$lineWidth=19;
$lineHeight=0.42;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $lineHeight, $lineWidth, $Mesnom, $selMes, $numAno;
        $this->SetMargins(1.5, 1, 2);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",12);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("LISTADO DE EMPLEADOS QUE FUERON DADOS DE BAJA EN : ".$Mesnom."/".$numAno),0,1,"L");

        $this->Ln();
        $this->SetFont("","",9);
        $header = array("CODIGO","NOMBRE DEL EMPLEADO","PUESTO","FECHA BAJA");
        $this->SetFont("","B");
        $this->SetWidths(array(1.5,8,5.5,3));
        $this->SetAligns(array("C","C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("L","L","L","C"));
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        //$this->SetY(-2.5);
        //$this->SetFont("Arial","I",8);
        //$this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sMaestro = "SELECT mae.*, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
            TRIM(tpu.tpu_nom) AS tpu_nom, TRIM(gru.gru_nom) AS gru_nom, TRIM(dep.dep_nom) AS dep_nom
            FROM maestro mae
            LEFT JOIN grupo gru ON mae.mae_gru=gru.gru_cod LEFT JOIN dep dep ON mae.mae_dep=dep.dep_cod 
            LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
            WHERE mae_emp='$empCod' AND mae_stat='B' AND year(mae_fsal)=$numAno AND month(mae_fsal)=$selMes GROUP BY mae_cod ORDER BY mae_emp,mae_gru,mae_dep,mae_cod";

# EJECUCION DE QUERYS
$db = new dbExec();
$select["maestro"] = $db->query($sMaestro);
# GENERAR PDF
//$pdf = new generatePDF("L","cm", "Letter");
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();
$func = new functions();
$ti_gru=9999;
$ti_dep=9999;
while ($rec = $db->fetchAssoc($select["maestro"])) {
    if (($ti_gru.$ti_dep)!=($rec["mae_gru"].$rec["mae_dep"])) {
       $pdf->SetFont("ARIAL","U",9);
       $pdf->Cell($lineWidth,.7, $rec["gru_nom"].",".$rec["dep_nom"],0,1,"L");
       $pdf->SetFont("ARIAL","",9);
       $ti_gru=$rec["mae_gru"];
       $ti_dep=$rec["mae_dep"];       
    }
    $body = array(
        $rec["mae_cod"],
        $rec["mae_nom"]." ".$rec["mae_ape"],
        $rec["tpu_nom"],
        strftime("%d/%m/%Y", strtotime($rec["mae_fsal"])),
    );
    $pdf->RowBorderHidden($body, $lineHeight);
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());
$pdf->Output(utf8_decode("ListaIngre").".pdf","I");
$db->close();
?>