<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$dtDel=$_GET["dtDel"];
$dtAl=$_GET["dtAl"];
$dtFec=$_GET["dtFec"];
$numPol=$_GET["numPol"];
$crTrepo=$_GET["crTrepo"];
$jsonPol=json_decode($_GET["tblPol"]);

$lineWidth=19;
$lineHeight=0.45;

class generatePDF extends PDF_MC_Table {
    function Header() {
      global $empCod, $empNom, $lineHeight, $lineWidth, $dtDel, $dtAl, $dtFec, $numPol, $crTrepo;
        $this->SetMargins(2.5, 1, 2.5);
        $this->Cell(0, 0, "", 0, 1);

        $this->SetFont("Arial","B",14);
        $this->Cell($lineWidth,.7,$empNom,0,0,"L");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1,utf8_decode("PÁGINA ").$this->PageNo(),0,1,"R");

        $this->SetFont("","",9);
        $this->Cell($lineWidth, $lineHeight, utf8_decode("Poliza de sueldos correspondiente del: ".strftime("%d/%m/%Y", strtotime($dtDel))." al ".strftime("%d/%m/%Y", strtotime($dtAl))),0,1,"L");
        $this->Cell($lineWidth, $lineHeight, "Poliza Numero: ".$numPol."    Fecha de la Poliza: ".strftime("%d/%m/%Y", strtotime($dtFec))."        ".$crTrepo,0,1,"L");
        $this->Ln();
    }
    
    function Footer() {
        global $btn, $dtGrabado;
        // Posición: a 1,5 cm del final
        $this->SetY(-2.5);
        $this->SetFont("Arial","I",7);
        $this->Cell(0,1,$dtGrabado,0,0,"L");
    }
}

# QUERYS

# EJECUCION DE QUERYS

# GENERAR PDF
$pdf = new generatePDF("P","cm", "Letter");
$pdf->AddPage();
$pdf->SetMargins(2.5, 1, 2.5);
$lineWidth=19;
$lineHeight=0.5;
$pdf->SetFont("","B",10);

$header = array("Cuenta","Nombre de Cuenta","Debe","Haber");
$pdf->SetFont("","B");
$pdf->SetWidths(array(3,8,3,3));
$pdf->SetAligns(array("C","C","C","C"));
$pdf->Row($header, $lineHeight);

$pdf->SetFont("");
$pdf->SetAligns(array("L","L","R","R"));
$debe = 0;
$haber = 0;
foreach ($jsonPol as $obj) {
    $debe += $obj->debe;
    $haber += $obj->haber;
    $body = array(
        $obj->cta,
        utf8_decode($obj->ctaNom),
        ($obj->debe != 0) ? number_format($obj->debe,2) : "",
        ($obj->haber != 0) ? number_format($obj->haber,2) : "",
    );
    $pdf->RowBorderLR($body, $lineHeight);
}
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());

$pdf->SetAligns(array("","R","R","R"));
$body = array(
    "",
    "Totales: ",
    number_format($debe,2),
    number_format($haber,2),
);
$pdf->RowBorderHidden($body, $lineHeight);
$pdf->line($pdf->GetX(), $pdf->GetY(), 19.5, $pdf->GetY());

$pdf->Ln($lineHeight*6);
$pdf->Cell($lineWidth/6);
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, "Hecho por", "T", 0, "C");
$pdf->Cell($lineWidth/6);
$pdf->MultiAlignCell($lineWidth/4, $lineHeight, "Revisado por", "T", 0, "C");

$pdf->Output(utf8_decode("Póliza Sueldos").".pdf","I");
?>