<?php
include_once('../../../php/sessionStart.php');
include_once('../../../php/db/dbExec.php');
include_once('../../../php/functions.php');
include_once('../../../php/timezone.php');
include_once('../../../php/privileges.php');
include_once('../../../php/maxExecTime.php');

$bitForm = "nom3020";
$bitMod = "nom";
$empCod = $_SESSION['empCod'];
$usuCod = utf8_decode($_SESSION['usuCod']);
$usuNom = utf8_decode($_SESSION['usuNom']);

switch ($_POST['action']) {
	case 'consultarPla':
		echo consultarPla();
		break;
	case 'consultarNp':
		echo consultarNp();
		break;

	case 'consultarEmple':
		echo consultarEmple();
		break;

	case 'guardar':
		echo guardar();
		break;

	case 'guardarAg':
		echo guardarAg();
		break;

	case 'borrar':
		echo borrar();
		break;

	case 'borrarReg':
		echo borrarReg();
		break;

}

function consultarPla() {
	global $empCod, $usuNom;

	$priv = new privileges();
	if (!$priv->consult($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorConsult());
	}

	$func = new functions();

	$numAno=$_POST['numAno'];

	# QUERYS

	$sBono14 = "SELECT b14.*, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
				TRIM(tpu.tpu_nom) AS tpu_nom 
				FROM bono14 b14
 				LEFT JOIN maestro mae ON b14.b14_emp=mae.mae_emp AND b14.b14_cod = mae.mae_cod 
 				LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
				WHERE b14_emp='$empCod' AND b14_ano='$numAno'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["bono14"] = $db->sFetchAll($sBono14);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, 'bono14');
}

function consultarNp() {
	global $empCod, $usuNom;

	$func = new functions();

	$numAno=$_POST['numAno'];
	$numCod=$_POST['numCod'];

	# QUERYS

	$sBono14 = "SELECT *, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
				TRIM(tpu.tpu_nom) AS tpu_nom
				FROM bono14 b14
 				LEFT JOIN maestro mae ON b14.b14_cod = mae.mae_cod 
 				LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
				WHERE b14_emp='$empCod' AND b14_ano='$numAno' AND b14_cod='$numCod'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp["bono14"] = $db->sFetchAssoc($sBono14);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, 'bono14');
}

function consultarEmple() {
	global $empCod, $usuNom;

	$func = new functions();

	$numAno=$_POST['numAno'];
	$numCoddag=$_POST['numCoddag'];

	# QUERYS

	$sMaestro = "SELECT *, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
				TRIM(tpu.tpu_nom) AS tpu_nom
				FROM maestro mae
 				LEFT JOIN tpuesto tpu ON mae.mae_tpue = tpu.tpu_cod 
				WHERE mae_emp ='$empCod' AND mae_cod='$numCoddag'";

	$sBono14 = "SELECT *
				FROM bono14
				WHERE b14_emp ='$empCod' AND b14_ano='$numAno' AND b14_cod='$numCoddag'";

	# EJECUCION DE QUERYS
	$db = new dbExec();
	$resp = $db->sEx($sBono14, "bono14");
	$resp["maestro"] = $db->sFetchAssoc($sMaestro);
	$db->close();

	$func = new functions();
	return $func->jsonEncodeArray($resp, 'bono14', 'maestro');
}


function guardar() {
	global $empCod, $usuNom, $bitMod, $bitForm;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numAno=$_POST['numAno'];
	$numCod=$_POST['numCod'];
	$numEne=(empty($_POST['numEne'])) ? 0 : $_POST['numEne'];
	$numFeb=(empty($_POST['numFeb'])) ? 0 : $_POST['numFeb'];
	$numMar=(empty($_POST['numMar'])) ? 0 : $_POST['numMar'];
	$numAbr=(empty($_POST['numAbr'])) ? 0 : $_POST['numAbr'];
	$numMay=(empty($_POST['numMay'])) ? 0 : $_POST['numMay'];
	$numJun=(empty($_POST['numJun'])) ? 0 : $_POST['numJun'];
	$numJul=(empty($_POST['numJul'])) ? 0 : $_POST['numJul'];
	$numAgo=(empty($_POST['numAgo'])) ? 0 : $_POST['numAgo'];
	$numSep=(empty($_POST['numSep'])) ? 0 : $_POST['numSep'];
	$numOct=(empty($_POST['numOct'])) ? 0 : $_POST['numOct'];
    $numNov=(empty($_POST['numNov'])) ? 0 : $_POST['numNov'];
	$numDic=(empty($_POST['numDic'])) ? 0 : $_POST['numDic'];
	$numTot=(empty($_POST['numTot'])) ? 0 : $_POST['numTot'];
	$numAnti=(empty($_POST['numAnti'])) ? 0 : $_POST['numAnti'];
	$numBono=(empty($_POST['numBono'])) ? 0 : $_POST['numBono'];
	$numLiqrec=(empty($_POST['numLiqrec'])) ? 0 : $_POST['numLiqrec'];

	# QUERYS PARA UN REGISTRO
	$uBono14="UPDATE bono14 SET b14_ene='$numEne', b14_feb='$numFeb', b14_mar='$numMar', b14_abr='$numAbr', b14_may='$numMay', b14_jun='$numJun', b14_jul='$numJul', b14_ago='$numAgo', b14_sep='$numSep', b14_oct='$numOct', b14_nov='$numNov', b14_dic='$numDic', b14_tot='$numTot', b14_anti='$numAnti', b14_bono='$numBono', b14_liqrec='$numLiqrec'  WHERE b14_emp='$empCod' AND b14_ano='$numAno' AND b14_cod='$numCod'";

	# EJECUCION DE QUERYS 
	$db = new dbExec();
	$resp= $db->uEx($uBono14);
	$db->iEx($func->iBitacora(utf8_decode("Se Modifico El Bono 14 Año $numAno  Codigo: $numCod Usuario: ").$usuNom, $bitMod, $bitForm));
	$db->close();
	
	return json_encode($resp);
}


function borrar() {
	global $empCod, $usuNom, $bitMod, $bitForm;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numAno=$_POST['numAno'];

	# QUERYS PARA UN REGISTRO

	$dBono14="DELETE FROM bono14 WHERE b14_emp='$empCod' AND b14_ano='$numAno'";

	# QUERYS PARA VARIOS REGISTROS

	# EJECUCION DE QUERYS 
	$db = new dbExec();

	$resp = $db->dEx($dBono14);
	//
	$db->iEx($func->iBitacora(utf8_decode("Se Borro El Bono 14 Año: $numAno Usuario: ").$usuNom, $bitMod, $bitForm));
	$db->close();

	return json_encode($resp);
}

function borrarReg() {
	global $empCod, $usuNom, $bitMod, $bitForm;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numAno=$_POST['numAno'];
	$numCod=$_POST['numCod'];


	# QUERYS PARA UN REGISTRO

	$dBono14="DELETE FROM bono14 WHERE b14_emp='$empCod' AND b14_ano='$numAno' AND b14_cod='$numCod'";
	
	# QUERYS PARA VARIOS REGISTROS

	# EJECUCION DE QUERYS 
	$db = new dbExec();

	$resp = $db->dEx($dBono14);
	//
	$db->iEx($func->iBitacora(utf8_decode("Se Borro Codigo: $numCod del Bono 14 Año: $numAno Usuario: ").$usuNom, $bitMod, $bitForm));
	$db->close();

	return json_encode($resp);
}

function guardarAg() {
	global $empCod, $usuNom, $bitMod, $bitForm, $numAno, $numCoddag, $dtDel, $dtAl, $mes, $ano;

	$priv = new privileges();
	if (!$priv->modify($_SESSION['usuPriv'])) {
		return json_encode($priv->rErrorModify());
	}

	$func = new functions();

	$numAno=$_POST['numAno'];
	$numCoddag=$_POST['numCoddag'];
	$txtNomdag=$_POST['txtNomdag'];

	$anoant=$numAno-1;
	$fecini1=$anoant."-07-01";
	$fecfin1=$numAno."-06-30";
	$fini = date("Y-m-d", strtotime($fecini1));
	$ffin = date("Y-m-d", strtotime($fecfin1));

	# QUERYS PARA UN REGISTRO
	$sNomper = "SELECT np.*, mae.mae_cod, TRIM(mae.mae_nom) AS mae_nom, TRIM(mae.mae_ape) AS mae_ape,
			mae_fing, TRIM(pue.tpu_nom) AS tpu_nom
			FROM nomper np
			LEFT JOIN maestro mae ON mae.mae_emp=np.np_emp AND mae.mae_cod=np.np_cod 
			LEFT JOIN tpuesto pue ON mae.mae_tpue=pue.tpu_cod
			WHERE np_emp='$empCod' AND np_ffin>='$fini' AND np_ffin<='$ffin' AND np_cod='$numCoddag'";

	$dBono14 = "DELETE FROM bono14 	WHERE b14_emp='$empCod' AND b14_ano='$numAno' AND b14_cod='$numCoddag'";

	function iBono14($cod,$ene,$feb,$mar,$abr,$may,$jun,$jul,$ago,$sep,$oct,$nov,$dic,$tot,$bono,$fing) { 
		global $empCod, $usuNom,  $numAno;
		return "INSERT INTO bono14(b14_emp, b14_ano, b14_cod, b14_ene, b14_feb, b14_mar, b14_abr, b14_may, b14_jun, b14_jul, b14_ago, b14_sep, b14_oct, b14_nov, b14_dic, b14_tot, b14_bono, b14_liqrec, b14_fing) VALUES ('$empCod', '$numAno','$cod','$ene','$feb','$mar', $abr,'$may','$jun','$jul','$ago','$sep','$oct','$nov','$dic','$tot','$bono','$bono', '$fing')";
	}
	function uBono14($cod,$ene,$feb,$mar,$abr,$may,$jun,$jul,$ago,$sep,$oct,$nov,$dic,$tot,$bono) { 
		global $empCod, $usuNom,  $numAno;
		return "UPDATE bono14 SET b14_ene='$ene', b14_feb='$feb', b14_mar='$mar', b14_abr='$abr', b14_may='$may', b14_jun='$jun', b14_jul='$jul', b14_ago='$ago', b14_sep='$sep', b14_oct='$oct', b14_nov='$nov', b14_dic='$dic', b14_tot='$tot', b14_bono='$bono', b14_liqrec='$bono' WHERE b14_emp='$empCod' AND b14_ano='$numAno' AND b14_cod='$cod'";
	}
	function sBono14($cod) { 
		global $empCod, $usuNom,  $numAno;
		return "SELECT * FROM bono14 WHERE b14_emp='$empCod' AND b14_ano='$numAno' AND b14_cod='$cod'";
	}


	# EJECUCION DE QUERYS 
	$db = new dbExec();
    $resp = $db->dEx($dBono14);
    $puesto="";
    $totbono=0;
    $liqrec=0;
	$select["nomper"] = $db->query($sNomper);
	while ($rec = $db->fetchAssoc($select['nomper'])) {
	    $cod = $rec["np_cod"];
	    $fing = $rec["mae_fing"];
	    $fecha = $rec["np_ffin"];
        $puesto= $rec["tpu_nom"];
	    $sdia = round($rec["np_snom"]/30,6);
	    $svaca=0;
	    $ssusi=0;
	    if ($rec["np_dvaca"]>0) {
	       $svaca= round($rec["np_dvaca"]*$sdia,2);
	    }
	    if ($rec["np_dsusi"]>0) {
		   $ssusi= round($rec["np_dsusi"]*$sdia,2);
	    }
	    $mesnp= date("m", strtotime($fecha));
	    $ene=0;
	    $feb=0;
	    $mar=0;
	    $abr=0;
	    $may=0;
	    $jun=0;
	    $jul=0;
	    $ago=0;
	    $sep=0;
	    $oct=0;
	    $nov=0;
	    $dic=0;

	    switch ($mesnp){
	      case 1:
	        $ene = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 2:
	        $feb = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 3:
	        $mar = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 4:
	        $abr = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 5:
	        $may = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 6:
	        $jun = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 7:
	        $jul = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 8:
	        $ago = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 9:
	        $sep = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 10:
	        $oct = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 11:
	        $nov = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	      case 12:
	        $dic = $rec["np_sord"]+$svaca+$ssusi;
	        break;
	    }

		$select["bono14"] = $db->query(sBono14($cod));
		$fetchAssoc["bono14"] = $db->fetchAssoc($select["bono14"]);
		if ($db->numRows($select["bono14"]) == 0) {
		   $tot=($ene+$feb+$mar+$abr+$may+$jun+$jul+$ago+$sep+$oct+$nov+$dic);
		   if ($tot>0) {
		      $bono=round($tot/12,2);
		   } else {
		   	  $bono=0;
		   }
		   $totbono=$bono;
		   $liqrec=$bono;
	       $db->iEx(iBono14($cod,$ene,$feb,$mar,$abr,$may,$jun,$jul,$ago,$sep,$oct,$nov,$dic,$tot,$bono,$fing));
	       continue;
		} else {
		   $nuene=$fetchAssoc["bono14"]["b14_ene"]+$ene;
		   $nufeb=$fetchAssoc["bono14"]["b14_feb"]+$feb;
		   $numar=$fetchAssoc["bono14"]["b14_mar"]+$mar;
		   $nuabr=$fetchAssoc["bono14"]["b14_abr"]+$abr;
		   $numay=$fetchAssoc["bono14"]["b14_may"]+$may;
		   $nujun=$fetchAssoc["bono14"]["b14_jun"]+$jun;
		   $nujul=$fetchAssoc["bono14"]["b14_jul"]+$jul;
		   $nuago=$fetchAssoc["bono14"]["b14_ago"]+$ago;
		   $nusep=$fetchAssoc["bono14"]["b14_sep"]+$sep;
		   $nuoct=$fetchAssoc["bono14"]["b14_oct"]+$oct;
		   $nunov=$fetchAssoc["bono14"]["b14_nov"]+$nov;
		   $nudic=$fetchAssoc["bono14"]["b14_dic"]+$dic;
		   $tot=($nuene+$nufeb+$numar+$nuabr+$numay+$nujun+$nujul+$nuago+$nusep+$nuoct+$nunov+$nudic);
		   if ($tot>0) {
		      $bono=round($tot/12,2);
		   } else {
		   	  $bono=0;
		   }
		   $totbono=$bono;
		   $liqrec=$bono;
	       $db->uEx(uBono14($cod,$nuene,$nufeb,$numar,$nuabr,$numay,$nujun,$nujul,$nuago,$nusep,$nuoct,$nunov,$nudic,$tot,$bono));
		}
	}

	$db->iEx($func->iBitacora(utf8_decode("Se Genero Bono 14:  $numAno Codigo: $numCoddag   Usuario: ").$usuNom, $bitMod, $bitForm));

	$resp["puesto"] = $puesto;
	$resp["totbono"] = $totbono;
	$resp["totanti"] = 0;
	$resp["liqrec"] = $liqrec;
	$db->close();
	return json_encode($resp);
}


?>