<?php
include_once("../../../php/sessionStart.php"); 
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empNom=utf8_decode($_SESSION["empNom"]);

$dtFecI=$_GET["dtFecI"];
$dtFecF=$_GET["dtFecF"];

class generatePDF extends PDF_MC_Table {
    function Header() {
    }
    
    function Footer() {
        // Posición: a 1,5 cm del final
        $this->SetY(-2);
        $this->SetFont("Arial","I",8);
        $this->Cell(0,1,"PAGINA ".$this->PageNo(),0,0,"C");
    }
}

# QUERYS
$sPolizas = "SELECT * FROM polizas p LEFT JOIN tipopol tp ON p.pol_tipo=tp.tp_cod WHERE pol_emp='$empCod' AND pol_fec>='$dtFecI' AND pol_fec<='$dtFecF'";

function sPoli_det($dtFec, $selBanCod, $selTipoCod, $numNum) {
    global $empCod;
    return "SELECT * FROM poli_det WHERE pold_emp='$empCod' AND pold_fec='$dtFec' AND pold_ban='$selBanCod' AND pold_num='$numNum'";
    //AND pold_tipo='$selTipoCod'
}


# EJECUCION DE QUERYS
$db = new dbExec();
$select["polizas"] = $db->query($sPolizas);

# GENERAR PDF
$pdf = new generatePDF("P","cm", array(22, 27.94));
$pdf->AddPage();
$pdf->SetMargins(2.5, 1, 2.5);
$pdf->SetFont("Arial","B",17);

$pdf->Cell(20,.7,$empNom,0,1,"C");

$lineWidth=17;
$lineHeight=0.35;

$pdf->SetFont("","",9);
$pdf->Ln($lineHeight);
$pdf->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Revision de Descuadres del ".strftime("%d/%m/%Y", strtotime($dtFecI))." al ".strftime("%d/%m/%Y", strtotime($dtFecF))),0,0,"C");
$pdf->Ln($lineHeight*2);

$header = array("Tipo Poliza","Banco","Numero Poliza","Fecha Poliza","Debe","Haber");
$pdf->SetFont("","B",8);
$pdf->SetWidths(array(3,1.5,3,2,3,3));
$pdf->SetAligns(array("C","C","C","C","C","C"));
$pdf->Row($header, $lineHeight);
$pdf->Ln($lineHeight);

$pdf->SetFont("");
$pdf->SetAligns(array("L","L","L","L","R","R"));


$totDebe = 0;
$totHaber = 0;
while ($rec = $db->fetchAssoc($select['polizas'])) {

    $pdf->SetFont("","B",8);
    //$pdf->Ln($lineHeight);

    $debe = 0;
    $haber = 0;

    $select["poli_det"] = $db->query(sPoli_det($rec["pol_fec"], $rec["pol_ban"], $rec["pol_tipo"], $rec["pol_num"]));
    
    while ($recTbl = $db->fetchAssoc($select['poli_det'])) {
        $debe += $recTbl["pold_debe"];
        $haber += $recTbl["pold_haber"];
    }
    // Esto Sirve para poner una linea en los totales
    //$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());

    $pdf->SetAligns(array("L","L","L","C","R","R"));

    if (round($debe,2) != round($haber,2)) {
        $body = array(
            $rec["tp_nom"],
            $rec["pol_ban"],
            $rec["pol_num"],
            strftime("%d/%m/%Y", strtotime($rec["pol_fec"])),
            //$rec["pol_fec"],        
            number_format($debe,2),
            number_format($haber,2),
        );
        $pdf->RowBorderHidden($body, $lineHeight);
        //$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
        //$pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);
        //$pdf->Ln($lineHeight);
    }

    $totDebe += $debe;
    $totHaber += $haber;
}

if ($totDebe == $totHaber) {
    $pdf->SetWidths(array(3,1.5,8,2,3,3));
    $body = array(
        "",
        "",
        "*** NO SE ENCONTRARON DESCUADRES **",
        "",        
        "",
        "",
    );
    $pdf->SetFont("","B",10);        
    $pdf->RowBorderHidden($body, $lineHeight);
    //$pdf->line($pdf->GetX()+11, $pdf->GetY(), 19.5, $pdf->GetY());
    //$pdf->line($pdf->GetX()+11, $pdf->GetY()+.075, 19.5, $pdf->GetY()+.075);
    $pdf->Ln($lineHeight);
}


$db->close();

$pdf->Output(utf8_decode("Descuadres en Polizas").".pdf","I");
?>