<?php 
include_once("../../../php/sessionStart.php");
include_once("../../../php/db/dbExec.php");
include_once("../../../php/fpdf/functions.php");
include_once('../../../php/timezone.php');
include_once('../../../php/functions.php');
include_once('../../../php/maxExecTime.php');

$empCod=utf8_decode($_SESSION["empCod"]);
$empConso=utf8_decode($_SESSION["empConso"]);
$empNom=utf8_decode($_SESSION["empNom"]);
$empNomc=utf8_decode($_SESSION["empNomc"]);
$pTcam=$_SESSION["pTcam"];

$numAno=$_GET["numAno"];
$crMoneda=$_GET["crMoneda"];
$textoMoneda=$_GET["textoMoneda"];
$crSaldo=$_GET["crSaldo"];
$textoSaldo=$_GET["textoSaldo"];
$cbFecsn=$_GET["cbFecsn"];

$lineWidth=25;
$lineHeight=0.35;
$wcol = 2.1;

class generatePDF extends PDF_MC_Table {
    function Header() {
        global $empNom, $empNomc, $numAno, $textoMoneda, $textoSaldo, $lineWidth, $lineHeight, $wcol;
        $this->SetMargins(1.5, 1, 1);

        $func = new functions();
        $this->SetFont("Arial","",9);
        $this->Cell(0, 0, "", 0, 1);
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNom),0,1,"C");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode($empNomc),0,1,"C");

        $this->SetFont("Arial","I",8);
        $this->SetY(.7);
        $this->Cell(0,1, utf8_decode("Página: ".((string)($this->PageNo()))),0,1,"R");

        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Cuadro Anual Ingresos y Gastos"),0,1,"C");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Correspondiente a ".$numAno),0,1,"C");
        $this->MultiAlignCell($lineWidth, $lineHeight, utf8_decode("Cifras Expresadas en ".$textoMoneda),0,1,"C");
        $this->SetY($this->GetY()-.7);
        $this->Cell(0, 1, utf8_decode($textoSaldo),0,1,"l");

        $this->SetFont("","B",7.5);
        $lineHeight=0.3;
        $header = array("Enero","Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
        $this->SetWidths(array($wcol,$wcol,$wcol,$wcol,$wcol,$wcol,$wcol,$wcol,$wcol,$wcol,$wcol,$wcol));
        $this->SetAligns(array("C","C","C","C","C","C","C","C","C","C","C","C"));
        $this->Row($header, $lineHeight);

        $this->SetFont("");
        $this->SetAligns(array("R","R","R","R","R","R","R","R","R","R","R","R"));
    }
    
    function Footer() {
        global $cbFecsn;
        // Posición: a 1,5 cm del final
        $func = new functions();
        $this->SetY(-2);
        $this->SetFont("Arial","I",8);
        if ($func->stringToBool($cbFecsn)) {
            $this->Cell(0,1,strftime("%d/%m/%Y %T"),0,0,"L");
        }
    }
}

# QUERYS

$sCierres = "SELECT
                c.cie_mes,
                cta.cta_niv,
                cta.cta_con,
                TRIM(c.cie_cta) AS cie_cta,
                TRIM(cta.cta_nom) AS cta_nom,
                TRIM(cta.cta_acta) AS cta_acta,
                (0) AS salIni,
                SUM(cie_mdebe) AS cie_mdebe,
                SUM(cie_mhaber) AS cie_mhaber,
                (SUM(cie_mdebe)-SUM(cie_mhaber)) AS salMes
            FROM empresas emp 
            LEFT JOIN cierres c ON c.cie_emp=emp.emp_cod
            INNER JOIN cuentas cta ON c.cie_emp=cta.cta_emp AND c.cie_cta=cta.cta
            WHERE emp.emp_conso='$empConso' AND c.cie_ano=$numAno AND c.cie_mes<=12 AND LEFT(c.cie_cta, 1)>3
            GROUP BY c.cie_cta, cie_mes";

/*
$sCierres = "SELECT
                c.cie_mes,
                cta.cta_niv,
                cta.cta_con,
                TRIM(c.cie_cta) AS cie_cta,
                TRIM(cta.cta_nom) AS cta_nom,
                TRIM(cta.cta_acta) AS cta_acta,
                (0) AS salIni,
                c.cie_mdebe,
                c.cie_mhaber,
                (SUM(cie_mdebe)-SUM(cie_mhaber)) AS salMes
            FROM cierres c 
            INNER JOIN cuentas cta ON c.cie_emp=cta.cta_emp AND c.cie_cta=cta.cta
            WHERE c.cie_emp='$empCod' AND c.cie_ano=$numAno AND c.cie_mes<=12 AND LEFT(c.cie_cta, 1)>3
            GROUP BY c.cie_cta, cie_mes";

*/
# EJECUCION DE QUERYS
$db = new dbExec();
$select["cierres"] = $db->query($sCierres);

$arrayCie=$db->fetchAll($select["cierres"]);

# GENERAR PDF
$pdf = new generatePDF("L","cm", array(22, 28));
$pdf->AddPage();

$ctaAnt=4;
$ctaNomAnt=4;
$ctaNivAnt=1;

$salIni=0;
$body = array("0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00");
foreach ($arrayCie as $rec) {
    if ($ctaAnt!=$rec["cie_cta"]) {
        if ($body[0]=="0.00" && $body[1]=="0.00" && $body[2]=="0.00" && $body[3]=="0.00" && $body[4]=="0.00" && $body[5]=="0.00" && $body[6]=="0.00" && $body[7]=="0.00" && $body[8]=="0.00" && $body[9]=="0.00" && $body[10]=="0.00" && $body[11]=="0.00") {
            if ($crSaldo != "M") {
                $saldo=($salIni+$rec["cie_mdebe"])-$rec["cie_mhaber"];
                $salIni+=$rec["salMes"];
            } else {
                $saldo=$rec["salMes"];
            }

            // TASA DE CAMBIO
            if ($crMoneda != "L") {
                $saldo/=$pTcam;
            }

            $body[$rec["cie_mes"]-1] = number_format($saldo, 2, '.', ',');

            $ctaAnt=$rec["cie_cta"];
            $ctaNomAnt=$rec["cta_nom"];
            $ctaNivAnt=$rec["cta_niv"];
            continue;
        }        
        $pdf->SetFont("","BU");
        $pdf->Cell($lineWidth,$lineHeight, $ctaAnt." - ".$ctaNomAnt,0,1);
        $pdf->SetFont("");
        $pdf->RowBorderHidden($body, $lineHeight);
        
        $salIni=0;
        $body = array("0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00");

        if ($rec["cta_niv"]!=$ctaNivAnt) {
            $pdf->Ln();
        }
    }

    if ($crSaldo != "M") {
        $saldo=($salIni+$rec["cie_mdebe"])-$rec["cie_mhaber"];
        $salIni+=$rec["salMes"];
    } else {
        $saldo=$rec["salMes"];
    }

    // TASA DE CAMBIO
    if ($crMoneda != "L") {
        $saldo/=$pTcam;
    }

    if (substr($rec["cie_cta"],0,1)=='4' && $saldo<0) {
        $saldo=$saldo*-1;
    }

    $body[$rec["cie_mes"]-1] = number_format($saldo, 2, '.', ',');

    $ctaAnt=$rec["cie_cta"];
    $ctaNomAnt=$rec["cta_nom"];
    $ctaNivAnt=$rec["cta_niv"];
}
if ($body[0]!="0.00" || $body[1]!="0.00" || $body[2]!="0.00" || $body[3]!="0.00" || $body[4]!="0.00" || $body[5]!="0.00" || $body[6]!="0.00" || $body[7]!="0.00" || $body[8]!="0.00" || $body[9]!="0.00" || $body[10]!="0.00" || $body[11]!="0.00") {
   $pdf->SetFont("","BU");
   $pdf->Cell($lineWidth,$lineHeight, $ctaAnt." - ".$ctaNomAnt,0,1);
   $pdf->SetFont("");
   $pdf->RowBorderHidden($body, $lineHeight);
}
$db->close();
ob_end_clean();
ob_start();
$pdf->Output(utf8_decode("Cuadro Anual Ingresos y Gastos").".pdf","I");
?>