<?php 
include_once('../../../php/sessionStart.php'); 
include_once('../../../php/db/dbExec.php');
?>
<?php include_once('../includes/htmlOpen.php'); ?>
    <main class="main" style="">
      <?php 
        $li[0] = '<i class="fas fa-file-invoice"></i>';
        $li[1] = $_GET["opcNom"];
        include_once('../../../php/includes/ol.php');
      ?>

      <div class="container-as">
        <div class="row">
          <div class="col">
            <ul class="nav nav-pills mb-1" id="pills-tab" role="tablist">
              <li class="nav-item">
                <a class="nav-link active" id="pills-0-tab" data-toggle="pill" href="#pills-0" role="tab" aria-controls="pills-0" aria-selected="true">Mantenimiento</a>
              </li>
              <li class="nav-item">
                <a class="nav-link" id="pills-1-tab" data-toggle="pill" href="#pills-1" role="tab" aria-controls="pills-1" aria-selected="true">Buscar Clientes</a>
              </li>
            </ul>
            <div class="tab-content bg-transparent border-0" id="pills-tabContent">
              <div class="tab-pane fade show active" id="pills-0" role="tabpanel" aria-labelledby="pills-0-tab">
                <form action="" name="thisform" autocomplete="off" enctype="multipart/form-data">
                  <div class="form-group">
                    <div class="form-row">
                      <div class="col-4">
                        <label for="txtNit">Nit</label>
                        <input type="text" class="form-control form-control-sm form-control-as" id="txtNit" maxlength="20">
                      </div>
                    </div>

                    <div class="form-row">
                      <div class="col-8">
                        <label for="txtCli">Cliente</label>
                        <input type="text" class="form-control form-control-sm form-control-as" id="txtCli" maxlength="100">
                      </div>
                    </div>
                    <div class="form-row">
                      <div class="col-8">
                        <label for="txtDir">Dirección</label>
                        <input type="text" class="form-control form-control-sm form-control-as" id="txtDir" maxlength="120">
                      </div>
                    </div>
                    <div class="form-row">
                      <div class="col-8">
                        <label for="txtTel">Telefono</label>
                        <input type="text" class="form-control form-control-sm form-control-as" id="txtTel" maxlength="60">
                      </div>
                    </div>
                  </div>

                  <div class="form-group">
                    <div class="form-row">
                      <div class="form-group col-4">
                        <button class="btn btn-success btn-lg btn-block" id="btnGuardar" type="button">Guardar</button>
                      </div>
                      <div class="form-group col-4">
                        <button class="btn btn-danger btn-lg btn-block" id="btnBorrar" type="button">Borrar</button>
                      </div>
                    </div>
                  </div>
                </form>

              </div>
              <div class="tab-pane fade" id="pills-1" role="tabpanel" aria-labelledby="pills-1-tab">
                <?php
                  $a='0';
                  $b='1';
                  include('../busClien/index.html')
                ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </main>
<?php include_once('../../../php/includes/htmlClose.php'); ?>

<script>
  var pressEnter = false;
  var inputClien = "txtNit"
  var nuevo = true;
  const txtNit = document.thisform.txtNit;
  const txtCli = document.thisform.txtCli;
  const txtDir = document.thisform.txtDir;
  const txtTel = document.thisform.txtTel;
  
  function restriccion(consultar = false){
    if (!consultar) {
      if (isNullPer(txtNit.value)) {
        txtNit.focus();
        alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el NIT"}});
        return true;
      }
      if (isNullPer(txtCli.value)) {
        txtCli.focus();
        alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar el Nombre del Cliente"}});
        return true;
      }
    } else {
      if (isNullPer(txtNit.value)) {
        limpiar();
        return true;
      }
    }
    return false;
  }
  
  function restriccionCamposVacios() {
    if (isNullPer(txtNit.value)) {
      txtNit.focus();
      alWarning({"msg":{"title":"Campo Vacío","text":"Es necesario ingresar EL NIT DEL CLIENTE"}});
      return true;
    }
    return false;
  }

  function limpiar(){
    txtNom.value = "";
    txtDir.value = "";
    txtTel.value = "";
  }

  $(document).ready(function() {
    $(this).find('input:visible:first').focus();
    txtNom.value = "";
    txtDir.value = "";
    txtTel.value = "";

    // SUBMIT FORM
    $('form').submit(function() {
      return false;
    });
    
    // FOCUS NIT
    $("#txtNit").focus(function (){
      txtNit.value = "";
      limpiar();
    });

    // FOCUS INPUT
    $("form[name='thisform'] input, select").focus(function (){
      if (!($("input:visible:first").is(":focus"))) {
        if (restriccionCamposVacios()) {return};
      }
    });

    // VALID NIT
    $("#txtNit")
    .focus(function() {
      inputClien = $(this).attr('id');
      txtCli.value="";
    })
    .keydown(function(e){
      if(ctrlBus(e)) { document.getElementById("pills-1-tab").click(); }
    })
    .change(function (){
      const parametros = new FormData();
      parametros.append("action", "consultarClien");
      parametros.append("txtNit", txtNit.value);
      parametros.append("txtCli", txtCli.value);
      parametros.append("txtDir", txtDir.value);
      parametros.append("txtTel", txtTel.value);

      //txtNit.focus();

      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        success: function (jsonPhp) {
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error == true){
            alError(jsonJS);
            nuevo = true;
          } else {
            if (jsonJS.clien === null) {
              nuevo = true;
            } else {
              txtCli.value = jsonJS.clien.cli_nom;
              txtDir.value = jsonJS.clien.cli_dir;
              txtTel.value = jsonJS.clien.cli_tel;
              nuevo = false;
            }
          }
        }
      });
    });

    // FOCUS VARIOS
    $("#txtCli").focus(function() {
      if (restriccionCamposVacios()) {return};
    });

    // CLICK BORRAR
    $("#btnBorrar").click(function (){
      if (restriccion()) {return};
      const fnT = function(){
        const parametros = new FormData();
        parametros.append("action", "borrar");

        parametros.append("txtNit", txtNit.value);
        parametros.append("txtCli", txtCli.value);
        parametros.append("txtDir", txtDir.value);
        parametros.append("txtTel", txtTel.value);
        
        txtNit.focus();

        $.ajax({
          data:  parametros,
          url:   window.location.origin+window.location.pathname+"actions.php",
          type:  "post",
          contentType: false,
          processData: false,
          beforeSend: function () {
            alLoad("Cargando...")
          },
          success: function (jsonPhp) {
            const jsonJS = JSON.parse(jsonPhp);

            if(jsonJS.error==true){
              alError(jsonJS);
            } else {
              alSuccess(jsonJS);
              limpiar();
              txtNit.value = "";
              txtNit.focus();
            }
          }
        });
      }

      const fnF = function(){
        return true;
      }

      usuClave(fnT, fnF);
    });

    // CLICK GUARDAR
    $("#btnGuardar").click(function (){
      if (restriccion()) {return};

      const parametros = new FormData();
      parametros.append("action", "guardar");

      parametros.append("nuevo", nuevo);
      parametros.append("txtNit", txtNit.value);
      parametros.append("txtCli", txtCli.value);
      parametros.append("txtDir", txtDir.value);
      parametros.append("txtTel", txtTel.value);

      txtNit.focus();
      
      $.ajax({
        data:  parametros,
        url:   window.location.origin+window.location.pathname+"actions.php",
        type:  "post",
        contentType: false,
        processData: false,
        beforeSend: function () {
          alLoad("Cargando...")
        },
        success: function (jsonPhp) {
          const jsonJS = JSON.parse(jsonPhp);

          if(jsonJS.error==true){
            alError(jsonJS);
          } else {
            alSuccess(jsonJS);
            limpiar();
            txtNit.value = "";
            txtNit.focus();
          }
        }
      });
    });
  });

  // FOCUS PILL
  $('a[data-toggle="pill"]').on('shown.bs.tab', function (e) {
    if (!isMobile()) {
      const target = e.target.attributes.href.value;
      const relatedTarget = e.relatedTarget.attributes.href.value;

      if (target != "#pills-0") {
        $(target+' input:visible:first').focus();
      } else {
        (relatedTarget == "#pills-1") ? txtCli.focus() : 0;
      }
      //$(target+' input:visible:first').focus();
    }
  });

</script>